SELECT 
 a.ProductId as left_pi, 
 b.ProductId as right_pi,
 a.EmAngle as left_em,
 b.EmAngle as right_em,
 a.Ext2URL as left_url, 
 b.Ext2URL as right_url, 
 st_intersection(a.geom, b.geom) as geom,
 st_area(st_intersection(a.geom, b.geom)) as ovarea,
 st_area(st_intersection(a.geom, b.geom)) / st_area(a.geom) * 100 as overlap_percentage,
 ABS(b.EmAngle - a.EmAngle)  as diff_em 
FROM 
mroctx as a, 
mroctx as b
WHERE
 st_intersects(a.geom, st_geomfromtext('Polygon ((...))'))
AND
 st_intersects(b.geom, st_geomfromtext('Polygon ((...))'))
AND
 st_overlaps(a.geom, b.geom) 
AND 
 a.EmAngle < 4
AND 
a.EmAngle < b.EmAngle 
AND
diff_em > 10 
AND
diff_em < 25
ORDER BY
ovarea desc,
diff_em desc,
left_em asc
LIMIT 1000;
