# pyanp

A Python library for [AHP (Analytic Hierarchy Process)](https://en.wikipedia.org/wiki/Analytic_hierarchy_process)
and [ANP (Analytic Network Process)](https://en.wikipedia.org/wiki/Analytic_network_process).  It should be of great use for:

* ANP/AHP researchers interested in extending the theory
* Practioneers needing to do calculations
* Students learning the theory
* Practioneers and Theorists wishing to publish using [Open Data](https://en.wikipedia.org/wiki/Open_data)

# Installation

1. First you need to install Jupyter and Python.  The easiest way is to install anaconda:
    1. Download and install anaconda with **Python 3.6** from [anaconda.com](https://www.anaconda.com/download)
    3. Further instructions available at [Installing Jupyter using Anaconda and Conda](http://jupyter.readthedocs.io/en/latest/install.html#id3)
2. Now you can directly install `pyanp` from a Terminal (or Windows console)
    ```
    pip install pyanp
    ```
    or if you want to install the bleeding edge from github:
    ```
    pip install git+https://github.com/wjladams/pyanp.git
    ```
 
# Tutorials / Documentation

* [Installing and getting started with Jupyter](tutorials/install.md)
* [AHP Tree Tutorial](tutorials/ahptree.md)
* [Limit matrix calculations Tutorial](tutorials/limitmatrix.md)
* [Priority calculations Tutorial](tutorials/priority.md)
* [ANP row sensitivity Tutorial](tutorials/rowsensitivity.md)
* [How to start contributing](tutorials/contrib.md)
* [Programmers Reference](https://pyanp.readthedocs.io/)

# Gitlab vs Github
At the moment, main development is on github, but mirrored to gitlab
