(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    265025,       5898]
NotebookOptionsPosition[    259940,       5797]
NotebookOutlinePosition[    260287,       5812]
CellTagsIndexPosition[    260244,       5809]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["comment", "Chapter",
 CellChangeTimes->{{3.772809966736481*^9, 
  3.772809967313614*^9}},ExpressionUUID->"8c829432-74cf-46d2-a2d9-\
ce02e27e948a"],

Cell[TextData[{
 "This notebook produces plots of the orbits generated by local \
complementation orbit up to and including 8 qubits, where isomorphic are not \
considered as equal (unless they ",
 StyleBox["are",
  FontSlant->"Italic"],
 " equal).\n\nThis work refers to \[OpenCurlyDoubleQuote]Mapping graph state \
orbits under local complementation\[CloseCurlyDoubleQuote], \
https://arxiv.org/abs/1910.03969. Please see this work for associated \
documentation.\n\nYou can choose to import from .mx or .csv. Importing data \
from .mx is faster, but may not be possible on older versions of Mathematica. \
Importing from .csv is broken up into qubit number as it can be slow for \
large number of qubits. Feel free to just import the qubit number you are \
interested in."
}], "Text",
 CellChangeTimes->{{3.769350392387492*^9, 3.769350396657919*^9}, {
   3.769437849182232*^9, 3.7694378589402075`*^9}, {3.7695128250289793`*^9, 
   3.769512825303007*^9}, {3.7695141514349833`*^9, 3.7695142510169835`*^9}, 
   3.7728088007587156`*^9, {3.7795601224836483`*^9, 3.7795601323711185`*^9}, 
   3.7796749845416923`*^9},ExpressionUUID->"31e83dc0-1ac0-4a1e-bdb1-\
08248a9ad027"],

Cell[CellGroupData[{

Cell["Load data", "Section",
 CellChangeTimes->{{3.7693480501240273`*^9, 
  3.769348052883855*^9}},ExpressionUUID->"df10a99b-3c09-44ec-a858-\
a64fe94ee1d6"],

Cell[CellGroupData[{

Cell["Constants & Data", "Subsubsection",
 CellChangeTimes->{{3.7695115722866707`*^9, 3.7695115726767488`*^9}, 
   3.791868921333538*^9},ExpressionUUID->"4ec793cc-43c6-435e-8d4c-\
2eb3b649109f"],

Cell[TextData[{
 "Data is organised into nested lists, where the first index, ",
 StyleBox["i",
  FontSlant->"Italic"],
 ", gives the qubit number and the second ",
 StyleBox["j",
  FontSlant->"Italic"],
 ",",
 StyleBox[" ",
  FontSlant->"Italic"],
 "indexes the orbit, which are in order as per the canonical listing of Hein, \
Danielsen, et al. (see references 11, 16 and 17 of the manuscript)."
}], "Text",
 CellChangeTimes->{{3.769350392387492*^9, 3.769350396657919*^9}, {
   3.7694296561798563`*^9, 3.7694297565358562`*^9}, {3.7694378266159754`*^9, 
   3.7694378672710404`*^9}, {3.7695118476702538`*^9, 3.7695118668611727`*^9}, 
   3.7695128279112678`*^9, {3.7695142044289837`*^9, 3.7695142327049837`*^9}, {
   3.7795601061184955`*^9, 3.779560135496547*^9}, 3.779674977969454*^9, {
   3.7918694915400934`*^9, 
   3.791869683419231*^9}},ExpressionUUID->"f52112b1-ca69-4bf2-b56c-\
105e006cbe2f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Graph", " ", "state", " ", "display", " ", "options"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"defcol", "=", 
   RowBox[{
    RowBox[{"ColorData", "[", 
     RowBox[{"97", ",", "\"\<ColorList\>\""}], "]"}], "[", 
    RowBox[{"[", "7", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"graphsize", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vertexsize", "=", "0.30"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"edgethickness", " ", "=", "0.024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"impad", "=", "10"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"precompiled", " ", "import", " ", "for", " ", "csv"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len4", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", "11"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len5", "=", 
   RowBox[{"{", 
    RowBox[{"6", ",", "14", ",", "30", ",", "132"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len6", "=", 
   RowBox[{"{", 
    RowBox[{
    "7", ",", "17", ",", "18", ",", "38", ",", "39", ",", "82", ",", "40", 
     ",", "41", ",", "176", ",", "372", ",", "132"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len7", "=", 
   RowBox[{"{", 
    RowBox[{
    "8", ",", "20", ",", "22", ",", "46", ",", "48", ",", "48", ",", "50", 
     ",", "104", ",", "106", ",", "108", ",", "224", ",", "50", ",", "52", 
     ",", "220", ",", "110", ",", "232", ",", "112", ",", "236", ",", "492", 
     ",", "484", ",", "1052", ",", "504", ",", "1056", ",", "532", ",", 
     "1096", ",", "528"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"len8", "=", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "23", ",", "26", ",", "54", ",", "27", ",", "58", ",", "57", 
      ",", "61", ",", "126", ",", "62", ",", "130", ",", "64", ",", "132", 
      ",", "134", ",", "136", ",", "138", ",", "284", ",", "288", ",", "135", 
      ",", "139", ",", "290", ",", "294", ",", "612", ",", "60", ",", "62", 
      ",", "63", ",", "264", ",", "66", ",", "138", ",", "288", ",", "140", 
      ",", "140", ",", "142", ",", "142", ",", "296", ",", "612", ",", "308", 
      ",", "300", ",", "644", ",", "616", ",", "145", ",", "149", ",", "616", 
      ",", "302", ",", "314", ",", "648", ",", "306", ",", "640", ",", "306", 
      ",", "656", ",", "648", ",", "1320", ",", "1380", ",", "1356", ",", 
      "2932", ",", "300", ",", "312", ",", "652", ",", "148", ",", "636", ",",
       "318", ",", "151", ",", "318", ",", "1368", ",", "668", ",", "668", 
      ",", "660", ",", "1408", ",", "1404", ",", "1380", ",", "1428", ",", 
      "1424", ",", "2952", ",", "3004", ",", "3024", ",", "152", ",", "692", 
      ",", "680", ",", "149", ",", "680", ",", "1424", ",", "1448", ",", 
      "1436", ",", "1468", ",", "3032", ",", "3092", ",", "3088", ",", "2904",
       ",", "660", ",", "704", ",", "1468", ",", "3072", ",", "3156", ",", 
      "1452", ",", "3160", ",", "532", ",", "3156", ",", "1492", ",", "1628", 
      ",", "3168", ",", "3248"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Initialise", " ", "variables"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenorbitsLi", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", "len4", ",", "len5", ",", "len6", ",", 
     "len7", ",", "len8"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourLiorbits", "=", 
   RowBox[{"Range", "[", "2", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourLigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "2", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len4", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"four", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiveLiorbits", "=", 
   RowBox[{"Range", "[", "4", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiveLigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "4", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len5", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"five", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sixLiorbits", "=", 
   RowBox[{"Range", "[", "11", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sixLigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "11", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len6", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"six", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sevenLiorbits", "=", 
   RowBox[{"Range", "[", "26", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sevenLigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "26", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len7", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"seven", "=", "7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightLiorbits", "=", 
   RowBox[{"Range", "[", "101", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightLigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "101", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len8", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eight", "=", "8"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Minimum", " ", "graph", " ", "state", " ", "chromatic", " ", "number", 
    " ", "found", " ", "each", " ", "entanglement", " ", "class"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Chi]graph", "=", "\[Chi]orbitsLi"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "5", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "6", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3",
      ",", "3", ",", "2", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "6", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3",
      ",", "3", ",", "2", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "7", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2",
      ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "2", 
     ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", 
     ",", "3", ",", "2", ",", "3", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Chi]graph", "[", 
     RowBox[{"[", "8", "]"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
      "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
      "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
      "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", 
      "2", ",", "3", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", 
      "2", ",", "3", ",", "2", ",", "2", ",", "3", ",", "3", ",", "2", ",", 
      "3", ",", "2", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", 
      "2", ",", "3", ",", "3", ",", "3", ",", "2", ",", "2", ",", "3", ",", 
      "3", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "2", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Minimum", " ", "graph", " ", "state", " ", "chromatic", " ", "index", " ",
     "found", " ", "each", " ", "entanglement", " ", "class"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]egraph", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "2", "}"}], ",", 
      RowBox[{"{", "2", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "5", ",", "4", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", 
        "3", ",", "3", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "6", ",", "5", ",", "4", ",", "4", ",", "3", ",", "4", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "2", ",", "4", ",", "4", ",", "4", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "7", ",", "6", ",", "5", ",", "5", ",", "4", ",", "4", ",", "5", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "2", ",", "5", ",", "4", ",", "5", ",", "5", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "3", ",", "3", ",", "4", ",", "4", ",", 
        "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "4", ",", 
        "4", ",", "3", ",", "3", ",", "4", ",", "3", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", ",", 
        "3", ",", "4", ",", "4", ",", "4", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "5", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", "4", ",", 
        "4", ",", "5", ",", "4"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Graph", " ", "state", " ", "rank", " ", "width", " ", "of", " ", "each", 
    " ", "entanglement", " ", "class"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rwdgraphs", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
        "1", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", 
        "1", ",", "2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
        "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", 
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "2", ",", "1", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", 
        "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "2", ",", 
        "2", ",", "2", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Chromatic", " ", "number", " ", "of", " ", "each", " ", "orbit"}],
    " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]orbitsLi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "2", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "3", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "2", ",", "2", ",", "3", ",", "2", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Chromatic", " ", "index", " ", "of", " ", "each", " ", "orbit"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]eorbitsLi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5", ",", "5", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "6", ",", "6", ",", "5", ",", "6", ",", "6", ",", "6", ",", "6", ",", 
        "6", ",", "6", ",", "6", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "7", ",", "7", ",", "6", ",", "7", ",", "7", ",", "6", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "3", ",", "7", ",", "3", ",", "3"}], "}"}]}], "}"}]}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "number", " ", "of", " ", "edges", " ", "in", " ", "each", " ", "orbit"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noedgorbitsLi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "36"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "49", ",", "130", ",", "660"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "18", ",", "62", ",", "67", ",", "172", ",", "182", ",", "436", ",", 
        "186", ",", "194", ",", "1012", ",", "2232", ",", "792"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "21", ",", "75", ",", "85", ",", "214", ",", "226", ",", "233", ",", 
        "243", ",", "574", ",", "598", ",", "622", ",", "1416", ",", "240", 
        ",", "255", ",", "1320", ",", "626", ",", "1448", ",", "638", ",", 
        "1476", ",", "3312", ",", "3300", ",", "7364", ",", "3420", ",", 
        "7392", ",", "3724", ",", "7672", ",", "3564"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "24", ",", "88", ",", "103", ",", "256", ",", "108", ",", "280", ",", 
        "284", ",", "304", ",", "712", ",", "313", ",", "756", ",", "323", 
        ",", "754", ",", "780", ",", "794", ",", "818", ",", "1852", ",", 
        "1912", ",", "812", ",", "828", ",", "1928", ",", "1980", ",", "4480",
         ",", "294", ",", "306", ",", "316", ",", "1628", ",", "335", ",", 
        "808", ",", "1852", ",", "830", ",", "822", ",", "834", ",", "834", 
        ",", "1912", ",", "4272", ",", "2036", ",", "2004", ",", "4648", ",", 
        "4356", ",", "868", ",", "896", ",", "4444", ",", "2020", ",", "2084",
         ",", "4680", ",", "2052", ",", "4660", ",", "2052", ",", "4744", ",",
         "4732", ",", "10296", ",", "10644", ",", "10608", ",", "23456", ",", 
        "1968", ",", "2064", ",", "4712", ",", "896", ",", "4476", ",", 
        "2112", ",", "908", ",", "2112", ",", "10512", ",", "4852", ",", 
        "4852", ",", "4840", ",", "10912", ",", "10884", ",", "10776", ",", 
        "11112", ",", "11084", ",", "23616", ",", "24032", ",", "24192", ",", 
        "912", ",", "5324", ",", "4960", ",", "904", ",", "4960", ",", 
        "10952", ",", "11192", ",", "11168", ",", "11392", ",", "24256", ",", 
        "24736", ",", "24704", ",", "23232", ",", "4620", ",", "5104", ",", 
        "11392", ",", "24576", ",", "25248", ",", "11352", ",", "25280", ",", 
        "4256", ",", "25248", ",", "11632", ",", "13024", ",", "25344", ",", 
        "25984"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "number", " ", "of", " ", "edges", " ", "in", " ", "each", " ", "orbit"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noedgorbitsLi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "36"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "49", ",", "130", ",", "660"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "18", ",", "62", ",", "67", ",", "172", ",", "182", ",", "436", ",", 
        "186", ",", "194", ",", "1012", ",", "2232", ",", "792"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "21", ",", "75", ",", "85", ",", "214", ",", "226", ",", "233", ",", 
        "243", ",", "574", ",", "598", ",", "622", ",", "1416", ",", "240", 
        ",", "255", ",", "1320", ",", "626", ",", "1448", ",", "638", ",", 
        "1476", ",", "3312", ",", "3300", ",", "7364", ",", "3420", ",", 
        "7392", ",", "3724", ",", "7672", ",", "3564"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "24", ",", "88", ",", "103", ",", "256", ",", "108", ",", "280", ",", 
        "284", ",", "304", ",", "712", ",", "313", ",", "756", ",", "323", 
        ",", "754", ",", "780", ",", "794", ",", "818", ",", "1852", ",", 
        "1912", ",", "812", ",", "828", ",", "1928", ",", "1980", ",", "4480",
         ",", "294", ",", "306", ",", "316", ",", "1628", ",", "335", ",", 
        "808", ",", "1852", ",", "830", ",", "822", ",", "834", ",", "834", 
        ",", "1912", ",", "4272", ",", "2036", ",", "2004", ",", "4648", ",", 
        "4356", ",", "868", ",", "896", ",", "4444", ",", "2020", ",", "2084",
         ",", "4680", ",", "2052", ",", "4660", ",", "2052", ",", "4744", ",",
         "4732", ",", "10296", ",", "10644", ",", "10608", ",", "23456", ",", 
        "1968", ",", "2064", ",", "4712", ",", "896", ",", "4476", ",", 
        "2112", ",", "908", ",", "2112", ",", "10512", ",", "4852", ",", 
        "4852", ",", "4840", ",", "10912", ",", "10884", ",", "10776", ",", 
        "11112", ",", "11084", ",", "23616", ",", "24032", ",", "24192", ",", 
        "912", ",", "5324", ",", "4960", ",", "904", ",", "4960", ",", 
        "10952", ",", "11192", ",", "11168", ",", "11392", ",", "24256", ",", 
        "24736", ",", "24704", ",", "23232", ",", "4620", ",", "5104", ",", 
        "11392", ",", "24576", ",", "25248", ",", "11352", ",", "25280", ",", 
        "4256", ",", "25248", ",", "11632", ",", "13024", ",", "25344", ",", 
        "25984"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Smallest", " ", "number", " ", "of", " ", "edges", " ", "of", " ", "any", 
    " ", "graph", " ", "state", " ", "found", " ", "in", " ", "an", " ", 
    "orbit"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"minedgeorbitsLi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "2", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "4", ",", "4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "6", ",", 
        "6", ",", "6", ",", "6", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", 
        "6", ",", "6", ",", "6", ",", "6", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "8", ",", "8", ",", "9", ",", "9", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "10", ",", "10", 
        ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",",
         "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "12", ",", "12", ",", "12", ",", "13", ",", "13", ",", "13"}], 
       "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Schmidt", " ", "measure", " ", "of", " ", "each", " ", "entanglement", 
     " ", 
     RowBox[{"class", ".", " ", "When"}], " ", "an", " ", "exact", " ", 
     "value", " ", "is", " ", "not", " ", "known"}], ",", " ", 
    RowBox[{
    "the", " ", "mean", " ", "of", " ", "the", " ", "upper", " ", "and", " ", 
     "lower", " ", "bounds", " ", "is", " ", "given"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"schmidtgraph", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "2", ",", "2.5`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "2", ",", 
        "3", ",", "3", ",", "3", ",", "3.5`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3.5`", ",", "3.5`",
         ",", "3.5`", ",", "3.5`", ",", "3", ",", "3.5`", ",", "3.5`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3.5`", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "3", 
        ",", "3", ",", "3", ",", "3", ",", "3.5`", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "3", ",", 
        "3", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4.5`", ",", "3.5`", ",", "4",
         ",", "4", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4", ",", "4.5`", ",", "4.5`", ",", "4", ",", "4.5`", ",", "4.5`"}], 
       "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Diameter", " ", "of", " ", "each", " ", "orbit"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"distsorbitsLi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "5", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "4", ",", "4", ",", "5", ",", "6", ",", "6", ",", "5", ",", 
        "6", ",", "6", ",", "7", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "4", ",", "4", ",", "5", ",", "5", ",", "6", ",", "6", ",", 
        "6", ",", "7", ",", "7", ",", "7", ",", "5", ",", "6", ",", "6", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "4", ",", "4", ",", "5", ",", "4", ",", "5", ",", "6", ",", 
        "6", ",", "6", ",", "6", ",", "7", ",", "6", ",", "6", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "5", ",", "5", ",", "6", ",", "6", ",", "6", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "8", ",", "8", ",", "8", ",", "7", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "9", ",", "7", ",", 
        "8", ",", "8", ",", "7", ",", "7", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "9", ",", "9", ",", "9", ",", "7", ",", "7", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "7", ",", "8", ",", "8", ",", 
        "9", ",", "9", ",", "8", ",", "9", ",", "6", ",", "9", ",", "8", ",", 
        "8", ",", "9", ",", "9"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Mean", " ", "diameter", " ", "of", " ", "each", " ", "orbit"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"meandistsorbitsLi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1.`", "}"}], ",", 
      RowBox[{"{", "1.`", "}"}], ",", 
      RowBox[{"{", "1.`", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.6`", ",", "2.109090909090909`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.6666666666666667`", ",", "2.241758241758242`", ",", 
        "2.6344827586206896`", ",", "3.455933379597502`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.7142857142857142`", ",", "2.338235294117647`", ",", 
        "2.3986928104575163`", ",", "2.7780938833570414`", ",", 
        "2.805668016194332`", ",", "3.242999096657633`", ",", 
        "2.7884615384615383`", ",", "2.8353658536585367`", ",", 
        "3.644935064935065`", ",", "4.082427614990001`", ",", 
        "2.8945176960444137`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.75`", ",", "2.4105263157894736`", ",", "2.5108225108225106`", ",", 
        "2.885024154589372`", ",", "2.9202127659574466`", ",", 
        "2.9414893617021276`", ",", "2.973061224489796`", ",", 
        "3.4014189693801344`", ",", "3.4176100628930817`", ",", 
        "3.4280027691242645`", ",", "3.8739189622037156`", ",", 
        "2.9126530612244896`", ",", "2.9879336349924586`", ",", 
        "3.7941054379410546`", ",", "3.4248540450375313`", ",", 
        "3.8206448723690105`", ",", "3.4483590733590734`", ",", 
        "3.84468085106383`", ",", "4.271372510059113`", ",", 
        "4.293653645432301`", ",", "4.722473255599411`", ",", 
        "4.2907949130613146`", ",", "4.717212408444636`", ",", 
        "4.009515313707999`", ",", "4.7181981801819814`", ",", 
        "4.273891668104191`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.7777777777777777`", ",", "2.466403162055336`", ",", 
        "2.5938461538461537`", ",", "2.9664570230607965`", ",", 
        "2.6324786324786325`", ",", "3.026618269812462`", ",", 
        "3.0469924812030076`", ",", "3.094535519125683`", ",", 
        "3.5194920634920637`", ",", "3.124801692226335`", ",", 
        "3.555635062611807`", ",", "3.1418650793650795`", ",", 
        "3.5641915336571826`", ",", "3.5718774548311076`", ",", 
        "3.596296296296296`", ",", "3.5966359885750556`", ",", 
        "4.0371771263624145`", ",", "4.047014130855595`", ",", 
        "3.5868435599778885`", ",", "3.616619747680117`", ",", 
        "4.059539434435032`", ",", "4.072647489029742`", ",", 
        "4.523223473786678`", ",", "3.0084745762711864`", ",", 
        "3.025383395029085`", ",", "3.1013824884792625`", ",", 
        "3.908399585205669`", ",", "3.1463869463869463`", ",", 
        "3.5690257061250397`", ",", "3.9618660472319007`", ",", 
        "3.5729701952723536`", ",", "3.5940390544707093`", ",", 
        "3.609129957047248`", ",", "3.606832484267306`", ",", 
        "4.000824553366926`", ",", "4.421573976017029`", ",", 
        "4.009327805744744`", ",", "4.057257525083612`", ",", 
        "4.445891251219535`", ",", "4.465906451272305`", ",", 
        "3.631704980842912`", ",", "3.6308724832214767`", ",", 
        "4.465104001689368`", ",", "4.0696574332797955`", ",", 
        "4.039111943183899`", ",", "4.459690499360772`", ",", 
        "4.081324333011893`", ",", "4.482345461658842`", ",", 
        "4.088524590163934`", ",", "4.474674176131074`", ",", 
        "4.49417539641651`", ",", "4.947687642153146`", ",", 
        "4.91017645636935`", ",", "4.936801314915804`", ",", 
        "5.371538100271688`", ",", "3.9672240802675587`", ",", 
        "4.023868414543656`", ",", "4.4616305259487525`", ",", 
        "3.6324692038977755`", ",", "4.453028277125736`", ",", 
        "4.0543420034521755`", ",", "3.6452097130242826`", ",", 
        "4.053607920163483`", ",", "4.8929529383077295`", ",", 
        "4.484554130120569`", ",", "4.484836922855937`", ",", 
        "4.506911298110084`", ",", "4.916723202170964`", ",", 
        "4.921401636298286`", ",", "4.942485102626351`", ",", 
        "4.929595103633605`", ",", "4.934244395840407`", ",", 
        "5.364321864160695`", ",", "5.37077879954045`", ",", 
        "5.363866004372124`", ",", "3.640815615196933`", ",", 
        "4.194222999255498`", ",", "4.495573074590661`", ",", 
        "3.6517322691819336`", ",", "4.4943342285367756`", ",", 
        "4.8974413132565315`", ",", "4.909481228069506`", ",", 
        "4.923409004881931`", ",", "4.922559710543863`", ",", 
        "5.3614118488895315`", ",", "5.365295815627978`", ",", 
        "5.3669415952909665`", ",", "5.386323068470063`", ",", 
        "4.430100703545317`", ",", "4.472269817664555`", ",", 
        "4.924292658282394`", ",", "5.372469608162379`", ",", 
        "5.369729983790592`", ",", "4.933588121045047`", ",", 
        "5.368582030044759`", ",", "3.5406878778868074`", ",", 
        "5.372864606243937`", ",", "4.934586967740311`", ",", 
        "4.63518421477856`", ",", "5.369262565662945`", ",", 
        "5.367322014561376`"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Length", " ", "of", " ", "the", " ", "automorphism", " ", "group", " ", 
    "of", " ", "each", " ", "orbit"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"autlenLiloops", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3", ",", "3", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "5", ",", "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "4", ",", "4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "6", ",", "5", ",", "5", ",", "4", ",", "5", ",", "5", ",", "4", ",", 
        "3", ",", "3", ",", "4", ",", "3", ",", "5", ",", "4", ",", "5", ",", 
        "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", 
        "4", ",", "4", ",", "3", ",", "3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "7", ",", "6", ",", "6", ",", "5", ",", "4", ",", "5", ",", "6", ",", 
        "5", ",", "4", ",", "5", ",", "4", ",", "6", ",", "5", ",", "4", ",", 
        "4", ",", "5", ",", "3", ",", "4", ",", "5", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "6", ",", "6", ",", "5", ",", "6", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "3", ",", 
        "4", ",", "4", ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "4", ",", "5", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "2", ",", "3", ",", "2", ",", "3", ",", "3", ",", "6", ",", 
        "4", ",", "4", ",", "5", ",", "4", ",", "5", ",", "4", ",", "3", ",", 
        "4", ",", "4", ",", "2", ",", "4", ",", "3", ",", "2", ",", "4", ",", 
        "4", ",", "2", ",", "3", ",", "2", ",", "4", ",", "5", ",", "5", ",", 
        "5", ",", "4", ",", "4", ",", "5", ",", "3", ",", "4", ",", "3", ",", 
        "3", ",", "2", ",", "3", ",", "5", ",", "6", ",", "5", ",", "4", ",", 
        "4", ",", "3", ",", "4", ",", "3", ",", "5", ",", "3", ",", "4", ",", 
        "4", ",", "5", ",", "5"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Length", " ", "of", " ", "the", " ", "automorphism", " ", "group", " ", 
     "of", " ", "each", " ", "orbit"}], ",", " ", 
    RowBox[{
     RowBox[{"with", " ", "self"}], "-", 
     RowBox[{"loops", " ", "removed"}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"autlenLinoloops", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "5", ",", "4", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", 
        "3", ",", "4", ",", "4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "6", ",", "5", ",", "5", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "3", ",", "3", ",", "4", ",", "2", ",", "4", ",", "4", ",", "5", ",", 
        "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", "2", ",", 
        "4", ",", "4", ",", "3", ",", "3", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "7", ",", "6", ",", "6", ",", "5", ",", "4", ",", "5", ",", "5", ",", 
        "5", ",", "4", ",", "5", ",", "4", ",", "4", ",", "3", ",", "4", ",", 
        "4", ",", "4", ",", "3", ",", "4", ",", "5", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "5", ",", "5", ",", "5", ",", "6", ",", "4", ",", 
        "4", ",", "4", ",", "5", ",", "4", ",", "4", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "3", ",", "2", ",", "5", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "3", ",", "5", ",", "3", ",", "3", ",", "3", ",", 
        "2", ",", "2", ",", "3", ",", "2", ",", "3", ",", "3", ",", "5", ",", 
        "4", ",", "3", ",", "5", ",", "5", ",", "4", ",", "4", ",", "3", ",", 
        "4", ",", "4", ",", "2", ",", "4", ",", "3", ",", "2", ",", "3", ",", 
        "4", ",", "2", ",", "3", ",", "2", ",", "4", ",", "6", ",", "5", ",", 
        "4", ",", "4", ",", "3", ",", "4", ",", "4", ",", "4", ",", "3", ",", 
        "3", ",", "2", ",", "3", ",", "5", ",", "6", ",", "4", ",", "4", ",", 
        "4", ",", "3", ",", "5", ",", "3", ",", "5", ",", "3", ",", "4", ",", 
        "4", ",", "5", ",", "5"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Is", " ", "the", " ", "orbit", " ", "a", " ", 
    RowBox[{"tree", "?"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"treeLi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False", ",", "False", ",", "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Is", " ", "the", " ", "orbit", " ", 
    RowBox[{"planar", "?"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"planarLi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False", ",", "False", ",", "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Is", " ", "the", " ", "orbit", " ", 
      RowBox[{"Hamiltonian", "?", " ", "Self"}]}], "-", 
     RowBox[{"loops", " ", 
      RowBox[{"removed", ".", " ", "Computing"}], " ", "for", " ", "6"}]}], 
    ",", " ", "7", ",", " ", 
    RowBox[{
    "and", " ", "8", " ", "and", " ", "9", " ", "qubit", " ", "orbits", " ", 
     "in", " ", "Mathematica", " ", "using", " ", 
     RowBox[{"HamiltonianGraphQ", "[", "]"}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hamilLi", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "True", "}"}], ",", 
     RowBox[{"{", "True", "}"}], ",", 
     RowBox[{"{", "False", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "False", ",", "True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
       "True", ",", "False", ",", "True", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.769511573462906*^9, 3.769511618160844*^9}, {
   3.7695119171351995`*^9, 3.769511985797065*^9}, {3.7695121170531893`*^9, 
   3.76951214606709*^9}, {3.7695121824527283`*^9, 3.7695121837738605`*^9}, {
   3.7695123187363553`*^9, 3.7695124797334538`*^9}, {3.769512847316208*^9, 
   3.769512848424319*^9}, {3.7695132111795907`*^9, 3.7695132741098833`*^9}, {
   3.7695135188689833`*^9, 3.7695135382819834`*^9}, {3.7695137600929832`*^9, 
   3.7695137695729837`*^9}, {3.769513800301984*^9, 3.7695138032249837`*^9}, {
   3.7695138696059837`*^9, 3.7695138851359835`*^9}, {3.7728043157466135`*^9, 
   3.772804315769603*^9}, 3.7728052460392113`*^9, {3.772808695342209*^9, 
   3.7728087088076963`*^9}, {3.7728103517110524`*^9, 
   3.7728103608065767`*^9}, {3.7728108757714567`*^9, 
   3.7728108763821073`*^9}, {3.772811028489762*^9, 3.7728110290924263`*^9}, {
   3.7728110829845047`*^9, 3.772811086387596*^9}, 3.7728117324011354`*^9, {
   3.7742764119954243`*^9, 3.7742764161792517`*^9}, {3.7742764641209936`*^9, 
   3.7742764651721644`*^9}, {3.7743496926553483`*^9, 3.774349696163955*^9}, 
   3.7745978161699276`*^9, {3.7747769771739917`*^9, 3.7747769774698286`*^9}, {
   3.774777027902123*^9, 3.7747770282049456`*^9}, {3.774778850521672*^9, 
   3.7747788657365847`*^9}, {3.7747789203728447`*^9, 3.774778923674014*^9}, {
   3.774780244822409*^9, 3.7747802689163747`*^9}, {3.774780342755142*^9, 
   3.774780343230689*^9}, {3.7747803977996883`*^9, 3.774780398095187*^9}, {
   3.7747810043700542`*^9, 3.7747810091353664`*^9}, {3.7747819236195755`*^9, 
   3.774781923857444*^9}, {3.7747828037850113`*^9, 3.774782804165471*^9}, {
   3.774787805611288*^9, 3.7747878244944677`*^9}, {3.775471639844063*^9, 
   3.7754716452252426`*^9}, {3.7754881377592278`*^9, 3.775488138847617*^9}, {
   3.7754882131892266`*^9, 3.7754882184383755`*^9}, {3.7778094449991355`*^9, 
   3.7778094675375276`*^9}, {3.7778980950363045`*^9, 
   3.7778981089171486`*^9}, {3.7778984304069743`*^9, 
   3.7778984410886683`*^9}, {3.7783278035675344`*^9, 3.778327805043667*^9}, {
   3.7795601422458577`*^9, 3.7795601430881863`*^9}, {3.7912009712284203`*^9, 
   3.7912009717172775`*^9}, {3.7918689758996325`*^9, 3.791869143486004*^9}, {
   3.7918691791185813`*^9, 3.7918692034733357`*^9}, {3.791870005356083*^9, 
   3.791870005593111*^9}, 3.791870618843464*^9, {3.7918707745799465`*^9, 
   3.791870825192478*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"7e7b6a6c-0c43-495a-8a22-713e217b0d1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import data from \[OpenCurlyQuote].csv\[CloseCurlyQuote] (not \
recommended)", "Subsection",
 CellChangeTimes->{{3.76951057286777*^9, 3.7695105750707703`*^9}, {
   3.7695117715116386`*^9, 3.769511793808868*^9}, {3.7918710648342237`*^9, 
   3.791871067034794*^9}, 
   3.7918711456113343`*^9},ExpressionUUID->"9693424a-c647-4eed-8773-\
9a2d95e80a05"],

Cell[CellGroupData[{

Cell["4 qubit", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
   3.7695105777227707`*^9, 3.7695105863467703`*^9}, 
   3.7695106326967707`*^9},ExpressionUUID->"0421e6e7-91d5-4712-85f7-\
ffb422a222e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fourLidat", "=", 
   RowBox[{"ToString", "@", 
    RowBox[{"Import", "[", "\"\<4qubitorbitsLi.csv\>\"", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fourLidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fourLidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fourLidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fourLidat", "=", 
    RowBox[{"ToExpression", "@", "fourLidat"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fourLiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"fourLidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"fourLidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"fourLidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"fourLidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "fourLiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fourLigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"Graph", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Range", "[", "four", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"fourLidat", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"fourLigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"UndirectedGraph", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"fourLigraphlists", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"EdgeStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexStyle", "\[Rule]", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "@", "fourLidat"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"Length", "@", 
       RowBox[{
        RowBox[{"fourLidat", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.7695106394907703`*^9, 3.7695106525707703`*^9}, {3.7695113154967704`*^9, 
   3.76951132742677*^9}, {3.769511410644349*^9, 3.769511410675355*^9}, {
   3.7695115706153364`*^9, 3.769511579968207*^9}, 3.769513046845159*^9, 
   3.769513085808055*^9, {3.7695132462490973`*^9, 3.769513251065579*^9}, {
   3.769513395219993*^9, 3.769513398342305*^9}, {3.7695135027039833`*^9, 
   3.7695135092899837`*^9}, 3.7695136114699836`*^9, {3.7695137601149836`*^9, 
   3.7695137740669837`*^9}, {3.772804315777597*^9, 3.772804315867545*^9}, 
   3.772804675142756*^9, 3.7728102997896314`*^9, 3.7728104939470935`*^9, {
   3.772810875789442*^9, 3.7728108757944393`*^9}, {3.7728110285237284`*^9, 
   3.7728110285297403`*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"1abcd559-fa18-420b-8afc-4b6cbaf90a9e"]
}, Closed]],

Cell[CellGroupData[{

Cell["5 qubit", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
  3.7695105777227707`*^9, 
  3.7695105863467703`*^9}},ExpressionUUID->"f527f263-2d6b-4b51-8cb2-\
246babcc7879"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fiveLidat", "=", 
   RowBox[{"ToString", "@", 
    RowBox[{"Import", "[", "\"\<5qubitorbitsLi.csv\>\"", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiveLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fiveLidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiveLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fiveLidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiveLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fiveLidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fiveLidat", "=", 
    RowBox[{"ToExpression", "@", "fiveLidat"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fiveLiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"fiveLidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"fiveLidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"fiveLidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"fiveLidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "fiveLiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fiveLigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"Graph", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Range", "[", "five", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"fiveLidat", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"fiveLigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"UndirectedGraph", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"fiveLigraphlists", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"EdgeStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexStyle", "\[Rule]", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "@", "fiveLidat"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"Length", "@", 
       RowBox[{
        RowBox[{"fiveLidat", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.76951067694777*^9, 3.7695106770687704`*^9}, {3.7695113043057704`*^9, 
   3.7695113317337704`*^9}, {3.7695114048681936`*^9, 3.7695114049002*^9}, {
   3.7695115848061743`*^9, 3.769511589590131*^9}, {3.7695133358670588`*^9, 
   3.7695133556600375`*^9}, 3.769513554622984*^9, 3.7695136114829836`*^9, {
   3.769513760124984*^9, 3.7695137741019835`*^9}, {3.7728043158785386`*^9, 
   3.772804315949497*^9}, 3.7728046419259777`*^9, 3.7728103034837523`*^9, 
   3.7728104847426496`*^9, 3.7728106877482767`*^9, 3.7728108758034344`*^9, {
   3.7728110285417185`*^9, 3.772811028547714*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"2ec46232-3204-48bd-b451-f8349cf20cac"]
}, Closed]],

Cell[CellGroupData[{

Cell["6 qubit", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
  3.7695105777227707`*^9, 
  3.7695106100097704`*^9}},ExpressionUUID->"f65b7cd5-86ff-4b43-9899-\
1f21251cd0be"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sixLidat", "=", 
   RowBox[{"ToString", "@", 
    RowBox[{"Import", "[", "\"\<6qubitorbitsLi.csv\>\"", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sixLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sixLidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sixLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sixLidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sixLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sixLidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sixLidat", "=", 
    RowBox[{"ToExpression", "@", "sixLidat"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sixLiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"sixLidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sixLidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"sixLidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"sixLidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "sixLiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sixLigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"Graph", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Range", "[", "six", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"sixLidat", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sixLigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"UndirectedGraph", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"sixLigraphlists", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"EdgeStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexStyle", "\[Rule]", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "@", "sixLidat"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"Length", "@", 
       RowBox[{
        RowBox[{"sixLidat", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.7695106631147704`*^9, 3.7695106709087706`*^9}, {3.7695112962817707`*^9, 
   3.7695112962857704`*^9}, {3.7695113365297704`*^9, 
   3.7695113365347705`*^9}, {3.7695113983708944`*^9, 3.769511398403901*^9}, {
   3.7695115915295186`*^9, 3.769511592352683*^9}, 3.7695134003765087`*^9, 
   3.7695135601709833`*^9, 3.7695136114899836`*^9, {3.7695137601359835`*^9, 
   3.7695137741319838`*^9}, {3.7728043159614906`*^9, 3.772804316033451*^9}, 
   3.7728046419349527`*^9, 3.7728103104584055`*^9, 3.7728106021359797`*^9, {
   3.7728106877582703`*^9, 3.772810687764268*^9}, {3.7728110285587053`*^9, 
   3.7728110285637026`*^9}},
 CellLabel->
  "In[117]:=",ExpressionUUID->"849882b0-cab2-4b8d-9414-60a64c8733ad"]
}, Closed]],

Cell[CellGroupData[{

Cell["7 qubit", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
  3.7695105777227707`*^9, 
  3.7695106215527706`*^9}},ExpressionUUID->"2d5cba60-f381-4b18-a96c-\
c0650f8b8724"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sevenLidat", "=", 
   RowBox[{"ToString", "@", 
    RowBox[{"Import", "[", "\"\<7qubitorbitsLi.csv\>\"", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sevenLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sevenLidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sevenLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sevenLidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sevenLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sevenLidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sevenLidat", "=", 
    RowBox[{"ToExpression", "@", "sevenLidat"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sevenLiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"sevenLidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sevenLidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"sevenLidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"sevenLidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "sevenLiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sevenLigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"Graph", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Range", "[", "seven", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"sevenLidat", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sevenLigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"UndirectedGraph", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"sevenLigraphlists", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"EdgeStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexStyle", "\[Rule]", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "@", "sevenLidat"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"Length", "@", 
       RowBox[{
        RowBox[{"sevenLidat", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.7695106766087704`*^9, 3.76951069586077*^9}, {3.7695112903317704`*^9, 
   3.76951129033677*^9}, {3.7695113426867704`*^9, 3.7695113426927705`*^9}, {
   3.769511392961813*^9, 3.7695113929998207`*^9}, 3.769511597453703*^9, 
   3.769511629255062*^9, 3.769513403638835*^9, 3.7695135625269833`*^9, 
   3.7695136114989834`*^9, {3.7695137601459837`*^9, 3.7695137741619835`*^9}, {
   3.7728043160464425`*^9, 3.772804316117402*^9}, 3.7728046419429474`*^9, 
   3.772810314909419*^9, 3.7728104813419876`*^9, {3.772810687773261*^9, 
   3.772810687778259*^9}, {3.772811028573697*^9, 3.7728110285776944`*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"e6accff7-cb8f-446c-920e-74c387f54d4a"]
}, Closed]],

Cell[CellGroupData[{

Cell["8 qubit (takes a few minutes)", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
  3.7695105777227707`*^9, 3.7695106243137703`*^9}, {3.7695110725937705`*^9, 
  3.76951107502777*^9}},ExpressionUUID->"c6096ee5-1a0d-4d0a-ad45-\
180f0cf87633"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eightLidat", "=", 
   RowBox[{"Import", "[", "\"\<8qubitorbitsLi.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<Import successfull. Converting to string for processing..\>\"", "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightLidat", "=", 
   RowBox[{"ToString", "@", "eightLidat"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<Success! Processing string..\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"eightLidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"eightLidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightLidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"eightLidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightLidat", "=", 
   RowBox[{"ToExpression", "@", "eightLidat"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<Success! Generating orbits..\>\"", "]"}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"eightLiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"eightLidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"eightLidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"eightLidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"eightLidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "eightLiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"eightLigraphlists", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "j", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", "eight", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"eightLidat", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "5", "]"}], "]"}], "[", 
          RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"eightLigraphlists", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "j", "]"}], "]"}], "=", 
       RowBox[{"UndirectedGraph", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"eightLigraphlists", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"EdgeStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"VertexStyle", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "eightLidat"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"Length", "@", 
        RowBox[{
         RowBox[{"eightLidat", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<Success! Done.\>\"", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.7695106766637707`*^9, 3.7695107099437704`*^9}, {3.7695112846587706`*^9, 
   3.7695112846627703`*^9}, {3.7695113485547705`*^9, 
   3.7695113704017706`*^9}, {3.7695116028867893`*^9, 3.769511604168046*^9}, {
   3.769512664755954*^9, 3.769512682037682*^9}, {3.769512756739151*^9, 
   3.7695127745529327`*^9}, 3.7695134062709837`*^9, 3.769513566096984*^9, 
   3.7695136115059834`*^9, {3.7695137601569834`*^9, 3.7695137741969833`*^9}, {
   3.772804316130394*^9, 3.772804316213369*^9}, {3.772804348241401*^9, 
   3.7728043650600853`*^9}, 3.772804641951945*^9, 3.772810318023108*^9, 
   3.772810474308593*^9, {3.772810687790254*^9, 3.77281068779525*^9}, {
   3.7728110245028644`*^9, 3.7728110245088615`*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"997f51d7-45ff-4ad9-b30f-73f1899edb6f"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Import successfull. Converting to string for processing..\"\
\>"], "Print",
 CellChangeTimes->{3.7728043585288534`*^9, 3.772804562070166*^9, 
  3.772804700354287*^9, 3.772805292016221*^9, 3.772810373368307*^9, 
  3.772810612471884*^9, 3.772810718860243*^9, 3.7728107859683256`*^9, 
  3.7916276305821037`*^9, 3.7916277271825066`*^9, 3.7918710616757135`*^9},
 CellLabel->
  "During evaluation of \
In[131]:=",ExpressionUUID->"8b6a919c-b12d-4d8f-9c7e-b972cc91b48f"],

Cell[BoxData["\<\"Success! Processing string..\"\>"], "Print",
 CellChangeTimes->{3.7728043585288534`*^9, 3.772804562070166*^9, 
  3.772804700354287*^9, 3.772805292016221*^9, 3.772810373368307*^9, 
  3.772810612471884*^9, 3.772810718860243*^9, 3.7728107859683256`*^9, 
  3.7916276305821037`*^9, 3.7916277271825066`*^9, 3.791871061955395*^9},
 CellLabel->
  "During evaluation of \
In[131]:=",ExpressionUUID->"ac46b7d5-2298-4016-97af-bd8d93108815"],

Cell[BoxData["\<\"Success! Generating orbits..\"\>"], "Print",
 CellChangeTimes->{3.7728043585288534`*^9, 3.772804562070166*^9, 
  3.772804700354287*^9, 3.772805292016221*^9, 3.772810373368307*^9, 
  3.772810612471884*^9, 3.772810718860243*^9, 3.7728107859683256`*^9, 
  3.7916276305821037`*^9, 3.7916277271825066`*^9, 3.7918710670639067`*^9},
 CellLabel->
  "During evaluation of \
In[131]:=",ExpressionUUID->"1662116c-525f-44c6-b0fe-48338c6b904d"],

Cell[BoxData["\<\"Success! Done.\"\>"], "Print",
 CellChangeTimes->{3.7728043585288534`*^9, 3.772804562070166*^9, 
  3.772804700354287*^9, 3.772805292016221*^9, 3.772810373368307*^9, 
  3.772810612471884*^9, 3.772810718860243*^9, 3.7728107859683256`*^9, 
  3.7916276305821037`*^9, 3.7916277271825066`*^9, 3.7918711020378323`*^9},
 CellLabel->
  "During evaluation of \
In[131]:=",ExpressionUUID->"a36a0b0d-14de-4c03-8d7c-9c7ed7f8b9e2"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Initialise to one variable.", "Subsubsection",
 CellChangeTimes->{{3.7695110857697706`*^9, 3.7695110927517705`*^9}, {
  3.769512876280104*^9, 
  3.7695128813226085`*^9}},ExpressionUUID->"e8429077-c4df-4425-9a92-\
8fb629b0e3a7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"orbitsCi", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", "fourLiorbits", ",", "fiveLiorbits", ",", 
     "sixLiorbits", ",", "sevenLiorbits", ",", "eightLiorbits"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"orbitsLigraphlist", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "}"}], ",", "fourLigraphlists", ",", "fiveLigraphlists", 
      ",", "sixLigraphlists", ",", "sevenLigraphlists", ",", 
      "eightLigraphlists"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "fourLidat", ",", "fiveLidat", ",", "sixLidat", ",", "sevenLidat", ",", 
    "eightLidat", ",", "nineLidat", ",", "fourLiorbits", ",", "fiveLiorbits", 
    ",", "sixLiorbits", ",", "sevenLiorbits", ",", "eightLiorbits", ",", 
    "nineLiorbits", ",", "fourLigraphlists", ",", "fiveLigraphlists", ",", 
    "sixLigraphlists", ",", "sevenLigraphlists", ",", "eightLigraphlists"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.779560181356546*^9, 3.7795601913706474`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"ee6f68e2-fbab-4e5f-b056-239ca5a16070"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Import data from \[OpenCurlyQuote].mx\[CloseCurlyQuote] (recommended)", \
"Subsection",
 CellChangeTimes->{{3.76951057286777*^9, 3.7695105750707703`*^9}, {
  3.7695117715116386`*^9, 3.769511790617549*^9}, {3.791871139530445*^9, 
  3.791871144539573*^9}},ExpressionUUID->"14177f10-8700-49ef-b2c5-\
d41f9013f0a0"],

Cell[CellGroupData[{

Cell["\<\
Import from Mathematica 11 \[OpenCurlyQuote].mx\[CloseCurlyQuote] file (this \
may take a minute)\
\>", "Subsubsection",
 CellChangeTimes->{{3.769344918150916*^9, 3.769344927756877*^9}, {
  3.7695140343249836`*^9, 3.7695140523919835`*^9}, {3.772810735671193*^9, 
  3.7728107507676697`*^9}},ExpressionUUID->"ddc49fcb-419b-400e-9aa5-\
eee29834883a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"orbitsLi", "=", 
   RowBox[{"Import", "[", "\"\<orbitsLi.mx\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"orbitsLigraphlist", "=", 
   RowBox[{"Import", "[", "\"\<orbitsLigraphlist.mx\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7693502852437787`*^9, 3.769350285245779*^9}, {
  3.769350361141368*^9, 3.769350369526206*^9}, {3.7693504759458475`*^9, 
  3.769350504757728*^9}, {3.769511713232811*^9, 3.769511715755063*^9}, {
  3.7728043162703333`*^9, 3.7728043162773347`*^9}, {3.776584984603546*^9, 
  3.776585001341548*^9}, {3.779560200159917*^9, 3.7795602009492054`*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"9b0c41d4-beb3-4559-9af8-b5c9542313e7"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions", "Chapter",
 CellChangeTimes->{{3.7695141358369837`*^9, 
  3.7695141367899837`*^9}},ExpressionUUID->"5e7806cc-6186-4f9d-b338-\
116084299b8b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"deleteIsoG1", "[", "gl_List", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"DeleteDuplicates", "[", 
       RowBox[{"gl", ",", "IsomorphicGraphQ"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"colourblender", "[", 
     RowBox[{"one_", ",", "two_"}], "]"}], ":=", 
    RowBox[{"Blend", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"one", ",", "two"}], "}"}], ",", "0.5"}], "]"}]}], ";"}], " ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"plotOrbitLi", "[", 
     RowBox[{"noqub_", ",", "myclass_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "oedgelabels", ",", "theselabels", ",", "graphimgs", ",", "imsz", ",", 
        "g1", ",", "graphlabelgraph", ",", "graphlabels", ",", "thisorbit"}], 
       "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Sanitise", " ", "graphs", " ", "for", " ", "printing"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"orbitsLigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", "=", 
          RowBox[{"Graph", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"orbitsLigraphlist", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"ImagePadding", "\[Rule]", "0"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsLigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Sanitise", " ", "orbit", " ", "edge", " ", "labels", " ", "for", " ",
          "printing"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"theselabels", "=", 
        RowBox[{"Sort", "@", 
         RowBox[{"(", 
          RowBox[{"List", "@@@", 
           RowBox[{"PropertyValue", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"orbitsLi", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], ",", "EdgeLabels"}], 
            "]"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"oedgelabels", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"theselabels", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<=", 
            RowBox[{
             RowBox[{
              RowBox[{"theselabels", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"oedgelabels", " ", ",", 
             RowBox[{"{", " ", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"theselabels", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<->", 
                RowBox[{
                 RowBox[{
                  RowBox[{"theselabels", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"theselabels", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", "theselabels"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"oedgelabels", "=", 
        RowBox[{"Thread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"oedgelabels", "\[Transpose]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "->", 
          RowBox[{
           RowBox[{"oedgelabels", "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "get", " ", "images", " ", "of", " ", "each", " ", "graph", " ", 
         "state", " ", "to", " ", "plot", " ", "on", " ", "the", " ", 
         "vertices", " ", "of", " ", "the", " ", "orbit"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"graphimgs", "=", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", 
          RowBox[{
           RowBox[{"orbitsLigraphlist", "[", 
            RowBox[{"[", "noqub", "]"}], "]"}], "[", 
           RowBox[{"[", "myclass", "]"}], "]"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"imsz", "=", "100"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"graph", " ", "state", " ", "vertices", " ", 
          RowBox[{"labelled", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{"graphsvertexlabelledQ", ",", 
            RowBox[{
             RowBox[{"g1", "=", 
              RowBox[{"Graph", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"orbitsLigraphlist", "[", 
                   RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                  RowBox[{"[", "myclass", "]"}], "]"}], "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{"VertexLabels", "\[Rule]", 
                 RowBox[{"Thread", "[", 
                  RowBox[{
                   RowBox[{"Range", "[", "noqub", "]"}], "\[Rule]", 
                   RowBox[{"Range", "[", "noqub", "]"}]}], "]"}]}], ",", 
                RowBox[{"VertexSize", "\[Rule]", "svsize"}], ",", 
                RowBox[{"EdgeStyle", "\[Rule]", "sesize"}], ",", 
                RowBox[{"VertexLabelStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "vertexlabelfontsize"}], "]"}]}]}], 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"g1", "=", 
              RowBox[{"SetProperty", "[", 
               RowBox[{"g1", ",", 
                RowBox[{"VertexLabels", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"#", "\[Rule]", 
                    RowBox[{"Placed", "[", 
                    RowBox[{"#2", ",", 
                    RowBox[{"{", 
                    RowBox[{"0.59", ",", "0.4"}], "}"}]}], "]"}]}], "&"}], "@@@", 
                   RowBox[{"(", 
                    RowBox[{"VertexLabels", "/.", 
                    RowBox[{"Options", "[", "g1", "]"}]}], ")"}]}], ")"}]}]}],
                "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"g1", "=", 
              RowBox[{"Graph", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"orbitsLigraphlist", "[", 
                   RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                  RowBox[{"[", "myclass", "]"}], "]"}], "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{"VertexSize", "\[Rule]", "svsize"}], ",", 
                RowBox[{"EdgeStyle", "\[Rule]", "sesize"}]}], "]"}]}], 
             ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"graphimgs", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"g1", ",", "\[IndentingNewLine]", 
               RowBox[{"Graphics", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Directive", "[", 
                   RowBox[{"Black", ",", 
                    RowBox[{"Thickness", "[", "gcirclethickness", "]"}]}], 
                   "]"}], ",", 
                  RowBox[{"Circle", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", "gpadding"}], 
                   "]"}]}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", "imsz"}]}], "]"}]}]}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsLigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"graphlabelgraph", "=", 
        RowBox[{"Thread", "[", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsLigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}], "]"}], "->", 
          "graphimgs"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"compute", " ", "graph", " ", "state", " ", "labels"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"graphslabelledQ", " ", ",", "\[IndentingNewLine]", 
         RowBox[{"graphlabels", "=", " ", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"i", "->", 
             RowBox[{"\"\<G\>\"", "<>", 
              RowBox[{"ToString", "[", "i", "]"}]}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "@", 
               RowBox[{
                RowBox[{"orbitsLigraphlist", "[", 
                 RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"graphlabels", "=", 
           RowBox[{"Thread", "[", 
            RowBox[{
             RowBox[{"Range", "@", 
              RowBox[{"Length", "@", 
               RowBox[{
                RowBox[{"orbitsLigraphlist", "[", 
                 RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                RowBox[{"[", "myclass", "]"}], "]"}]}]}], "\[Rule]", 
             RowBox[{"Table", "[", 
              RowBox[{"None", ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", 
                 RowBox[{"Length", "@", 
                  RowBox[{
                   RowBox[{"orbitsLigraphlist", "[", 
                    RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                   RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}]}],
             "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"orbitedgeslabelledQ", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"thisorbit", "=", 
           RowBox[{"UndirectedGraph", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"orbitsLi", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], ",", 
             RowBox[{"VertexLabels", "\[Rule]", "graphlabels"}], ",", 
             RowBox[{"EdgeLabels", "\[Rule]", "oedgelabels"}], ",", 
             RowBox[{"VertexShape", "\[Rule]", "graphlabelgraph"}], ",", 
             RowBox[{"VertexSize", "\[Rule]", "lvsize"}], ",", 
             RowBox[{"EdgeStyle", "\[Rule]", "lesize"}], ",", 
             RowBox[{"EdgeLabelStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "edgefontsize"}], "]"}]}]}], 
            RowBox[{"(*", 
             RowBox[{",", 
              RowBox[{"GraphLayout", "\[Rule]", "\"\<SpringEmbedding\>\""}]}],
              "*)"}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"graphslabelledQ", " ", ",", 
            RowBox[{
             RowBox[{"thisorbit", "=", 
              RowBox[{"SetProperty", "[", 
               RowBox[{"thisorbit", ",", 
                RowBox[{"VertexLabels", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"#", "\[Rule]", 
                    RowBox[{"Placed", "[", 
                    RowBox[{"#2", ",", 
                    RowBox[{"{", 
                    RowBox[{"0.51", ",", "0.29"}], "}"}]}], "]"}]}], "&"}], "@@@", 
                   RowBox[{"(", 
                    RowBox[{"VertexLabels", "/.", 
                    RowBox[{"Options", "[", "thisorbit", "]"}]}], ")"}]}], 
                  ")"}]}]}], "]"}]}], ";"}]}], "]"}]}], "\[IndentingNewLine]",
          ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"thisorbit", "=", 
           RowBox[{"UndirectedGraph", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"orbitsLi", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], ",", 
             RowBox[{"EdgeLabels", "\[Rule]", "None"}], ",", 
             RowBox[{"VertexShape", "\[Rule]", "graphlabelgraph"}], ",", 
             RowBox[{"VertexLabels", "\[Rule]", "graphlabels"}], ",", 
             RowBox[{"VertexSize", "\[Rule]", "lvsize"}], ",", 
             RowBox[{"EdgeStyle", "\[Rule]", "lesize"}], ",", 
             RowBox[{"EdgeLabelStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "edgefontsize"}], "]"}]}]}], 
            RowBox[{"(*", 
             RowBox[{",", 
              RowBox[{"GraphLayout", "\[Rule]", "\"\<SpringEmbedding\>\""}]}],
              "*)"}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"graphslabelledQ", " ", ",", 
            RowBox[{
             RowBox[{"thisorbit", "=", 
              RowBox[{"SetProperty", "[", 
               RowBox[{"thisorbit", ",", 
                RowBox[{"VertexLabels", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"#", "\[Rule]", 
                    RowBox[{"Placed", "[", 
                    RowBox[{"#2", ",", 
                    RowBox[{"{", 
                    RowBox[{"0.51", ",", "0.29"}], "}"}]}], "]"}]}], "&"}], "@@@", 
                   RowBox[{"(", 
                    RowBox[{"VertexLabels", "/.", 
                    RowBox[{"Options", "[", "thisorbit", "]"}]}], ")"}]}], 
                  ")"}]}]}], "]"}]}], ";"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "thisorbit"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotOrbitMatrixLi", "[", 
    RowBox[{"noqub_", ",", "myclass_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "theselabels", ",", "oedgelabels", ",", "goodcolours", ",", "labels", 
       ",", "colourlabel", ",", "mycolours", ",", "isocolours", ",", 
       "isocolours2", ",", "gatheredisocols", ",", "isolens", ",", "isocount",
        ",", "colourisoadjmat", ",", "LCadj", ",", "isogroups", ",", "isomat",
        ",", "one", ",", "two", ",", "glo", ",", "glr", ",", "glos", ",", 
       "bticks", ",", "arfaccumisolenssd", ",", "tickas", ",", "gl", ",", 
       "btickstr", ",", "accumisolens", ",", "noedg", ",", "avar", ",", 
       "orbitadj", ",", "orbitlegend", ",", "dist", ",", "distp", ",", 
       "distleg"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Sanitise", " ", "graphs", " ", "for", " ", "printing"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"orbitsLigraphlist", "[", 
            RowBox[{"[", "noqub", "]"}], "]"}], "[", 
           RowBox[{"[", "myclass", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], " ", "=", 
         RowBox[{"Graph", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"orbitsLigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}], "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", 
           RowBox[{"ImagePadding", "\[Rule]", "0"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "@", 
           RowBox[{
            RowBox[{"orbitsLigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Sanitise", " ", "orbit", " ", "edge", " ", "labels", " ", "for", " ", 
        "printing"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"theselabels", "=", 
       RowBox[{"Sort", "@", 
        RowBox[{"(", 
         RowBox[{"List", "@@@", 
          RowBox[{"PropertyValue", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"orbitsLi", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}], ",", "EdgeLabels"}], 
           "]"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"oedgelabels", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"theselabels", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<=", 
           RowBox[{
            RowBox[{
             RowBox[{"theselabels", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"oedgelabels", " ", ",", 
            RowBox[{"{", " ", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"theselabels", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<->", 
               RowBox[{
                RowBox[{
                 RowBox[{"theselabels", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"theselabels", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "@", "theselabels"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"oedgelabels", "=", 
       RowBox[{"Thread", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"oedgelabels", "\[Transpose]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "->", 
         RowBox[{
          RowBox[{"oedgelabels", "\[Transpose]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"compute", " ", "colour", " ", "space"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"goodcolours", "=", 
       RowBox[{"ColorData", "[", 
        RowBox[{"97", ",", "\"\<ColorList\>\""}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"labels", "=", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"theselabels", "\[Transpose]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"one", " ", "colour", " ", "per", " ", "LC", " ", "type", " ", 
        RowBox[{"(", 
         RowBox[{"graph", " ", "state", " ", "vertex"}], ")"}]}], " ", "*)"}],
       "\[IndentingNewLine]", 
      RowBox[{"colourlabel", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"labels", "/.", 
          RowBox[{"{", 
           RowBox[{"Thread", "[", 
            RowBox[{
             RowBox[{"Range", "[", "15", "]"}], "->", "goodcolours"}], "]"}], 
           "}"}]}], ",", "1"}], "]"}]}], ";", 
      RowBox[{"colourlabel", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Sort", "@", 
             RowBox[{"(", 
              RowBox[{"List", "@@@", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"orbitsLi", "[", 
                   RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                  RowBox[{"[", "myclass", "]"}], "]"}], ",", "EdgeLabels"}], 
                "]"}]}], ")"}]}], "\[Transpose]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "colourlabel"}], "}"}], 
        "\[Transpose]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Isomorphic", " ", "region", " ", "colours"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"mycolours", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{
           RowBox[{"i", "/", 
            RowBox[{"Length", "[", 
             RowBox[{
              RowBox[{"orbitsLigraphlist", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], "]"}]}], ",", "satmod", 
           ",", "brightmod"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsLigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"isocolours", "=", "mycolours"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "Find", " ", "regions", " ", "of", " ", "isomorphic", " ", "graphs"}],
         ",", " ", 
        RowBox[{"set", " ", "colour", " ", "regions", " ", 
         RowBox[{"to", " ", "'"}], 
         RowBox[{"isocolours", "'"}]}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IsomorphicGraphQ", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"orbitsLigraphlist", "[", 
                  RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                 RowBox[{"[", "myclass", "]"}], "]"}], "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"orbitsLigraphlist", "[", 
                  RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                 RowBox[{"[", "myclass", "]"}], "]"}], "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"isocolours", "[", 
                RowBox[{"[", "j", "]"}], "]"}], "=", 
               RowBox[{"mycolours", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], ";"}]}], 
            "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", 
             RowBox[{"Length", "@", 
              RowBox[{
               RowBox[{"orbitsLigraphlist", "[", 
                RowBox[{"[", "noqub", "]"}], "]"}], "[", 
               RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], 
         ";"}], "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "@", 
           RowBox[{
            RowBox[{"orbitsLigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "define", " ", "colours", " ", "for", " ", "regions", " ", "of", " ", 
        "isomorphic", " ", "graphs"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"isocolours2", "=", 
       RowBox[{"Outer", "[", 
        RowBox[{"colourblender", ",", "isocolours", ",", "isocolours"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"gatheredisocols", "=", "isocolours2"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"gatheredisocols", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "=", 
         RowBox[{"Gather", "[", 
          RowBox[{"isocolours2", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "@", 
           RowBox[{
            RowBox[{"orbitsLigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"isolens", "=", 
       RowBox[{"Range", "[", 
        RowBox[{"Length", "@", 
         RowBox[{"gatheredisocols", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"isolens", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "=", 
         RowBox[{"Length", "@", 
          RowBox[{
           RowBox[{"gatheredisocols", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "@", 
           RowBox[{"gatheredisocols", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"isocount", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{"j", ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"Length", "@", "isolens"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"isolens", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "regions", " ", "of", " ", "same", " ", "number", " ", "of", " ", 
        RowBox[{"edges", ":", " ", 
         RowBox[{"'", 
          RowBox[{"gatheredisocols", "'"}]}]}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Do", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"gatheredisocols", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "j", "]"}], "]"}], "[", 
              RowBox[{"[", "k", "]"}], "]"}], "=", 
             RowBox[{"Blend", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"gatheredisocols", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                   RowBox[{"[", "j", "]"}], "]"}], "[", 
                  RowBox[{"[", "k", "]"}], "]"}], ",", 
                 RowBox[{"Hue", "[", 
                  RowBox[{"0.95", ",", "0.0", ",", "1"}], "]"}]}], "}"}], ",", 
               RowBox[{"1", "*", 
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                   RowBox[{"isocount", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "-", "j"}], "]"}], "/", 
                 RowBox[{"Length", "@", 
                  RowBox[{"gatheredisocols", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}]}]}]}], "]"}]}], ";"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", 
             RowBox[{"Length", "@", 
              RowBox[{
               RowBox[{"gatheredisocols", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "j", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}], 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "@", "gatheredisocols"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"Length", "@", 
           RowBox[{"gatheredisocols", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"gatheredisocols", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"gatheredisocols", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "@", 
           RowBox[{
            RowBox[{"orbitsLigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"varible", " ", "to", " ", 
        RowBox[{"plot", ":", " ", 
         RowBox[{"'", 
          RowBox[{"colourisoadjmat", "'"}]}]}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"colourisoadjmat", "=", 
       RowBox[{
        RowBox[{"AdjacencyMatrix", "[", 
         RowBox[{
          RowBox[{"orbitsLi", "[", 
           RowBox[{"[", "noqub", "]"}], "]"}], "[", 
          RowBox[{"[", "myclass", "]"}], "]"}], "]"}], " ", "//", 
        "Normal"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"colourisoadjmat", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"colourisoadjmat", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"gatheredisocols", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}]}]}], ";"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "@", 
           RowBox[{
            RowBox[{"orbitsLigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"Length", "@", 
           RowBox[{
            RowBox[{"orbitsLigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"one", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"colourlabel", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"two", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"colourlabel", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"Head", "@", 
              RowBox[{
               RowBox[{"colourlabel", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[NotEqual]", 
            "\"\<List\>\""}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"colourisoadjmat", "[", 
               RowBox[{"[", "one", "]"}], "]"}], "[", 
              RowBox[{"[", "two", "]"}], "]"}], "=", 
             RowBox[{
              RowBox[{"colourlabel", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ";"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"colourisoadjmat", "[", 
              RowBox[{"[", "one", "]"}], "]"}], "[", 
             RowBox[{"[", "two", "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"colourlabel", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ";"}], 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "@", "colourlabel"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Make", " ", "frame", " ", "ticks"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"glo", "=", 
       RowBox[{"Accumulate", "@", "isolens"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"glr", "=", "glo"}], ";", "\[IndentingNewLine]", 
      RowBox[{"glos", "=", 
       RowBox[{"ToString", "/@", "glo"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"avar", "=", 
       RowBox[{"Accumulate", "[", "isolens", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"bticks", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Accumulate", "@", "isolens"}], " ", "+", 
          RowBox[{"Delete", "[", " ", 
           RowBox[{
            RowBox[{"Flatten", "[", 
             RowBox[{"PrependTo", "[", 
              RowBox[{"avar", ",", "0"}], "]"}], "]"}], ",", 
            RowBox[{"-", "1"}]}], "]"}]}], ")"}], " ", "/", " ", "2"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"noedg", " ", "=", 
       RowBox[{"Length", "/@", 
        RowBox[{"EdgeList", "/@", 
         RowBox[{"deleteIsoG1", "@", 
          RowBox[{
           RowBox[{"orbitsLigraphlist", "[", 
            RowBox[{"[", "noqub", "]"}], "]"}], "[", 
           RowBox[{"[", "myclass", "]"}], "]"}]}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"btickstr", "=", 
       RowBox[{"ToString", "/@", "noedg"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"bticks", "[", 
              RowBox[{"[", 
               RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", 
             RowBox[{"bticks", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "<", "tickthresedge"}],
           ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"btickstr", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "=", "\"\<\>\""}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{
           RowBox[{"Length", "@", "bticks"}], "-", "1"}]}], "}"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"glo", "[", 
               RowBox[{"[", 
                RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", 
              RowBox[{"glo", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "<", "tickthresno"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"glos", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "=", "\"\<\>\""}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{
           RowBox[{"Length", "@", "glo"}], "-", "1"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"tickas", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"glo", "+", 
             RowBox[{"1", "/", "2"}]}], ",", "glos"}], "}"}], 
          "\[Transpose]"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"bticks", "+", 
             RowBox[{"1", "/", "2"}]}], ",", "btickstr"}], "}"}], 
          "\[Transpose]"}], ",", "None", ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"glo", "+", 
             RowBox[{"1", "/", "2"}]}], ",", "glos"}], "}"}], 
          "\[Transpose]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"gl", "=", 
       RowBox[{"{", 
        RowBox[{"glr", ",", 
         RowBox[{
          RowBox[{"Length", "@", 
           RowBox[{
            RowBox[{"orbitsLigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}]}], "-", "glr"}]}], "}"}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"orbitadj", "=", 
       RowBox[{"ArrayPlot", "[", 
        RowBox[{"colourisoadjmat", ",", "\[IndentingNewLine]", 
         RowBox[{"MaxPlotPoints", "\[Rule]", 
          RowBox[{
           RowBox[{"Length", "@", 
            RowBox[{"AdjacencyMatrix", "[", 
             RowBox[{
              RowBox[{"orbitsLi", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], "]"}]}], "^", "2"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"AbsoluteThickness", "[", "myframethickness", "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotRangePadding", "\[Rule]", "0"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
           "\"\<Graph index\>\"", ",", "\"\<No.  Edges in graph\>\"", ",", 
            "\"\<\>\"", ",", "\"\<Graph index\>\""}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"FontFamily", "\[Rule]", " ", "\"\<Helvetica\>\""}], ",", 
            " ", 
            RowBox[{"FontSize", "\[Rule]", " ", "myfontsize"}]}], "}"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"FrameTicks", "\[Rule]", "tickas"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"GridLines", "\[Rule]", "gl"}], ",", "\[IndentingNewLine]", 
         RowBox[{"FrameTicksStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"Opacity", "[", "0", "]"}], ",", 
            RowBox[{"FontOpacity", "\[Rule]", "1"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Method", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<GridLinesInFront\>\"", "\[Rule]", "True"}], "}"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ImagePadding", "\[Rule]", "40"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"GridLinesStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsoluteThickness", "[", 
             RowBox[{"myframethickness", "/", "3"}], "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", "graphsize"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"orbitlegend", "=", 
       RowBox[{"TableForm", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Range", "[", "noqub", "]"}], ",", 
           RowBox[{"goodcolours", "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", "noqub"}], "]"}], "]"}]}], "}"}], 
         "\[Transpose]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"dist", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Length", "/@", 
            RowBox[{"orbitsLigraphlist", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"dist", "[", 
         RowBox[{"[", "noqub", "]"}], "]"}], "[", 
        RowBox[{"[", "myclass", "]"}], "]"}], "=", 
       RowBox[{"GraphDistanceMatrix", "[", 
        RowBox[{
         RowBox[{"orbitsLi", "[", 
          RowBox[{"[", "noqub", "]"}], "]"}], "[", 
         RowBox[{"[", "myclass", "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"distp", "=", 
       RowBox[{"MatrixPlot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"dist", "[", 
           RowBox[{"[", "noqub", "]"}], "]"}], "[", 
          RowBox[{"[", "myclass", "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"MaxPlotPoints", "\[Rule]", 
          RowBox[{
           RowBox[{"Length", "@", 
            RowBox[{"AdjacencyMatrix", "[", 
             RowBox[{
              RowBox[{"orbitsLi", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], "]"}]}], "^", "2"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"AbsoluteThickness", "[", "myframethickness", "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotRangePadding", "\[Rule]", "0"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
           "\"\<Graph index\>\"", ",", "\"\<No.  Edges in graph\>\"", ",", 
            "\"\<\>\"", ",", "\"\<Graph index\>\""}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"FontFamily", "\[Rule]", " ", "\"\<Helvetica\>\""}], ",", 
            " ", 
            RowBox[{"FontSize", "\[Rule]", " ", "myfontsize"}]}], "}"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"FrameTicks", "\[Rule]", "tickas"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"GridLines", "\[Rule]", "gl"}], ",", "\[IndentingNewLine]", 
         RowBox[{"FrameTicksStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"Opacity", "[", "0", "]"}], ",", 
            RowBox[{"FontOpacity", "\[Rule]", "1"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Method", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<GridLinesInFront\>\"", "\[Rule]", "True"}], "}"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
         RowBox[{"GridLinesStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsoluteThickness", "[", 
             RowBox[{"myframethickness", "/", "3"}], "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ImagePadding", "\[Rule]", "40"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ColorFunction", "\[Rule]", "\"\<SolarColors\>\""}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"distleg", "=", 
       RowBox[{"BarLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<SolarColors\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"1", "+", 
              RowBox[{"Max", "@", 
               RowBox[{
                RowBox[{"dist", "[", 
                 RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                RowBox[{"[", "myclass", "]"}], "]"}]}]}]}], "}"}]}], "}"}], 
         ",", 
         RowBox[{"Max", "@", 
          RowBox[{
           RowBox[{"dist", "[", 
            RowBox[{"[", "noqub", "]"}], "]"}], "[", 
           RowBox[{"[", "myclass", "]"}], "]"}]}], ",", 
         RowBox[{"Method", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"TicksStyle", "\[Rule]", "Black"}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Black", ",", 
               RowBox[{"FontFamily", "\[Rule]", " ", "\"\<Helvetica\>\""}], 
               ",", " ", 
               RowBox[{"FontSize", "\[Rule]", " ", "myfontsize"}]}], 
              "}"}]}]}], "}"}]}]}], " ", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"orbitadj", ",", "orbitlegend", ",", "distp", ",", "distleg"}],
        "}"}]}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7518139241681814`*^9, 3.751813926810446*^9}, {
   3.7518141480515676`*^9, 3.7518141544302053`*^9}, 3.7519136204239264`*^9, {
   3.769257669669498*^9, 3.769257671101641*^9}, {3.7692636540962934`*^9, 
   3.7692636546043444`*^9}, {3.7693449350446053`*^9, 3.769344935509652*^9}, {
   3.769345140050104*^9, 3.769345152261325*^9}, {3.769345441949459*^9, 
   3.769345453196459*^9}, {3.769345763904459*^9, 3.7693457651254587`*^9}, {
   3.7694265197196703`*^9, 3.76942652561626*^9}, {3.7694267903957353`*^9, 
   3.769426822924988*^9}, {3.7694271497526674`*^9, 3.769427161106803*^9}, {
   3.769427199461069*^9, 3.769427200815069*^9}, {3.769502882214143*^9, 
   3.7695028883247538`*^9}, {3.7728043163392735`*^9, 3.772804316937958*^9}, {
   3.772804579074*^9, 3.772804580493997*^9}, {3.7728048094696693`*^9, 
   3.772804809651548*^9}, 3.7728055335594006`*^9},
 CellLabel->
  "In[153]:=",ExpressionUUID->"b21e00fb-62b7-48c7-992d-4aac20badc2c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Print labelled graph state orbits ", "Title"],
 Cell[BoxData[
  SubscriptBox["L", "i"]], "Title",
  CellChangeTimes->{{3.7692578793134604`*^9, 3.7692579112106495`*^9}},
  ExpressionUUID->"ba9366c4-81b3-4a21-b50f-cef23761e302"]
}], "Title",
 CellChangeTimes->{
  3.769345205139612*^9, 3.769350285296784*^9, 3.7693503612163754`*^9, 
   3.772804316955968*^9, {3.7795602357883835`*^9, 
   3.7795602386702323`*^9}},ExpressionUUID->"3905a911-7c8a-4e79-b6bc-\
5846855eb1cf"],

Cell[CellGroupData[{

Cell["Plot Settings", "Subsubsection",
 CellChangeTimes->{
  3.769257635893121*^9, {3.7692580591892223`*^9, 3.7692580653222227`*^9}, {
   3.7694264057712765`*^9, 
   3.7694264072894287`*^9}},ExpressionUUID->"be4f3816-b05f-4d17-ae7b-\
e7994a0a038c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sesize", " ", "=", " ", 
   RowBox[{"Thickness", "[", "0.01", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lesize", " ", "=", 
   RowBox[{"Thickness", "[", "0.004", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"svsize", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lvsize", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gcirclethickness", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gpadding", "=", "1.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"edgefontsize", "=", "12"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vertexlabelfontsize", "=", "8"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Label", " ", "edge", " ", "vertices", " ", "when", " ", "printing", " ", 
    "orbit", " ", "as", " ", "a", " ", 
    RowBox[{"graph", "?"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"orbitedgeslabelledQ", "=", "True"}], ";"}], 
  "   "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"graphslabelledQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"graphsvertexlabelledQ", "=", "False"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7694254059742484`*^9, 3.7694254430885363`*^9}, {
   3.7694254905552726`*^9, 3.7694255932002726`*^9}, {3.7694256258712726`*^9, 
   3.7694256289972725`*^9}, 3.7694264044701467`*^9, {3.769426500002699*^9, 
   3.769426503372036*^9}, {3.769502980974018*^9, 3.7695029965525756`*^9}, {
   3.7695136899619837`*^9, 3.769513697214984*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"f2a2a5c7-8e7e-4bb4-be79-6d022806a540"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pick and display graph state orbit", "Subsubsection",
 CellChangeTimes->{{3.7693447216142645`*^9, 3.769344728481951*^9}, {
  3.769344901699271*^9, 3.769344902818383*^9}, {3.772804435459152*^9, 
  3.7728044364536705`*^9}},ExpressionUUID->"125d41b7-380d-464b-bf87-\
267d6b23d012"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"noqub", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myclass", "=", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<First graph in orbit is: \>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"orbitsLigraphlist", "[", 
      RowBox[{"[", "noqub", "]"}], "]"}], "[", 
     RowBox[{"[", "myclass", "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Number of graphs in Orbit is: \>\"", ",", 
   RowBox[{"Length", "@", 
    RowBox[{
     RowBox[{"orbitsLigraphlist", "[", 
      RowBox[{"[", "noqub", "]"}], "]"}], "[", 
     RowBox[{"[", "myclass", "]"}], "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Adjacency matrix of orbit is: \>\"", ",", 
    RowBox[{"MatrixPlot", "@", 
     RowBox[{"AdjacencyMatrix", "@", 
      RowBox[{
       RowBox[{"orbitsLi", "[", 
        RowBox[{"[", "noqub", "]"}], "]"}], "[", 
       RowBox[{"[", "myclass", "]"}], "]"}]}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"plotOrbitLi", "[", 
  RowBox[{"noqub", ",", "myclass"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.7522668683075867`*^9, {3.752266908678623*^9, 3.7522669255753126`*^9}, {
   3.752266965302285*^9, 3.752266966406396*^9}, {3.7692568878250637`*^9, 
   3.769256897995064*^9}, {3.7692569480750637`*^9, 3.769257028688757*^9}, {
   3.769262846258811*^9, 3.769262847194811*^9}, {3.769264278300806*^9, 
   3.769264278689806*^9}, {3.7693411852978477`*^9, 3.7693411861938477`*^9}, {
   3.769341328190848*^9, 3.769341328591848*^9}, {3.769341392329848*^9, 
   3.769341392845848*^9}, {3.769341511902848*^9, 3.7693415123638477`*^9}, {
   3.7693416014648476`*^9, 3.769341603826848*^9}, {3.7693417499168477`*^9, 
   3.7693417767198477`*^9}, {3.769345791267459*^9, 3.769345813411459*^9}, {
   3.7693458638034587`*^9, 3.7693458675144587`*^9}, {3.769345961959459*^9, 
   3.7693459941054587`*^9}, {3.769348910079268*^9, 3.769348915126268*^9}, {
   3.7693489772214737`*^9, 3.7693489784888535`*^9}, 3.7693502853107853`*^9, {
   3.7693503612283764`*^9, 3.7693503695392075`*^9}, 3.7694240111048155`*^9, 
   3.769425391884658*^9, {3.7694256146542726`*^9, 3.7694256173742723`*^9}, {
   3.769426410441744*^9, 3.7694264310067997`*^9}, {3.769426492837982*^9, 
   3.769426493968096*^9}, {3.7695139921709833`*^9, 3.7695139922319837`*^9}, {
   3.7728043171634126`*^9, 3.7728043171834016`*^9}, 3.7728048222779455`*^9, {
   3.772805139878668*^9, 3.7728051403841248`*^9}, {3.7728054664901123`*^9, 
   3.772805466593053*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"e3bf4687-e988-4538-bc54-b35a7b5be56f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"First graph in orbit is: \"\>", "\[InvisibleSpace]", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {1, 6}, {4, 5}}}, {
        GraphLayout -> "CircularEmbedding", ImagePadding -> 23, ImageSize -> 
         120, VertexSize -> {0.2}}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
         1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
         0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
         0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 6}, {4, 5}}]}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.09999999999999994], DiskBox[2, 0.09999999999999994], 
           DiskBox[3, 0.09999999999999994], DiskBox[4, 0.09999999999999994], 
           DiskBox[5, 0.09999999999999994], 
           DiskBox[6, 0.09999999999999994]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->23,
    ImageSize->120]}],
  SequenceForm["First graph in orbit is: ", 
   Graph[{1, 2, 3, 4, 5, 6}, {
    Null, {{1, 2}, {1, 3}, {1, 4}, {1, 6}, {4, 5}}}, {
    GraphLayout -> "CircularEmbedding", ImagePadding -> 23, ImageSize -> 120, 
     VertexSize -> {0.2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7692569761400642`*^9, 3.769257043444708*^9}, 
   3.769257298180645*^9, 3.769257449477481*^9, 3.7692575946799994`*^9, 
   3.769262807145811*^9, {3.7692628474008107`*^9, 3.769262851069811*^9}, 
   3.769262960241811*^9, 3.769263205764465*^9, {3.7692634017500615`*^9, 
   3.76926340283317*^9}, {3.769264274764806*^9, 3.7692642790518055`*^9}, 
   3.769264628078806*^9, 3.7693397275336866`*^9, 3.769339867936725*^9, {
   3.769339980766007*^9, 3.769340010345965*^9}, {3.7693410767788477`*^9, 
   3.769341099665848*^9}, 3.769341186590848*^9, {3.769341270017848*^9, 
   3.769341276961848*^9}, {3.769341317881848*^9, 3.7693413289268475`*^9}, 
   3.769341393097848*^9, 3.769341459177848*^9, 3.7693415297478476`*^9, {
   3.7693415980028477`*^9, 3.769341606855848*^9}, 3.7693417316928477`*^9, {
   3.7693417659358478`*^9, 3.7693417880168476`*^9}, 3.769341879281848*^9, 
   3.769342895722684*^9, 3.769344713961499*^9, {3.769345951305459*^9, 
   3.769345994807459*^9}, 3.7693481834570155`*^9, 3.769348930858268*^9, {
   3.7693504601782703`*^9, 3.769350488004053*^9}, 3.7693505331345654`*^9, 
   3.769420554207165*^9, 3.769425331356711*^9, {3.7694253932845173`*^9, 
   3.7694254441784277`*^9}, {3.7694254921942725`*^9, 3.769425630182273*^9}, {
   3.7694264143481345`*^9, 3.7694265046711655`*^9}, 3.7694271718838806`*^9, 
   3.769427270211069*^9, 3.7694347792722445`*^9, 3.769502921740095*^9, {
   3.7695029829382143`*^9, 3.7695029984477654`*^9}, {3.769513986091984*^9, 
   3.7695139926009836`*^9}, 3.7728044372972016`*^9, 3.772804513838357*^9, 
   3.7728047302031727`*^9, {3.7728047961314287`*^9, 3.7728048225385*^9}, 
   3.772804867171218*^9, 3.7728050699272647`*^9, 3.772805140637971*^9, 
   3.7728053531638303`*^9, 3.7728054084805436`*^9, 3.7728054668568745`*^9, 
   3.7728055659761143`*^9, 3.7728102574307227`*^9, 3.772810451855772*^9, 
   3.7728107709514017`*^9, 3.772810814599785*^9, 3.7728109097638273`*^9, 
   3.7728110931634955`*^9, 3.7742600961713934`*^9, 3.7795602185064583`*^9, 
   3.791627631108693*^9, 3.7916277753677187`*^9, 3.79187115918503*^9},
 CellLabel->
  "During evaluation of \
In[168]:=",ExpressionUUID->"ffb1593a-377b-4ef7-b8d1-de12df0cad47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Number of graphs in Orbit is: \"\>", "\[InvisibleSpace]", 
   "17"}],
  SequenceForm["Number of graphs in Orbit is: ", 17],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7692569761400642`*^9, 3.769257043444708*^9}, 
   3.769257298180645*^9, 3.769257449477481*^9, 3.7692575946799994`*^9, 
   3.769262807145811*^9, {3.7692628474008107`*^9, 3.769262851069811*^9}, 
   3.769262960241811*^9, 3.769263205764465*^9, {3.7692634017500615`*^9, 
   3.76926340283317*^9}, {3.769264274764806*^9, 3.7692642790518055`*^9}, 
   3.769264628078806*^9, 3.7693397275336866`*^9, 3.769339867936725*^9, {
   3.769339980766007*^9, 3.769340010345965*^9}, {3.7693410767788477`*^9, 
   3.769341099665848*^9}, 3.769341186590848*^9, {3.769341270017848*^9, 
   3.769341276961848*^9}, {3.769341317881848*^9, 3.7693413289268475`*^9}, 
   3.769341393097848*^9, 3.769341459177848*^9, 3.7693415297478476`*^9, {
   3.7693415980028477`*^9, 3.769341606855848*^9}, 3.7693417316928477`*^9, {
   3.7693417659358478`*^9, 3.7693417880168476`*^9}, 3.769341879281848*^9, 
   3.769342895722684*^9, 3.769344713961499*^9, {3.769345951305459*^9, 
   3.769345994807459*^9}, 3.7693481834570155`*^9, 3.769348930858268*^9, {
   3.7693504601782703`*^9, 3.769350488004053*^9}, 3.7693505331345654`*^9, 
   3.769420554207165*^9, 3.769425331356711*^9, {3.7694253932845173`*^9, 
   3.7694254441784277`*^9}, {3.7694254921942725`*^9, 3.769425630182273*^9}, {
   3.7694264143481345`*^9, 3.7694265046711655`*^9}, 3.7694271718838806`*^9, 
   3.769427270211069*^9, 3.7694347792722445`*^9, 3.769502921740095*^9, {
   3.7695029829382143`*^9, 3.7695029984477654`*^9}, {3.769513986091984*^9, 
   3.7695139926009836`*^9}, 3.7728044372972016`*^9, 3.772804513838357*^9, 
   3.7728047302031727`*^9, {3.7728047961314287`*^9, 3.7728048225385*^9}, 
   3.772804867171218*^9, 3.7728050699272647`*^9, 3.772805140637971*^9, 
   3.7728053531638303`*^9, 3.7728054084805436`*^9, 3.7728054668568745`*^9, 
   3.7728055659761143`*^9, 3.7728102574307227`*^9, 3.772810451855772*^9, 
   3.7728107709514017`*^9, 3.772810814599785*^9, 3.7728109097638273`*^9, 
   3.7728110931634955`*^9, 3.7742600961713934`*^9, 3.7795602185064583`*^9, 
   3.791627631108693*^9, 3.7916277753677187`*^9, 3.7918711591890545`*^9},
 CellLabel->
  "During evaluation of \
In[168]:=",ExpressionUUID->"71bf81a8-d24d-4dc3-ab30-709928c74501"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Adjacency matrix of orbit is: \"\>", "\[InvisibleSpace]", 
   GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmVmYGAQhGIQGwI+2A91+mGVyDr3h7fsGVAA7cUHm3+Hinpa04PN
v4NN/UDRQyV/DVeaWulqNL7oQ1MrnIdKfA1Uehuo8Bls9g429wwUTet8N1z9
O1DuHCrhTKq/hgo96v7hbT6t6aFe74yG/6i9o+4ZPOaPumdouWew+XewuXM0
/Ie3O4eKv4aK+yl1DwCnxYA7
     "], {{0, 0}, {17, 17}}, {0, 1}],
    Frame->True,
    FrameLabel->{None, None},
    FrameTicks->{{{{16.5, 
         FormBox["1", TraditionalForm]}, {12.5, 
         FormBox["5", TraditionalForm]}, {7.5, 
         FormBox["10", TraditionalForm]}, {0.5, 
         FormBox["17", TraditionalForm]}}, {{16.5, 
         FormBox["1", TraditionalForm]}, {12.5, 
         FormBox["5", TraditionalForm]}, {7.5, 
         FormBox["10", TraditionalForm]}, {0.5, 
         FormBox["17", TraditionalForm]}}}, {{{0.5, 
         FormBox["1", TraditionalForm]}, {4.5, 
         FormBox["5", TraditionalForm]}, {9.5, 
         FormBox["10", TraditionalForm]}, {16.5, 
         FormBox["17", TraditionalForm]}}, {{0.5, 
         FormBox["1", TraditionalForm]}, {4.5, 
         FormBox["5", TraditionalForm]}, {9.5, 
         FormBox["10", TraditionalForm]}, {16.5, 
         FormBox["17", TraditionalForm]}}}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultPlotStyle" -> Automatic, "DomainPadding" -> Scaled[0.02], 
      "RangePadding" -> Scaled[0.05]}]}],
  SequenceForm["Adjacency matrix of orbit is: ", 
   Graphics[
    Raster[CompressedData["
1:eJxTTMoPSmVmYGAQhGIQGwI+2A91+mGVyDr3h7fsGVAA7cUHm3+Hinpa04PN
v4NN/UDRQyV/DVeaWulqNL7oQ1MrnIdKfA1Uehuo8Bls9g429wwUTet8N1z9
O1DuHCrhTKq/hgo96v7hbT6t6aFe74yG/6i9o+4ZPOaPumdouWew+XewuXM0
/Ie3O4eKv4aK+yl1DwCnxYA7
     "], {{0, 0}, {17, 17}}, {0, 1}], Frame -> True, 
    FrameLabel -> {None, None}, 
    FrameTicks -> {{{{16.5, 1}, {12.5, 5}, {7.5, 10}, {0.5, 17}}, {{
        16.5, 1}, {12.5, 5}, {7.5, 10}, {0.5, 17}}}, {{{0.5, 1}, {4.5, 5}, {
        9.5, 10}, {16.5, 17}}, {{0.5, 1}, {4.5, 5}, {9.5, 10}, {16.5, 17}}}}, 
    GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], 
    Method -> {
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultPlotStyle" -> Automatic, "DomainPadding" -> Scaled[0.02], 
      "RangePadding" -> Scaled[0.05]}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7692569761400642`*^9, 3.769257043444708*^9}, 
   3.769257298180645*^9, 3.769257449477481*^9, 3.7692575946799994`*^9, 
   3.769262807145811*^9, {3.7692628474008107`*^9, 3.769262851069811*^9}, 
   3.769262960241811*^9, 3.769263205764465*^9, {3.7692634017500615`*^9, 
   3.76926340283317*^9}, {3.769264274764806*^9, 3.7692642790518055`*^9}, 
   3.769264628078806*^9, 3.7693397275336866`*^9, 3.769339867936725*^9, {
   3.769339980766007*^9, 3.769340010345965*^9}, {3.7693410767788477`*^9, 
   3.769341099665848*^9}, 3.769341186590848*^9, {3.769341270017848*^9, 
   3.769341276961848*^9}, {3.769341317881848*^9, 3.7693413289268475`*^9}, 
   3.769341393097848*^9, 3.769341459177848*^9, 3.7693415297478476`*^9, {
   3.7693415980028477`*^9, 3.769341606855848*^9}, 3.7693417316928477`*^9, {
   3.7693417659358478`*^9, 3.7693417880168476`*^9}, 3.769341879281848*^9, 
   3.769342895722684*^9, 3.769344713961499*^9, {3.769345951305459*^9, 
   3.769345994807459*^9}, 3.7693481834570155`*^9, 3.769348930858268*^9, {
   3.7693504601782703`*^9, 3.769350488004053*^9}, 3.7693505331345654`*^9, 
   3.769420554207165*^9, 3.769425331356711*^9, {3.7694253932845173`*^9, 
   3.7694254441784277`*^9}, {3.7694254921942725`*^9, 3.769425630182273*^9}, {
   3.7694264143481345`*^9, 3.7694265046711655`*^9}, 3.7694271718838806`*^9, 
   3.769427270211069*^9, 3.7694347792722445`*^9, 3.769502921740095*^9, {
   3.7695029829382143`*^9, 3.7695029984477654`*^9}, {3.769513986091984*^9, 
   3.7695139926009836`*^9}, 3.7728044372972016`*^9, 3.772804513838357*^9, 
   3.7728047302031727`*^9, {3.7728047961314287`*^9, 3.7728048225385*^9}, 
   3.772804867171218*^9, 3.7728050699272647`*^9, 3.772805140637971*^9, 
   3.7728053531638303`*^9, 3.7728054084805436`*^9, 3.7728054668568745`*^9, 
   3.7728055659761143`*^9, 3.7728102574307227`*^9, 3.772810451855772*^9, 
   3.7728107709514017`*^9, 3.772810814599785*^9, 3.7728109097638273`*^9, 
   3.7728110931634955`*^9, 3.7742600961713934`*^9, 3.7795602185064583`*^9, 
   3.791627631108693*^9, 3.7916277753677187`*^9, 3.7918711593007274`*^9},
 CellLabel->
  "During evaluation of \
In[168]:=",ExpressionUUID->"49e23287-31c5-4a56-8c15-0a768f4e673f"]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}, {
      Null, SparseArray[
       Automatic, {17, 17}, 0, {
        1, {{0, 3, 6, 9, 12, 15, 18, 21, 24, 26, 28, 30, 32, 34, 36, 37, 38, 
          38}, {{9}, {15}, {1}, {9}, {16}, {2}, {10}, {15}, {3}, {10}, {16}, {
          4}, {11}, {15}, {5}, {11}, {16}, {6}, {12}, {15}, {7}, {12}, {16}, {
          8}, {17}, {9}, {17}, {10}, {17}, {11}, {17}, {12}, {14}, {17}, {
          15}, {16}, {15}, {16}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
         1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
         1}}]}, {EdgeLabels -> {
        UndirectedEdge[2, 9] -> "5", UndirectedEdge[2, 16] -> "1", 
         UndirectedEdge[8, 16] -> "6", UndirectedEdge[3, 10] -> "4", 
         UndirectedEdge[16, 16] -> "4", UndirectedEdge[13, 17] -> "{4, 5}", 
         UndirectedEdge[14, 16] -> "5", UndirectedEdge[11, 11] -> "{1, 2, 6}",
          UndirectedEdge[5, 5] -> "{1, 2, 5, 6}", UndirectedEdge[1, 1] -> 
         "{2, 3, 5, 6}", UndirectedEdge[6, 6] -> "{1, 2, 4, 6}", 
         UndirectedEdge[5, 15] -> "3", UndirectedEdge[4, 10] -> "5", 
         UndirectedEdge[3, 3] -> "{1, 3, 5, 6}", UndirectedEdge[14, 15] -> 
         "4", UndirectedEdge[11, 17] -> "3", UndirectedEdge[13, 14] -> 
         "{1, 2, 3, 6}", UndirectedEdge[7, 15] -> "6", UndirectedEdge[10, 17] -> 
         "2", UndirectedEdge[12, 12] -> "{1, 2, 3}", UndirectedEdge[9, 9] -> 
         "{2, 3, 6}", UndirectedEdge[1, 15] -> "1", UndirectedEdge[8, 8] -> 
         "{1, 2, 3, 4}", UndirectedEdge[12, 17] -> "6", UndirectedEdge[1, 9] -> 
         "4", UndirectedEdge[15, 15] -> "5", UndirectedEdge[5, 11] -> "4", 
         UndirectedEdge[6, 11] -> "5", UndirectedEdge[4, 4] -> "{1, 3, 4, 6}",
          UndirectedEdge[2, 2] -> "{2, 3, 4, 6}", UndirectedEdge[3, 15] -> 
         "2", UndirectedEdge[6, 16] -> "3", UndirectedEdge[4, 16] -> "2", 
         UndirectedEdge[9, 17] -> "1", UndirectedEdge[8, 12] -> "5", 
         UndirectedEdge[7, 7] -> "{1, 2, 3, 5}", UndirectedEdge[7, 12] -> "4",
          UndirectedEdge[10, 10] -> "{1, 3, 6}"}, EdgeLabelStyle -> {
         Directive[
          GrayLevel[0], 12]}, EdgeStyle -> {
         Thickness[0.004]}, 
       VertexLabels -> {
        9 -> None, 17 -> None, 14 -> None, 5 -> None, 6 -> None, 13 -> None, 
         16 -> None, 4 -> None, 15 -> None, 12 -> None, 8 -> None, 7 -> None, 
         1 -> None, 10 -> None, 2 -> None, 3 -> None, 11 -> None}, 
       VertexShape -> {13 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844386, 0.4999999999999993}, {
             0.8660254037844389, -0.5000000000000012}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               
               Line[{{1, 4}, {1, 5}, {2, 4}, {2, 5}, {3, 4}, {3, 5}, {4, 6}, {
                5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 3 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 
             0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {1.8369701987210297`*^-16, 1.}, {
             0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
             0.4999999999999993}, {3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 2}, {2, 3}, {2, 4}, {2, 6}, {4, 5}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 15 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               
               Line[{{1, 2}, {1, 3}, {1, 4}, {1, 6}, {2, 3}, {2, 4}, {2, 6}, {
                3, 4}, {3, 6}, {4, 5}, {4, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 8 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 6}, {2, 6}, {3, 6}, {4, 5}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 1 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 2}, {1, 3}, {1, 4}, {1, 6}, {4, 5}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 10 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 
             0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 2}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {4, 5}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 11 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             0.8660254037844386, 0.4999999999999993}, {
             0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 3}, {2, 3}, {3, 4}, {3, 5}, {3, 6}, {4, 5}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 6 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             0.8660254037844386, 0.4999999999999993}, {
             0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 3}, {2, 3}, {3, 5}, {3, 6}, {4, 5}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 17 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               
               Line[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 4}, {
                2, 5}, {2, 6}, {3, 4}, {3, 5}, {3, 6}, {4, 6}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 14 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844386, 0.4999999999999993}, {
             0.8660254037844389, -0.5000000000000012}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               
               Line[{{1, 4}, {1, 5}, {2, 4}, {2, 5}, {3, 4}, {3, 5}, {4, 5}, {
                4, 6}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 7 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 6}, {2, 6}, {3, 6}, {4, 5}, {4, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 4 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 
             0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 2}, {2, 3}, {2, 5}, {2, 6}, {4, 5}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 2 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {4, 5}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 9 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {4, 5}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 12 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 6}, {2, 6}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 16 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               
               Line[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 6}, {
                3, 5}, {3, 6}, {4, 5}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 5 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
             0.4999999999999993}, {3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.01], 
               Line[{{1, 3}, {2, 3}, {3, 4}, {3, 6}, {4, 5}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}]}, 
       VertexSize -> {0.4}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], {
         {Arrowheads[0.], 
          ArrowBox[{{0., 1.662267162030579}, {0.8611627768446949, 
           1.1951019589824445`}}, 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"4\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {0.43058138842234744, 1.4286845605065117},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0., 1.662267162030579}, {0.7678290133647148, 
           1.875528998013787}}, 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"1\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {0.3839145066823574, 1.768898080022183}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{0., 
           1.662267162030579}, {-0.10941587305899234`, 
           1.4826701107818414`}, {-0.3134000346836234, 
           1.4490707134988745`}, {-0.43311408377118815`, 
           1.5220040779793507`}, {-0.39063835835034544`, 
           1.8960688200526399`}, {-0.2576196189043366, 
           1.9403039210424269`}, {-0.06636225037919219, 1.861824135897975}, {
           0., 1.662267162030579}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{2, 3, 5, 6}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {-0.49680733877738803, 1.7186805304544692},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.9026040407889364`, 0.6335478067974877}, {
           0.8611627768446949, 1.1951019589824445`}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"5\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.3818834088168157, 0.9143248828899662},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.9026040407889364`, 0.6335478067974877}, {
           2.6451707055318314`, 0.9876539191969691}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"1\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {2.2738873731603837, 0.8106008629972283},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{1.9026040407889364`, 
           0.6335478067974877}, {2.091137212004147, 0.540369599961989}, {
           2.1425895158828343`, 0.34015510144372635`}, {2.080500249670019, 
           0.21448399144606536`}, {1.7041703791569192`, 0.2238093238568896}, {
           1.648381672711184, 0.35240141187167234`}, {1.709687240575086, 
           0.549821806816644}, {1.9026040407889364`, 0.6335478067974877}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{2, 3, 4, 6}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.8902180047190547, 0.13370124423005783},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.0788543839251163`, 2.8741720731150924`}, {
           2.031007296801752, 2.526962659579965}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"4\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.554930840363434, 2.7005673663475287}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.0788543839251163`, 2.8741720731150924`}, {
           0.7678290133647148, 1.875528998013787}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"2\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {0.9233416986449156, 2.37485053556444}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{1.0788543839251163`, 
           2.8741720731150924`}, {0.8686199699791927, 2.868840462630732}, {
           0.7298556959707491, 3.0220646815070364`}, {0.7262833770113437, 
           3.162191564738422}, {1.0636652125364503`, 3.3291784813597216`}, {
           1.172915793838668, 3.2413569842646623`}, {1.2105920046366336`, 
           3.0380992952803303`}, {1.0788543839251163`, 2.8741720731150924`}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{1, 3, 5, 6}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {0.857060041230267, 3.3222873144856124}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{2.9396112667529444`, 2.069683989522913}, {
           2.031007296801752, 2.526962659579965}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"5\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {2.485309281777348, 2.298323324551439}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{2.9396112667529444`, 2.069683989522913}, {
           2.6451707055318314`, 0.9876539191969691}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"2\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {2.792390986142388, 1.528668954359941}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{2.9396112667529444`, 2.069683989522913}, {
           2.9427280699324587`, 2.27996290053275}, {3.1014021423221094`, 
           2.4124609146409925`}, {3.241559433419373, 2.410402123936001}, {
           3.394860584884921, 2.066585471889716}, {3.302721881619502, 
           1.9609504198120218`}, {3.0981149377536243`, 1.9314685014007376`}, {
           2.9396112667529444`, 2.069683989522913}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{1, 3, 4, 6}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {3.3962733208292373, 2.2733007087942454},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.4323814717846164, 0.7523755999808989}, {
           1.3878744643180156`, 0.2891628457532296}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"4\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {0.910127968051316, 0.5207692228670642}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.4323814717846164, 0.7523755999808989}, {
           0.7678290133647148, 1.875528998013787}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"3\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {0.6001052425746656, 1.313952298997343}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{0.4323814717846164, 0.7523755999808989}, {
           0.42824622826758874`, 0.5421142515627985}, {0.2689322686074553, 
           0.4103863226759021}, {0.12878659316464297`, 
           0.41312393506696454`}, {-0.022847498914169234`, 
           0.7576790618386772}, {0.06980176244968642, 0.8628666049968752}, {
           0.27454910076539885`, 0.8913571726299193}, {0.4323814717846164, 
           0.7523755999808989}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{1, 2, 5, 6}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {-0.025261434681597476, 0.5509730921485577},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{2.3717848387033182`, 0.}, {1.3878744643180156`, 
           0.2891628457532296}}, 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"5\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.879829651510667, 0.1445814228766148}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{2.3717848387033182`, 0.}, {2.6451707055318314`, 
           0.9876539191969691}}, 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"3\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {2.508477772117575, 0.49382695959848455},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{2.3717848387033182`, 0.}, {
           2.5815234974356422`, 0.015382779680824243`}, {
           2.7274588968907163`, -0.1310277533324532}, {
           2.7377305687061684`, -0.27082330986056924`}, {
           2.408723388508683, -0.4537588412465694}, {
           2.295396651362094, -0.37126426254834277`}, {
           2.2480400582518842`, -0.1700416542749726}, {2.3717848387033182`, 
           0.}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{1, 2, 4, 6}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {2.614762353111267, -0.43699190781081404},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.485258669831963, 2.458946588529197}, {
           2.3790168028056895`, 2.003281976911422}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"4\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.9321377363188263, 2.231114282720309}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.485258669831963, 2.458946588529197}, {
           0.7678290133647148, 1.875528998013787}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"6\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.1265438415983389, 2.167237793271492}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{1.485258669831963, 2.458946588529197}, {
           1.2862007567910525`, 2.526791126631394}, {1.2091455401479754`, 
           2.7186268669916585`}, {1.254368690017184, 2.851312947344079}, {
           1.6287389828886791`, 2.8910055452395795`}, {1.7007800063021052`, 
           2.770752394973451}, {1.66566448983201, 2.5670237563520715`}, {
           1.485258669831963, 2.458946588529197}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{1, 2, 3, 5}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.4325416620211568, 2.956159739086858}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{3.2832100322552407`, 1.5119487938491154`}, {
           2.3790168028056895`, 2.003281976911422}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"5\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {2.831113417530465, 1.7576153853802685}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{3.2832100322552407`, 1.5119487938491154`}, {
           2.6451707055318314`, 0.9876539191969691}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"6\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {2.964190368893536, 1.2498013565230424}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{3.2832100322552407`, 
           1.5119487938491154`}, {3.353183935616445, 1.7102682021931799`}, {
           3.545812579598228, 1.785284137227569}, {3.678004443529226, 
           1.7386620826038337`}, {3.7137303796295718`, 1.3639157807478544`}, {
           3.5927289665471758`, 1.2931558846275697`}, {3.389395935706082, 
           1.3304233444325897`}, {3.2832100322552407`, 1.5119487938491154`}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{1, 2, 3, 4}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {3.780953276930918, 1.5594004785371103}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.8611627768446949, 1.1951019589824445`}, {
           1.6165483109249241`, 1.4810136358353756`}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"1\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.2388555438848095, 1.33805779740891}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{0.8611627768446949, 
           1.1951019589824445`}, {0.9830264890455127, 0.9673997307980369}, {
           0.9124083202239859, 0.7981245882091111}, {0.8056054196035616, 
           0.7351533096315365}, {0.5066478539723416, 0.8968427605590717}, {
           0.5008866459642383, 1.020693678960665}, {0.6038964608667658, 
           1.1724499892082254`}, {0.8611627768446949, 1.1951019589824445`}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{2, 3, 6}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {0.6233009316263048, 0.7553045708713934},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{2.031007296801752, 2.526962659579965}, {
           1.6165483109249241`, 1.4810136358353756`}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"2\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.8237778038633379, 2.00398814770767}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{2.031007296801752, 2.526962659579965}, {
           1.8880400607882604`, 2.733294412946152}, {1.9399442973775005`, 
           2.913490995501875}, {2.041881271036273, 2.988936586079484}, {
           2.360043719189577, 2.8514209540081654`}, {2.374937331041099, 
           2.7254790465177283`}, {2.279251923774946, 2.5642054870698647`}, {
           2.031007296801752, 2.526962659579965}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{1, 3, 6}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {2.229380072036935, 2.9859269741464582}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.3878744643180156`, 0.2891628457532296}, {
           1.6165483109249241`, 1.4810136358353756`}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"3\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.50221138762147, 0.8850882407943026}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{1.3878744643180156`, 
           0.2891628457532296}, {1.5391659534467195`, 0.0927755519115652}, {
           1.4961120052198444`, -0.09149180370112642}, {
           1.3968747677975974`, -0.17233622505046345`}, {
           1.070967037315934, -0.04644418713839042}, {1.0518475485924124`, 
           0.0801192155713175}, {1.1438481540197984`, 0.24547939639914274`}, {
           1.3878744643180156`, 0.2891628457532296}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{1, 2, 6}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.2077082695745454, -0.17724914194826374},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{2.3790168028056895`, 2.003281976911422}, {
           1.6165483109249241`, 1.4810136358353756`}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"6\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.9977825568653067, 1.7421478063733988},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{2.3790168028056895`, 2.003281976911422}, {
           2.2540723484183824`, 2.2275876151347545`}, {2.322161797711578, 
           2.398832462577238}, {2.42854488368012, 2.4636707958379382`}, {
           2.7305571664245, 2.304662580358974}, {2.7373060749635787`, 
           2.180260720751704}, {2.6346561968450626`, 2.0272117958848375`}, {
           2.3790168028056895`, 2.003281976911422}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"{1, 2, 3}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {2.6119524020816005, 2.445708249402073}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.1693987207018077`, 0.7348393558879744}, {
           1.6212615249506934`, 1.1456266040497243`}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"{1, 2, 3, 6}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.3953301228262505, 0.9402329799688494},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.1693987207018077`, 0.7348393558879744}, {
           1.6165483109249241`, 1.4810136358353756`}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"{4, 5}\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.3929735158133658, 1.107926495861675}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.6212615249506934`, 1.1456266040497243`}, {
           0.7678290133647148, 1.875528998013787}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"4\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {1.194545269157704, 1.5105778010317557}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.6212615249506934`, 1.1456266040497243`}, {
           2.6451707055318314`, 0.9876539191969691}}, 0.06708402953801812]}, 
         InsetBox[
          StyleBox["\<\"5\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {2.1332161152412623, 1.0666402616233466},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{0.7678290133647148, 1.875528998013787}, {
           0.44708201293025857`, 1.902953390682819}, {0.3641613936159511, 
           2.0157369168339137`}, {0.35642974632781665`, 2.1097004183540777`}, 
           {0.5465249232886121, 2.2939905980899162`}, {0.640203547660564, 
           2.283349483322338}, {0.7503620387629675, 2.196972057355917}, {
           0.7678290133647148, 1.875528998013787}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"5\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {0.4197994455982154, 2.2345212262865775},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{2.6451707055318314`, 
           0.9876539191969691}, {2.9330747334589415`, 1.0612577092638815`}, {
           3.061721680196897, 0.969142817650053}, {3.09956337933934, 
           0.869369179817365}, {2.9376541701219026`, 0.620342873186335}, {
           2.8311084344156527`, 0.6144454836647281}, {2.6947176761996294`, 
           0.6946499176773436}, {2.6451707055318314`, 0.9876539191969691}},
           SplineDegree->7], 0.06708402953801812]}, InsetBox[
          StyleBox["\<\"4\"\>",
           StripOnInput->False,
           LineColor->GrayLevel[0],
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->12,
           FontColor->GrayLevel[0]], {3.0643601207579536, 0.715109915112525}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 6}, {4, 5}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {0., 1.662267162030579}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {4, 5}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.9026040407889364, 0.6335478067974877}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 
            0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {1.8369701987210297`*^-16, 1.}, {
            0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
            0.4999999999999993}, {3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 6}, {4, 5}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.0788543839251163, 2.8741720731150924}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 
            0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 2}, {2, 3}, {2, 5}, {2, 6}, {4, 5}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.9396112667529444, 2.069683989522913}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
            0.4999999999999993}, {3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 3}, {2, 3}, {3, 4}, {3, 6}, {4, 5}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {0.4323814717846164, 0.7523755999808989}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            0.8660254037844386, 0.4999999999999993}, {
            0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 3}, {2, 3}, {3, 5}, {3, 6}, {4, 5}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.3717848387033182, 0.}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 6}, {2, 6}, {3, 6}, {4, 5}, {4, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.485258669831963, 2.458946588529197}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 6}, {2, 6}, {3, 6}, {4, 5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {3.2832100322552407, 1.5119487938491154}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {4, 5}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {0.8611627768446949, 1.1951019589824445}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 
            0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {4, 5}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.031007296801752, 2.526962659579965}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            0.8660254037844386, 0.4999999999999993}, {
            0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 3}, {2, 3}, {3, 4}, {3, 5}, {3, 6}, {4, 5}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.3878744643180156, 0.2891628457532296}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 6}, {2, 6}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.3790168028056895, 2.003281976911422}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844386, 0.4999999999999993}, {
            0.8660254037844389, -0.5000000000000012}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 4}, {1, 5}, {2, 4}, {2, 5}, {3, 4}, {3, 5}, {4, 
               6}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.1693987207018077, 0.7348393558879744}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844386, 0.4999999999999993}, {
            0.8660254037844389, -0.5000000000000012}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 4}, {1, 5}, {2, 4}, {2, 5}, {3, 4}, {3, 5}, {4, 
               5}, {4, 6}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.6212615249506934, 1.1456266040497243}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 6}, {2, 3}, {2, 4}, {2, 
               6}, {3, 4}, {3, 6}, {4, 5}, {4, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {0.7678290133647148, 1.875528998013787}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 
               6}, {3, 5}, {3, 6}, {4, 5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.6451707055318314, 0.9876539191969691}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.01], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 
               4}, {2, 5}, {2, 6}, {3, 4}, {3, 5}, {3, 6}, {4, 6}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.6165483109249241, 1.4810136358353756}, 
         Automatic, {0.13416805907603624, 0.13416805907603624}]}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.7694264144801474`*^9, 3.7694265050702057`*^9}, 
   3.7694271723669286`*^9, 3.7694272705750694`*^9, 3.769434779967314*^9, 
   3.769502922174138*^9, {3.7695029833492556`*^9, 3.769502998854806*^9}, {
   3.7695139863809834`*^9, 3.7695139930069838`*^9}, 3.7728044403913174`*^9, 
   3.7728045166130176`*^9, 3.7728047308233285`*^9, {3.772804797100914*^9, 
   3.772804823039213*^9}, 3.7728048678632336`*^9, 3.7728050704633403`*^9, 
   3.7728051409377875`*^9, 3.772805353533618*^9, 3.7728054088199835`*^9, 
   3.7728054674141865`*^9, 3.7728055665108843`*^9, 3.7728102588427486`*^9, 
   3.7728104530968437`*^9, 3.7728107716349077`*^9, 3.7728108159589543`*^9, 
   3.772810910403099*^9, 3.7728110937732286`*^9, 3.774260096941866*^9, 
   3.7795602192423983`*^9, 3.791627631235387*^9, 3.7916277757816095`*^9, 
   3.791871159852454*^9},
 CellLabel->
  "Out[173]=",ExpressionUUID->"5e47e22d-2382-4067-88f0-3c3bea358ac2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Print labelled graph state orbitsLi adjacency matrices, ordered and grouped \
by graph state isomorphism\
\>", "Section",
 CellChangeTimes->{{3.7693457016124587`*^9, 3.7693457142404585`*^9}, 
   3.769350285429797*^9, 3.769350361342388*^9, 
   3.77280431720439*^9},ExpressionUUID->"1f653e64-7953-4def-bd23-\
6acf91fdd5de"],

Cell[CellGroupData[{

Cell["Plot Settings", "Subsubsection",
 CellChangeTimes->{3.769345258913989*^9, 
  3.779560288743086*^9},ExpressionUUID->"60cef662-4142-405d-a9a9-\
66c38643579b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Adjust", " ", "plot", " ", "cosmetics"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"myframethickness", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"myfontsize", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"graphsize", "=", "270"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Adjust", " ", "colour", " ", "space", " ", "for", " ", "plots"}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"satmod", "=", "0.17"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"brightmod", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Difference", " ", "in", " ", "edge", " ", "number", " ", "required", " ",
      "to", " ", "be", " ", "displayed", " ", "on", " ", "the", " ", "plot"}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tickthresno", "=", "1"}], ";"}], "          ", 
   RowBox[{"(*", 
    RowBox[{"in", " ", "graph", " ", "index"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tickthresedge", "=", "1"}], ";"}], "     ", 
   RowBox[{"(*", 
    RowBox[{"in", " ", "edge", " ", "number"}], "*)"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"plotOrbitMatrixLi", "[", 
    RowBox[{"noqub", ",", "myclass"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7693452404261403`*^9, 3.769345314758459*^9}, {
   3.769346033569459*^9, 3.7693461669054585`*^9}, {3.769348765295662*^9, 
   3.769348777807913*^9}, {3.7693500734336*^9, 3.769350074496706*^9}, 
   3.7693502854588003`*^9, {3.7693503613803916`*^9, 3.7693503696002135`*^9}, {
   3.7693504471889715`*^9, 3.7693504481270657`*^9}, {3.7694265496556635`*^9, 
   3.769426578661564*^9}, {3.7694266202227197`*^9, 3.769426714944191*^9}, {
   3.769426780932789*^9, 3.7694267852342196`*^9}, 3.7694268692746224`*^9, {
   3.7694268994506397`*^9, 3.7694271202987223`*^9}, {3.769427192801972*^9, 
   3.769427195066069*^9}, 3.7728043172683535`*^9, 3.772804871373067*^9},
 CellLabel->
  "In[174]:=",ExpressionUUID->"5a385965-e56e-43a1-a70a-c4c39ab08fed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmVmYGAQhGIQGwI+2Et41218Iv7evv/QV42Y/vf2Q0W8YNqkpypT
rtsbTns5vcP8gf3xlhneq7Y9s/c5Ev38vt4b+3/VH24t7X1sv3nWOvVdeofs
GZ5FbWF4+9C+dO1e/1DFZ/aSE/be+/vxhH3Q1rss97e8sJ/jL7t6yrzb9h8k
Oy9wmO2yv7L1m11o61v7O/rz10isu2Gv4c64KOHYKbh7EnR+Hp0U/8Y+e0/J
ZAmWd3DxinIQeG0fA3boG4LiEP+8gtMwcYNpf5JO6r+zZwnj0900F7d/canH
GQ441OMKH1zqcYUbTL3HwyqRde5v7UMeL519ROE91cVh4e/6V3phz7139kub
ulbFv3xg/3GOrsIWuXv2mV0My8sLn2GEcw3QtIdVbwjGL3p8DbXwxzB/gOIF
VziTGl+44sX6vn/v9Lz3cPfA1A0V8RLFTK+jN9/Dw43a4rjSLShURda9xyh3
yI0v9PIw8L+bxuLtbzHcM1TE/aVfbGn0ewdPb9QWBwf7obcY4U+onEHPX6Tm
O5g7wNZ/fY2Rr+gtTmp6u764wJbr+muMcCNVHFc444ovXPkLRhNbTuIqtwdb
OJNqPrXCH5d6WscLrvp3sIUzteKF1PAfqHjB1Y4abOFMqjguf1GrfKN1vOBK
P+ju4AI7ELOdMdDiuNxPrfjFlQ5xtTdwtQ9hNKntf/T+8lAJf1zqaV0Pkhov
5Pa/Bku8UCv/Uitf4FJPrfxCqH9N73ihdflJrXxBtXghcXyD1vEyUPUXtfIF
rfMLofErSuNlsLUfqJUvqBUvJI8fkhgvuMwfbO0EWrfnqZVfCI3boMfLUAl/
XOK0Hl8iNV5IHZ/HFS8AyCeGyg==
     "], {{0, 0}, {17, 17}}, {0, 1}],
    AspectRatio->1,
    Frame->Automatic,
    FrameLabel->{
      FormBox["\"No.  Edges in graph\"", TraditionalForm], 
      FormBox["\"Graph index\"", TraditionalForm], 
      FormBox["\"Graph index\"", TraditionalForm], 
      FormBox["\"\"", TraditionalForm]},
    FrameStyle->AbsoluteThickness[0.5],
    FrameTicks->{{{{9., 
         FormBox["\"8\"", TraditionalForm]}, {5., 
         FormBox["\"12\"", TraditionalForm]}, {4., 
         FormBox["\"13\"", TraditionalForm]}, {3., 
         FormBox["\"14\"", TraditionalForm]}, {1., 
         FormBox["\"16\"", TraditionalForm]}, {0., 
         FormBox["\"17\"", TraditionalForm]}}, None}, {{{4., 
         FormBox["\"5\"", TraditionalForm]}, {10., 
         FormBox["\"6\"", TraditionalForm]}, {12.5, 
         FormBox["\"8\"", TraditionalForm]}, {13.5, 
         FormBox["\"9\"", TraditionalForm]}, {15., 
         FormBox["\"11\"", TraditionalForm]}, {16.5, 
         FormBox["\"14\"", TraditionalForm]}}, {{8., 
         FormBox["\"8\"", TraditionalForm]}, {12., 
         FormBox["\"12\"", TraditionalForm]}, {13., 
         FormBox["\"13\"", TraditionalForm]}, {14., 
         FormBox["\"14\"", TraditionalForm]}, {16., 
         FormBox["\"16\"", TraditionalForm]}, {17., 
         FormBox["\"17\"", TraditionalForm]}}}},
    FrameTicksStyle->Directive[
      Opacity[0], FontOpacity -> 1],
    GridLines->{{8, 12, 13, 14, 16, 17}, {9, 5, 4, 3, 1, 0}},
    GridLinesStyle->Directive[
      GrayLevel[0], 
      AbsoluteThickness[0.16666666666666666`]],
    ImagePadding->40,
    ImageSize->270,
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Helvetica", FontSize -> 10},
    Method->{
     "GridLinesInFront" -> True, "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultPlotStyle" -> Automatic},
    PlotRangePadding->0], ",", 
   TagBox[GridBox[{
      {"1", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.368417, 0.506779, 0.709798], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.24561133333333335`, 0.3378526666666667, 0.4731986666666667],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.368417, 0.506779, 0.709798]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.368417, 0.506779, 0.709798],
        Editable->False,
        Selectable->False]},
      {"2", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.880722, 0.611041, 0.142051], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.587148, 0.40736066666666665`, 0.09470066666666668],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.880722, 0.611041, 0.142051]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.880722, 0.611041, 0.142051],
        Editable->False,
        Selectable->False]},
      {"3", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.560181, 0.691569, 0.194885], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.37345400000000006`, 0.461046, 0.12992333333333334`],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.560181, 0.691569, 0.194885]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.560181, 0.691569, 0.194885],
        Editable->False,
        Selectable->False]},
      {"4", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.922526, 0.385626, 0.209179], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.6150173333333333, 0.25708400000000003`, 0.13945266666666667`],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.922526, 0.385626, 0.209179]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.922526, 0.385626, 0.209179],
        Editable->False,
        Selectable->False]},
      {"5", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.528488, 0.470624, 0.701351], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.3523253333333333, 0.3137493333333333, 0.46756733333333333`],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.528488`", ",", "0.470624`", ",", "0.701351`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.528488, 0.470624, 0.701351]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.528488, 0.470624, 0.701351],
        Editable->False,
        Selectable->False]},
      {"6", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.772079, 0.431554, 0.102387], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.5147193333333333, 0.28770266666666666`, 0.06825800000000001],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.772079`", ",", "0.431554`", ",", "0.102387`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.772079, 0.431554, 0.102387]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.772079, 0.431554, 0.102387],
        Editable->False,
        Selectable->False]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Function[BoxForm`e$, 
     TableForm[BoxForm`e$]]], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmVmYGAQhGIQGwI+2P9fb1W0ZPMT+1CX6Y0ibVvsh4r4A3fTN99b
3tszb7q+2z7ugf0qfpX3MqfW0FyckDsPZYRt4698bn/tRPBvyeZdOMUP9mfd
eM/53p4v4yXXNsEb9qumSd4W6FiAUz0h9ww29YMlPeBSP9zDH1c6HCzxQij8
Sc1fg6VcIlec2HKDVHFSw3+gysPBKk6reCc1/KmV7wY6PIlNn7SuXwaq/Bmo
eCE3nGmVX8gN/8EeL/QKZ0rjhdrhT+94GazhTK32/0C1N6iVX9oUi35V2b2y
X63WsYvf4QBB82mtntL2P6ni1G6f07r/Re/4onb9S+94oXb8Drb0T6r5tA7/
4ZZfqF3+43LPYImXgc4vtE7/lOYXerVbBkt+oVf6pzS/DFS80Hp8b6DTP7Hq
B7o9T6v8MljTP7HqB1u8UCu/AACNr0jt
     "], {{0, 0}, {17, 17}}, {0, 1}],
    AspectRatio->1,
    Frame->True,
    FrameLabel->{
      FormBox["\"No.  Edges in graph\"", TraditionalForm], 
      FormBox["\"Graph index\"", TraditionalForm], 
      FormBox["\"Graph index\"", TraditionalForm], 
      FormBox["\"\"", TraditionalForm]},
    FrameStyle->AbsoluteThickness[0.5],
    FrameTicks->{{{{9., 
         FormBox["\"8\"", TraditionalForm]}, {5., 
         FormBox["\"12\"", TraditionalForm]}, {4., 
         FormBox["\"13\"", TraditionalForm]}, {3., 
         FormBox["\"14\"", TraditionalForm]}, {1., 
         FormBox["\"16\"", TraditionalForm]}, {0., 
         FormBox["\"17\"", TraditionalForm]}}, None}, {{{4., 
         FormBox["\"5\"", TraditionalForm]}, {10., 
         FormBox["\"6\"", TraditionalForm]}, {12.5, 
         FormBox["\"8\"", TraditionalForm]}, {13.5, 
         FormBox["\"9\"", TraditionalForm]}, {15., 
         FormBox["\"11\"", TraditionalForm]}, {16.5, 
         FormBox["\"14\"", TraditionalForm]}}, {{8., 
         FormBox["\"8\"", TraditionalForm]}, {12., 
         FormBox["\"12\"", TraditionalForm]}, {13., 
         FormBox["\"13\"", TraditionalForm]}, {14., 
         FormBox["\"14\"", TraditionalForm]}, {16., 
         FormBox["\"16\"", TraditionalForm]}, {17., 
         FormBox["\"17\"", TraditionalForm]}}}},
    FrameTicksStyle->Directive[
      Opacity[0], FontOpacity -> 1],
    GridLines->{{8, 12, 13, 14, 16, 17}, {9, 5, 4, 3, 1, 0}},
    GridLinesStyle->Directive[
      GrayLevel[0], 
      AbsoluteThickness[0.16666666666666666`]],
    ImagePadding->40,
    ImageSize->270,
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Helvetica", FontSize -> 10},
    Method->{
     "GridLinesInFront" -> True, "AxisPadding" -> Scaled[0.02], 
      "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultPlotStyle" -> Automatic, "DomainPadding" -> Scaled[0.02], 
      "RangePadding" -> Scaled[0.05]},
    PlotRangePadding->0], ",", 
   TemplateBox[{StyleBox[
      StyleBox[
       PaneBox[
        GraphicsBox[{
          
          RasterBox[{{{0.468742, 0., 0.0158236}}, {{0.8516958, 
           0.17299620000000004`, 0.009622340000000005}}, {{0.969963, 0.376081,
            0.0322881}}, {{0.9939926, 0.5927594, 0.07059434}}, {{1., 0.820127,
            0.126955}}}, {{
             Rational[-15, 2], 
             Rational[-125, 2]}, {
             Rational[15, 2], 
             Rational[125, 2]}}], {Antialiasing -> False, 
           AbsoluteThickness[0.1], 
           Directive[
            Opacity[0.3], 
            GrayLevel[0]], 
           LineBox[
            NCache[{{
               Rational[15, 2], 
               Rational[-125, 2]}, {
               Rational[-15, 2], 
               Rational[-125, 2]}, {
               Rational[-15, 2], 
               Rational[125, 2]}, {
               Rational[15, 2], 
               Rational[125, 2]}, {
               Rational[15, 2], 
               Rational[-125, 2]}}, {{7.5, -62.5}, {-7.5, -62.5}, {-7.5, 
             62.5}, {7.5, 62.5}, {7.5, -62.5}}]]}, {
           CapForm[None], {}}, 
          StyleBox[{Antialiasing -> False, 
            StyleBox[
             LineBox[{{7.5, -62.5}, {7.5, 62.5}}], 
             Directive[
              AbsoluteThickness[0.2], 
              Opacity[0.3], 
              GrayLevel[0]], StripOnInput -> False], 
            StyleBox[
             StyleBox[{{
                StyleBox[
                 LineBox[{{{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, -12.5}, 
                    Offset[{4., 0}, {7.5, -12.5}]}, {{7.5, 12.5}, 
                    Offset[{4., 0}, {7.5, 12.5}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}}], 
                 Directive[
                  GrayLevel[0], 
                  AbsoluteThickness[0.2]], StripOnInput -> False]}, 
               StyleBox[
                StyleBox[{{
                   StyleBox[{
                    InsetBox[
                    FormBox["1", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], {-1, 0.}, Automatic, {1, 
                    0}], 
                    InsetBox[
                    FormBox["2", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -12.5}], {-1, 0.}, Automatic, {1, 
                    0}], 
                    InsetBox[
                    FormBox["3", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 12.5}], {-1, 0.}, Automatic, {1, 
                    0}], 
                    InsetBox[
                    FormBox["4", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], {-1, 0.}, Automatic, {1, 
                    0}]}, 
                    Directive[
                    GrayLevel[0], 
                    AbsoluteThickness[0.2]], {
                    Directive[
                    Opacity[1], 
                    GrayLevel[0.3]]}, StripOnInput -> False]}, {}}, {
                  Directive[
                   Opacity[1], 
                   GrayLevel[0.3]]}, StripOnInput -> False], "GraphicsLabel", 
                StripOnInput -> False]}, "GraphicsTicks", StripOnInput -> 
              False], {
              Directive[
               GrayLevel[0], 
               AbsoluteThickness[0.2]]}, StripOnInput -> False]}, 
           "GraphicsAxes", StripOnInput -> False]}, PlotRangePadding -> 
         Scaled[0.02], PlotRange -> All, Frame -> True, 
         FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
         Opacity[0], FrameTicksStyle -> Opacity[0], 
         ImageSize -> {Automatic, 125}, BaseStyle -> {}], Alignment -> Left, 
        AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}}, 
        ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
       False], {FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
      False]},
    "BarLegend",
    DisplayFunction->(#& ),
    InterpretationFunction:>(RowBox[{"BarLegend", "[", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"SolarColors\"", ",", 
             RowBox[{"{", 
               RowBox[{"0", ",", "5"}], "}"}]}], "}"}], ",", "4", ",", 
         RowBox[{"Method", "\[Rule]", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"TicksStyle", "\[Rule]", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}]}], 
             "}"}]}]}], "]"}]& )]}], "}"}]], "Output",
 CellChangeTimes->{{3.769427035092202*^9, 3.769427050035697*^9}, {
   3.7694270834990425`*^9, 3.7694271222539177`*^9}, {3.7694271749451866`*^9, 
   3.7694271956960692`*^9}, 3.769427270751069*^9, 3.769434780708388*^9, 
   3.7695029227451954`*^9, 3.7728045004749427`*^9, {3.772804857626335*^9, 
   3.772804887525087*^9}, 3.77280508529904*^9, 3.772805178790861*^9, {
   3.7728054053933296`*^9, 3.7728054309416914`*^9}, 3.772805491049654*^9, {
   3.7728055423129334`*^9, 3.772805566759281*^9}, 3.7728108177932096`*^9, 
   3.7728109117231627`*^9, 3.772811095322646*^9, 3.7795602217456045`*^9, 
   3.791627631956456*^9, 3.791627776020009*^9, 3.791871161631316*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"6cbd66e0-b17f-4895-9800-64e93d5c50a6"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{950, 1108},
WindowMargins->{{Automatic, -961}, {1088, Automatic}},
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 152, 3, 85, "Chapter",ExpressionUUID->"8c829432-74cf-46d2-a2d9-ce02e27e948a"],
Cell[735, 27, 1170, 20, 228, "Text",ExpressionUUID->"31e83dc0-1ac0-4a1e-bdb1-08248a9ad027"],
Cell[CellGroupData[{
Cell[1930, 51, 156, 3, 67, "Section",ExpressionUUID->"df10a99b-3c09-44ec-a858-a64fe94ee1d6"],
Cell[CellGroupData[{
Cell[2111, 58, 194, 3, 62, "Subsubsection",ExpressionUUID->"4ec793cc-43c6-435e-8d4c-2eb3b649109f"],
Cell[2308, 63, 898, 20, 96, "Text",ExpressionUUID->"f52112b1-ca69-4bf2-b56c-105e006cbe2f"],
Cell[3209, 85, 49681, 1000, 4189, "Input",ExpressionUUID->"7e7b6a6c-0c43-495a-8a22-713e217b0d1f",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[52927, 1090, 354, 6, 71, "Subsection",ExpressionUUID->"9693424a-c647-4eed-8773-9a2d95e80a05"],
Cell[CellGroupData[{
Cell[53306, 1100, 237, 4, 62, "Subsubsection",ExpressionUUID->"0421e6e7-91d5-4712-85f7-ffb422a222e6"],
Cell[53546, 1106, 6134, 148, 560, "Input",ExpressionUUID->"1abcd559-fa18-420b-8afc-4b6cbaf90a9e"]
}, Closed]],
Cell[CellGroupData[{
Cell[59717, 1259, 211, 4, 54, "Subsubsection",ExpressionUUID->"f527f263-2d6b-4b51-8cb2-246babcc7879"],
Cell[59931, 1265, 6010, 146, 560, "Input",ExpressionUUID->"2ec46232-3204-48bd-b451-f8349cf20cac"]
}, Closed]],
Cell[CellGroupData[{
Cell[65978, 1416, 211, 4, 54, "Subsubsection",ExpressionUUID->"f65b7cd5-86ff-4b43-9899-1f21251cd0be"],
Cell[66192, 1422, 6027, 147, 560, "Input",ExpressionUUID->"849882b0-cab2-4b8d-9414-60a64c8733ad"]
}, Closed]],
Cell[CellGroupData[{
Cell[72256, 1574, 211, 4, 54, "Subsubsection",ExpressionUUID->"2d5cba60-f381-4b18-a96c-c0650f8b8724"],
Cell[72470, 1580, 6049, 146, 560, "Input",ExpressionUUID->"e6accff7-cb8f-446c-920e-74c387f54d4a"]
}, Closed]],
Cell[CellGroupData[{
Cell[78556, 1731, 280, 4, 54, "Subsubsection",ExpressionUUID->"c6096ee5-1a0d-4d0a-ad45-180f0cf87633"],
Cell[CellGroupData[{
Cell[78861, 1739, 6813, 165, 674, "Input",ExpressionUUID->"997f51d7-45ff-4ad9-b30f-73f1899edb6f"],
Cell[CellGroupData[{
Cell[85699, 1908, 480, 8, 48, "Print",ExpressionUUID->"8b6a919c-b12d-4d8f-9c7e-b972cc91b48f"],
Cell[86182, 1918, 447, 7, 48, "Print",ExpressionUUID->"ac46b7d5-2298-4016-97af-bd8d93108815"],
Cell[86632, 1927, 449, 7, 48, "Print",ExpressionUUID->"1662116c-525f-44c6-b0fe-48338c6b904d"],
Cell[87084, 1936, 435, 7, 48, "Print",ExpressionUUID->"a36a0b0d-14de-4c03-8d7c-9c7ed7f8b9e2"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[87580, 1950, 233, 4, 54, "Subsubsection",ExpressionUUID->"e8429077-c4df-4425-9a92-8fb629b0e3a7"],
Cell[87816, 1956, 1329, 32, 161, "Input",ExpressionUUID->"ee6f68e2-fbab-4e5f-b056-239ca5a16070"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[89194, 1994, 317, 5, 55, "Subsection",ExpressionUUID->"14177f10-8700-49ef-b2c5-d41f9013f0a0"],
Cell[CellGroupData[{
Cell[89536, 2003, 357, 7, 62, "Subsubsection",ExpressionUUID->"ddc49fcb-419b-400e-9aa5-eee29834883a"],
Cell[89896, 2012, 853, 19, 85, "Input",ExpressionUUID->"9b0c41d4-beb3-4559-9af8-b5c9542313e7"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90822, 2039, 158, 3, 85, "Chapter",ExpressionUUID->"5e7806cc-6186-4f9d-b338-116084299b8b"],
Cell[90983, 2044, 48286, 1162, 4170, "Input",ExpressionUUID->"b21e00fb-62b7-48c7-992d-4aac20badc2c",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[139306, 3211, 494, 11, 88, "Title",ExpressionUUID->"3905a911-7c8a-4e79-b6bc-5846855eb1cf"],
Cell[CellGroupData[{
Cell[139825, 3226, 248, 5, 62, "Subsubsection",ExpressionUUID->"be4f3816-b05f-4d17-ae7b-e7994a0a038c"],
Cell[140076, 3233, 1702, 40, 275, "Input",ExpressionUUID->"f2a2a5c7-8e7e-4bb4-be79-6d022806a540"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141815, 3278, 284, 4, 62, "Subsubsection",ExpressionUUID->"125d41b7-380d-464b-bf87-267d6b23d012"],
Cell[CellGroupData[{
Cell[142124, 3286, 2772, 55, 199, "Input",ExpressionUUID->"e3bf4687-e988-4538-bc54-b35a7b5be56f"],
Cell[CellGroupData[{
Cell[144921, 3345, 3926, 68, 166, "Print",ExpressionUUID->"ffb1593a-377b-4ef7-b8d1-de12df0cad47"],
Cell[148850, 3415, 2379, 36, 48, "Print",ExpressionUUID->"71bf81a8-d24d-4dc3-ab30-709928c74501"],
Cell[151232, 3453, 5276, 97, 128, "Print",ExpressionUUID->"49e23287-31c5-4a56-8c15-0a768f4e673f"]
}, Open  ]],
Cell[156523, 3553, 72934, 1528, 319, "Output",ExpressionUUID->"5e47e22d-2382-4067-88f0-3c3bea358ac2"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[229506, 5087, 331, 7, 105, "Section",ExpressionUUID->"1f653e64-7953-4def-bd23-6acf91fdd5de"],
Cell[CellGroupData[{
Cell[229862, 5098, 162, 3, 62, "Subsubsection",ExpressionUUID->"60cef662-4142-405d-a9a9-66c38643579b"],
Cell[CellGroupData[{
Cell[230049, 5105, 2186, 47, 294, "Input",ExpressionUUID->"5a385965-e56e-43a1-a70a-c4c39ab08fed"],
Cell[232238, 5154, 27650, 637, 607, "Output",ExpressionUUID->"6cbd66e0-b17f-4895-9800-64e93d5c50a6"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

