(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    383397,       7652]
NotebookOptionsPosition[    377440,       7535]
NotebookOutlinePosition[    377810,       7551]
CellTagsIndexPosition[    377767,       7548]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This notebook produces plots of the orbits generated by local complementation \
orbit up and including to 9 qubits, when isomorphic graphs are considered \
equal.

This work refers to \[OpenCurlyDoubleQuote]Mapping graph state orbits under \
local complementation\[CloseCurlyDoubleQuote], \
https://arxiv.org/abs/1910.03969. Please see this work for assosciated \
documentation.

You can choose to import from .mx or .csv. Importing data from .mx is faster, \
but may not be possible on older versions of Mathematica. Importing from .csv \
is broken up into qubit number as it can be slow for large number of qubits. \
Feel free to just import the qubit number you are interested in.\
\>", "Text",
 CellChangeTimes->{{3.769350392387492*^9, 3.769350396657919*^9}, {
   3.7694296561798563`*^9, 3.7694297565358562`*^9}, {3.7694378266159754`*^9, 
   3.7694378672710404`*^9}, {3.7695118476702538`*^9, 3.7695118668611727`*^9}, 
   3.7695128279112678`*^9, {3.7695142044289837`*^9, 3.7695142327049837`*^9}, {
   3.7795601061184955`*^9, 3.779560135496547*^9}, 
   3.779674977969454*^9},ExpressionUUID->"6d21a25a-13df-4ee1-b3db-\
c52d9e784b69"],

Cell[CellGroupData[{

Cell["Load data", "Section",
 CellChangeTimes->{{3.7518136369004574`*^9, 3.751813637219489*^9}, 
   3.7692554485988054`*^9, {3.769348054128228*^9, 
   3.7693480551965485`*^9}},ExpressionUUID->"71733473-9ec5-4fee-b78d-\
79ce04e711f7"],

Cell[CellGroupData[{

Cell["Constants & Data", "Subsubsection",
 CellChangeTimes->{{3.7695115722866707`*^9, 3.7695115726767488`*^9}, {
  3.7918679847780633`*^9, 
  3.791867990066801*^9}},ExpressionUUID->"55ab2756-0d76-4bec-86d6-\
0ee91ef5055e"],

Cell[TextData[{
 "Data is organised into nested lists, where the first index, ",
 StyleBox["i",
  FontSlant->"Italic"],
 ", gives the qubit number and the second ",
 StyleBox["j",
  FontSlant->"Italic"],
 ",",
 StyleBox[" ",
  FontSlant->"Italic"],
 "indexes the orbit, which are in order as per the canonical listing of Hein, \
Danielsen, et al. (see references 11, 16 and 17 of the manuscript)."
}], "Text",
 CellChangeTimes->{{3.769350392387492*^9, 3.769350396657919*^9}, {
   3.7694296561798563`*^9, 3.7694297565358562`*^9}, {3.7694378266159754`*^9, 
   3.7694378672710404`*^9}, {3.7695118476702538`*^9, 3.7695118668611727`*^9}, 
   3.7695128279112678`*^9, {3.7695142044289837`*^9, 3.7695142327049837`*^9}, {
   3.7795601061184955`*^9, 3.779560135496547*^9}, 3.779674977969454*^9, {
   3.7918694915400934`*^9, 
   3.7918696773739653`*^9}},ExpressionUUID->"178fd3c3-153b-470a-b0fe-\
24b3cf25fbdc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"goodcolours", "=", 
    RowBox[{"ColorData", "[", 
     RowBox[{"97", ",", "\"\<ColorList\>\""}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Graph", " ", "state", " ", "display", " ", "options"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"defcol", "=", 
   RowBox[{
    RowBox[{"ColorData", "[", 
     RowBox[{"97", ",", "\"\<ColorList\>\""}], "]"}], "[", 
    RowBox[{"[", "7", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"graphsize", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vertexsize", "=", "0.30"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"edgethickness", " ", "=", "0.024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"impad", "=", "10"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"precompiled", " ", "import", " ", "for", " ", "csv"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len4", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len5", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "10", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len6", "=", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "6", ",", "4", ",", "16", ",", "10", ",", "25", ",", "5", ",", 
     "5", ",", "21", ",", "16", ",", "2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len7", "=", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "6", ",", "6", ",", "16", ",", "10", ",", "10", ",", "16", ",", 
     "44", ",", "44", ",", "14", ",", "66", ",", "10", ",", "10", ",", "21", 
     ",", "26", ",", "36", ",", "28", ",", "72", ",", "114", ",", "56", ",", 
     "92", ",", "57", ",", "33", ",", "9", ",", "46", ",", "9"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len8", "=", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "6", ",", "6", ",", "16", ",", "4", ",", "16", ",", "10", ",", 
     "16", ",", "44", ",", "16", ",", "44", ",", "10", ",", "25", ",", "44", 
     ",", "44", ",", "26", ",", "120", ",", "66", ",", "14", ",", "25", ",", 
     "120", ",", "72", ",", "172", ",", "10", ",", "10", ",", "10", ",", "21",
      ",", "10", ",", "44", ",", "66", ",", "26", ",", "26", ",", "28", ",", 
     "44", ",", "132", ",", "114", ",", "72", ",", "72", ",", "198", ",", 
     "56", ",", "28", ",", "10", ",", "56", ",", "66", ",", "72", ",", "63", 
     ",", "66", ",", "176", ",", "76", ",", "194", ",", "352", ",", "154", 
     ",", "542", ",", "300", ",", "214", ",", "14", ",", "66", ",", "66", ",",
      "6", ",", "57", ",", "28", ",", "17", ",", "72", ",", "87", ",", "114", 
     ",", "372", ",", "70", ",", "264", ",", "542", ",", "156", ",", "174", 
     ",", "542", ",", "262", ",", "802", ",", "117", ",", "10", ",", "37", 
     ",", "36", ",", "7", ",", "103", ",", "46", ",", "170", ",", "74", ",", 
     "340", ",", "254", ",", "433", ",", "476", ",", "28", ",", "9", ",", 
     "39", ",", "46", ",", "208", ",", "298", ",", "24", ",", "267", ",", "4",
      ",", "22", ",", "46", ",", "28", ",", "7", ",", "51"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"len9", "=", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "6", ",", "6", ",", "16", ",", "6", ",", "16", ",", "10", ",", 
      "10", ",", "16", ",", "44", ",", "16", ",", "44", ",", "16", ",", "16", 
      ",", "44", ",", "44", ",", "44", ",", "44", ",", "26", ",", "120", ",", 
      "10", ",", "44", ",", "44", ",", "66", ",", "26", ",", "66", ",", "120",
       ",", "14", ",", "44", ",", "120", ",", "26", ",", "44", ",", "120", 
      ",", "72", ",", "120", ",", "112", ",", "328", ",", "72", ",", "66", 
      ",", "120", ",", "328", ",", "72", ",", "328", ",", "174", ",", "18", 
      ",", "196", ",", "464", ",", "10", ",", "16", ",", "10", ",", "21", ",",
       "16", ",", "44", ",", "66", ",", "26", ",", "36", ",", "26", ",", "44",
       ",", "26", ",", "28", ",", "44", ",", "132", ",", "114", ",", "5", ",",
       "44", ",", "72", ",", "44", ",", "28", ",", "72", ",", "132", ",", 
      "26", ",", "120", ",", "372", ",", "72", ",", "72", ",", "75", ",", 
      "56", ",", "28", ",", "56", ",", "44", ",", "26", ",", "66", ",", "132",
       ",", "114", ",", "176", ",", "120", ",", "28", ",", "120", ",", "72", 
      ",", "66", ",", "120", ",", "372", ",", "352", ",", "76", ",", "542", 
      ",", "56", ",", "176", ",", "352", ",", "154", ",", "120", ",", "176", 
      ",", "42", ",", "72", ",", "76", ",", "72", ",", "154", ",", "372", ",",
       "352", ",", "196", ",", "542", ",", "300", ",", "76", ",", "120", ",", 
      "352", ",", "72", ",", "328", ",", "194", ",", "198", ",", "194", ",", 
      "484", ",", "542", ",", "300", ",", "984", ",", "66", ",", "46", ",", 
      "74", ",", "328", ",", "208", ",", "352", ",", "968", ",", "542", ",", 
      "300", ",", "984", ",", "1498", ",", "828", ",", "154", ",", "91", ",", 
      "240", ",", "488", ",", "420", ",", "1428", ",", "498", ",", "5", ",", 
      "36", ",", "132", ",", "66", ",", "75", ",", "66", ",", "114", ",", 
      "14", ",", "204", ",", "24", ",", "57", ",", "28", ",", "87", ",", "72",
       ",", "132", ",", "26", ",", "72", ",", "372", ",", "114", ",", "372", 
      ",", "114", ",", "112", ",", "542", ",", "264", ",", "94", ",", "87", 
      ",", "132", ",", "198", ",", "176", ",", "46", ",", "198", ",", "264", 
      ",", "372", ",", "1052", ",", "91", ",", "156", ",", "542", ",", "174", 
      ",", "38", ",", "72", ",", "132", ",", "352", ",", "204", ",", "186", 
      ",", "198", ",", "528", ",", "220", ",", "1052", ",", "296", ",", "300",
       ",", "754", ",", "754", ",", "76", ",", "194", ",", "188", ",", "352", 
      ",", "28", ",", "220", ",", "372", ",", "372", ",", "1052", ",", "544", 
      ",", "324", ",", "1008", ",", "312", ",", "1052", ",", "1052", ",", 
      "1052", ",", "1056", ",", "1550", ",", "1534", ",", "220", ",", "186", 
      ",", "1476", ",", "1498", ",", "924", ",", "763", ",", "156", ",", 
      "308", ",", "98", ",", "542", ",", "272", ",", "300", ",", "984", ",", 
      "754", ",", "3004", ",", "222", ",", "426", ",", "105", ",", "1436", 
      ",", "704", ",", "1472", ",", "474", ",", "1508", ",", "1498", ",", 
      "2104", ",", "4246", ",", "1328", ",", "28", ",", "37", ",", "21", ",", 
      "89", ",", "14", ",", "46", ",", "57", ",", "186", ",", "170", ",", 
      "142", ",", "170", ",", "74", ",", "340", ",", "76", ",", "204", ",", 
      "198", ",", "102", ",", "542", ",", "306", ",", "320", ",", "484", ",", 
      "782", ",", "38", ",", "36", ",", "204", ",", "220", ",", "198", ",", 
      "372", ",", "542", ",", "1052", ",", "340", ",", "1052", ",", "1096", 
      ",", "1594", ",", "94", ",", "192", ",", "178", ",", "476", ",", "542", 
      ",", "596", ",", "920", ",", "3004", ",", "952", ",", "1544", ",", 
      "806", ",", "202", ",", "1334", ",", "156", ",", "504", ",", "528", ",",
       "1052", ",", "462", ",", "340", ",", "192", ",", "542", ",", "542", 
      ",", "476", ",", "1534", ",", "754", ",", "484", ",", "1564", ",", 
      "952", ",", "1534", ",", "1550", ",", "1550", ",", "3004", ",", "1578", 
      ",", "116", ",", "58", ",", "452", ",", "283", ",", "462", ",", "3088", 
      ",", "908", ",", "399", ",", "2198", ",", "4306", ",", "4402", ",", 
      "2270", ",", "2292", ",", "4378", ",", "2684", ",", "9", ",", "63", ",",
       "100", ",", "46", ",", "42", ",", "75", ",", "85", ",", "174", ",", 
      "340", ",", "119", ",", "182", ",", "188", ",", "1578", ",", "460", ",",
       "220", ",", "166", ",", "1148", ",", "24", ",", "24", ",", "170", ",", 
      "160", ",", "784", ",", "564", ",", "168", ",", "494", ",", "1536", ",",
       "1594", ",", "1610", ",", "1578", ",", "768", ",", "494", ",", "1568", 
      ",", "476", ",", "1610", ",", "1626", ",", "124", ",", "484", ",", 
      "1114", ",", "1628", ",", "814", ",", "1594", ",", "66", ",", "952", 
      ",", "356", ",", "952", ",", "126", ",", "840", ",", "2214", ",", 
      "4470", ",", "818", ",", "2262", ",", "8836", ",", "726", ",", "1129", 
      ",", "1384", ",", "1398", ",", "305", ",", "844", ",", "4514", ",", 
      "2336", ",", "476", ",", "153", ",", "27", ",", "70", ",", "46", ",", 
      "162", ",", "170", ",", "276", ",", "340", ",", "220", ",", "494", ",", 
      "1610", ",", "128", ",", "494", ",", "988", ",", "736", ",", "1348", 
      ",", "227", ",", "608", ",", "1246", ",", "541", ",", "4580", ",", 
      "4538", ",", "1384", ",", "2408", ",", "744", ",", "4594", ",", "4592", 
      ",", "2366", ",", "344", ",", "870", ",", "119", ",", "115", ",", "99", 
      ",", "30", ",", "269", ",", "538", ",", "238", ",", "68", ",", "772", 
      ",", "1216", ",", "630", ",", "1414", ",", "672", ",", "836", ",", 
      "4670", ",", "80", ",", "1464", ",", "1478", ",", "862", ",", "278", 
      ",", "129", ",", "94", ",", "893", ",", "609", ",", "242", ",", "21", 
      ",", "567"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lenorbitsCi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", "len4", ",", "len5", ",", "len6", ",", 
      "len7", ",", "len8", ",", "len9"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourCiorbits", "=", 
   RowBox[{"Range", "[", "2", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourCigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "2", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len4", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"four", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiveCiorbits", "=", 
   RowBox[{"Range", "[", "4", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiveCigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "4", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len5", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"five", "=", "5"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sixCiorbits", "=", 
   RowBox[{"Range", "[", "11", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sixCigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "11", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len6", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"six", "=", "6"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sevenCiorbits", "=", 
   RowBox[{"Range", "[", "26", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sevenCigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "26", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len7", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"seven", "=", "7"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightCiorbits", "=", 
   RowBox[{"Range", "[", "101", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightCigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "101", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len8", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eight", "=", "8"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nineCiorbits", "=", 
   RowBox[{"Range", "[", "440", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nineCigraphlists", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Range", "[", "440", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"len9", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nine", "=", "9"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "number", " ", "of", " ", "edges", " ", "in", " ", "each", " ", "orbit"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noedgorbitsCi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "2", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "9", ",", "19", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "9", ",", "5", ",", "34", ",", "20", ",", "58", ",", "8", 
        ",", "9", ",", "47", ",", "29", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "9", ",", "9", ",", "34", ",", "19", ",", "20", ",", "35", 
        ",", "114", ",", "118", ",", "30", ",", "191", ",", "20", ",", "21", 
        ",", "47", ",", "68", ",", "98", ",", "70", ",", "206", ",", "336", 
        ",", "157", ",", "271", ",", "164", ",", "80", ",", "16", ",", "109", 
        ",", "16"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "9", ",", "9", ",", "34", ",", "5", ",", "34", ",", "20", 
        ",", "35", ",", "114", ",", "35", ",", "118", ",", "20", ",", "58", 
        ",", "118", ",", "118", ",", "66", ",", "372", ",", "201", ",", "31", 
        ",", "62", ",", "382", ",", "218", ",", "593", ",", "20", ",", "20", 
        ",", "21", ",", "47", ",", "21", ",", "122", ",", "197", ",", "69", 
        ",", "68", ",", "70", ",", "120", ",", "402", ",", "336", ",", "220", 
        ",", "222", ",", "678", ",", "157", ",", "72", ",", "21", ",", "164", 
        ",", "198", ",", "219", ",", "182", ",", "202", ",", "616", ",", 
        "230", ",", "659", ",", "1264", ",", "506", ",", "2021", ",", "1056", 
        ",", "749", ",", "34", ",", "205", ",", "193", ",", "12", ",", "164", 
        ",", "77", ",", "41", ",", "215", ",", "267", ",", "364", ",", "1324",
         ",", "208", ",", "974", ",", "2025", ",", "528", ",", "576", ",", 
        "2043", ",", "967", ",", "3044", ",", "342", ",", "22", ",", "102", 
        ",", "97", ",", "12", ",", "339", ",", "121", ",", "571", ",", "224", 
        ",", "1172", ",", "858", ",", "1586", ",", "1706", ",", "75", ",", 
        "16", ",", "103", ",", "124", ",", "758", ",", "1076", ",", "56", ",",
         "885", ",", "5", ",", "46", ",", "126", ",", "60", ",", "16", ",", 
        "134"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "9", ",", "9", ",", "34", ",", "9", ",", "34", ",", "19", 
        ",", "20", ",", "35", ",", "114", ",", "35", ",", "118", ",", "35", 
        ",", "35", ",", "114", ",", "118", ",", "118", ",", "118", ",", "66", 
        ",", "372", ",", "20", ",", "118", ",", "118", ",", "201", ",", "66", 
        ",", "191", ",", "388", ",", "31", ",", "121", ",", "382", ",", "67", 
        ",", "121", ",", "382", ",", "218", ",", "382", ",", "366", ",", 
        "1180", ",", "222", ",", "201", ",", "394", ",", "1220", ",", "222", 
        ",", "1208", ",", "612", ",", "41", ",", "692", ",", "1850", ",", 
        "20", ",", "36", ",", "21", ",", "47", ",", "37", ",", "122", ",", 
        "197", ",", "68", ",", "98", ",", "69", ",", "124", ",", "68", ",", 
        "70", ",", "120", ",", "402", ",", "336", ",", "9", ",", "122", ",", 
        "220", ",", "120", ",", "70", ",", "206", ",", "426", ",", "69", ",", 
        "392", ",", "1324", ",", "226", ",", "222", ",", "252", ",", "157", 
        ",", "72", ",", "164", ",", "123", ",", "71", ",", "198", ",", "424", 
        ",", "360", ",", "616", ",", "386", ",", "72", ",", "390", ",", "219",
         ",", "202", ",", "390", ",", "1312", ",", "1264", ",", "230", ",", 
        "2021", ",", "164", ",", "616", ",", "1264", ",", "506", ",", "394", 
        ",", "632", ",", "125", ",", "226", ",", "238", ",", "226", ",", 
        "534", ",", "1376", ",", "1312", ",", "704", ",", "2139", ",", "1056",
         ",", "234", ",", "396", ",", "1292", ",", "228", ",", "1224", ",", 
        "678", ",", "706", ",", "686", ",", "1934", ",", "2133", ",", "1092", 
        ",", "4000", ",", "221", ",", "133", ",", "233", ",", "1228", ",", 
        "732", ",", "1304", ",", "3948", ",", "2123", ",", "1116", ",", 
        "4024", ",", "6360", ",", "3312", ",", "526", ",", "302", ",", "942", 
        ",", "1952", ",", "1592", ",", "6110", ",", "2055", ",", "8", ",", 
        "103", ",", "422", ",", "213", ",", "246", ",", "205", ",", "362", 
        ",", "32", ",", "718", ",", "68", ",", "164", ",", "73", ",", "267", 
        ",", "217", ",", "420", ",", "70", ",", "215", ",", "1324", ",", 
        "364", ",", "1324", ",", "364", ",", "358", ",", "2025", ",", "974", 
        ",", "326", ",", "287", ",", "436", ",", "700", ",", "648", ",", 
        "135", ",", "710", ",", "1030", ",", "1380", ",", "4274", ",", "309", 
        ",", "528", ",", "2043", ",", "576", ",", "104", ",", "230", ",", 
        "434", ",", "1308", ",", "710", ",", "676", ",", "712", ",", "2088", 
        ",", "776", ",", "4250", ",", "1114", ",", "1112", ",", "3116", ",", 
        "3144", ",", "236", ",", "684", ",", "676", ",", "1312", ",", "74", 
        ",", "776", ",", "1372", ",", "1372", ",", "4242", ",", "2154", ",", 
        "1188", ",", "4108", ",", "1150", ",", "4262", ",", "4262", ",", 
        "4262", ",", "4300", ",", "6520", ",", "6528", ",", "746", ",", "663",
         ",", "6364", ",", "6388", ",", "3660", ",", "3181", ",", "548", ",", 
        "1128", ",", "320", ",", "2141", ",", "1048", ",", "1126", ",", 
        "4036", ",", "3146", ",", "12984", ",", "833", ",", "1656", ",", 
        "334", ",", "6190", ",", "2992", ",", "6286", ",", "1800", ",", 
        "6478", ",", "6438", ",", "9226", ",", "18931", ",", "5374", ",", 
        "73", ",", "102", ",", "56", ",", "300", ",", "31", ",", "121", ",", 
        "177", ",", "656", ",", "571", ",", "523", ",", "607", ",", "224", 
        ",", "1172", ",", "236", ",", "716", ",", "706", ",", "350", ",", 
        "2149", ",", "1149", ",", "1182", ",", "1830", ",", "3256", ",", 
        "106", ",", "107", ",", "720", ",", "780", ",", "712", ",", "1384", 
        ",", "2147", ",", "4286", ",", "1236", ",", "4286", ",", "4440", ",", 
        "6720", ",", "323", ",", "678", ",", "635", ",", "1842", ",", "2165", 
        ",", "2318", ",", "3656", ",", "13000", ",", "3748", ",", "6636", ",",
         "3325", ",", "710", ",", "5415", ",", "562", ",", "2036", ",", 
        "2120", ",", "4274", ",", "1802", ",", "1242", ",", "672", ",", 
        "2161", ",", "2161", ",", "1860", ",", "6544", ",", "3176", ",", 
        "1876", ",", "6654", ",", "3760", ",", "6582", ",", "6600", ",", 
        "6598", ",", "13068", ",", "6760", ",", "382", ",", "171", ",", 
        "1768", ",", "1118", ",", "1824", ",", "13404", ",", "3624", ",", 
        "1470", ",", "9693", ",", "19201", ",", "19633", ",", "9879", ",", 
        "9938", ",", "19525", ",", "11058", ",", "16", ",", "189", ",", "330",
         ",", "124", ",", "128", ",", "253", ",", "273", ",", "613", ",", 
        "1250", ",", "421", ",", "635", ",", "658", ",", "6708", ",", "1820", 
        ",", "756", ",", "594", ",", "4916", ",", "58", ",", "56", ",", "606",
         ",", "589", ",", "3294", ",", "2238", ",", "598", ",", "1888", ",", 
        "6576", ",", "6774", ",", "6848", ",", "6758", ",", "3248", ",", 
        "1892", ",", "6718", ",", "1866", ",", "6886", ",", "6902", ",", 
        "398", ",", "1884", ",", "4825", ",", "6910", ",", "3404", ",", 
        "6796", ",", "188", ",", "3788", ",", "1336", ",", "3788", ",", "415",
         ",", "3452", ",", "9699", ",", "19939", ",", "3411", ",", "9965", 
        ",", "39762", ",", "2816", ",", "4942", ",", "5602", ",", "5655", ",",
         "1178", ",", "3477", ",", "20137", ",", "10200", ",", "1864", ",", 
        "573", ",", "73", ",", "193", ",", "126", ",", "590", ",", "612", ",",
         "1043", ",", "1256", ",", "764", ",", "1904", ",", "6908", ",", 
        "408", ",", "1906", ",", "3896", ",", "3283", ",", "5549", ",", "792",
         ",", "2520", ",", "5219", ",", "2253", ",", "20322", ",", "20245", 
        ",", "5666", ",", "10412", ",", "2879", ",", "20497", ",", "20488", 
        ",", "10287", ",", "1202", ",", "3255", ",", "393", ",", "384", ",", 
        "330", ",", "77", ",", "986", ",", "2034", ",", "820", ",", "189", 
        ",", "2990", ",", "5211", ",", "2575", ",", "5799", ",", "2714", ",", 
        "3505", ",", "20839", ",", "268", ",", "5914", ",", "5967", ",", 
        "3577", ",", "1030", ",", "417", ",", "320", ",", "3667", ",", "2632",
         ",", "843", ",", "51", ",", "2368"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Smallest", " ", "number", " ", "of", " ", "edges", " ", "of", " ", "any", 
    " ", "graph", " ", "state", " ", "found", " ", "in", " ", "an", " ", 
    "orbit"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"minedgeorbitsCi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "4", ",", "4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "6", ",", 
        "6", ",", "6", ",", "6", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", 
        "6", ",", "6", ",", "6", ",", "6", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "8", ",", "8", ",", "9", ",", "9", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "10", ",", "10", 
        ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",",
         "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "12", ",", "12", ",", "12", ",", "13", ",", "13", ",", "13"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
       "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
        ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",",
         "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
        "10", ",", "10", ",", "10", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", "11", ",", 
        "11", ",", "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", 
        "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", 
        "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", 
        "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", 
        "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", 
        "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", 
        "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", 
        "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", 
        "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", 
        "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", "12", ",", 
        "12", ",", "13", ",", "13", ",", "13", ",", "13", ",", "13", ",", 
        "13", ",", "13", ",", "13", ",", "13", ",", "13", ",", "13", ",", 
        "13", ",", "13", ",", "13", ",", "13", ",", "13", ",", "13", ",", 
        "13", ",", "13", ",", "13", ",", "13", ",", "13", ",", "13", ",", 
        "13", ",", "13", ",", "13", ",", "13", ",", "13", ",", "13", ",", 
        "13", ",", "13", ",", "14", ",", "14", ",", "14", ",", "14", ",", 
        "14", ",", "14", ",", "14", ",", "14", ",", "14", ",", "14", ",", 
        "14", ",", "14", ",", "14", ",", "14", ",", "14", ",", "14", ",", 
        "14", ",", "14", ",", "15", ",", "15", ",", "15", ",", "15", ",", 
        "15", ",", "15", ",", "15", ",", "15", ",", "15"}], "}"}]}], "}"}]}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Schmidt", " ", "measure", " ", "of", " ", "each", " ", "entanglement", 
     " ", 
     RowBox[{"class", ".", " ", "When"}], " ", "an", " ", "exact", " ", 
     "value", " ", "is", " ", "not", " ", "known"}], ",", " ", 
    RowBox[{
    "the", " ", "mean", " ", "of", " ", "the", " ", "upper", " ", "and", " ", 
     "lower", " ", "bounds", " ", "is", " ", "given"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"schmidtgraph", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "2", ",", "2.5`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "2", ",", 
        "3", ",", "3", ",", "3", ",", "3.5`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3.5`", ",", "3.5`",
         ",", "3.5`", ",", "3.5`", ",", "3", ",", "3.5`", ",", "3.5`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3.5`", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "3", 
        ",", "3", ",", "3", ",", "3", ",", "3.5`", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "3", ",", 
        "3", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4.5`", ",", "3.5`", ",", "4",
         ",", "4", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4", ",", "4.5`", ",", "4.5`", ",", "4", ",", "4.5`", ",", "4.5`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "2", ",", "2", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3.5`", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "2", ",", "3", 
        ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", 
        ",", "3", ",", "3.5`", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4.5`", 
        ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "3", 
        ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4.5`", ",", "4.5`", ",",
         "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "3.5`", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
        ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4", ",", "4", ",", "4", ",", 
        "4", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", 
        ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4", ",", "4", ",", "4.5`", ",", "4.5`", 
        ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", "4.5`", ",", 
        "4.5`", ",", "5`", ",", "5`"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Minimum", " ", "graph", " ", "state", " ", "chromatic", " ", "number", 
    " ", "found", " ", "each", " ", "entanglement", " ", "class"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Chi]graph", "=", "\[Chi]orbitsCi"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "5", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "6", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3",
      ",", "3", ",", "2", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "6", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3",
      ",", "3", ",", "2", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "7", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2",
      ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "2", 
     ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", 
     ",", "3", ",", "2", ",", "3", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]graph", "[", 
    RowBox[{"[", "8", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2",
      ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
     ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
     ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "2", 
     ",", "3", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "2", 
     ",", "3", ",", "2", ",", "2", ",", "3", ",", "3", ",", "2", ",", "3", 
     ",", "2", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", "2", 
     ",", "3", ",", "3", ",", "3", ",", "2", ",", "2", ",", "3", ",", "3", 
     ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", 
     ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", 
     ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "2", ",", "3", 
     ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", 
     ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", 
     ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", 
     ",", "3", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Chi]graph", "[", 
     RowBox[{"[", "9", "]"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
      "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
      "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
      "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
      "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
      "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
      "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
      "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "2", ",", "3", ",", 
      "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "2", ",", 
      "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "2", ",", "2", ",", "3", ",", "2", ",", 
      "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "2", ",", "3", ",", "2", ",", "2", ",", "3", ",", "3", ",", 
      "3", ",", "2", ",", "3", ",", "2", ",", "3", ",", "2", ",", "3", ",", 
      "3", ",", "3", ",", "2", ",", "2", ",", "3", ",", "2", ",", "3", ",", 
      "3", ",", "3", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "2", ",", 
      "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", "2", ",", 
      "3", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", 
      "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "2", ",", "2", ",", "3", ",", "2", ",", 
      "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", "2", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "2", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "2", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", 
      "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
      "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3"}], "}"}]}], ";"}],
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Minimum", " ", "graph", " ", "state", " ", "chromatic", " ", "index", " ",
     "found", " ", "each", " ", "entanglement", " ", "class"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]egraph", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "2", "}"}], ",", 
      RowBox[{"{", "2", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "5", ",", "4", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", 
        "3", ",", "3", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "6", ",", "5", ",", "4", ",", "4", ",", "3", ",", "4", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "2", ",", "4", ",", "4", ",", "4", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "7", ",", "6", ",", "5", ",", "5", ",", "4", ",", "4", ",", "5", ",", 
        "4", ",", "4", ",", "4", ",", "4", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "2", ",", "5", ",", "4", ",", "5", ",", "5", ",", "4", ",", 
        "4", ",", "4", ",", "4", ",", "3", ",", "3", ",", "4", ",", "4", ",", 
        "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "4", ",", 
        "4", ",", "3", ",", "3", ",", "4", ",", "3", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", ",", 
        "3", ",", "4", ",", "4", ",", "4", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "5", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", "4", ",", 
        "4", ",", "5", ",", "4"}], "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "440"}], "}"}]}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Chromatic", " ", "number", " ", "of", " ", "each", " ", "orbit"}],
    " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]orbitsCi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "2", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "2"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", 
        "3", ",", "5", ",", "3", ",", "5", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "2", ",", "2", ",", "3", ",", "2", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", "3", ",", 
        "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", 
        "3", ",", "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "5", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", "4", ",", 
        "5", ",", "3", ",", "4", ",", "3", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "5", ",", "4", ",", "3", ",", "3", ",", 
        "5", ",", "3", ",", "4", ",", "4", ",", "3", ",", "3", ",", "5", ",", 
        "4", ",", "3", ",", "4", ",", "4", ",", "3", ",", "3", ",", "5", ",", 
        "4", ",", "4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "2", ",", "2", ",", "3", ",", "2", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", 
        "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "4", ",", "4", ",", "4", ",", "3", ",", "4", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "5", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", ",", "5", ",", 
        "3", ",", "3", ",", "4", ",", "3", ",", "3", ",", "4", ",", "3", ",", 
        "3", ",", "4", ",", "4", ",", "3", ",", "5", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", 
        "3", ",", "4", ",", "3", ",", "4", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", 
        "3", ",", "3", ",", "4", ",", "3", ",", "4", ",", "3", ",", "4", ",", 
        "3", ",", "3", ",", "4", ",", "3", ",", "5", ",", "4", ",", "4", ",", 
        "3", ",", "4", ",", "3", ",", "5", ",", "3", ",", "3", ",", "4", ",", 
        "3", ",", "5", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "5", ",", "3", ",", "3", ",", "4", ",", "4", ",", "4", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", 
        "3", ",", "5", ",", "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "4", ",", "3", ",", "3", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", 
        "4", ",", "4", ",", "4", ",", "3", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "4", ",", "3", ",", "4", ",", "5", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "5", ",", 
        "5", ",", "4", ",", "4", ",", "4", ",", "3", ",", "3", ",", "4", ",", 
        "4", ",", "3", ",", "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "5", ",", "5", ",", "3", ",", "3", ",", "3", ",", 
        "5", ",", "3", ",", "5", ",", "5", ",", "3", ",", "3", ",", "4", ",", 
        "3", ",", "3", ",", "4", ",", "4", ",", "4", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "4", ",", "4", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "4", ",", "4", ",", "3", ",", "4", ",", "3", ",", "3", ",", 
        "5", ",", "5", ",", "4", ",", "3", ",", "4", ",", "3", ",", "4", ",", 
        "3", ",", "5", ",", "3", ",", "5", ",", "3", ",", "4", ",", "3", ",", 
        "3", ",", "4", ",", "3", ",", "5", ",", "4", ",", "5", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "\"\<\>\"", ",", "4", ",", "4", ",", 
        "3", ",", "5", ",", "5", ",", "4", ",", "4", ",", "3", ",", "3", ",", 
        "3", ",", "4", ",", "3", ",", "5", ",", "4", ",", "3", ",", "4", ",", 
        "4", ",", "5", ",", "4", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "4", ",", "3", ",", "5", ",", "3", ",", "3", ",", "4", ",", "5", ",", 
        "3", ",", "4", ",", "5", ",", "5", ",", "3", ",", "5", ",", "5", ",", 
        "3", ",", "3", ",", "5", ",", "4", ",", "4", ",", "4", ",", "3", ",", 
        "4", ",", "3", ",", "4", ",", "5", ",", "3", ",", "3", ",", "5", ",", 
        "5", ",", "4", ",", "3", ",", "4", ",", "4", ",", "4", ",", "3"}], 
       "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Chromatic", " ", "index", " ", "of", " ", "each", " ", "orbit"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]eorbitsCi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "4", ",", "3", ",", 
        "3", ",", "5", ",", "6", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "4", ",", "4", ",", "4", ",", "5", ",", "3", ",", "3", ",", "5", ",", 
        "4", ",", "5", ",", "4", ",", "5", ",", "6", ",", "6", ",", "7", ",", 
        "6", ",", "7", ",", "5", ",", "7", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "3", ",", "2", ",", "3", ",", "3", ",", 
        "3", ",", "4", ",", "3", ",", "4", ",", "3", ",", "4", ",", "4", ",", 
        "4", ",", "4", ",", "5", ",", "5", ",", "4", ",", "4", ",", "5", ",", 
        "5", ",", "6", ",", "3", ",", "3", ",", "3", ",", "5", ",", "3", ",", 
        "4", ",", "5", ",", "4", ",", "4", ",", "4", ",", "4", ",", "5", ",", 
        "6", ",", "5", ",", "5", ",", "6", ",", "6", ",", "4", ",", "4", ",", 
        "6", ",", "5", ",", "5", ",", "6", ",", "5", ",", "6", ",", "5", ",", 
        "6", ",", "6", ",", "7", ",", "7", ",", "7", ",", "8", ",", "5", ",", 
        "5", ",", "6", ",", "3", ",", "6", ",", "5", ",", "4", ",", "5", ",", 
        "7", ",", "6", ",", "6", ",", "6", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "8", ",", "8", ",", "8", ",", "4", ",", "7", ",", 
        "6", ",", "3", ",", "6", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "8", ",", "8", ",", "8", ",", "8", ",", "4", ",", "6", ",", "7", ",", 
        "8", ",", "8", ",", "5", ",", "8", ",", "3", ",", "8", ",", "7", ",", 
        "6", ",", "5", ",", "8"}], "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "440"}], "}"}]}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Graph", " ", "state", " ", "rank", " ", "width", " ", "of", " ", "each", 
    " ", "entanglement", " ", "class"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rwdgraphs", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
        "1", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", 
        "1", ",", "2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
        "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", 
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "2", ",", "1", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", 
        "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "2", ",", 
        "2", ",", "2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "2", ",", "1", ",", "1", ",", "2", ",", "1", ",", "2", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", 
        "1", ",", "1", ",", "2", ",", "1", ",", "1", ",", "2", ",", "2", ",", 
        "1", ",", "1", ",", "2", ",", "1", ",", "1", ",", "2", ",", "2", ",", 
        "1", ",", "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", 
        "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", "1", ",", 
        "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "1", ",", "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", 
        "1", ",", "2", ",", "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2", ",", "1", ",", 
        "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", 
        "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "1", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "3", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "2", ",", "3", ",", 
        "2", ",", "3", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", "2", ",", 
        "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "2", ",", "2", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", 
        "3", ",", "2", ",", "2", ",", "2", ",", "3", ",", "2", ",", "2", ",", 
        "3", ",", "3", ",", "3", ",", "2", ",", "2", ",", "3"}], "}"}]}], 
     "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Diameter", " ", "of", " ", "each", " ", "orbit"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"distsorbitsCi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "3", ",", "3", ",", "3", ",", "3", ",", "5", ",", "3", ",", 
        "3", ",", "4", ",", "4", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "5", ",", "5", ",", "5", ",", "6", ",", "3", ",", "3", ",", "4", ",", 
        "4", ",", "4", ",", "5", ",", "5", ",", "6", ",", "5", ",", "7", ",", 
        "5", ",", "5", ",", "3", ",", "5", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "5", ",", "3", ",", "5", ",", "3", ",", "5", ",", "5", ",", 
        "5", ",", "5", ",", "6", ",", "6", ",", "5", ",", "5", ",", "6", ",", 
        "5", ",", "7", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", 
        "5", ",", "5", ",", "4", ",", "4", ",", "5", ",", "5", ",", "5", ",", 
        "6", ",", "5", ",", "5", ",", "6", ",", "5", ",", "5", ",", "4", ",", 
        "5", ",", "6", ",", "5", ",", "6", ",", "6", ",", "6", ",", "6", ",", 
        "7", ",", "7", ",", "6", ",", "7", ",", "7", ",", "8", ",", "4", ",", 
        "5", ",", "5", ",", "3", ",", "5", ",", "4", ",", "4", ",", "5", ",", 
        "5", ",", "6", ",", "7", ",", "6", ",", "6", ",", "7", ",", "6", ",", 
        "6", ",", "7", ",", "6", ",", "8", ",", "7", ",", "4", ",", "5", ",", 
        "5", ",", "5", ",", "6", ",", "5", ",", "6", ",", "6", ",", "7", ",", 
        "7", ",", "8", ",", "7", ",", "4", ",", "4", ",", "5", ",", "5", ",", 
        "6", ",", "7", ",", "5", ",", "7", ",", "2", ",", "5", ",", "5", ",", 
        "6", ",", "2", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "5", ",", "3", ",", "5", ",", "3", ",", "3", ",", 
        "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "6", ",", "3", ",", 
        "5", ",", "5", ",", "6", ",", "5", ",", "6", ",", "6", ",", "5", ",", 
        "5", ",", "6", ",", "5", ",", "5", ",", "6", ",", "5", ",", "6", ",", 
        "5", ",", "7", ",", "5", ",", "6", ",", "6", ",", "7", ",", "5", ",", 
        "7", ",", "7", ",", "5", ",", "7", ",", "8", ",", "3", ",", "3", ",", 
        "3", ",", "4", ",", "3", ",", "5", ",", "5", ",", "4", ",", "4", ",", 
        "4", ",", "5", ",", "4", ",", "5", ",", "5", ",", "5", ",", "6", ",", 
        "3", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", 
        "4", ",", "6", ",", "7", ",", "5", ",", "5", ",", "6", ",", "5", ",", 
        "5", ",", "5", ",", "5", ",", "4", ",", "6", ",", "5", ",", "6", ",", 
        "6", ",", "6", ",", "5", ",", "6", ",", "5", ",", "6", ",", "6", ",", 
        "7", ",", "7", ",", "6", ",", "7", ",", "5", ",", "6", ",", "7", ",", 
        "6", ",", "6", ",", "6", ",", "5", ",", "5", ",", "6", ",", "5", ",", 
        "6", ",", "7", ",", "7", ",", "6", ",", "7", ",", "7", ",", "6", ",", 
        "6", ",", "7", ",", "5", ",", "7", ",", "7", ",", "6", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "6", ",", "5", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "8", ",", "7", ",", "7", ",", "7", ",", 
        "8", ",", "8", ",", "6", ",", "6", ",", "6", ",", "7", ",", "7", ",", 
        "9", ",", "9", ",", "3", ",", "4", ",", "5", ",", "5", ",", "6", ",", 
        "5", ",", "6", ",", "5", ",", "7", ",", "4", ",", "5", ",", "5", ",", 
        "5", ",", "5", ",", "5", ",", "4", ",", "5", ",", "7", ",", "6", ",", 
        "7", ",", "6", ",", "6", ",", "7", ",", "6", ",", "5", ",", "5", ",", 
        "5", ",", "6", ",", "6", ",", "5", ",", "6", ",", "6", ",", "7", ",", 
        "7", ",", "6", ",", "6", ",", "7", ",", "6", ",", "5", ",", "5", ",", 
        "5", ",", "7", ",", "7", ",", "6", ",", "6", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "6", ",", "7", ",", 
        "6", ",", "7", ",", "6", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "9", ",", "8", ",", "7", ",", "6", ",", "8", ",", "8", ",", 
        "7", ",", "9", ",", "6", ",", "7", ",", "6", ",", "7", ",", "6", ",", 
        "7", ",", "7", ",", "7", ",", "9", ",", "6", ",", "7", ",", "7", ",", 
        "8", ",", "7", ",", "9", ",", "7", ",", "8", ",", "8", ",", "8", ",", 
        "9", ",", "8", ",", "5", ",", "5", ",", "4", ",", "5", ",", "5", ",", 
        "5", ",", "5", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", 
        "7", ",", "6", ",", "7", ",", "6", ",", "6", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "8", ",", "5", ",", "5", ",", "7", ",", "7", ",", 
        "6", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "9", ",", "6", ",", "6", ",", "6", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "9", ",", "7", ",", "8", ",", "9", ",", "6", ",", "8", ",", 
        "6", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
        "7", ",", "7", ",", "7", ",", "8", ",", "7", ",", "7", ",", "9", ",", 
        "7", ",", "8", ",", "9", ",", "9", ",", "9", ",", "8", ",", "6", ",", 
        "5", ",", "7", ",", "6", ",", "7", ",", "9", ",", "7", ",", "7", ",", 
        "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", 
        "4", ",", "5", ",", "6", ",", "5", ",", "5", ",", "6", ",", "6", ",", 
        "6", ",", "7", ",", "6", ",", "6", ",", "6", ",", "8", ",", "7", ",", 
        "7", ",", "9", ",", "9", ",", "5", ",", "5", ",", "6", ",", "6", ",", 
        "7", ",", "7", ",", "6", ",", "7", ",", "8", ",", "9", ",", "8", ",", 
        "8", ",", "8", ",", "7", ",", "8", ",", "7", ",", "8", ",", "9", ",", 
        "7", ",", "7", ",", "8", ",", "9", ",", "8", ",", "9", ",", "6", ",", 
        "7", ",", "7", ",", "7", ",", "6", ",", "8", ",", "9", ",", "9", ",", 
        "9", ",", "9", ",", "9", ",", "8", ",", "8", ",", "8", ",", "8", ",", 
        "8", ",", "9", ",", "9", ",", "9", ",", "7", ",", "6", ",", "5", ",", 
        "6", ",", "5", ",", "6", ",", "6", ",", "9", ",", "7", ",", "7", ",", 
        "7", ",", "8", ",", "7", ",", "7", ",", "7", ",", "7", ",", "8", ",", 
        "6", ",", "7", ",", "9", ",", "9", ",", "9", ",", "9", ",", "8", ",", 
        "9", ",", "8", ",", "9", ",", "9", ",", "9", ",", "7", ",", "7", ",", 
        "6", ",", "6", ",", "6", ",", "5", ",", "7", ",", "7", ",", "7", ",", 
        "6", ",", "8", ",", "8", ",", "7", ",", "8", ",", "9", ",", "8", ",", 
        "9", ",", "5", ",", "8", ",", "8", ",", "9", ",", "7", ",", "6", ",", 
        "8", ",", "9", ",", "7", ",", "7", ",", "4", ",", "9"}], "}"}]}], 
     "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Mean", " ", "diameter", " ", "of", " ", "each", " ", "orbit"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"meandistsorbitsCi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1.`", "}"}], ",", 
      RowBox[{"{", "1.`", "}"}], ",", 
      RowBox[{"{", "1.`", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", "1.6666666666666667`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.`", ",", "1.8`", ",", "2.0444444444444443`", ",", 
        "1.3333333333333333`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.`", ",", "1.8`", ",", "1.6666666666666667`", ",", "2.25`", ",", 
        "2.0444444444444443`", ",", "2.506666666666667`", ",", "1.7`", ",", 
        "1.7`", ",", "2.3190476190476192`", ",", "2.216666666666667`", ",", 
        "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.`", ",", "1.8`", ",", "1.8`", ",", "2.25`", ",", 
        "2.0444444444444443`", ",", "2.0444444444444443`", ",", "2.25`", ",", 
        "2.8372093023255816`", ",", "2.8372093023255816`", ",", 
        "2.340659340659341`", ",", "3.055011655011655`", ",", 
        "2.0444444444444443`", ",", "2.0444444444444443`", ",", 
        "2.3190476190476192`", ",", "2.5015384615384617`", ",", 
        "2.541269841269841`", ",", "2.6296296296296298`", ",", 
        "3.0610328638497655`", ",", "3.2925011644154636`", ",", 
        "2.8454545454545452`", ",", "3.015527950310559`", ",", 
        "2.793859649122807`", ",", "2.4318181818181817`", ",", 
        "1.8055555555555556`", ",", "2.8067632850241546`", ",", 
        "1.9722222222222223`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.`", ",", "1.8`", ",", "1.8`", ",", "2.25`", ",", 
        "1.6666666666666667`", ",", "2.25`", ",", "2.0444444444444443`", ",", 
        "2.25`", ",", "2.8372093023255816`", ",", "2.25`", ",", 
        "2.8372093023255816`", ",", "2.0444444444444443`", ",", 
        "2.506666666666667`", ",", "2.8372093023255816`", ",", 
        "2.8372093023255816`", ",", "2.5507692307692307`", ",", 
        "3.4453781512605044`", ",", "3.055011655011655`", ",", 
        "2.340659340659341`", ",", "2.506666666666667`", ",", 
        "3.4453781512605044`", ",", "3.176056338028169`", ",", 
        "3.540595675234598`", ",", "2.0444444444444443`", ",", 
        "2.0444444444444443`", ",", "2.0444444444444443`", ",", 
        "2.3190476190476192`", ",", "2.0444444444444443`", ",", 
        "2.8372093023255816`", ",", "2.8797202797202797`", ",", 
        "2.5015384615384617`", ",", "2.5015384615384617`", ",", 
        "2.6296296296296298`", ",", "2.8372093023255816`", ",", 
        "3.455933379597502`", ",", "3.2925011644154636`", ",", 
        "3.0610328638497655`", ",", "3.132237871674491`", ",", 
        "3.6200071783828127`", ",", "2.8454545454545452`", ",", 
        "2.6296296296296298`", ",", "2.1333333333333333`", ",", 
        "2.8454545454545452`", ",", "3.055011655011655`", ",", 
        "3.0610328638497655`", ",", "2.9359959037378394`", ",", 
        "3.055011655011655`", ",", "3.451168831168831`", ",", 
        "3.2126315789473683`", ",", "3.5345334116767266`", ",", 
        "4.064685314685315`", ",", "3.4918088447500213`", ",", 
        "4.147171767466288`", ",", "3.8855295429208474`", ",", 
        "3.378131718660875`", ",", "1.989010989010989`", ",", 
        "2.8797202797202797`", ",", "2.9874125874125874`", ",", "1.8`", ",", 
        "2.793859649122807`", ",", "2.433862433862434`", ",", 
        "2.360294117647059`", ",", "3.0610328638497655`", ",", 
        "2.9933172948409514`", ",", "3.2925011644154636`", ",", 
        "4.082427614990001`", ",", "3.094409937888199`", ",", 
        "3.526529554096094`", ",", "4.147171767466288`", ",", 
        "3.410090984284533`", ",", "3.478705733838283`", ",", 
        "4.147171767466288`", ",", "3.3682548038957623`", ",", 
        "4.264815489366471`", ",", "3.256557618626584`", ",", 
        "2.022222222222222`", ",", "2.512012012012012`", ",", 
        "2.626984126984127`", ",", "2.238095238095238`", ",", 
        "3.1376356367789833`", ",", "2.8067632850241546`", ",", 
        "3.4096762965541245`", ",", "3.001851166234728`", ",", 
        "3.941055006073226`", ",", "3.5884970900376585`", ",", 
        "3.821358309810966`", ",", "3.945077399380805`", ",", 
        "2.171957671957672`", ",", "1.9722222222222223`", ",", 
        "2.673414304993252`", ",", "2.8067632850241546`", ",", 
        "3.247166480862133`", ",", "3.4541387024608503`", ",", 
        "2.4420289855072466`", ",", "3.6490946467291825`", ",", 
        "1.3333333333333333`", ",", "2.242424242424242`", ",", 
        "2.8067632850241546`", ",", "2.560846560846561`", ",", 
        "1.3333333333333333`", ",", "2.7223529411764704`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.`", ",", "1.8`", ",", "1.8`", ",", "2.25`", ",", "1.8`", ",", 
        "2.25`", ",", "2.0444444444444443`", ",", "2.0444444444444443`", ",", 
        "2.25`", ",", "2.8372093023255816`", ",", "2.25`", ",", 
        "2.8372093023255816`", ",", "2.25`", ",", "2.25`", ",", 
        "2.8372093023255816`", ",", "2.8372093023255816`", ",", 
        "2.8372093023255816`", ",", "2.8372093023255816`", ",", 
        "2.5507692307692307`", ",", "3.4453781512605044`", ",", 
        "2.0444444444444443`", ",", "2.8372093023255816`", ",", 
        "2.8372093023255816`", ",", "3.055011655011655`", ",", 
        "2.5507692307692307`", ",", "3.055011655011655`", ",", 
        "3.4453781512605044`", ",", "2.340659340659341`", ",", 
        "2.8372093023255816`", ",", "3.4453781512605044`", ",", 
        "2.5507692307692307`", ",", "2.8372093023255816`", ",", 
        "3.4453781512605044`", ",", "3.176056338028169`", ",", 
        "3.4453781512605044`", ",", "3.3873873873873874`", ",", 
        "4.083687625867085`", ",", "3.176056338028169`", ",", 
        "3.055011655011655`", ",", "3.4453781512605044`", ",", 
        "4.083687625867085`", ",", "3.176056338028169`", ",", 
        "4.083687625867085`", ",", "3.6754368480499635`", ",", 
        "2.6470588235294117`", ",", "3.7982208267922553`", ",", 
        "4.1558520145974525`", ",", "2.0444444444444443`", ",", "2.25`", ",", 
        "2.0444444444444443`", ",", "2.3190476190476192`", ",", "2.25`", ",", 
        "2.8372093023255816`", ",", "2.8797202797202797`", ",", 
        "2.5015384615384617`", ",", "2.541269841269841`", ",", 
        "2.5015384615384617`", ",", "2.8372093023255816`", ",", 
        "2.5015384615384617`", ",", "2.6296296296296298`", ",", 
        "2.8372093023255816`", ",", "3.455933379597502`", ",", 
        "3.2925011644154636`", ",", "1.7`", ",", "2.8372093023255816`", ",", 
        "3.0610328638497655`", ",", "2.8372093023255816`", ",", 
        "2.6296296296296298`", ",", "3.0610328638497655`", ",", 
        "3.455933379597502`", ",", "2.5015384615384617`", ",", 
        "3.4453781512605044`", ",", "4.082427614990001`", ",", 
        "3.132237871674491`", ",", "3.132237871674491`", ",", 
        "2.9931531531531532`", ",", "2.8454545454545452`", ",", 
        "2.6296296296296298`", ",", "2.8454545454545452`", ",", 
        "2.8372093023255816`", ",", "2.5015384615384617`", ",", 
        "3.055011655011655`", ",", "3.455933379597502`", ",", 
        "3.2925011644154636`", ",", "3.451168831168831`", ",", 
        "3.4453781512605044`", ",", "2.6296296296296298`", ",", 
        "3.4453781512605044`", ",", "3.0610328638497655`", ",", 
        "3.055011655011655`", ",", "3.4453781512605044`", ",", 
        "4.082427614990001`", ",", "4.064685314685315`", ",", 
        "3.2126315789473683`", ",", "4.147171767466288`", ",", 
        "2.8454545454545452`", ",", "3.451168831168831`", ",", 
        "4.064685314685315`", ",", "3.4918088447500213`", ",", 
        "3.4453781512605044`", ",", "3.451168831168831`", ",", 
        "2.8118466898954706`", ",", "3.132237871674491`", ",", 
        "3.2126315789473683`", ",", "3.0610328638497655`", ",", 
        "3.4918088447500213`", ",", "4.082427614990001`", ",", 
        "4.064685314685315`", ",", "3.752171637885924`", ",", 
        "4.147171767466288`", ",", "3.8855295429208474`", ",", 
        "3.2126315789473683`", ",", "3.4453781512605044`", ",", 
        "4.064685314685315`", ",", "3.132237871674491`", ",", 
        "4.083687625867085`", ",", "3.6815875220340795`", ",", 
        "3.6200071783828127`", ",", "3.6815875220340795`", ",", 
        "4.11337542562839`", ",", "4.147171767466288`", ",", 
        "3.8855295429208474`", ",", "4.700915564598169`", ",", 
        "3.006060606060606`", ",", "2.9584541062801932`", ",", 
        "3.1747500925583116`", ",", "4.083687625867085`", ",", 
        "3.8435525826830172`", ",", "4.064685314685315`", ",", 
        "4.726734297947986`", ",", "4.147171767466288`", ",", 
        "3.8855295429208474`", ",", "4.700915564598169`", ",", 
        "4.76349316345196`", ",", "4.554726063006385`", ",", 
        "3.4918088447500213`", ",", "3.177045177045177`", ",", 
        "3.535495118549512`", ",", "4.123834449792978`", ",", 
        "4.13017388339584`", ",", "4.778034269068525`", ",", 
        "3.7233440805475424`", ",", "1.7`", ",", "2.541269841269841`", ",", 
        "3.455933379597502`", ",", "2.8797202797202797`", ",", 
        "2.9931531531531532`", ",", "2.8797202797202797`", ",", 
        "3.2925011644154636`", ",", "2.340659340659341`", ",", 
        "3.695547184390998`", ",", "2.427536231884058`", ",", 
        "2.793859649122807`", ",", "2.6296296296296298`", ",", 
        "2.9933172948409514`", ",", "3.0610328638497655`", ",", 
        "3.455933379597502`", ",", "2.5015384615384617`", ",", 
        "3.0610328638497655`", ",", "4.082427614990001`", ",", 
        "3.2925011644154636`", ",", "4.082427614990001`", ",", 
        "3.2925011644154636`", ",", "3.343951093951094`", ",", 
        "4.147171767466288`", ",", "3.526529554096094`", ",", 
        "3.059025394646534`", ",", "2.9933172948409514`", ",", 
        "3.455933379597502`", ",", "3.6200071783828127`", ",", 
        "3.451168831168831`", ",", "2.9256038647342995`", ",", 
        "3.6200071783828127`", ",", "3.526529554096094`", ",", 
        "4.082427614990001`", ",", "4.722473255599411`", ",", 
        "3.126007326007326`", ",", "3.410090984284533`", ",", 
        "4.147171767466288`", ",", "3.478705733838283`", ",", 
        "2.8890469416785205`", ",", "3.132237871674491`", ",", 
        "3.455933379597502`", ",", "4.064685314685315`", ",", 
        "3.695547184390998`", ",", "3.467770996803255`", ",", 
        "3.6200071783828127`", ",", "4.096148870105226`", ",", 
        "3.8069738480697386`", ",", "4.722473255599411`", ",", 
        "3.7600320659642694`", ",", "3.8855295429208474`", ",", 
        "4.178479715091887`", ",", "4.178479715091887`", ",", 
        "3.2126315789473683`", ",", "3.6815875220340795`", ",", 
        "3.618500398225054`", ",", "4.064685314685315`", ",", 
        "2.6984126984126986`", ",", "3.8069738480697386`", ",", 
        "4.082427614990001`", ",", "4.082427614990001`", ",", 
        "4.722473255599411`", ",", "4.127762430939226`", ",", 
        "3.899782135076253`", ",", "4.715192068220866`", ",", 
        "3.9410091516200842`", ",", "4.722473255599411`", ",", 
        "4.722473255599411`", ",", "4.722473255599411`", ",", 
        "4.717212408444636`", ",", "4.791229305066745`", ",", 
        "4.7633488715448316`", ",", "3.6968451639684514`", ",", 
        "3.608079046788724`", ",", "4.652119792384364`", ",", 
        "4.76349316345196`", ",", "4.539186165946729`", ",", 
        "4.0378496265948405`", ",", "3.410090984284533`", ",", 
        "3.9906087397944074`", ",", "3.2674100568062276`", ",", 
        "4.147171767466288`", ",", "3.5773279791621446`", ",", 
        "3.8855295429208474`", ",", "4.700915564598169`", ",", 
        "4.178479715091887`", ",", "5.37077879954045`", ",", 
        "3.5130651013003953`", ",", "4.059817729908865`", ",", 
        "3.1406593406593406`", ",", "4.754773713276329`", ",", 
        "4.124822190611664`", ",", "4.7925786214642505`", ",", 
        "4.132978296357749`", ",", "4.749036767410792`", ",", 
        "4.76349316345196`", ",", "4.733146021707175`", ",", 
        "5.316255803979856`", ",", "4.598421568716463`", ",", 
        "2.6296296296296298`", ",", "2.512012012012012`", ",", 
        "2.3190476190476192`", ",", "2.981358529111338`", ",", 
        "2.340659340659341`", ",", "2.8067632850241546`", ",", 
        "2.793859649122807`", ",", "3.467770996803255`", ",", 
        "3.4096762965541245`", ",", "3.2015782639096995`", ",", 
        "3.4096762965541245`", ",", "3.001851166234728`", ",", 
        "3.941055006073226`", ",", "3.2126315789473683`", ",", 
        "3.695547184390998`", ",", "3.6200071783828127`", ",", 
        "3.1195884294311784`", ",", "4.147171767466288`", ",", 
        "3.765520197149898`", ",", "3.8824843260188087`", ",", 
        "4.0413052033605394`", ",", "4.180629463832519`", ",", 
        "2.8890469416785205`", ",", "2.6095238095238096`", ",", 
        "3.695547184390998`", ",", "3.8069738480697386`", ",", 
        "3.6200071783828127`", ",", "4.082427614990001`", ",", 
        "4.147171767466288`", ",", "4.722473255599411`", ",", 
        "3.941055006073226`", ",", "4.722473255599411`", ",", 
        "4.7181981801819814`", ",", "4.79046896672314`", ",", 
        "3.019217570350034`", ",", "3.649869109947644`", ",", 
        "3.5345648447914684`", ",", "3.945077399380805`", ",", 
        "4.147171767466288`", ",", "4.304077604196041`", ",", 
        "4.532409991957231`", ",", "5.37077879954045`", ",", 
        "4.567894034585443`", ",", "4.651423443329225`", ",", 
        "4.107350153352958`", ",", "3.638589232057534`", ",", 
        "4.648600680904859`", ",", "3.410090984284533`", ",", 
        "4.07455268389662`", ",", "4.07824449427865`", ",", 
        "4.722473255599411`", ",", "3.9489064803598426`", ",", 
        "3.941055006073226`", ",", "3.6729930191972078`", ",", 
        "4.147171767466288`", ",", "4.147171767466288`", ",", 
        "3.945077399380805`", ",", "4.7633488715448316`", ",", 
        "4.178479715091887`", ",", "4.0413052033605394`", ",", 
        "4.787875961533741`", ",", "4.567894034585443`", ",", 
        "4.7633488715448316`", ",", "4.791229305066745`", ",", 
        "4.791229305066745`", ",", "5.37077879954045`", ",", 
        "4.749868394932542`", ",", "3.3304347826086955`", ",", 
        "2.6811857229280096`", ",", "4.005670780762514`", ",", 
        "3.4057840262636896`", ",", "3.915316787334141`", ",", 
        "5.3669415952909665`", ",", "4.560078488894502`", ",", 
        "3.8620672283724384`", ",", "4.722555325050331`", ",", 
        "5.321802978098788`", ",", "5.307152942502742`", ",", 
        "4.830000990170134`", ",", "4.858017525136298`", ",", 
        "5.3113668953319575`", ",", "5.216901082212729`", ",", 
        "1.9722222222222223`", ",", "2.853558627752176`", ",", 
        "3.1626262626262625`", ",", "2.8067632850241546`", ",", 
        "2.5760743321718933`", ",", "2.9931531531531532`", ",", 
        "3.1336134453781512`", ",", "3.478705733838283`", ",", 
        "3.941055006073226`", ",", "2.9787779518587096`", ",", 
        "3.4999696436160526`", ",", "3.5869268403686427`", ",", 
        "4.749868394932542`", ",", "3.8949417448138677`", ",", 
        "3.6968451639684514`", ",", "3.206425702811245`", ",", 
        "4.274271011485803`", ",", "2.4420289855072466`", ",", 
        "2.4420289855072466`", ",", "3.4096762965541245`", ",", 
        "3.287578616352201`", ",", "4.144499178981937`", ",", 
        "4.140067772696925`", ",", "3.426005132591959`", ",", 
        "4.059636530865313`", ",", "4.728944421824104`", ",", 
        "4.79046896672314`", ",", "4.757303058494725`", ",", 
        "4.749868394932542`", ",", "4.143568692959583`", ",", 
        "4.059636530865313`", ",", "4.757119088860816`", ",", 
        "3.945077399380805`", ",", "4.757303058494725`", ",", 
        "4.792522282145899`", ",", "3.4316810910044584`", ",", 
        "4.0413052033605394`", ",", "4.173400371970881`", ",", 
        "4.786565466958829`", ",", "4.1976300352684115`", ",", 
        "4.79046896672314`", ",", "3.0606060606060606`", ",", 
        "4.567894034585443`", ",", "3.699699319512581`", ",", 
        "4.567894034585443`", ",", "3.2191746031746034`", ",", 
        "4.111181111300301`", ",", "4.805458914658434`", ",", 
        "5.313387026610861`", ",", "4.090473525600548`", ",", 
        "4.748293733240888`", ",", "6.020661578155731`", ",", 
        "4.242059466134701`", ",", "4.122206936408923`", ",", 
        "4.609641643574537`", ",", "4.6817562260433405`", ",", 
        "3.4598144952545296`", ",", "4.12303722318733`", ",", 
        "5.314398585251822`", ",", "4.835504971986741`", ",", 
        "3.945077399380805`", ",", "2.927330581355349`", ",", 
        "2.4444444444444446`", ",", "3.0111801242236025`", ",", 
        "2.8067632850241546`", ",", "3.3180737673491296`", ",", 
        "3.4096762965541245`", ",", "3.6717786561264822`", ",", 
        "3.941055006073226`", ",", "3.6968451639684514`", ",", 
        "4.059636530865313`", ",", "4.757303058494725`", ",", 
        "3.4648129921259843`", ",", "4.059636530865313`", ",", 
        "4.598892895085505`", ",", "3.7276249630286897`", ",", 
        "4.504512720872188`", ",", "3.4789676815718686`", ",", 
        "3.8746206537761205`", ",", "4.4583457425206445`", ",", 
        "3.690045868419251`", ",", "5.4090808523056175`", ",", 
        "5.307363781251904`", ",", "4.573082935229187`", ",", 
        "4.890304027428306`", ",", "4.249283636521513`", ",", 
        "5.314682551982105`", ",", "5.317998800106556`", ",", 
        "4.838795194072475`", ",", "3.8441250254254524`", ",", 
        "4.417740036771027`", ",", "3.1652186298248113`", ",", 
        "3.0013729977116705`", ",", "3.0061842918985775`", ",", 
        "2.6620689655172414`", ",", "3.605032458525218`", ",", 
        "4.133946681619627`", ",", "3.7236464205935538`", ",", 
        "2.9569798068481123`", ",", "4.246782658951768`", ",", 
        "4.257829759584146`", ",", "3.911979206096853`", ",", 
        "4.518813482804149`", ",", "4.014144666808601`", ",", 
        "4.029292610950348`", ",", "5.30979667706679`", ",", 
        "2.7531645569620253`", ",", "4.611370079446007`", ",", 
        "4.679905598060656`", ",", "4.105933585023619`", ",", 
        "3.494740669558216`", ",", "3.1155523255813953`", ",", 
        "2.847403340196751`", ",", "4.145019308121463`", ",", 
        "3.6437105695272662`", ",", "3.4909639587119785`", ",", 
        "2.033333333333333`", ",", "3.716996653392413`"}], "}"}]}], "}"}]}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Length", " ", "of", " ", "the", " ", "automorphism", " ", "group", " ", 
    "of", " ", "each", " ", "orbit"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"autlenCiloops", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
        "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
        "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", 
        "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
        "0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
        "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", 
        "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
        "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
        "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "2", ",", 
        "0", ",", "0", ",", "2", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
        "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", 
        "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
        "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", 
        "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
        "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
        "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
     "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Length", " ", "of", " ", "the", " ", "automorphism", " ", "group", " ", 
     "of", " ", "each", " ", "orbit"}], ",", " ", 
    RowBox[{
     RowBox[{"with", " ", "self"}], "-", 
     RowBox[{"loops", " ", "removed"}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"autlenCinoloops", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "1", ",", "3", ",", "1", ",", "2", ",", "1", ",", 
        "1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "3", ",", "1", ",", "1", ",", "3", ",", 
        "3", ",", "3", ",", "1", ",", "2", ",", "1", ",", "1", ",", "0", ",", 
        "3", ",", "1", ",", "3", ",", "2", ",", "2", ",", "1", ",", "1", ",", 
        "1", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "3", ",", "1", ",", "3", ",", "1", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "1", ",", "2", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "2", ",", "1", ",", "2", ",", "3", ",", 
        "3", ",", "2", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
        "4", ",", "2", ",", "3", ",", "3", ",", "3", ",", "4", ",", "3", ",", 
        "2", ",", "2", ",", "3", ",", "2", ",", "1", ",", "3", ",", "1", ",", 
        "1", ",", "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "3", ",", 
        "2", ",", "4", ",", "2", ",", "0", ",", "2", ",", "0", ",", "0", ",", 
        "2", ",", "1", ",", "3", ",", "1", ",", "1", ",", "2", ",", "2", ",", 
        "0", ",", "2", ",", "3", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
        "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
        "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "2", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
        "0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "2", ",", "3", ",", "2", ",", "3", ",", "1", ",", 
        "1", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "1", ",", 
        "3", ",", "3", ",", "2", ",", "3", ",", "2", ",", "3", ",", "1", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
        "5", ",", "3", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", 
        "3", ",", "4", ",", "1", ",", "3", ",", "2", ",", "1", ",", "3", ",", 
        "1", ",", "0", ",", "3", ",", "4", ",", "2", ",", "3", ",", "1", ",", 
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", 
        "1", ",", "3", ",", "2", ",", "3", ",", "3", ",", "2", ",", "3", ",", 
        "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", "1", ",", "1", ",", 
        "3", ",", "1", ",", "5", ",", "3", ",", "2", ",", "3", ",", "2", ",", 
        "2", ",", "3", ",", "3", ",", "3", ",", "2", ",", "2", ",", "4", ",", 
        "3", ",", "4", ",", "3", ",", "0", ",", "1", ",", "2", ",", "4", ",", 
        "2", ",", "3", ",", "2", ",", "2", ",", "3", ",", "3", ",", "2", ",", 
        "2", ",", "3", ",", "4", ",", "3", ",", "0", ",", "2", ",", "3", ",", 
        "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", "2", ",", "3", ",", 
        "3", ",", "0", ",", "2", ",", "4", ",", "2", ",", "2", ",", "2", ",", 
        "4", ",", "3", ",", "4", ",", "4", ",", "0", ",", "2", ",", "4", ",", 
        "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "2", ",", "2", ",", 
        "2", ",", "1", ",", "1", ",", "1", ",", "3", ",", "2", ",", "1", ",", 
        "2", ",", "2", ",", "1", ",", "3", ",", "1", ",", "1", ",", "3", ",", 
        "0", ",", "2", ",", "3", ",", "3", ",", "2", ",", "3", ",", "2", ",", 
        "3", ",", "2", ",", "2", ",", "0", ",", "1", ",", "2", ",", "0", ",", 
        "3", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "4", ",", 
        "2", ",", "1", ",", "1", ",", "0", ",", "1", ",", "2", ",", "3", ",", 
        "4", ",", "4", ",", "3", ",", "3", ",", "2", ",", "2", ",", "3", ",", 
        "2", ",", "1", ",", "2", ",", "0", ",", "0", ",", "3", ",", "3", ",", 
        "4", ",", "4", ",", "1", ",", "3", ",", "3", ",", "3", ",", "2", ",", 
        "2", ",", "2", ",", "4", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
        "5", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "2", ",", "0", ",", "1", ",", "3", ",", "1", ",", "0", ",", "1", ",", 
        "2", ",", "4", ",", "0", ",", "2", ",", "1", ",", "2", ",", "0", ",", 
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "0", ",", 
        "0", ",", "0", ",", "3", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
        "0", ",", "1", ",", "3", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "2", ",", "3", ",", "3", ",", "2", ",", "2", ",", "0", ",", "1", ",", 
        "2", ",", "1", ",", "1", ",", "2", ",", "1", ",", "3", ",", "3", ",", 
        "2", ",", "4", ",", "0", ",", "2", ",", "2", ",", "2", ",", "4", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "2", ",", 
        "2", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", "0", ",", 
        "1", ",", "2", ",", "3", ",", "2", ",", "1", ",", "2", ",", "1", ",", 
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "2", ",", 
        "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", "2", ",", 
        "0", ",", "1", ",", "0", ",", "1", ",", "2", ",", "2", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "2", ",", 
        "1", ",", "2", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "2", ",", "1", ",", "1", ",", "2", ",", "1", ",", "1", ",", 
        "1", ",", "2", ",", "1", ",", "2", ",", "0", ",", "1", ",", "2", ",", 
        "2", ",", "1", ",", "0", ",", "2", ",", "1", ",", "1", ",", "2", ",", 
        "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", 
        "1", ",", "1", ",", "2", ",", "1", ",", "2", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "2", ",", "2", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
     "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Is", " ", "the", " ", "orbit", " ", "a", " ", 
    RowBox[{"tree", "?"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"treeCi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False", ",", "False", ",", "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False"}], 
       "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Is", " ", "the", " ", "orbit", " ", 
    RowBox[{"planar", "?"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"planarCi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "True", ",", "True", ",", "False", ",", "True", ",", 
        "False", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "True", ",", "True", ",", "False", ",", "True", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "True", ",", "True", ",", "False", ",", "True", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "True", ",", 
        "True", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "True", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "True", ",", "True", ",", "True", ",", "False", ",", "True", ",", 
        "False", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False"}], 
       "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Is", " ", "the", " ", "orbit", " ", 
     RowBox[{"Eulerian", "?", " ", "Self"}]}], "-", 
    RowBox[{"loops", " ", 
     RowBox[{"removed", "."}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eulerCi", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "False", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"False", ",", "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"False", ",", "True", ",", "False", ",", "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "False", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "False", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "True", ",", "False", ",", "True", ",", "True", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "True", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "False", ",", "True", ",", "True", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "True", ",", 
        "True", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "True", ",", "False", ",", "True", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "True", ",", "False", ",", "True", ",", "False", ",", "True", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "True", ",", "True", ",", "True", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "True", ",", "True", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "False", ",", "True", ",", "False", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "True", ",", "True", ",", "True", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "True", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "True", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "True", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "True", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "True", ",", "True", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "True", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
        "False", ",", "False", ",", "False", ",", "False", ",", "False"}], 
       "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Is", " ", "the", " ", "orbit", " ", 
     RowBox[{"Hamiltonian", "?", " ", "Self"}]}], "-", 
    RowBox[{"loops", " ", 
     RowBox[{"removed", ".", " ", "Computing"}], " ", "for", " ", "8", " ", 
     "and", " ", "9", " ", "qubits", " ", "fails", " ", "in", " ", 
     "Mathematica", " ", "using", " ", 
     RowBox[{"HamiltonianGraphQ", "[", "]"}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hamilCi", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "True", "}"}], ",", 
     RowBox[{"{", "True", "}"}], ",", 
     RowBox[{"{", "False", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True", ",", "True", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "False", ",", "True", ",", "False", ",", "True", ",", "True", ",", 
       "False", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
       "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "False", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
       "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
       "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
       "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
       "False", ",", "True", ",", "True", ",", "False", ",", "True", ",", 
       "False"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.769511573462906*^9, 3.769511618160844*^9}, {
   3.7695119171351995`*^9, 3.769511985797065*^9}, {3.7695121170531893`*^9, 
   3.76951214606709*^9}, {3.7695121824527283`*^9, 3.7695121837738605`*^9}, {
   3.7695123187363553`*^9, 3.7695124797334538`*^9}, {3.769512847316208*^9, 
   3.769512848424319*^9}, {3.7695132111795907`*^9, 3.7695132741098833`*^9}, {
   3.7695135188689833`*^9, 3.7695135382819834`*^9}, {3.77280339792424*^9, 
   3.77280339796726*^9}, {3.77280352114225*^9, 3.772803521770917*^9}, {
   3.772803694477684*^9, 3.7728036969190845`*^9}, {3.772810075050521*^9, 
   3.7728100756802053`*^9}, {3.7728101296780605`*^9, 
   3.7728101623191724`*^9}, {3.7728111097918005`*^9, 3.772811114283656*^9}, {
   3.7728112443308535`*^9, 3.7728112483254805`*^9}, {3.7728112785540266`*^9, 
   3.77281128959324*^9}, {3.7746109966108427`*^9, 3.7746109998187227`*^9}, {
   3.774775299812337*^9, 3.774775351692501*^9}, {3.7747755325280933`*^9, 
   3.7747755989193993`*^9}, {3.774775648184976*^9, 3.77477565185209*^9}, {
   3.7747758889209337`*^9, 3.7747759116344333`*^9}, {3.774775947007846*^9, 
   3.7747759705459146`*^9}, {3.7747760940706453`*^9, 
   3.7747761301515574`*^9}, {3.7747765390168486`*^9, 3.774776575014407*^9}, {
   3.774777006071568*^9, 3.7747770218845406`*^9}, {3.7747776754903355`*^9, 
   3.7747776907251177`*^9}, {3.7747790399354773`*^9, 3.774779040021448*^9}, {
   3.7747804465356774`*^9, 3.774780446748578*^9}, {3.77478097137204*^9, 
   3.774780976709219*^9}, {3.774781025938141*^9, 3.774781030812241*^9}, {
   3.774782066112426*^9, 3.7747820663722606`*^9}, {3.774782772104974*^9, 
   3.7747827886004868`*^9}, {3.774784149835894*^9, 3.7747841759477053`*^9}, {
   3.774787792111045*^9, 3.7747877926807065`*^9}, {3.7747911948020945`*^9, 
   3.7747911951446185`*^9}, {3.774791240714406*^9, 3.7747912457223167`*^9}, {
   3.775471619973275*^9, 3.7754716698090606`*^9}, {3.7754719011817603`*^9, 
   3.7754719054596767`*^9}, {3.7754721365276833`*^9, 3.775472157711197*^9}, {
   3.7754858082650733`*^9, 3.7754858091017866`*^9}, {3.7754881253550043`*^9, 
   3.775488126069579*^9}, 3.775488162313059*^9, {3.7755639446906953`*^9, 
   3.7755639468819947`*^9}, {3.7760898355250216`*^9, 
   3.7760898360801463`*^9}, {3.776149972677431*^9, 3.7761500013748593`*^9}, {
   3.776166216441678*^9, 3.776166254167407*^9}, {3.776583112738394*^9, 
   3.776583130871549*^9}, {3.7765838905510864`*^9, 3.7765838949434595`*^9}, {
   3.776584573440833*^9, 3.776584583583625*^9}, {3.776584624771162*^9, 
   3.776584640265061*^9}, {3.7765862635866857`*^9, 3.7765862757400875`*^9}, {
   3.7765868368143673`*^9, 3.776586840855069*^9}, {3.776587387501298*^9, 
   3.7765873877108088`*^9}, 3.7766046526244946`*^9, {3.777809462599609*^9, 
   3.7778094628464484`*^9}, 3.777891963103365*^9, {3.777896242965534*^9, 
   3.7778962608735666`*^9}, 3.779560037467167*^9, {3.7912009642534113`*^9, 
   3.7912009643950653`*^9}, {3.791868029879113*^9, 3.791868346904903*^9}, {
   3.7918686531922216`*^9, 3.7918687216895823`*^9}, {3.7918688806000347`*^9, 
   3.791868891590238*^9}, {3.791869155263719*^9, 3.7918691568297844`*^9}, {
   3.7918692440109677`*^9, 3.7918693582997828`*^9}, {3.7918694497528677`*^9, 
   3.791869472735721*^9}, {3.7918698441487455`*^9, 3.791869863657216*^9}, {
   3.7918706306863317`*^9, 3.7918706496386614`*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"2d067464-a022-4d79-8071-4fdcf6a0eb05"]
}, Closed]],

Cell[CellGroupData[{

Cell["Import data from \[OpenCurlyQuote].csv\[CloseCurlyQuote] (not \
reccomended)", "Subsection",
 CellChangeTimes->{{3.76951057286777*^9, 3.7695105750707703`*^9}, {
  3.7695117715116386`*^9, 3.769511793808868*^9}, {3.791871020783966*^9, 
  3.7918710233769855`*^9}},ExpressionUUID->"7c8d78ac-71ff-4ac6-a6f0-\
71c70ee256b2"],

Cell[CellGroupData[{

Cell["4 qubit", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
   3.7695105777227707`*^9, 3.7695105863467703`*^9}, 
   3.7695106326967707`*^9},ExpressionUUID->"1c7f1b3a-04e9-47d1-9d98-\
699f343fc1b3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fourCidat", "=", 
   RowBox[{"ToString", "@", 
    RowBox[{"Import", "[", "\"\<4qubitorbitsCi.csv\>\"", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fourCidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fourCidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fourCidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fourCidat", "=", 
    RowBox[{"ToExpression", "@", "fourCidat"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fourCiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"fourCidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"fourCidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"fourCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"fourCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "fourCiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fourCigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"Graph", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Range", "[", "four", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"fourCidat", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"fourCigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"UndirectedGraph", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"fourCigraphlists", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"EdgeStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexStyle", "\[Rule]", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "@", "fourCidat"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"Length", "@", 
       RowBox[{
        RowBox[{"fourCidat", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.7695106394907703`*^9, 3.7695106525707703`*^9}, {3.7695113154967704`*^9, 
   3.76951132742677*^9}, {3.769511410644349*^9, 3.769511410675355*^9}, {
   3.7695115706153364`*^9, 3.769511579968207*^9}, 3.769513046845159*^9, 
   3.769513085808055*^9, {3.7695132462490973`*^9, 3.769513251065579*^9}, {
   3.769513395219993*^9, 3.769513398342305*^9}, {3.7695135027039833`*^9, 
   3.7695135092899837`*^9}, 3.7695136114699836`*^9, {3.7728033907970333`*^9, 
   3.7728033980432205`*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"43a681a6-74ba-4fbd-a7c5-f581334ff521"]
}, Closed]],

Cell[CellGroupData[{

Cell["5 qubit", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
  3.7695105777227707`*^9, 
  3.7695105863467703`*^9}},ExpressionUUID->"b04c62fd-967c-4d87-b281-\
0dbbdcbd00c1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fiveCidat", "=", 
   RowBox[{"ToString", "@", 
    RowBox[{"Import", "[", "\"\<5qubitorbitsCi.csv\>\"", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiveCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fiveCidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiveCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fiveCidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiveCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"fiveCidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fiveCidat", "=", 
    RowBox[{"ToExpression", "@", "fiveCidat"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fiveCiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"fiveCidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"fiveCidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"fiveCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"fiveCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "fiveCiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fiveCigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"Graph", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Range", "[", "five", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"fiveCidat", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"fiveCigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"UndirectedGraph", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"fiveCigraphlists", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"EdgeStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexStyle", "\[Rule]", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "@", "fiveCidat"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"Length", "@", 
       RowBox[{
        RowBox[{"fiveCidat", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.76951067694777*^9, 3.7695106770687704`*^9}, {3.7695113043057704`*^9, 
   3.7695113317337704`*^9}, {3.7695114048681936`*^9, 3.7695114049002*^9}, {
   3.7695115848061743`*^9, 3.769511589590131*^9}, {3.7695133358670588`*^9, 
   3.7695133556600375`*^9}, 3.769513554622984*^9, 3.7695136114829836`*^9, {
   3.7728033908060274`*^9, 3.7728033981031895`*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"e4b71112-6d99-460d-b097-1ac83b22f570"]
}, Closed]],

Cell[CellGroupData[{

Cell["6 qubit", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
  3.7695105777227707`*^9, 
  3.7695106100097704`*^9}},ExpressionUUID->"2e2b421f-cc71-4771-843e-\
9a9def2530db"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sixCidat", "=", 
   RowBox[{"ToString", "@", 
    RowBox[{"Import", "[", "\"\<6qubitorbitsCi.csv\>\"", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sixCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sixCidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sixCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sixCidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sixCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sixCidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sixCidat", "=", 
    RowBox[{"ToExpression", "@", "sixCidat"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sixCiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"sixCidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sixCidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"sixCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"sixCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "sixCiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sixCigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"Graph", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Range", "[", "six", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"sixCidat", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sixCigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"UndirectedGraph", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"sixCigraphlists", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"EdgeStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexStyle", "\[Rule]", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "@", "sixCidat"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"Length", "@", 
       RowBox[{
        RowBox[{"sixCidat", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.7695106631147704`*^9, 3.7695106709087706`*^9}, {3.7695112962817707`*^9, 
   3.7695112962857704`*^9}, {3.7695113365297704`*^9, 
   3.7695113365347705`*^9}, {3.7695113983708944`*^9, 3.769511398403901*^9}, {
   3.7695115915295186`*^9, 3.769511592352683*^9}, 3.7695134003765087`*^9, 
   3.7695135601709833`*^9, 3.7695136114899836`*^9, {3.772803390814006*^9, 
   3.7728033981622305`*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"ac43734c-b85a-407e-8eff-7481bccd98cb"]
}, Closed]],

Cell[CellGroupData[{

Cell["7 qubit", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
  3.7695105777227707`*^9, 
  3.7695106215527706`*^9}},ExpressionUUID->"48965ab4-a6d9-4237-b158-\
be518aa2aada"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sevenCidat", "=", 
   RowBox[{"ToString", "@", 
    RowBox[{"Import", "[", "\"\<7qubitorbitsCi.csv\>\"", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sevenCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sevenCidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sevenCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sevenCidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sevenCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"sevenCidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sevenCidat", "=", 
    RowBox[{"ToExpression", "@", "sevenCidat"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sevenCiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"sevenCidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sevenCidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"sevenCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"sevenCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "sevenCiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sevenCigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"Graph", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Range", "[", "seven", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"sevenCidat", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sevenCigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"UndirectedGraph", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"sevenCigraphlists", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"EdgeStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexStyle", "\[Rule]", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "@", "sevenCidat"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"Length", "@", 
       RowBox[{
        RowBox[{"sevenCidat", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.7695106766087704`*^9, 3.76951069586077*^9}, {3.7695112903317704`*^9, 
   3.76951129033677*^9}, {3.7695113426867704`*^9, 3.7695113426927705`*^9}, {
   3.769511392961813*^9, 3.7695113929998207`*^9}, 3.769511597453703*^9, 
   3.769511629255062*^9, 3.769513403638835*^9, 3.7695135625269833`*^9, 
   3.7695136114989834`*^9, {3.7728033908210225`*^9, 3.772803398223194*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"e2468250-3ee0-4097-8787-2a194d17cc0b"]
}, Closed]],

Cell[CellGroupData[{

Cell["8 qubit (takes a few minutes)", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
  3.7695105777227707`*^9, 3.7695106243137703`*^9}, {3.7695110725937705`*^9, 
  3.76951107502777*^9}},ExpressionUUID->"a9cf0a88-0618-4152-9f80-\
8876ce24a3c6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eightCidat", "=", 
   RowBox[{"Import", "[", "\"\<8qubitorbitsCi.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<Import successfull. Converting to string for processing..\>\"", "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightCidat", "=", 
   RowBox[{"ToString", "@", "eightCidat"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<Success! Processing string..\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"eightCidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"eightCidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"eightCidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eightCidat", "=", 
   RowBox[{"ToExpression", "@", "eightCidat"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<Success! Generating orbits..\>\"", "]"}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"eightCiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"eightCidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"eightCidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"eightCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"eightCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "eightCiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"eightCigraphlists", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "j", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", "eight", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"eightCidat", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "5", "]"}], "]"}], "[", 
          RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"eightCigraphlists", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "j", "]"}], "]"}], "=", 
       RowBox[{"UndirectedGraph", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"eightCigraphlists", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"EdgeStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"VertexStyle", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "eightCidat"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"Length", "@", 
        RowBox[{
         RowBox[{"eightCidat", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<Success! Done.\>\"", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.7695106766637707`*^9, 3.7695107099437704`*^9}, {3.7695112846587706`*^9, 
   3.7695112846627703`*^9}, {3.7695113485547705`*^9, 
   3.7695113704017706`*^9}, {3.7695116028867893`*^9, 3.769511604168046*^9}, {
   3.769512664755954*^9, 3.769512682037682*^9}, {3.769512756739151*^9, 
   3.7695127745529327`*^9}, 3.7695134062709837`*^9, 3.769513566096984*^9, 
   3.7695136115059834`*^9, {3.7728033908290195`*^9, 3.7728033982928467`*^9}, {
   3.7728035518972316`*^9, 3.7728035999121094`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"274d9b41-f22d-4844-8486-a7c26eb60caa"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Import successfull. Converting to string for processing..\"\
\>"], "Print",
 CellChangeTimes->{{3.772803541499118*^9, 3.7728035652762556`*^9}, 
   3.772803600564492*^9, 3.7728036495694747`*^9, 3.7728037086762495`*^9, 
   3.779560058843152*^9, 3.7916276516967754`*^9, 3.7916282823009205`*^9, 
   3.7916284493191757`*^9, 3.791870909999047*^9, 3.791871004272456*^9},
 CellLabel->
  "During evaluation of \
In[143]:=",ExpressionUUID->"0c720882-8c46-4a2b-b8d7-2c3695204ea7"],

Cell[BoxData["\<\"Success! Processing string..\"\>"], "Print",
 CellChangeTimes->{{3.772803541499118*^9, 3.7728035652762556`*^9}, 
   3.772803600564492*^9, 3.7728036495694747`*^9, 3.7728037086762495`*^9, 
   3.779560058843152*^9, 3.7916276516967754`*^9, 3.7916282823009205`*^9, 
   3.7916284493191757`*^9, 3.791870909999047*^9, 3.7918710043193316`*^9},
 CellLabel->
  "During evaluation of \
In[143]:=",ExpressionUUID->"435c1e18-b858-4d12-87f3-b3b32e5ba462"],

Cell[BoxData["\<\"Success! Generating orbits..\"\>"], "Print",
 CellChangeTimes->{{3.772803541499118*^9, 3.7728035652762556`*^9}, 
   3.772803600564492*^9, 3.7728036495694747`*^9, 3.7728037086762495`*^9, 
   3.779560058843152*^9, 3.7916276516967754`*^9, 3.7916282823009205`*^9, 
   3.7916284493191757`*^9, 3.791870909999047*^9, 3.7918710048704386`*^9},
 CellLabel->
  "During evaluation of \
In[143]:=",ExpressionUUID->"637d74db-7c29-497a-9b35-50df24544053"],

Cell[BoxData["\<\"Success! Done.\"\>"], "Print",
 CellChangeTimes->{{3.772803541499118*^9, 3.7728035652762556`*^9}, 
   3.772803600564492*^9, 3.7728036495694747`*^9, 3.7728037086762495`*^9, 
   3.779560058843152*^9, 3.7916276516967754`*^9, 3.7916282823009205`*^9, 
   3.7916284493191757`*^9, 3.791870909999047*^9, 3.7918710087028675`*^9},
 CellLabel->
  "During evaluation of \
In[143]:=",ExpressionUUID->"ae652593-1a66-40e5-804a-cbdad61b7a19"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["9 qubit (takes tens of minutes)", "Subsubsection",
 CellChangeTimes->{{3.769507553794551*^9, 3.769507573207206*^9}, {
  3.7695105777227707`*^9, 3.7695106254177704`*^9}, {3.7695110653637705`*^9, 
  3.7695110699037704`*^9}, {3.7695117565941467`*^9, 
  3.7695117583013177`*^9}},ExpressionUUID->"c42432ab-bba7-45f2-8f9d-\
73c4be21f146"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nineCidat", "=", 
   RowBox[{"Import", "[", "\"\<9qubitorbitsCi.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<Import successfull. Converting to string for processing..\>\"", "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nineCidat", "=", 
   RowBox[{"ToString", "@", "nineCidat"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<Successfull. Processing string..\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nineCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"nineCidat", ",", 
     RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nineCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"nineCidat", ",", 
     RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nineCidat", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"nineCidat", ",", 
     RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[DirectedEdge]\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nineCidat", "=", 
   RowBox[{"ToExpression", "@", "nineCidat"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.791628514996664*^9, 3.7916285318805304`*^9}},
 CellLabel->
  "In[155]:=",ExpressionUUID->"53391037-9d57-4855-9650-69e45cef23ea"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Import successfull. Converting to string for processing..\"\
\>"], "Print",
 CellChangeTimes->{3.791628479824355*^9, 3.7916285443142834`*^9, 
  3.791870910161621*^9, 3.791871011862005*^9},
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"6d40be85-3dcd-47a2-9448-6f00729c89f1"],

Cell[BoxData["\<\"Successfull. Processing string..\"\>"], "Print",
 CellChangeTimes->{3.791628479824355*^9, 3.7916285443142834`*^9, 
  3.791870910161621*^9, 3.791871012789832*^9},
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"6a67ea35-38da-4e2a-a6ab-d0cff3816583"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "\"\<Success! Generating orbits..\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"nineCiorbits", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Graph", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"nineCidat", "\[Transpose]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"nineCidat", "\[Transpose]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"EdgeLabels", "\[Rule]", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"nineCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "->", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"nineCidat", "\[Transpose]"}], "[", 
                RowBox[{"[", "4", "]"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Transpose]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "@", "nineCiorbits"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<Success! Generating graphlist..\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"nineCigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"Graph", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Range", "[", "nine", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"nineCidat", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"nineCigraphlists", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", 
      RowBox[{"UndirectedGraph", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"nineCigraphlists", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "impad"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexSize", "->", "vertexsize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"EdgeStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "edgethickness", "]"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"VertexStyle", "\[Rule]", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"VertexLabels", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "@", "nineCidat"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"Length", "@", 
       RowBox[{
        RowBox[{"nineCidat", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<Success! Done.\>\"", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695075750703917`*^9, 3.769507580783963*^9}, {
   3.769507687123596*^9, 3.7695078155794406`*^9}, {3.76950788028091*^9, 
   3.769508063388219*^9}, {3.7695080967135515`*^9, 3.769508100579938*^9}, {
   3.7695081435942388`*^9, 3.7695081797838573`*^9}, {3.7695082657634544`*^9, 
   3.7695082883717155`*^9}, {3.7695083190777855`*^9, 3.769508546330508*^9}, {
   3.7695085790397787`*^9, 3.7695087252213955`*^9}, {3.769508785391412*^9, 
   3.76950880947482*^9}, {3.769508846917564*^9, 3.769509053058176*^9}, {
   3.7695106767197704`*^9, 3.7695106767657704`*^9}, {3.7695107168647704`*^9, 
   3.76951074342877*^9}, {3.7695109984257703`*^9, 3.7695110105157704`*^9}, {
   3.7695112290267706`*^9, 3.76951127773577*^9}, {3.76951135715777*^9, 
   3.769511380520325*^9}, {3.7695114428107805`*^9, 3.769511464876193*^9}, {
   3.7695116111344385`*^9, 3.7695116119095936`*^9}, {3.7695127834808254`*^9, 
   3.769512789478425*^9}, 3.769513414379984*^9, 3.7695135691409836`*^9, 
   3.7695136114559836`*^9, {3.7728033908370132`*^9, 3.772803398359809*^9}, {
   3.7728036070490704`*^9, 3.772803614736787*^9}, 3.7916282985848722`*^9, {
   3.7916284575232162`*^9, 3.7916284712714157`*^9}, {3.7916285178639927`*^9, 
   3.7916285555262365`*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"139c670b-916e-48b3-be9b-ff0012dc3b7c"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Success! Generating orbits..\"\>"], "Print",
 CellChangeTimes->{3.791627651911208*^9, 3.7916284563782806`*^9, 
  3.791628500775529*^9, 3.791628561845323*^9, 3.7918709102144346`*^9, 
  3.7918710294297876`*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"611d5377-a99c-42d2-b500-3cd2d7defdbe"],

Cell[BoxData["\<\"Success! Generating graphlist..\"\>"], "Print",
 CellChangeTimes->{3.791627651911208*^9, 3.7916284563782806`*^9, 
  3.791628500775529*^9, 3.791628561845323*^9, 3.7918709102144346`*^9, 
  3.7918710347578588`*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"0785315f-a790-4f9a-968b-0b4cc76bf5bf"],

Cell[BoxData["\<\"Success! Done.\"\>"], "Print",
 CellChangeTimes->{3.791627651911208*^9, 3.7916284563782806`*^9, 
  3.791628500775529*^9, 3.791628561845323*^9, 3.7918709102144346`*^9, 
  3.791871137412377*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"330a6543-f2cc-4920-a091-fedca089bbea"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initialise to one variable.", "Subsubsection",
 CellChangeTimes->{{3.7695110857697706`*^9, 3.7695110927517705`*^9}, {
  3.769512876280104*^9, 
  3.7695128813226085`*^9}},ExpressionUUID->"13da6bd3-ef64-4cc8-a970-\
a1054d8e41e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"orbitsCi", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", "fourCiorbits", ",", "fiveCiorbits", ",", 
     "sixCiorbits", ",", "sevenCiorbits", ",", "eightCiorbits", ",", 
     "nineCiorbits"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"orbitsCigraphlist", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "}"}], ",", "fourCigraphlists", ",", "fiveCigraphlists", 
      ",", "sixCigraphlists", ",", "sevenCigraphlists", ",", 
      "eightCigraphlists", ",", "nineCigraphlists"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "fourCidat", ",", "fiveCidat", ",", "sixCidat", ",", "sevenCidat", ",", 
    "eightCidat", ",", "nineCidat", ",", "fourCiorbits", ",", "fiveCiorbits", 
    ",", "sixCiorbits", ",", "sevenCiorbits", ",", "eightCiorbits", ",", 
    "nineCiorbits", ",", "fourCigraphlists", ",", "fiveCigraphlists", ",", 
    "sixCigraphlists", ",", "sevenCigraphlists", ",", "eightCigraphlists", 
    ",", "nineCigraphlists"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7695110936037703`*^9, 3.7695111556797705`*^9}, {
  3.7695112777457705`*^9, 3.7695113571817703`*^9}, {3.7695128711545916`*^9, 
  3.7695129075352297`*^9}, {3.76951295504698*^9, 3.769513009998475*^9}, {
  3.7728033983638067`*^9, 3.7728033984167995`*^9}, {3.7728053822002087`*^9, 
  3.772805390661682*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"3bf8d525-6733-4182-a42a-b30ff639a708"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import data from \[OpenCurlyQuote].mx\[CloseCurlyQuote] (recommended)", \
"Subsection",
 CellChangeTimes->{{3.76951057286777*^9, 3.7695105750707703`*^9}, {
   3.7695117715116386`*^9, 3.769511790617549*^9}, {3.7795600053180113`*^9, 
   3.779560016437023*^9}, 
   3.7918711512712293`*^9},ExpressionUUID->"cf831fb6-486a-401d-9635-\
d78fc63291c0"],

Cell[CellGroupData[{

Cell["Import from Mathematica 11 \[OpenCurlyQuote].mx\[CloseCurlyQuote] file \
(this may take 30s)", "Subsubsection",
 CellChangeTimes->{{3.769344918150916*^9, 3.769344927756877*^9}, {
  3.769507559296651*^9, 3.769507566927578*^9}, {3.7695117973382206`*^9, 
  3.7695118169411807`*^9}, {3.769514047650984*^9, 3.7695140510819836`*^9}, {
  3.7728107610801735`*^9, 
  3.7728107614719567`*^9}},ExpressionUUID->"34330a43-6c9f-429c-9fd4-\
efdd702d4638"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"orbitsCi", "=", 
   RowBox[{"Import", "[", "\"\<orbitsCi.mx\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"orbitsCigraphlist", "=", 
   RowBox[{"Import", "[", "\"\<orbitsCigraphlist.mx\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.769256765636064*^9, 3.769256772072064*^9}, {
   3.7693497328965497`*^9, 3.769349733667627*^9}, {3.769350219507206*^9, 
   3.7693502614714017`*^9}, 3.7693503076260166`*^9, {3.7693503434055943`*^9, 
   3.769350343720626*^9}, {3.7695117023577237`*^9, 3.7695117047699647`*^9}, {
   3.769513233811854*^9, 3.7695132344889216`*^9}, {3.772803398419794*^9, 
   3.772803398426791*^9}, {3.774776159455839*^9, 3.7747761711015186`*^9}, {
   3.7747762204795666`*^9, 3.774776220820383*^9}, {3.7747762770330586`*^9, 
   3.7747762823040953`*^9}, {3.774776596113451*^9, 3.7747766036392026`*^9}, 
   3.7754699924847317`*^9, {3.7765839269532537`*^9, 3.776583969305251*^9}, {
   3.776584321655408*^9, 3.7765843230945997`*^9}, {3.7765848955088077`*^9, 
   3.7765848976906357`*^9}, {3.7765860206314325`*^9, 3.776586020779484*^9}, {
   3.7766056923686433`*^9, 3.776605776555964*^9}, {3.776605856619109*^9, 
   3.776605877811185*^9}, {3.776605916777237*^9, 3.776605921649539*^9}, {
   3.7766071015651093`*^9, 3.776607101755994*^9}, {3.7795599958629103`*^9, 
   3.7795599988560686`*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"b2651e37-3d3c-435f-9719-78b8526ecbab"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions", "Chapter",
 CellChangeTimes->{{3.7692576511326447`*^9, 3.7692576715706882`*^9}, {
   3.7693449316002607`*^9, 3.7693449400271034`*^9}, {3.769345430584459*^9, 
   3.7693454323134584`*^9}, 
   3.7694272047380695`*^9},ExpressionUUID->"a0a930aa-b9ec-4b5e-8d36-\
6eb56e7edf9d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"deleteIsoG1", "[", "gl_List", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"DeleteDuplicates", "[", 
       RowBox[{"gl", ",", "IsomorphicGraphQ"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"colourblender", "[", 
     RowBox[{"one_", ",", "two_"}], "]"}], ":=", 
    RowBox[{"Blend", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"one", ",", "two"}], "}"}], ",", "0.5"}], "]"}]}], ";"}], " ", 
  "\[IndentingNewLine]", "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"plotOrbitCi", "[", 
     RowBox[{"noqub_", ",", "myclass_", ",", 
      RowBox[{"embed_:", " ", "\"\<SpringElectricalEmbedding\>\""}]}], "]"}], 
    ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "oedgelabels", ",", "theselabels", ",", "graphimgs", ",", "imsz", ",", 
        "g1", ",", "graphlabelgraph", ",", "graphlabels", ",", "thisorbit"}], 
       "}"}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{"Sanitise", " ", "graphs", " ", "for", " ", "printing"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"orbitsCigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", "=", 
          RowBox[{"Graph", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"orbitsCigraphlist", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"ImagePadding", "\[Rule]", "0"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Sanitise", " ", "orbit", " ", "edge", " ", "labels", " ", "for", " ",
          "printing"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"theselabels", "=", 
        RowBox[{"Sort", "@", 
         RowBox[{"(", 
          RowBox[{"List", "@@@", 
           RowBox[{"PropertyValue", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"orbitsCi", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], ",", "EdgeLabels"}], 
            "]"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"oedgelabels", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"theselabels", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<=", 
            RowBox[{
             RowBox[{
              RowBox[{"theselabels", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"oedgelabels", " ", ",", 
             RowBox[{"{", " ", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"theselabels", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<->", 
                RowBox[{
                 RowBox[{
                  RowBox[{"theselabels", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"theselabels", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", "theselabels"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"oedgelabels", "=", 
        RowBox[{"Thread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"oedgelabels", "\[Transpose]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "->", 
          RowBox[{
           RowBox[{"oedgelabels", "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "get", " ", "images", " ", "of", " ", "each", " ", "graph", " ", 
         "state", " ", "to", " ", "plot", " ", "on", " ", "the", " ", 
         "vertices", " ", "of", " ", "the", " ", "orbit"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"graphimgs", "=", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", 
          RowBox[{
           RowBox[{"orbitsCigraphlist", "[", 
            RowBox[{"[", "noqub", "]"}], "]"}], "[", 
           RowBox[{"[", "myclass", "]"}], "]"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"imsz", "=", "100"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"graph", " ", "state", " ", "vertices", " ", 
          RowBox[{"labelled", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{"graphsvertexlabelledQ", ",", 
            RowBox[{
             RowBox[{"g1", "=", 
              RowBox[{"Graph", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"orbitsCigraphlist", "[", 
                   RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                  RowBox[{"[", "myclass", "]"}], "]"}], "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{"VertexLabels", "\[Rule]", 
                 RowBox[{"Thread", "[", 
                  RowBox[{
                   RowBox[{"Range", "[", "noqub", "]"}], "\[Rule]", 
                   RowBox[{"Range", "[", "noqub", "]"}]}], "]"}]}], ",", 
                RowBox[{"VertexSize", "\[Rule]", "svsize"}], ",", 
                RowBox[{"EdgeStyle", "\[Rule]", "sesize"}], ",", 
                RowBox[{"VertexLabelStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "vertexlabelfontsize"}], "]"}]}]}], 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"g1", "=", 
              RowBox[{"SetProperty", "[", 
               RowBox[{"g1", ",", 
                RowBox[{"VertexLabels", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"#", "\[Rule]", 
                    RowBox[{"Placed", "[", 
                    RowBox[{"#2", ",", 
                    RowBox[{"{", 
                    RowBox[{"0.59", ",", "0.4"}], "}"}]}], "]"}]}], "&"}], "@@@", 
                   RowBox[{"(", 
                    RowBox[{"VertexLabels", "/.", 
                    RowBox[{"Options", "[", "g1", "]"}]}], ")"}]}], ")"}]}]}],
                "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"g1", "=", 
              RowBox[{"Graph", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"orbitsCigraphlist", "[", 
                   RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                  RowBox[{"[", "myclass", "]"}], "]"}], "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{"VertexSize", "\[Rule]", "svsize"}], ",", 
                RowBox[{"EdgeStyle", "\[Rule]", "sesize"}]}], "]"}]}], 
             ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"graphimgs", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"g1", ",", "\[IndentingNewLine]", 
               RowBox[{"Graphics", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Directive", "[", 
                   RowBox[{"Black", ",", 
                    RowBox[{"Thickness", "[", "gcirclethickness", "]"}]}], 
                   "]"}], ",", 
                  RowBox[{"Circle", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", "gpadding"}], 
                   "]"}]}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", "imsz"}]}], "]"}]}]}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"graphlabelgraph", "=", 
        RowBox[{"Thread", "[", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}], "]"}], "->", 
          "graphimgs"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"compute", " ", "graph", " ", "state", " ", "labels"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"graphslabelledQ", " ", ",", "\[IndentingNewLine]", 
         RowBox[{"graphlabels", "=", " ", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"i", "->", 
             RowBox[{"\"\<G\>\"", "<>", 
              RowBox[{"ToString", "[", "i", "]"}]}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "@", 
               RowBox[{
                RowBox[{"orbitsCigraphlist", "[", 
                 RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"graphlabels", "=", 
           RowBox[{"Thread", "[", 
            RowBox[{
             RowBox[{"Range", "@", 
              RowBox[{"Length", "@", 
               RowBox[{
                RowBox[{"orbitsCigraphlist", "[", 
                 RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                RowBox[{"[", "myclass", "]"}], "]"}]}]}], "\[Rule]", 
             RowBox[{"Table", "[", 
              RowBox[{"None", ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", 
                 RowBox[{"Length", "@", 
                  RowBox[{
                   RowBox[{"orbitsCigraphlist", "[", 
                    RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                   RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}]}],
             "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"orbitedgeslabelledQ", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"thisorbit", "=", 
           RowBox[{"Graph", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"orbitsCi", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], ",", 
             RowBox[{"VertexLabels", "\[Rule]", "graphlabels"}], ",", 
             RowBox[{"EdgeLabels", "\[Rule]", "oedgelabels"}], ",", 
             RowBox[{"VertexShape", "\[Rule]", "graphlabelgraph"}], ",", 
             RowBox[{"VertexSize", "\[Rule]", "lvsize"}], ",", 
             RowBox[{"EdgeStyle", "\[Rule]", "lesize"}], ",", 
             RowBox[{"EdgeLabelStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "edgefontsize"}], "]"}]}], ",", 
             RowBox[{"GraphLayout", "\[Rule]", "embed"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"graphslabelledQ", " ", ",", 
            RowBox[{
             RowBox[{"thisorbit", "=", 
              RowBox[{"SetProperty", "[", 
               RowBox[{"thisorbit", ",", 
                RowBox[{"VertexLabels", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"#", "\[Rule]", 
                    RowBox[{"Placed", "[", 
                    RowBox[{"#2", ",", 
                    RowBox[{"{", 
                    RowBox[{"0.51", ",", "0.29"}], "}"}]}], "]"}]}], "&"}], "@@@", 
                   RowBox[{"(", 
                    RowBox[{"VertexLabels", "/.", 
                    RowBox[{"Options", "[", "thisorbit", "]"}]}], ")"}]}], 
                  ")"}]}]}], "]"}]}], ";"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"thisorbit", "=", 
           RowBox[{"UndirectedGraph", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"orbitsCi", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], ",", 
             RowBox[{"EdgeLabels", "\[Rule]", "None"}], ",", 
             RowBox[{"VertexShape", "\[Rule]", "graphlabelgraph"}], ",", 
             RowBox[{"VertexLabels", "\[Rule]", "graphlabels"}], ",", 
             RowBox[{"VertexSize", "\[Rule]", "lvsize"}], ",", 
             RowBox[{"EdgeStyle", "\[Rule]", "lesize"}], ",", 
             RowBox[{"EdgeLabelStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "edgefontsize"}], "]"}]}], ",", 
             RowBox[{"GraphLayout", "\[Rule]", "embed"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"graphslabelledQ", " ", ",", 
            RowBox[{
             RowBox[{"thisorbit", "=", 
              RowBox[{"SetProperty", "[", 
               RowBox[{"thisorbit", ",", 
                RowBox[{"VertexLabels", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"#", "\[Rule]", 
                    RowBox[{"Placed", "[", 
                    RowBox[{"#2", ",", 
                    RowBox[{"{", 
                    RowBox[{"0.51", ",", "0.29"}], "}"}]}], "]"}]}], "&"}], "@@@", 
                   RowBox[{"(", 
                    RowBox[{"VertexLabels", "/.", 
                    RowBox[{"Options", "[", "thisorbit", "]"}]}], ")"}]}], 
                  ")"}]}]}], "]"}]}], ";"}]}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "thisorbit"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"plotOrbitMatrixCi", "[", 
     RowBox[{"noqub_", ",", "myclass_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "theselabels", ",", "oedgelabels", ",", "goodcolours", ",", "labels", 
        ",", "colourlabel", ",", "mycolours", ",", "isocolours", ",", 
        "isocolours2", ",", "gatheredisocols", ",", "isolens", ",", 
        "isocount", ",", "colourisoadjmat", ",", "LCadj", ",", "isogroups", 
        ",", "isomat", ",", "one", ",", "two", ",", "glo", ",", "glr", ",", 
        "glos", ",", "bticks", ",", "arfaccumisolenssd", ",", "tickas", ",", 
        "gl", ",", "btickstr", ",", "accumisolens", ",", "noedg", ",", 
        "orbitadj", ",", "orbitlegend", ",", "dist", ",", "distp", ",", 
        "distleg"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Sanitise", " ", "graphs", " ", "for", " ", "printing"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"orbitsCigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", "=", 
          RowBox[{"Graph", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"orbitsCigraphlist", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"ImagePadding", "\[Rule]", "0"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Sanitise", " ", "orbit", " ", "edge", " ", "labels", " ", "for", " ",
          "printing"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"theselabels", "=", 
        RowBox[{"Sort", "@", 
         RowBox[{"(", 
          RowBox[{"List", "@@@", 
           RowBox[{"PropertyValue", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"orbitsCi", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}], ",", "EdgeLabels"}], 
            "]"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"oedgelabels", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"theselabels", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<=", 
            RowBox[{
             RowBox[{
              RowBox[{"theselabels", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"oedgelabels", " ", ",", 
             RowBox[{"{", " ", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"theselabels", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<->", 
                RowBox[{
                 RowBox[{
                  RowBox[{"theselabels", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"theselabels", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", "theselabels"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"oedgelabels", "=", 
        RowBox[{"Thread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"oedgelabels", "\[Transpose]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "->", 
          RowBox[{
           RowBox[{"oedgelabels", "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"compute", " ", "colour", " ", "space"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"goodcolours", "=", 
        RowBox[{"ColorData", "[", 
         RowBox[{"97", ",", "\"\<ColorList\>\""}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"labels", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{
          RowBox[{"theselabels", "\[Transpose]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]",
        "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"one", " ", "colour", " ", "per", " ", "LC", " ", "type", " ", 
         RowBox[{"(", 
          RowBox[{"graph", " ", "state", " ", "vertex"}], ")"}]}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"colourlabel", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"labels", "/.", 
           RowBox[{"{", 
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"Range", "[", "15", "]"}], "->", "goodcolours"}], "]"}],
             "}"}]}], ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"colourlabel", "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Sort", "@", 
              RowBox[{"(", 
               RowBox[{"List", "@@@", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"orbitsCi", "[", 
                    RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                   RowBox[{"[", "myclass", "]"}], "]"}], ",", "EdgeLabels"}], 
                 "]"}]}], ")"}]}], "\[Transpose]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "colourlabel"}], "}"}], 
         "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Isomorphic", " ", "region", " ", "colours"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"mycolours", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Hue", "[", 
           RowBox[{
            RowBox[{"i", "/", 
             RowBox[{"Length", "[", 
              RowBox[{
               RowBox[{"orbitsCigraphlist", "[", 
                RowBox[{"[", "noqub", "]"}], "]"}], "[", 
               RowBox[{"[", "myclass", "]"}], "]"}], "]"}]}], ",", "satmod", 
            ",", "brightmod"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "@", 
             RowBox[{
              RowBox[{"orbitsCigraphlist", "[", 
               RowBox[{"[", "noqub", "]"}], "]"}], "[", 
              RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"isocolours", "=", "mycolours"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "Find", " ", "regions", " ", "of", " ", "isomorphic", " ", 
          "graphs"}], ",", " ", 
         RowBox[{"set", " ", "colour", " ", "regions", " ", 
          RowBox[{"to", " ", "'"}], 
          RowBox[{"isocolours", "'"}]}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Do", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"SameQ", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"Length", "@", 
                  RowBox[{"EdgeList", "@", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"orbitsCigraphlist", "[", 
                    RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                    RowBox[{"[", "myclass", "]"}], "]"}], "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], ",", 
                RowBox[{"(", 
                 RowBox[{"Length", "@", 
                  RowBox[{"EdgeList", "@", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"orbitsCigraphlist", "[", 
                    RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                    RowBox[{"[", "myclass", "]"}], "]"}], "[", 
                    RowBox[{"[", "j", "]"}], "]"}]}]}], ")"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"isocolours", "[", 
                 RowBox[{"[", "j", "]"}], "]"}], "=", 
                RowBox[{"mycolours", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ";"}]}], 
             "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", 
              RowBox[{"Length", "@", 
               RowBox[{
                RowBox[{"orbitsCigraphlist", "[", 
                 RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], 
          ";"}], "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "define", " ", "colours", " ", "for", " ", "regions", " ", "of", " ", 
         "isomorphic", " ", "graphs"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"isocolours2", "=", 
        RowBox[{"Outer", "[", 
         RowBox[{"colourblender", ",", "isocolours", ",", "isocolours"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"gatheredisocols", "=", "isocolours2"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"gatheredisocols", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          RowBox[{"Gather", "[", 
           RowBox[{"isocolours2", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"isolens", "=", 
        RowBox[{"Range", "[", 
         RowBox[{"Length", "@", 
          RowBox[{"gatheredisocols", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"isolens", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          RowBox[{"Length", "@", 
           RowBox[{
            RowBox[{"gatheredisocols", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{"gatheredisocols", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"isocount", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{"j", ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", 
             RowBox[{"Length", "@", "isolens"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"isolens", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "regions", " ", "of", " ", "same", " ", "number", " ", "of", " ", 
         RowBox[{"edges", ":", " ", 
          RowBox[{"'", 
           RowBox[{"gatheredisocols", "'"}]}]}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"gatheredisocols", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "j", "]"}], "]"}], "[", 
              RowBox[{"[", "k", "]"}], "]"}], "=", 
             RowBox[{"Blend", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"gatheredisocols", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                   RowBox[{"[", "j", "]"}], "]"}], "[", 
                  RowBox[{"[", "k", "]"}], "]"}], ",", 
                 RowBox[{"Hue", "[", 
                  RowBox[{"0.95", ",", "0.0", ",", "1"}], "]"}]}], "}"}], ",", 
               RowBox[{"1", "*", 
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                   RowBox[{"isocount", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "-", "j"}], "]"}], "/", 
                 RowBox[{"Length", "@", 
                  RowBox[{"gatheredisocols", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}]}]}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", 
              RowBox[{"Length", "@", 
               RowBox[{
                RowBox[{"gatheredisocols", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "j", "]"}], "]"}]}]}], "}"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", "gatheredisocols"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Length", "@", 
            RowBox[{"gatheredisocols", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"gatheredisocols", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{"gatheredisocols", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"varible", " ", "to", " ", 
         RowBox[{"plot", ":", " ", 
          RowBox[{"'", 
           RowBox[{"colourisoadjmat", "'"}]}]}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"colourisoadjmat", "=", 
        RowBox[{
         RowBox[{"AdjacencyMatrix", "[", 
          RowBox[{
           RowBox[{"orbitsCi", "[", 
            RowBox[{"[", "noqub", "]"}], "]"}], "[", 
           RowBox[{"[", "myclass", "]"}], "]"}], "]"}], " ", "//", 
         "Normal"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"colourisoadjmat", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"colourisoadjmat", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"gatheredisocols", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"isogroups", "=", "colourisoadjmat"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"one", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"colourlabel", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"two", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"colourlabel", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{"Head", "@", 
               RowBox[{
                RowBox[{"colourlabel", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[NotEqual]", 
             "\"\<List\>\""}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"colourisoadjmat", "[", 
               RowBox[{"[", "one", "]"}], "]"}], "[", 
              RowBox[{"[", "two", "]"}], "]"}], "=", 
             RowBox[{
              RowBox[{"colourlabel", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"colourisoadjmat", "[", 
               RowBox[{"[", "one", "]"}], "]"}], "[", 
              RowBox[{"[", "two", "]"}], "]"}], "=", 
             RowBox[{
              RowBox[{
               RowBox[{"colourlabel", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}]}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", "colourlabel"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Make", " ", "frame", " ", "ticks"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"glo", "=", 
        RowBox[{"Accumulate", "@", "isolens"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"glr", "=", "glo"}], ";", "\[IndentingNewLine]", 
       RowBox[{"glos", "=", 
        RowBox[{"ToString", "/@", "glo"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"accumisolens", "=", 
        RowBox[{"Accumulate", "[", "isolens", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"bticks", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Accumulate", "@", "isolens"}], " ", "+", 
           RowBox[{"Delete", "[", " ", 
            RowBox[{
             RowBox[{"Flatten", "[", 
              RowBox[{"PrependTo", "[", 
               RowBox[{"accumisolens", ",", "0"}], "]"}], "]"}], ",", 
             RowBox[{"-", "1"}]}], "]"}]}], ")"}], " ", "/", " ", "2"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"noedg", " ", "=", " ", 
        RowBox[{
         RowBox[{"Length", "/@", 
          RowBox[{"EdgeList", "/@", 
           RowBox[{
            RowBox[{"orbitsCigraphlist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}]}]}], "//", 
         "DeleteDuplicates"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"btickstr", "=", 
        RowBox[{"ToString", "/@", "noedg"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"bticks", "[", 
               RowBox[{"[", 
                RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", 
              RowBox[{"bticks", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "<", 
            "tickthresedge"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"btickstr", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "=", "\"\<\>\""}]}], 
          "\[IndentingNewLine]", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{
            RowBox[{"Length", "@", "bticks"}], "-", "1"}]}], "}"}]}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"glo", "[", 
               RowBox[{"[", 
                RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", 
              RowBox[{"glo", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "<", "tickthresno"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"glos", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "=", "\"\<\>\""}]}], 
          "\[IndentingNewLine]", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{
            RowBox[{"Length", "@", "glo"}], "-", "1"}]}], "}"}]}], "]"}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"tickas", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"glo", "+", 
              RowBox[{"1", "/", "2"}]}], ",", "glos"}], "}"}], 
           "\[Transpose]"}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"bticks", "+", 
              RowBox[{"1", "/", "2"}]}], ",", "btickstr"}], "}"}], 
           "\[Transpose]"}], ",", "None", ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"glo", "+", 
              RowBox[{"1", "/", "2"}]}], ",", "glos"}], "}"}], 
           "\[Transpose]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"gl", "=", 
        RowBox[{"{", 
         RowBox[{"glr", ",", 
          RowBox[{
           RowBox[{"Length", "@", 
            RowBox[{
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "noqub", "]"}], "]"}], "[", 
             RowBox[{"[", "myclass", "]"}], "]"}]}], "-", "glr"}]}], "}"}]}], 
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"orbitadj", "=", 
        RowBox[{"ArrayPlot", "[", 
         RowBox[{"colourisoadjmat", ",", "\[IndentingNewLine]", 
          RowBox[{"MaxPlotPoints", "\[Rule]", 
           RowBox[{
            RowBox[{"Length", "@", 
             RowBox[{"AdjacencyMatrix", "[", 
              RowBox[{
               RowBox[{"orbitsCi", "[", 
                RowBox[{"[", "noqub", "]"}], "]"}], "[", 
               RowBox[{"[", "myclass", "]"}], "]"}], "]"}]}], "^", "2"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"FrameStyle", "\[Rule]", 
           RowBox[{"AbsoluteThickness", "[", "myframethickness", "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"PlotRangePadding", "\[Rule]", "0"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<Graph index\>\"", ",", "\"\<No.  Edges in graph\>\"", ",", 
             "\"\<\>\"", ",", "\"\<Graph index\>\""}], "}"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Black", ",", 
             RowBox[{"FontFamily", "\[Rule]", " ", "\"\<Helvetica\>\""}], ",",
              " ", 
             RowBox[{"FontSize", "\[Rule]", " ", "myfontsize"}]}], "}"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"FrameTicks", "\[Rule]", "tickas"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"GridLines", "\[Rule]", "gl"}], ",", "\[IndentingNewLine]", 
          RowBox[{"FrameTicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"Opacity", "[", "0", "]"}], ",", 
             RowBox[{"FontOpacity", "\[Rule]", "1"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Method", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GridLinesInFront\>\"", "\[Rule]", "True"}], "}"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
          RowBox[{"ImagePadding", "\[Rule]", "40"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", 
             RowBox[{"AbsoluteThickness", "[", 
              RowBox[{"myframethickness", "/", "3"}], "]"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ImageSize", "\[Rule]", "graphsize"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"orbitlegend", "=", 
        RowBox[{"TableForm", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Range", "[", "noqub", "]"}], ",", 
            RowBox[{"goodcolours", "[", 
             RowBox[{"[", 
              RowBox[{"1", ";;", "noqub"}], "]"}], "]"}]}], "}"}], 
          "\[Transpose]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"dist", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "9"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"Length", "/@", 
             RowBox[{"orbitsCigraphlist", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"dist", "[", 
          RowBox[{"[", "noqub", "]"}], "]"}], "[", 
         RowBox[{"[", "myclass", "]"}], "]"}], "=", 
        RowBox[{"GraphDistanceMatrix", "[", 
         RowBox[{
          RowBox[{"orbitsCi", "[", 
           RowBox[{"[", "noqub", "]"}], "]"}], "[", 
          RowBox[{"[", "myclass", "]"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"distp", "=", 
        RowBox[{"MatrixPlot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"dist", "[", 
            RowBox[{"[", "noqub", "]"}], "]"}], "[", 
           RowBox[{"[", "myclass", "]"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"MaxPlotPoints", "\[Rule]", 
           RowBox[{
            RowBox[{"Length", "@", 
             RowBox[{"AdjacencyMatrix", "[", 
              RowBox[{
               RowBox[{"orbitsCi", "[", 
                RowBox[{"[", "noqub", "]"}], "]"}], "[", 
               RowBox[{"[", "myclass", "]"}], "]"}], "]"}]}], "^", "2"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"FrameStyle", "\[Rule]", 
           RowBox[{"AbsoluteThickness", "[", "myframethickness", "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"PlotRangePadding", "\[Rule]", "0"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<Graph index\>\"", ",", "\"\<No.  Edges in graph\>\"", ",", 
             "\"\<\>\"", ",", "\"\<Graph index\>\""}], "}"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Black", ",", 
             RowBox[{"FontFamily", "\[Rule]", " ", "\"\<Helvetica\>\""}], ",",
              " ", 
             RowBox[{"FontSize", "\[Rule]", " ", "myfontsize"}]}], "}"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"FrameTicks", "\[Rule]", "tickas"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"GridLines", "\[Rule]", "gl"}], ",", "\[IndentingNewLine]", 
          RowBox[{"FrameTicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"Opacity", "[", "0", "]"}], ",", 
             RowBox[{"FontOpacity", "\[Rule]", "1"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Method", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GridLinesInFront\>\"", "\[Rule]", "True"}], "}"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", 
             RowBox[{"AbsoluteThickness", "[", 
              RowBox[{"myframethickness", "/", "3"}], "]"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ImageSize", "\[Rule]", "graphsize"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ImagePadding", "\[Rule]", "40"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ColorFunction", "\[Rule]", "\"\<SolarColors\>\""}]}], 
         "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"distleg", "=", 
        RowBox[{"BarLegend", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<SolarColors\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"1", "+", 
               RowBox[{"Max", "@", 
                RowBox[{
                 RowBox[{"dist", "[", 
                  RowBox[{"[", "noqub", "]"}], "]"}], "[", 
                 RowBox[{"[", "myclass", "]"}], "]"}]}]}]}], "}"}]}], "}"}], 
          ",", 
          RowBox[{"Max", "@", 
           RowBox[{
            RowBox[{"dist", "[", 
             RowBox[{"[", "noqub", "]"}], "]"}], "[", 
            RowBox[{"[", "myclass", "]"}], "]"}]}], ",", 
          RowBox[{"Method", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"TicksStyle", "\[Rule]", "Black"}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Black", ",", 
                RowBox[{"FontFamily", "\[Rule]", " ", "\"\<Helvetica\>\""}], 
                ",", " ", 
                RowBox[{"FontSize", "\[Rule]", " ", "myfontsize"}]}], 
               "}"}]}]}], "}"}]}]}], " ", "]"}]}], ";", "\[IndentingNewLine]",
        "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
        "orbitadj", ",", "orbitlegend", ",", "distp", ",", "distleg"}], 
        "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7518139241681814`*^9, 3.751813926810446*^9}, {
   3.7518141480515676`*^9, 3.7518141544302053`*^9}, 3.7519136204239264`*^9, {
   3.769257669669498*^9, 3.769257671101641*^9}, {3.7692636540962934`*^9, 
   3.7692636546043444`*^9}, {3.7693449350446053`*^9, 3.769344935509652*^9}, {
   3.769345140050104*^9, 3.769345152261325*^9}, {3.769345441949459*^9, 
   3.769345453196459*^9}, {3.769345763904459*^9, 3.7693457651254587`*^9}, {
   3.7694257896002727`*^9, 3.7694257976352725`*^9}, {3.769426155632265*^9, 
   3.769426156570359*^9}, {3.7694262426219635`*^9, 3.76942626319102*^9}, {
   3.7694263288445845`*^9, 3.7694263421119113`*^9}, {3.7694266039550934`*^9, 
   3.7694266107297707`*^9}, {3.7694267260192986`*^9, 3.769426752586955*^9}, 
   3.769427156251317*^9, {3.7695023444962025`*^9, 3.769502344922203*^9}, {
   3.769502415156203*^9, 3.769502423832203*^9}, {3.769502517409666*^9, 
   3.7695025626401887`*^9}, {3.769502692577181*^9, 3.7695027737662992`*^9}, {
   3.769502812346157*^9, 3.769502861761098*^9}, {3.7728033909119697`*^9, 
   3.772803399064406*^9}, {3.77280366439435*^9, 3.7728036645742474`*^9}, {
   3.7728037676809063`*^9, 3.7728037678593807`*^9}, {3.7728038583803763`*^9, 
   3.7728038585015383`*^9}, {3.7728039032712708`*^9, 
   3.7728039110159993`*^9}, {3.7783369992946215`*^9, 
   3.7783370035311637`*^9}, {3.7784144814181128`*^9, 3.778414482623933*^9}, {
   3.778414519956422*^9, 3.778414520982768*^9}, {3.778414592778706*^9, 
   3.778414637904163*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"22bda154-9acb-4934-b086-f16c8f96ee23"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Print unlabelled graph state orbits, ", "Title"],
 StyleBox[Cell[BoxData[
  SubscriptBox["C", "i"]], "Title",
  CellChangeTimes->{{3.7692578793134604`*^9, 3.7692579112106495`*^9}},
  ExpressionUUID->"c18dc7f5-c4d1-4a02-892f-9c7a9807b963"], "Title"]
}], "Title",
 CellChangeTimes->{{3.769262602666811*^9, 3.7692626209928107`*^9}, {
  3.779560242358234*^9, 
  3.7795602425071487`*^9}},ExpressionUUID->"2dad5fb9-fdca-4385-b630-\
529c3cc150d7"],

Cell[CellGroupData[{

Cell["Plot settings", "Subsubsection",
 CellChangeTimes->{{3.7692576206245937`*^9, 3.7692576295634875`*^9}, 
   3.7692581233382225`*^9, {3.7694258179552727`*^9, 
   3.7694258191622725`*^9}},ExpressionUUID->"2235ba26-cf26-44c6-8f71-\
2bbcf7ddbca8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sesize", " ", "=", " ", 
    RowBox[{"Thickness", "[", "0.004", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"graph", " ", "state", " ", "edge", " ", "size"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lesize", " ", "=", 
    RowBox[{"Thickness", "[", "0.004", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"orbit", " ", "edge", " ", "size"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"svsize", "=", "0.4"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"graph", " ", "state", " ", "vertex", " ", "size"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lvsize", "=", "0.6"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"orbit", " ", "vertex", " ", "size"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gcirclethickness", "=", "0.02"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
   "thickness", " ", "of", " ", "orbit", " ", "vertex", " ", 
    "circumference"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gpadding", "=", "1.6"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"padding", " ", "of", " ", "graph", " ", "states"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"edgefontsize", "=", "12"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"orbit", " ", "edge", " ", "font", " ", "size"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vertexlabelfontsize", "=", "8"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"graph", " ", "state", " ", "vertex", " ", "font", " ", "size"}], 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Label", " ", "edge", " ", "vertices", " ", "when", " ", "printing", " ", 
    "orbit", " ", "as", " ", "a", " ", 
    RowBox[{"graph", "?"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"orbitedgeslabelledQ", "=", "False"}], ";"}], 
  "   "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"graphslabelledQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"graphsvertexlabelledQ", "=", "False"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7518817553567533`*^9, 3.7518818283300505`*^9}, {
   3.751892222463233*^9, 3.7518922334383307`*^9}, {3.751893127474725*^9, 
   3.7518931295069284`*^9}, {3.7518970161875906`*^9, 3.751897040113983*^9}, {
   3.751897106472618*^9, 3.7518971241003804`*^9}, {3.751897823248288*^9, 
   3.7518978397159348`*^9}, {3.751898130165977*^9, 3.7518982181857777`*^9}, {
   3.7518982484047995`*^9, 3.751898287452704*^9}, {3.75189837302226*^9, 
   3.751898381028061*^9}, {3.7518986729072456`*^9, 3.751898701290084*^9}, {
   3.7518987444333973`*^9, 3.7518987473496895`*^9}, {3.7518988329762506`*^9, 
   3.7518988776837215`*^9}, {3.751899506073554*^9, 3.751899508321779*^9}, {
   3.751900471877125*^9, 3.751900577486685*^9}, {3.7519006389208274`*^9, 
   3.7519006701139464`*^9}, {3.751900728634798*^9, 3.751900786186552*^9}, {
   3.7519008698359165`*^9, 3.751900875627496*^9}, {3.751901262168146*^9, 
   3.751901262839213*^9}, {3.751901434157343*^9, 3.751901434863414*^9}, 
   3.751913112013926*^9, {3.751962340658823*^9, 3.7519623584055977`*^9}, {
   3.752269190624819*^9, 3.7522691921129675`*^9}, {3.7522748657866793`*^9, 
   3.7522748725276794`*^9}, {3.7522751308986797`*^9, 
   3.7522751310316796`*^9}, {3.7522755140452414`*^9, 3.752275538548935*^9}, {
   3.7530412649571233`*^9, 3.7530413192601233`*^9}, {3.7692571132386637`*^9, 
   3.7692571233346825`*^9}, {3.769257250054022*^9, 3.769257276512312*^9}, 
   3.7692574590614395`*^9, {3.7692576143909707`*^9, 3.7692576148210135`*^9}, {
   3.769262836661811*^9, 3.769262836805811*^9}, {3.7692628719008107`*^9, 
   3.769262882293811*^9}, {3.769262977865811*^9, 3.769262991489811*^9}, {
   3.769263063827811*^9, 3.7692630641568108`*^9}, {3.769263265534441*^9, 
   3.7692632662065086`*^9}, {3.769263365407428*^9, 3.769263370313918*^9}, {
   3.7692639860194826`*^9, 3.769263989300811*^9}, {3.769264143415806*^9, 
   3.7692641511678057`*^9}, {3.7692645564788055`*^9, 3.769264562381806*^9}, {
   3.7692646080428057`*^9, 3.7692646145618057`*^9}, {3.769340055930523*^9, 
   3.7693400628372135`*^9}, {3.7693401686607943`*^9, 
   3.7693402035862865`*^9}, {3.76934055645757*^9, 3.769340587810705*^9}, {
   3.769341802460848*^9, 3.769341802696848*^9}, {3.769341986316848*^9, 
   3.769341991007848*^9}, {3.769342034473848*^9, 3.7693420345708475`*^9}, {
   3.769344875333635*^9, 3.7693448845345545`*^9}, {3.769420691861929*^9, 
   3.76942069907365*^9}, {3.7694213092154517`*^9, 3.7694213140313773`*^9}, {
   3.7694217813068438`*^9, 3.769421809542667*^9}, {3.769423320175235*^9, 
   3.7694233231329393`*^9}, {3.7694234262124786`*^9, 3.769423518944479*^9}, {
   3.769424268229525*^9, 3.7694242721109133`*^9}, {3.7694244569923997`*^9, 
   3.76942445719742*^9}, {3.7694258215932727`*^9, 3.7694258218112726`*^9}, {
   3.7694993599230347`*^9, 3.7694993948924217`*^9}, {3.769502281059203*^9, 
   3.7695022819872026`*^9}, {3.7695024321212025`*^9, 3.769502432580203*^9}, {
   3.769513310189491*^9, 3.7695133284773197`*^9}, {3.7695134450079837`*^9, 
   3.7695134451539836`*^9}, {3.769513628834984*^9, 3.7695137022069836`*^9}, {
   3.7728041152510576`*^9, 3.7728042272019653`*^9}, {3.774690689589924*^9, 
   3.7746907225148277`*^9}, {3.77556434060365*^9, 3.7755643411488905`*^9}, {
   3.776174740555686*^9, 3.776174752922261*^9}, {3.776596022897892*^9, 
   3.7765960230158033`*^9}, {3.7766068647983713`*^9, 3.776606871244275*^9}, {
   3.77833615921576*^9, 3.778336159724462*^9}, {3.77833770386343*^9, 
   3.7783377043390846`*^9}, {3.778414560492807*^9, 3.778414578555749*^9}},
 CellLabel->
  "In[195]:=",ExpressionUUID->"fd59f28c-5282-49e9-bafb-8236bc9e8cd4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pick and display a graph state orbit", "Subsubsection",
 CellChangeTimes->{{3.7693448781889205`*^9, 
  3.7693448979448957`*^9}},ExpressionUUID->"d781aa6f-1c36-4106-8c8a-\
ca1efb5a4d5f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"noqub", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myclass", "=", "6"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<First graph in orbit is: \>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"orbitsCigraphlist", "[", 
      RowBox[{"[", "noqub", "]"}], "]"}], "[", 
     RowBox[{"[", "myclass", "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Number of graphs in Orbit is: \>\"", ",", 
   RowBox[{"Length", "@", 
    RowBox[{
     RowBox[{"orbitsCigraphlist", "[", 
      RowBox[{"[", "noqub", "]"}], "]"}], "[", 
     RowBox[{"[", "myclass", "]"}], "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Adjacency matrix of orbit is: \>\"", ",", 
    RowBox[{"MatrixPlot", "@", 
     RowBox[{"AdjacencyMatrix", "@", 
      RowBox[{
       RowBox[{"orbitsCi", "[", 
        RowBox[{"[", "noqub", "]"}], "]"}], "[", 
       RowBox[{"[", "myclass", "]"}], "]"}]}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"plotOrbitCi", "[", 
  RowBox[{"noqub", ",", "myclass", ",", "\"\<SpringElectricalEmbedding\>\""}],
   "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.7693448862807293`*^9, {3.7693453414084587`*^9, 3.7693453924954586`*^9}, {
   3.7693458216814585`*^9, 3.769345841986459*^9}, {3.769348916495268*^9, 
   3.7693489202322683`*^9}, {3.7693490986468897`*^9, 
   3.7693490990790195`*^9}, {3.7693494136560006`*^9, 3.769349413832036*^9}, {
   3.7693502195182066`*^9, 3.7693502489671516`*^9}, {3.7694205935811014`*^9, 
   3.7694205936201057`*^9}, {3.7694206806948123`*^9, 
   3.7694206808198247`*^9}, {3.7694213019015274`*^9, 
   3.7694213020545883`*^9}, {3.7694216611648307`*^9, 
   3.7694216717158856`*^9}, {3.7694235105094786`*^9, 3.769423510635479*^9}, {
   3.769423549807479*^9, 3.7694235671124787`*^9}, {3.769423606189479*^9, 
   3.769423616628479*^9}, {3.7694238758532915`*^9, 3.769423876326339*^9}, {
   3.7694239495096564`*^9, 3.7694239599957047`*^9}, {3.769424162594963*^9, 
   3.7694241722219253`*^9}, {3.7694242032050233`*^9, 
   3.7694242034640493`*^9}, {3.7694244723939395`*^9, 
   3.7694244813618364`*^9}, {3.7694247257782755`*^9, 
   3.7694247265803556`*^9}, {3.769425771788273*^9, 3.769425777802273*^9}, {
   3.7694258206382723`*^9, 3.7694258243632727`*^9}, {3.769426347279428*^9, 
   3.7694263476514654`*^9}, {3.769426770128709*^9, 3.769426770299726*^9}, {
   3.7694991936567883`*^9, 3.769499201477352*^9}, {3.769499347799611*^9, 
   3.769499352582567*^9}, {3.769499447266659*^9, 3.7694994814800797`*^9}, {
   3.7694996043273635`*^9, 3.7694996190128317`*^9}, {3.7694996634012704`*^9, 
   3.7694996757315035`*^9}, {3.7694998936752954`*^9, 3.76949989402133*^9}, {
   3.769502190766203*^9, 3.7695021921642027`*^9}, 3.7695132991083827`*^9, {
   3.7695134513999834`*^9, 3.7695134554089837`*^9}, {3.772803399067404*^9, 
   3.772803399076399*^9}, {3.7728040999950676`*^9, 3.7728041001429625`*^9}, {
   3.772804136552538*^9, 3.772804136972275*^9}, 3.774690681252839*^9, {
   3.7755643293523397`*^9, 3.7755643315198536`*^9}, {3.776174683295024*^9, 
   3.776174697467429*^9}, {3.7761747351685176`*^9, 3.7761747353144293`*^9}, {
   3.7765960164209986`*^9, 3.776596016512943*^9}, {3.776606854760519*^9, 
   3.7766068832227726`*^9}, {3.776607036407575*^9, 3.7766070365874715`*^9}, {
   3.7766855775142*^9, 3.77668557761712*^9}, 3.778336152586371*^9, {
   3.7784146152133985`*^9, 3.7784147803065844`*^9}, {3.7784148215887723`*^9, 
   3.7784148698323107`*^9}},
 CellLabel->
  "In[206]:=",ExpressionUUID->"438ab07c-3f1e-4695-ad9a-cf93a5eb67c2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"First graph in orbit is: \"\>", "\[InvisibleSpace]", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6}, {
        Null, {{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}}, {
        GraphLayout -> {
          "Dimension" -> 2, "VertexLayout" -> "CircularEmbedding"}, 
         ImagePadding -> 0, ImageSize -> 120, VertexSize -> {0.2}}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{-0.8660254037844389, 
         0.5000000000000008}, {-0.8660254037844384, -0.49999999999999933`}, {
         3.8285686989269494`*^-16, -1.}, {
         0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
         0.4999999999999993}, {1.8369701987210297`*^-16, 1.}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.09999999999999994], DiskBox[2, 0.09999999999999994], 
           DiskBox[3, 0.09999999999999994], DiskBox[4, 0.09999999999999994], 
           DiskBox[5, 0.09999999999999994], 
           DiskBox[6, 0.09999999999999994]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->0,
    ImageSize->120]}],
  SequenceForm["First graph in orbit is: ", 
   Graph[{1, 2, 3, 4, 5, 6}, {
    Null, {{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}}, {
    GraphLayout -> {"Dimension" -> 2, "VertexLayout" -> "CircularEmbedding"}, 
     ImagePadding -> 0, ImageSize -> 120, VertexSize -> {0.2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.769345830236459*^9, 3.7693458423754587`*^9}, 
   3.769349008322801*^9, 3.7693490994991455`*^9, 3.769349393616994*^9, 
   3.769349784618721*^9, 3.769350283365591*^9, 3.7693503262448783`*^9, 
   3.7693503910833616`*^9, {3.7694205790266466`*^9, 3.7694205939601393`*^9}, 
   3.769420681279871*^9, 3.769421302313692*^9, 3.769421572379201*^9, {
   3.769421645350793*^9, 3.7694216720639205`*^9}, 3.7694218714838605`*^9, 
   3.769421929526664*^9, 3.7694233240988426`*^9, 3.7694234294054785`*^9, {
   3.769423472991479*^9, 3.769423520024479*^9}, {3.7694236072574787`*^9, 
   3.769423616861479*^9}, 3.7694236652774787`*^9, 3.7694238119329*^9, {
   3.7694238590016065`*^9, 3.769423876761382*^9}, {3.769423950535759*^9, 
   3.7694239603037357`*^9}, {3.769424201410844*^9, 3.7694242037770805`*^9}, 
   3.769424273246027*^9, 3.769424358214523*^9, {3.7694244585365543`*^9, 
   3.7694244815758576`*^9}, 3.769424726893387*^9, {3.7694257781202726`*^9, 
   3.769425800413273*^9}, 3.7694262031470165`*^9, {3.769426759272623*^9, 
   3.7694267708317795`*^9}, 3.769427269052069*^9, 3.769435495256836*^9, {
   3.769499235328121*^9, 3.7694992411862926`*^9}, {3.769499349856022*^9, 
   3.7694993980057335`*^9}, {3.7694994476096935`*^9, 3.7694994816770997`*^9}, 
   3.76949951837877*^9, {3.7694996053264637`*^9, 3.769499619564887*^9}, {
   3.769499664347365*^9, 3.7694996761085405`*^9}, 3.769499894211349*^9, {
   3.769502231260203*^9, 3.769502241172203*^9}, 3.769502283360203*^9, {
   3.769502428709203*^9, 3.769502433853203*^9}, 3.769502574074332*^9, 
   3.769502779499872*^9, 3.769502866672589*^9, {3.7695132877742496`*^9, 
   3.7695133206655383`*^9}, {3.7695134371459837`*^9, 3.769513455714984*^9}, {
   3.7695135785979834`*^9, 3.7695135837339835`*^9}, {3.7695136230029836`*^9, 
   3.769513703565984*^9}, 3.7728037285973234`*^9, {3.7728037847507443`*^9, 
   3.7728038118810496`*^9}, 3.7728038838695574`*^9, 3.772803915844962*^9, {
   3.772804100387848*^9, 3.772804144564432*^9}, 3.774260283274734*^9, {
   3.7746906831037254`*^9, 3.7746907236088734`*^9}, {3.7755643320505543`*^9, 
   3.7755643428346806`*^9}, {3.776174685561227*^9, 3.7761746980549393`*^9}, {
   3.7761747355753527`*^9, 3.7761747579902515`*^9}, {3.7765960168757334`*^9, 
   3.7765960240850177`*^9}, {3.7766068563663626`*^9, 3.776606883407667*^9}, 
   3.776607036819338*^9, 3.776685577915942*^9, {3.7783361528223543`*^9, 
   3.7783361609896545`*^9}, 3.778337008266876*^9, 3.7783377056184273`*^9, {
   3.778414553940363*^9, 3.7784145827669296`*^9}, {3.778414617805806*^9, 
   3.778414780642683*^9}, {3.7784148218292284`*^9, 3.7784148704389377`*^9}, 
   3.779560074687081*^9, 3.791627653270563*^9, 3.7916287050139203`*^9, 
   3.791870910737112*^9, {3.7918711794152703`*^9, 3.7918711895143776`*^9}},
 CellLabel->
  "During evaluation of \
In[206]:=",ExpressionUUID->"86de566f-9beb-40a8-8c44-b9da969c838c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Number of graphs in Orbit is: \"\>", "\[InvisibleSpace]", 
   "25"}],
  SequenceForm["Number of graphs in Orbit is: ", 25],
  Editable->False]], "Print",
 CellChangeTimes->{{3.769345830236459*^9, 3.7693458423754587`*^9}, 
   3.769349008322801*^9, 3.7693490994991455`*^9, 3.769349393616994*^9, 
   3.769349784618721*^9, 3.769350283365591*^9, 3.7693503262448783`*^9, 
   3.7693503910833616`*^9, {3.7694205790266466`*^9, 3.7694205939601393`*^9}, 
   3.769420681279871*^9, 3.769421302313692*^9, 3.769421572379201*^9, {
   3.769421645350793*^9, 3.7694216720639205`*^9}, 3.7694218714838605`*^9, 
   3.769421929526664*^9, 3.7694233240988426`*^9, 3.7694234294054785`*^9, {
   3.769423472991479*^9, 3.769423520024479*^9}, {3.7694236072574787`*^9, 
   3.769423616861479*^9}, 3.7694236652774787`*^9, 3.7694238119329*^9, {
   3.7694238590016065`*^9, 3.769423876761382*^9}, {3.769423950535759*^9, 
   3.7694239603037357`*^9}, {3.769424201410844*^9, 3.7694242037770805`*^9}, 
   3.769424273246027*^9, 3.769424358214523*^9, {3.7694244585365543`*^9, 
   3.7694244815758576`*^9}, 3.769424726893387*^9, {3.7694257781202726`*^9, 
   3.769425800413273*^9}, 3.7694262031470165`*^9, {3.769426759272623*^9, 
   3.7694267708317795`*^9}, 3.769427269052069*^9, 3.769435495256836*^9, {
   3.769499235328121*^9, 3.7694992411862926`*^9}, {3.769499349856022*^9, 
   3.7694993980057335`*^9}, {3.7694994476096935`*^9, 3.7694994816770997`*^9}, 
   3.76949951837877*^9, {3.7694996053264637`*^9, 3.769499619564887*^9}, {
   3.769499664347365*^9, 3.7694996761085405`*^9}, 3.769499894211349*^9, {
   3.769502231260203*^9, 3.769502241172203*^9}, 3.769502283360203*^9, {
   3.769502428709203*^9, 3.769502433853203*^9}, 3.769502574074332*^9, 
   3.769502779499872*^9, 3.769502866672589*^9, {3.7695132877742496`*^9, 
   3.7695133206655383`*^9}, {3.7695134371459837`*^9, 3.769513455714984*^9}, {
   3.7695135785979834`*^9, 3.7695135837339835`*^9}, {3.7695136230029836`*^9, 
   3.769513703565984*^9}, 3.7728037285973234`*^9, {3.7728037847507443`*^9, 
   3.7728038118810496`*^9}, 3.7728038838695574`*^9, 3.772803915844962*^9, {
   3.772804100387848*^9, 3.772804144564432*^9}, 3.774260283274734*^9, {
   3.7746906831037254`*^9, 3.7746907236088734`*^9}, {3.7755643320505543`*^9, 
   3.7755643428346806`*^9}, {3.776174685561227*^9, 3.7761746980549393`*^9}, {
   3.7761747355753527`*^9, 3.7761747579902515`*^9}, {3.7765960168757334`*^9, 
   3.7765960240850177`*^9}, {3.7766068563663626`*^9, 3.776606883407667*^9}, 
   3.776607036819338*^9, 3.776685577915942*^9, {3.7783361528223543`*^9, 
   3.7783361609896545`*^9}, 3.778337008266876*^9, 3.7783377056184273`*^9, {
   3.778414553940363*^9, 3.7784145827669296`*^9}, {3.778414617805806*^9, 
   3.778414780642683*^9}, {3.7784148218292284`*^9, 3.7784148704389377`*^9}, 
   3.779560074687081*^9, 3.791627653270563*^9, 3.7916287050139203`*^9, 
   3.791870910737112*^9, {3.7918711794152703`*^9, 3.7918711895183673`*^9}},
 CellLabel->
  "During evaluation of \
In[206]:=",ExpressionUUID->"684fa087-97cf-486d-b069-142b88c4f0c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Adjacency matrix of orbit is: \"\>", "\[InvisibleSpace]", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztmbENAjEQBC3RAgkhlRCSUwISMTlFURDZd0AJCPGklkC2b+e8L6H5lwj2
9tZnP+zP19NlU0rZrZ/3/ed6Hsw6l9v2flwe6/P3avd9tboo+tUY5ZtaPp0f
Uzknzmed7st/Oin6KWzlp/syhmo+U9bpbDnPev6M6iOl762oVi99/Wb102xL
tfnmnOQmpb8Unb3r8jodQzU/1fRQ9P+6Xug+R9HvmyydUXqy5kSNdB8o+um/
S/Smmj+zzWe6b1FUOx/Otm+q6ZlNfxTtW52znavpeZhNv9q+2bsucwzV5h49
D3T9lHqz+kyvK2r+t5ondP+zUm2/cN5y0P9jmi35AjBSeaY=
     "], {{0, 0}, {25, 25}}, {0, 1}],
    Frame->True,
    FrameLabel->{None, None},
    FrameTicks->{{{{24.5, 
         FormBox["1", TraditionalForm]}, {20.5, 
         FormBox["5", TraditionalForm]}, {15.5, 
         FormBox["10", TraditionalForm]}, {10.5, 
         FormBox["15", TraditionalForm]}, {5.5, 
         FormBox["20", TraditionalForm]}, {0.5, 
         FormBox["25", TraditionalForm]}}, {{24.5, 
         FormBox["1", TraditionalForm]}, {20.5, 
         FormBox["5", TraditionalForm]}, {15.5, 
         FormBox["10", TraditionalForm]}, {10.5, 
         FormBox["15", TraditionalForm]}, {5.5, 
         FormBox["20", TraditionalForm]}, {0.5, 
         FormBox["25", TraditionalForm]}}}, {{{0.5, 
         FormBox["1", TraditionalForm]}, {4.5, 
         FormBox["5", TraditionalForm]}, {9.5, 
         FormBox["10", TraditionalForm]}, {14.5, 
         FormBox["15", TraditionalForm]}, {19.5, 
         FormBox["20", TraditionalForm]}, {24.5, 
         FormBox["25", TraditionalForm]}}, {{0.5, 
         FormBox["1", TraditionalForm]}, {4.5, 
         FormBox["5", TraditionalForm]}, {9.5, 
         FormBox["10", TraditionalForm]}, {14.5, 
         FormBox["15", TraditionalForm]}, {19.5, 
         FormBox["20", TraditionalForm]}, {24.5, 
         FormBox["25", TraditionalForm]}}}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultPlotStyle" -> Automatic, "DomainPadding" -> Scaled[0.02], 
      "RangePadding" -> Scaled[0.05]}]}],
  SequenceForm["Adjacency matrix of orbit is: ", 
   Graphics[
    Raster[CompressedData["
1:eJztmbENAjEQBC3RAgkhlRCSUwISMTlFURDZd0AJCPGklkC2b+e8L6H5lwj2
9tZnP+zP19NlU0rZrZ/3/ed6Hsw6l9v2flwe6/P3avd9tboo+tUY5ZtaPp0f
Uzknzmed7st/Oin6KWzlp/syhmo+U9bpbDnPev6M6iOl762oVi99/Wb102xL
tfnmnOQmpb8Unb3r8jodQzU/1fRQ9P+6Xug+R9HvmyydUXqy5kSNdB8o+um/
S/Smmj+zzWe6b1FUOx/Otm+q6ZlNfxTtW52znavpeZhNv9q+2bsucwzV5h49
D3T9lHqz+kyvK2r+t5ondP+zUm2/cN5y0P9jmi35AjBSeaY=
     "], {{0, 0}, {25, 25}}, {0, 1}], Frame -> True, 
    FrameLabel -> {None, None}, 
    FrameTicks -> {{{{24.5, 1}, {20.5, 5}, {15.5, 10}, {10.5, 15}, {
        5.5, 20}, {0.5, 25}}, {{24.5, 1}, {20.5, 5}, {15.5, 10}, {10.5, 15}, {
        5.5, 20}, {0.5, 25}}}, {{{0.5, 1}, {4.5, 5}, {9.5, 10}, {14.5, 15}, {
        19.5, 20}, {24.5, 25}}, {{0.5, 1}, {4.5, 5}, {9.5, 10}, {14.5, 15}, {
        19.5, 20}, {24.5, 25}}}}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], 
    Method -> {
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultPlotStyle" -> Automatic, "DomainPadding" -> Scaled[0.02], 
      "RangePadding" -> Scaled[0.05]}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.769345830236459*^9, 3.7693458423754587`*^9}, 
   3.769349008322801*^9, 3.7693490994991455`*^9, 3.769349393616994*^9, 
   3.769349784618721*^9, 3.769350283365591*^9, 3.7693503262448783`*^9, 
   3.7693503910833616`*^9, {3.7694205790266466`*^9, 3.7694205939601393`*^9}, 
   3.769420681279871*^9, 3.769421302313692*^9, 3.769421572379201*^9, {
   3.769421645350793*^9, 3.7694216720639205`*^9}, 3.7694218714838605`*^9, 
   3.769421929526664*^9, 3.7694233240988426`*^9, 3.7694234294054785`*^9, {
   3.769423472991479*^9, 3.769423520024479*^9}, {3.7694236072574787`*^9, 
   3.769423616861479*^9}, 3.7694236652774787`*^9, 3.7694238119329*^9, {
   3.7694238590016065`*^9, 3.769423876761382*^9}, {3.769423950535759*^9, 
   3.7694239603037357`*^9}, {3.769424201410844*^9, 3.7694242037770805`*^9}, 
   3.769424273246027*^9, 3.769424358214523*^9, {3.7694244585365543`*^9, 
   3.7694244815758576`*^9}, 3.769424726893387*^9, {3.7694257781202726`*^9, 
   3.769425800413273*^9}, 3.7694262031470165`*^9, {3.769426759272623*^9, 
   3.7694267708317795`*^9}, 3.769427269052069*^9, 3.769435495256836*^9, {
   3.769499235328121*^9, 3.7694992411862926`*^9}, {3.769499349856022*^9, 
   3.7694993980057335`*^9}, {3.7694994476096935`*^9, 3.7694994816770997`*^9}, 
   3.76949951837877*^9, {3.7694996053264637`*^9, 3.769499619564887*^9}, {
   3.769499664347365*^9, 3.7694996761085405`*^9}, 3.769499894211349*^9, {
   3.769502231260203*^9, 3.769502241172203*^9}, 3.769502283360203*^9, {
   3.769502428709203*^9, 3.769502433853203*^9}, 3.769502574074332*^9, 
   3.769502779499872*^9, 3.769502866672589*^9, {3.7695132877742496`*^9, 
   3.7695133206655383`*^9}, {3.7695134371459837`*^9, 3.769513455714984*^9}, {
   3.7695135785979834`*^9, 3.7695135837339835`*^9}, {3.7695136230029836`*^9, 
   3.769513703565984*^9}, 3.7728037285973234`*^9, {3.7728037847507443`*^9, 
   3.7728038118810496`*^9}, 3.7728038838695574`*^9, 3.772803915844962*^9, {
   3.772804100387848*^9, 3.772804144564432*^9}, 3.774260283274734*^9, {
   3.7746906831037254`*^9, 3.7746907236088734`*^9}, {3.7755643320505543`*^9, 
   3.7755643428346806`*^9}, {3.776174685561227*^9, 3.7761746980549393`*^9}, {
   3.7761747355753527`*^9, 3.7761747579902515`*^9}, {3.7765960168757334`*^9, 
   3.7765960240850177`*^9}, {3.7766068563663626`*^9, 3.776606883407667*^9}, 
   3.776607036819338*^9, 3.776685577915942*^9, {3.7783361528223543`*^9, 
   3.7783361609896545`*^9}, 3.778337008266876*^9, 3.7783377056184273`*^9, {
   3.778414553940363*^9, 3.7784145827669296`*^9}, {3.778414617805806*^9, 
   3.778414780642683*^9}, {3.7784148218292284`*^9, 3.7784148704389377`*^9}, 
   3.779560074687081*^9, 3.791627653270563*^9, 3.7916287050139203`*^9, 
   3.791870910737112*^9, {3.7918711794152703`*^9, 3.7918711895824556`*^9}},
 CellLabel->
  "During evaluation of \
In[206]:=",ExpressionUUID->"136ebf24-f0ab-47b6-94b6-7a1720ca8e83"]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
       20, 21, 22, 23, 24, 25}, {
      Null, SparseArray[
       Automatic, {25, 25}, 0, {
        1, {{0, 3, 7, 11, 14, 19, 22, 25, 26, 29, 32, 35, 36, 40, 44, 45, 47, 
          50, 52, 53, 55, 55, 57, 58, 58, 58}, {{2}, {3}, {1}, {7}, {8}, {
          10}, {2}, {6}, {7}, {9}, {3}, {9}, {18}, {4}, {6}, {10}, {11}, {
          19}, {5}, {12}, {14}, {6}, {12}, {20}, {7}, {15}, {13}, {19}, {9}, {
          15}, {18}, {10}, {12}, {15}, {24}, {22}, {18}, {20}, {25}, {13}, {
          19}, {20}, {21}, {14}, {25}, {17}, {24}, {19}, {21}, {22}, {24}, {
          18}, {19}, {23}, {20}, {24}, {25}, {25}}}, {1, 1, 1, 1, 1, 1, 1, 1, 
         1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
         1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
         1, 1, 1, 1}}]}, {EdgeLabelStyle -> {
         Directive[
          GrayLevel[0], 12]}, EdgeStyle -> {
         Thickness[0.004]}, GraphLayout -> "SpringElectricalEmbedding", 
       VertexLabels -> {
        19 -> None, 23 -> None, 9 -> None, 22 -> None, 17 -> None, 14 -> None,
          5 -> None, 6 -> None, 24 -> None, 13 -> None, 16 -> None, 4 -> None,
          15 -> None, 12 -> None, 21 -> None, 20 -> None, 1 -> None, 7 -> 
         None, 8 -> None, 18 -> None, 2 -> None, 10 -> None, 3 -> None, 11 -> 
         None, 25 -> None}, VertexShape -> {20 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844389, -0.5000000000000012}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}, {3, 4}, {
                3, 5}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 24 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844389, -0.5000000000000012}, {
             1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844386, 
             0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 6}, {3, 5}, {
                3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 3 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 
             0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {1.8369701987210297`*^-16, 1.}, {
             3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
             0.4999999999999993}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               Line[{{1, 2}, {2, 3}, {2, 4}, {3, 4}, {4, 5}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 13 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {
             0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
             0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {1, 4}, {1, 5}, {2, 4}, {2, 5}, {3, 4}, {3, 5}, {
                5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 15 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844386, 0.4999999999999993}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}, {4, 5}, {4, 6}, {
                5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 25 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844386, 0.4999999999999993}, {
             0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {1, 4}, {1, 5}, {1, 6}, {2, 4}, {2, 5}, {2, 6}, {
                3, 4}, {3, 5}, {3, 6}, {4, 5}, {4, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 8 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             3.8285686989269494`*^-16, -1.}, {0.8660254037844386, 
             0.4999999999999993}, {
             0.8660254037844389, -0.5000000000000012}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {1, 3}, {2, 3}, {3, 4}, {4, 5}, {4, 6}, {5, 
                6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 1 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 
             0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
             0.4999999999999993}, {1.8369701987210297`*^-16, 1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               Line[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 21 -> Graphics[{
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 6}, {
                4, 5}, {4, 6}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 10 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844386, 0.4999999999999993}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}, {4, 5}, {5, 
                6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 18 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {
             0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
             0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {1, 4}, {1, 5}, {2, 4}, {2, 5}, {3, 4}, {3, 5}, {
                4, 5}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 11 -> Graphics[{
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844386, 0.4999999999999993}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             0.8660254037844389, -0.5000000000000012}, {
             3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 3}, {1, 4}, {2, 3}, {2, 4}, {4, 5}, {4, 6}, {5, 
                6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 19 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 
             0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {1.8369701987210297`*^-16, 1.}, {
             0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
             0.4999999999999993}, {3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {2, 3}, {2, 5}, {2, 6}, {3, 5}, {3, 6}, {4, 5}, {
                4, 6}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 6 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 4}, {4, 5}, {5, 
                6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 17 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 6}, {
                4, 5}, {4, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 14 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844389, -0.5000000000000012}, {
             1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
             0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}, {4, 5}, {
                5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 7 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             0.8660254037844386, 0.4999999999999993}, {
             3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {1, 3}, {2, 3}, {3, 4}, {3, 5}, {4, 5}, {5, 
                6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 4 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 
             0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {0.8660254037844386, 0.4999999999999993}, {
             1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               Line[{{1, 2}, {2, 4}, {2, 5}, {3, 4}, {3, 5}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 2 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
             0.4999999999999993}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               Line[{{1, 2}, {1, 3}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 22 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844389, -0.5000000000000012}, {
             1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844386, 
             0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 6}, {3, 5}, {
                3, 6}, {4, 5}, {4, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 9 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 
             0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {0.8660254037844386, 0.4999999999999993}, {
             1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {2, 4}, {2, 5}, {3, 4}, {3, 5}, {4, 5}, {5, 
                6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 12 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
             0.4999999999999993}, {3.8285686989269494`*^-16, -1.}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {1, 3}, {2, 3}, {3, 5}, {3, 6}, {4, 5}, {4, 6}, {
                5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 16 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844389, -0.5000000000000012}, {
             1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844386, 
             0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 6}, {4, 5}, {
                4, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 23 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
             0.8660254037844386, 0.4999999999999993}, {
             0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               
               Line[{{1, 2}, {1, 4}, {1, 5}, {1, 6}, {2, 4}, {2, 5}, {2, 6}, {
                3, 4}, {3, 5}, {3, 6}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}], 5 -> Graphics[{
            
            GraphicsComplex[{{-0.8660254037844389, 0.5000000000000008}, {
             0.8660254037844386, 0.4999999999999993}, {
             1.8369701987210297`*^-16, 
             1.}, {-0.8660254037844384, -0.49999999999999933`}, {
             3.8285686989269494`*^-16, -1.}, {
             0.8660254037844389, -0.5000000000000012}}, {{
               Directive[
                Opacity[0.7], 
                Hue[0.6, 0.7, 0.5]], 
               Thickness[0.004], 
               Line[{{1, 3}, {1, 4}, {2, 3}, {2, 4}, {4, 5}, {5, 6}}]}, {
               Directive[
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.7]]]], 
               Disk[1, 0.19999999999999987`], 
               Disk[2, 0.19999999999999987`], 
               Disk[3, 0.19999999999999987`], 
               Disk[4, 0.19999999999999987`], 
               Disk[5, 0.19999999999999987`], 
               Disk[6, 0.19999999999999987`]}}], {
             Directive[
              GrayLevel[0], 
              Thickness[0.02]], 
             Circle[{0, 0}, 1.6]}}, {
           ImageSize -> 100, FormatType -> TraditionalForm, FrameTicks -> 
            None, ImagePadding -> 0, ImageSize -> 120}]}, 
       VertexSize -> {0.6}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[{{0., 2.4253729504487858`}, {0.26508516434934415`, 
          1.5417199229793828`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0., 2.4253729504487858`}, {0.9887178281204376, 
          2.387880535482709}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0., 
          2.4253729504487858`}, {-0.18672496124266488`, 
          2.3286221212873337`}, {-0.37853284630812983`, 
          2.405746649928977}, {-0.4430240694711164, 
          2.530211951673374}, {-0.2126135585775065, 
          2.8279360101270514`}, {-0.07595074864590048, 2.796726947581381}, {
          0.0468203660987197, 2.6303968207977895`}, {0., 2.4253729504487858`}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.26508516434934415`, 1.5417199229793828`}, {
          1.350358295569337, 1.8789232477875923`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.26508516434934415`, 1.5417199229793828`}, {
          0.06886984696997178, 0.5850040594813193}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.26508516434934415`, 1.5417199229793828`}, {
          0.967606255894675, 0.9325140777289143}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.26508516434934415`, 
          1.5417199229793828`}, {0.0860304910549198, 
          1.3140966390037594`}, {-0.07739517524196474, 
          1.3095459666833582`}, {-0.1702698351539002, 
          1.3690593709275545`}, {-0.18391434027005268`, 
          1.6749306082822073`}, {-0.09670765611250359, 1.7424771994377664`}, {
          0.06647408232815584, 1.7524960448119877`}, {0.26508516434934415`, 
          1.5417199229793828`}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.9887178281204376, 2.387880535482709}, {
          2.019065052986808, 2.526773683280538}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.9887178281204376, 2.387880535482709}, {
          1.350358295569337, 1.8789232477875923`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.9887178281204376, 2.387880535482709}, {
          1.4860848739412202`, 1.3492188398162055`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.9887178281204376, 2.387880535482709}, {
          0.7632391936032318, 2.535107833742851}, {0.7442931866529598, 
          2.71087483654755}, {0.8035896920206274, 2.814535517418899}, {
          1.1320566473054168`, 2.830329270706821}, {1.201025285436309, 
          2.7328359926723866`}, {1.1990305849991982`, 2.5560620929460045`}, {
          0.9887178281204376, 2.387880535482709}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.8435551299557726, 0.34682094519043205`}, {
          1.4860848739412202`, 1.3492188398162055`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.8435551299557726, 0.34682094519043205`}, {
          1.6191426125710224`, 0.08121253866051847}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8435551299557726, 
          0.34682094519043205`}, {0.8228056732383672, 0.13754506286407445`}, {
          0.6535737691262565, 0.018827972173923513`}, {0.514083462026576, 
          0.03263952864402653}, {0.39017114997579894`, 0.3881066469365766}, {
          0.49084834847991615`, 0.48563821397131995`}, {0.6972074903807763, 
          0.49784843695391834`}, {0.8435551299557726, 0.34682094519043205`}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.7825724903322435`, 1.7567386745074156`}, {
          2.019065052986808, 2.526773683280538}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.7825724903322435`, 1.7567386745074156`}, {
          0.967606255894675, 0.9325140777289143}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.7825724903322435`, 1.7567386745074156`}, {
          1.9697563865053174`, 0.8963729091123096}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.7825724903322435`, 1.7567386745074156`}, {
          2.66033728579397, 1.921688212342152}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{1.7825724903322435`, 
          1.7567386745074156`}, {1.5087571212225088`, 1.6647580685783205`}, {
          1.369175579174044, 1.7508704700610942`}, {1.3241313447321845`, 
          1.8519491005650301`}, {1.481707778842703, 2.1155056386909683`}, {
          1.5920672047566213`, 2.123670791044405}, {1.7339907750262218`, 
          2.041475579677273}, {1.7825724903322435`, 1.7567386745074156`}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.019065052986808, 2.526773683280538}, {
          2.2289932089274367`, 1.7023146787797838`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.019065052986808, 2.526773683280538}, {3.051283701600039,
           2.3660851839562707`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{2.019065052986808, 2.526773683280538}, {
          1.8118335382083097`, 2.647937313894257}, {1.781425744237799, 
          2.8388929782120647`}, {1.8454117164757817`, 2.953042046691384}, {
          2.2013939428736022`, 2.9494039884398133`}, {2.2630336387006964`, 
          2.833971053900837}, {2.2287295556426323`, 2.6436767304049598`}, {
          2.019065052986808, 2.526773683280538}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.350358295569337, 1.8789232477875923`}, {
          2.2289932089274367`, 1.7023146787797838`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.350358295569337, 1.8789232477875923`}, {
          2.5527547724336714`, 1.2829583719892834`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{1.350358295569337, 1.8789232477875923`}, {
          1.2862309633020603`, 2.1783357039199718`}, {1.3785500392024426`, 
          2.298745786134943}, {1.4748784251047697`, 2.3331132104683876`}, {
          1.7144752968161492`, 2.1776080218597436`}, {1.722313774542166, 
          2.07563333846822}, {1.6499343657265593`, 1.942281844837215}, {
          1.350358295569337, 1.8789232477875923`}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.06886984696997178, 0.5850040594813193}, {
          1.194297345268978, 0.24658643726007778`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.4860848739412202`, 1.3492188398162055`}, {
          2.0134663523843814`, 0.49763416781333913`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.4860848739412202`, 1.3492188398162055`}, {
          2.66033728579397, 1.921688212342152}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{1.4860848739412202`, 
          1.3492188398162055`}, {1.2285165545724466`, 1.1540899723935347`}, {
          1.0922907047305097`, 1.1819942267893664`}, {1.0239115586599885`, 
          1.245980535083268}, {1.0401379296327007`, 1.5085726718506753`}, {
          1.11587460568969, 1.5636536228796345`}, {1.2544995486141133`, 
          1.5745740064693066`}, {1.4860848739412202`, 1.3492188398162055`}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.967606255894675, 0.9325140777289143}, {
          1.194297345268978, 0.24658643726007778`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.967606255894675, 0.9325140777289143}, {
          1.6191426125710224`, 0.08121253866051847}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.967606255894675, 0.9325140777289143}, {
          0.9281915012864345, 0.6428207456629902}, {0.7913516555665692, 
          0.5568801198196562}, {0.6824037449532048, 0.5604743551839713}, {
          0.5144437187600943, 0.8125234850293722}, {0.5530697389940498, 
          0.9144577595191521}, {0.6850675109792254, 1.0076646409063654`}, {
          0.967606255894675, 0.9325140777289143}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.9697563865053174`, 0.8963729091123096}, {
          2.2289932089274367`, 1.7023146787797838`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.9697563865053174`, 0.8963729091123096}, {
          1.194297345268978, 0.24658643726007778`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.9697563865053174`, 0.8963729091123096}, {
          2.7849721411829824`, 0.33474705239409774`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.2289932089274367`, 1.7023146787797838`}, {
          3.0477952005140816`, 0.8953995442012171}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.0134663523843814`, 0.49763416781333913`}, {
          1.6191426125710224`, 0.08121253866051847}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.0134663523843814`, 0.49763416781333913`}, {
          2.5527547724336714`, 1.2829583719892834`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.0134663523843814`, 0.49763416781333913`}, {
          2.3796735029997906`, 0.}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{2.0134663523843814`, 
          0.49763416781333913`}, {2.2802468308360595`, 0.7046304858120775}, {
          2.4060379931814575`, 0.6822737783498595}, {2.4714599891091558`, 
          0.6264824873091106}, {2.4754236535024394`, 0.38381188238122943`}, {
          2.4118586051994577`, 0.32591377929143145`}, {2.2868646755584785`, 
          0.2994608693255429}, {2.0134663523843814`, 0.49763416781333913`}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.051283701600039, 2.3660851839562707`}, {
          2.66033728579397, 1.921688212342152}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.051283701600039, 2.3660851839562707`}, {
          2.5527547724336714`, 1.2829583719892834`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.051283701600039, 2.3660851839562707`}, {
          4.025640401821496, 2.4243786507843295`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{3.051283701600039, 2.3660851839562707`}, {
          2.8406001028991152`, 2.538054926274283}, {2.840250815470421, 
          2.7131703158849367`}, {2.9090817144997083`, 2.809353975558892}, {
          3.234753505742332, 2.7939256422022383`}, {3.2941833667171174`, 
          2.691665773857062}, {3.277281009193069, 2.517367661445228}, {
          3.051283701600039, 2.3660851839562707`}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.194297345268978, 0.24658643726007778`}, {
          2.3796735029997906`, 0.}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.9148593856553577`, 0.6273215564527941}, {
          3.73404952765904, 1.5563519773816932`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.9148593856553577`, 0.6273215564527941}, {
          2.7849721411829824`, 0.33474705239409774`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.73404952765904, 1.5563519773816932`}, {2.66033728579397,
           1.921688212342152}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.73404952765904, 1.5563519773816932`}, {
          4.025640401821496, 2.4243786507843295`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.73404952765904, 1.5563519773816932`}, {
          3.0477952005140816`, 0.8953995442012171}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.6191426125710224`, 0.08121253866051847}, {
          2.7849721411829824`, 0.33474705239409774`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{1.6191426125710224`, 
          0.08121253866051847}, {1.8124598112899715`, -0.03103717755158847}, {
          1.8466352128229062`, -0.22934638599855656`}, {
          1.7787285523341563`, -0.3475629716053852}, {
          1.4110818572697492`, -0.32625136462090404`}, {
          1.3572896052563403`, -0.20098018168325918`}, {
          1.414150132667163, -0.007948110132018266}, {1.6191426125710224`, 
          0.08121253866051847}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{2.66033728579397, 1.921688212342152}, {
          2.3686114174607136`, 1.9932927097000595`}, {2.29929455738862, 
          2.132972445004525}, {2.3120516035213172`, 2.237339907245201}, {
          2.5667056519900835`, 2.38230956022185}, {2.6629622651430416`, 
          2.3400014779571983`}, {2.74768623461036, 2.209092713763655}, {
          2.66033728579397, 1.921688212342152}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.5527547724336714`, 1.2829583719892834`}, {
          3.146477019494383, 0.1584277153310547}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{2.5527547724336714`, 
          1.2829583719892834`}, {2.7808113513634796`, 1.5026522503704756`}, {
          2.9242028104530706`, 1.4897684096573784`}, {3.00148398407849, 
          1.4311611315461379`}, {3.00888026896358, 1.1593804826279916`}, {
          2.934901017387236, 1.0966567775338683`}, {2.7924225228222963`, 
          1.0759932231960783`}, {2.5527547724336714`, 1.2829583719892834`}},
          SplineDegree->7], 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.0477952005140816`, 0.8953995442012171}, {
          2.7849721411829824`, 0.33474705239409774`}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.0477952005140816`, 0.8953995442012171}, {
          2.3796735029997906`, 0.}}, 0.10943507315507658`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.146477019494383, 0.1584277153310547}, {
          2.3796735029997906`, 0.}}, 0.10943507315507658`]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 
            0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
            0.4999999999999993}, {1.8369701987210297`*^-16, 1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {0., 2.4253729504487858}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
            0.4999999999999993}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {0.26508516434934415, 1.5417199229793828}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 
            0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {1.8369701987210297`*^-16, 1.}, {
            3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
            0.4999999999999993}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {2, 3}, {2, 4}, {3, 4}, {4, 5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {0.9887178281204376, 2.387880535482709}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 
            0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {0.8660254037844386, 0.4999999999999993}, {
            1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {2, 4}, {2, 5}, {3, 4}, {3, 5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {0.8435551299557726, 0.34682094519043205}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844386, 0.4999999999999993}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 3}, {1, 4}, {2, 3}, {2, 4}, {4, 5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.7825724903322435, 1.7567386745074156}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 4}, {4, 5}, {5, 
               6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.019065052986808, 2.526773683280538}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            0.8660254037844386, 0.4999999999999993}, {
            3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 4}, {3, 5}, {4, 5}, {5, 
               6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.350358295569337, 1.8789232477875923}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            3.8285686989269494`*^-16, -1.}, {0.8660254037844386, 
            0.4999999999999993}, {0.8660254037844389, -0.5000000000000012}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 4}, {4, 5}, {4, 6}, {5, 
               6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {0.06886984696997178, 0.5850040594813193}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 
            0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {0.8660254037844386, 0.4999999999999993}, {
            1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {2, 4}, {2, 5}, {3, 4}, {3, 5}, {4, 5}, {5, 
               6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.4860848739412202, 1.3492188398162055}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844386, 0.4999999999999993}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}, {4, 5}, {5, 
               6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {0.967606255894675, 0.9325140777289143}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844386, 0.4999999999999993}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 3}, {1, 4}, {2, 3}, {2, 4}, {4, 5}, {4, 6}, {5, 
               6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.9697563865053174, 0.8963729091123096}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
            0.4999999999999993}, {3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 5}, {3, 6}, {4, 5}, {4, 
               6}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.2289932089274367, 1.7023146787797838}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {
            0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
            0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {2, 4}, {2, 5}, {3, 4}, {3, 
               5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.0134663523843814, 0.49763416781333913}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844389, -0.5000000000000012}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}, {4, 
               5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {3.051283701600039, 2.3660851839562707}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844386, 0.4999999999999993}, {
            1.8369701987210297`*^-16, 
            1.}, {-0.8660254037844384, -0.49999999999999933`}, {
            0.8660254037844389, -0.5000000000000012}, {
            3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}, {4, 5}, {4, 
               6}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.194297345268978, 0.24658643726007778}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844389, -0.5000000000000012}, {
            1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844386, 
            0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 6}, {4, 
               5}, {4, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {3.9148593856553577, 0.6273215564527941}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 
               6}, {4, 5}, {4, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {3.73404952765904, 1.5563519773816932}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {
            0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
            0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {2, 4}, {2, 5}, {3, 4}, {3, 
               5}, {4, 5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {1.6191426125710224, 0.08121253866051847}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 
            0.5000000000000008}, {-0.8660254037844384, \
-0.49999999999999933`}, {1.8369701987210297`*^-16, 1.}, {
            0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
            0.4999999999999993}, {3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {2, 3}, {2, 5}, {2, 6}, {3, 5}, {3, 6}, {4, 
               5}, {4, 6}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.66033728579397, 1.921688212342152}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844389, -0.5000000000000012}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}, {3.8285686989269494`*^-16, -1.}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}, {3, 
               4}, {3, 5}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.5527547724336714, 1.2829583719892834}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {0.8660254037844386, 
            0.4999999999999993}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 
               6}, {4, 5}, {4, 6}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {4.025640401821496, 2.4243786507843295}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844389, -0.5000000000000012}, {
            1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844386, 
            0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 6}, {3, 
               5}, {3, 6}, {4, 5}, {4, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {3.0477952005140816, 0.8953995442012171}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844386, 0.4999999999999993}, {
            0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 6}, {2, 4}, {2, 5}, {2, 
               6}, {3, 4}, {3, 5}, {3, 6}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {3.146477019494383, 0.1584277153310547}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            0.8660254037844389, -0.5000000000000012}, {
            1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844386, 
            0.4999999999999993}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 3}, {1, 5}, {1, 6}, {2, 3}, {2, 5}, {2, 6}, {3, 
               5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.7849721411829824, 0.33474705239409774}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}], InsetBox[
         GraphicsBox[{
           GraphicsComplexBox[{{-0.8660254037844389, 0.5000000000000008}, {
            1.8369701987210297`*^-16, 1.}, {3.8285686989269494`*^-16, -1.}, {
            0.8660254037844386, 0.4999999999999993}, {
            0.8660254037844389, -0.5000000000000012}, {-0.8660254037844384, \
-0.49999999999999933`}}, {
             {Hue[0.6, 0.7, 0.5], Thickness[0.004], Opacity[0.7], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 6}, {2, 4}, {2, 5}, {2, 
               6}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {4, 6}}]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
              DiskBox[1, 0.19999999999999987], 
              DiskBox[2, 0.19999999999999987], 
              DiskBox[3, 0.19999999999999987], 
              DiskBox[4, 0.19999999999999987], 
              DiskBox[5, 0.19999999999999987], 
              DiskBox[6, 0.19999999999999987]}}], 
           {GrayLevel[0], Thickness[0.02], CircleBox[{0, 0}, 1.6]}},
          FormatType->TraditionalForm,
          FrameTicks->None,
          ImagePadding->0,
          ImageSize->100], {2.3796735029997906, 0.}, 
         Automatic, {0.21887014631015317, 0.21887014631015317}]}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.776596017283501*^9, 3.776596024383839*^9}, {
   3.7766068567607*^9, 3.7766068840492983`*^9}, 3.7766070370953417`*^9, 
   3.7766855781707983`*^9, {3.7783361536726933`*^9, 3.7783361614703784`*^9}, 
   3.7783370088155594`*^9, 3.7783377062490273`*^9, {3.7784145550464277`*^9, 
   3.7784145831556673`*^9}, {3.778414617906746*^9, 3.778414781044882*^9}, {
   3.778414822637766*^9, 3.7784148709762125`*^9}, 3.7795600761593213`*^9, 
   3.7916276537971153`*^9, 3.791628705452711*^9, 3.79187091122842*^9, {
   3.7918711799599466`*^9, 3.7918711901060658`*^9}},
 CellLabel->
  "Out[211]=",ExpressionUUID->"a6248909-8bbb-462e-970a-521c1f7d2e7d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Print unlabelled graph state orbit adjacency matrices, ordered and grouped by \
edgecount \
\>", "Section",
 CellChangeTimes->{
  3.7693447584929523`*^9, {3.7693499605383115`*^9, 3.7693499605803156`*^9}, {
   3.779560272511243*^9, 
   3.779560281399896*^9}},ExpressionUUID->"ec0f9110-c08c-49cf-8168-\
e95fa03b58be"],

Cell[CellGroupData[{

Cell["Plot Settings", "Subsubsection",
 CellChangeTimes->{{3.7694258293652725`*^9, 
  3.769425830736273*^9}},ExpressionUUID->"36a564f3-9667-4c74-9eee-\
498a4fb7cadd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Adjust", " ", "plot", " ", "cosmetics"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"myframethickness", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"myfontsize", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"graphsize", "=", "270"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Adjust", " ", "colour", " ", "space", " ", "for", " ", "plots"}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"satmod", "=", "0.17"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"brightmod", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Difference", " ", "in", " ", "edge", " ", "number", " ", "required", " ",
      "to", " ", "be", " ", "displayed", " ", "on", " ", "the", " ", "plot"}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tickthresno", "=", "1"}], ";"}], "          ", 
   RowBox[{"(*", 
    RowBox[{"in", " ", "graph", " ", "index"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tickthresedge", "=", "1"}], ";"}], "     ", 
   RowBox[{"(*", 
    RowBox[{"in", " ", "edge", " ", "number"}], "*)"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"plotOrbitMatrixCi", "[", 
    RowBox[{"noqub", ",", "myclass"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7694260758822913`*^9, 3.7694260797726803`*^9}, {
   3.76942635029673*^9, 3.769426357125413*^9}, 3.7728033990833955`*^9},
 CellLabel->
  "In[212]:=",ExpressionUUID->"b7370530-4f03-4fdc-ad82-43f62857b7e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJztm1lIVFEYx6cFCiOCqMgkS5AyIqUe6qkOvbSQYVk9tNBmPSQtRrSgELRB
SYuEqYnYZhkttriURkELbRT4IBmVpVSmOTNXiwwKsxnqzMO5/DnzyXfmOuWA
jPPjeJ37fb/znXPuuTdm9abktX1cLlfk3x//739erSL5ZvS+lvmW+DSyuGnW
HUtIXpQ2NaL2jFfMO5S7cfB9ft4et+zIvW8e0Xk948vVk87zWQ3pQ0pmesSM
PjsGxMZZIi3n6MfY7FoxMac5d/+UevFob96cCxWNsH1Nefu0Rfs84k3CiUvD
S16KuJm9Tq98+BS2lzz/uP/lFgv8eZjuZefu+X7QItaPb8+tW+ARZ3dnXljR
XC/aCiaMLot+K9Zluoq3b/adV+OSMpenQWy9fDtpUUyjiMy6/baj7XHgOP4s
pk1tEaWft5QP9R1Pcl8wfRH9HHhX815oFT+c890SYz7sKXxeZQXiL9tx8W13
ToxIqLMCcQ4V18VN5qXS38322/PeVa7zU+Z92+aogfUbvDjvoL2OSx8iMkel
eFM9Wv+lH02pfhHt/qgc+fa/eAV9M+yVjlM9UbnOW9UrHQ/aK9BPR09vS3k2
wZ736GGpc78e9triz8VH+cJ6s8QbiLPTHMVna+/8/lHLrUAeZXsuHqwP1aWL
v1WmWl3m0oe8WzlZg9K9Wh5sfUN1tccrXh+oxwl2PuO0Vzquzt/e1O7aMiPb
Y8u770NDepHbFn8u3m9FXuLQZ+6g44zac/G9A5OuZB/zBOImOeqnyCt0HMRv
fO2o2dHstc13qTy5vK7vu7ImUZA08mJ24WvRGnmguv/kKrKHXZ3XqesF016Z
9gTFgcsrqm/U4yQ+WPrpXbxb/MpofXX20HtRml8ytir+HvQH+YzaU73S+RNq
r9D5UusVF0d5p3qF+gXVH2q9QvWHWse4vNLVsVDXK6e8Ml2vqBz5SfWEWq+o
823klY6rXsnP4/zT9jz738+O74zpqODnMu7fP6w69WKNfV4Yai7z8XTSg2vx
G+3ralPcdD0kryMUT4K9/qZe7w0Xr1D8UXvUH1F8nPLKdJ3k8gpxVA+d8gp9
n3CpV2j+Y9or1L9Qf0H9i8srycO1XiGO4snlFZc/VK+o4yPqp6brFfLWKa+o
/YvLQxT//20c5N4nVeuV+v9yO7N2/vxh/36xcTsPVkbROfJEXbdk7ElIPBdh
X8+EilPnb1z10/Q6l7rvgPZPdfvU6v0hyCtdnIP1SjdPNuWJbvxS23PVQ2q9
5br+Ztor3X59sF4hT6C3RA+5/OHyFuUdXQ/n8tD0/kJ380pXz1VPqLy7jYNc
nlDH03AZB7m8ou63cnlFHb+4uOn1gmmvkM/dzSvqfAm1R+frlD9cXnFdf/tX
69WThXfPFy23X1eq+LvfJLnMB5XD+zeY1gVU/5E/pq+rIE7dV0U+o/bU++Ko
9/3Kd/X5BS6vUB5Rey5/uPzsbl6h9QLVQ6e8Qnnh8gdxFDfdeKT6oBuPwtUr
Lu6UV8gTNH5xjY9UT6i+UetYj1eh8QrlBdUZNJ4ijtYLTnG0n2Wao/vfuDh6
fgFx1RP5fJaOq8+f/gafhAGF
     "], {{0, 0}, {25, 25}}, {0, 1}],
    AspectRatio->1,
    Frame->Automatic,
    FrameLabel->{
      FormBox["\"No.  Edges in graph\"", TraditionalForm], 
      FormBox["\"Graph index\"", TraditionalForm], 
      FormBox["\"Graph index\"", TraditionalForm], 
      FormBox["\"\"", TraditionalForm]},
    FrameStyle->AbsoluteThickness[0.5],
    FrameTicks->{{{{24., 
         FormBox["\"1\"", TraditionalForm]}, {20., 
         FormBox["\"5\"", TraditionalForm]}, {14., 
         FormBox["\"11\"", TraditionalForm]}, {9., 
         FormBox["\"16\"", TraditionalForm]}, {5., 
         FormBox["\"20\"", TraditionalForm]}, {3., 
         FormBox["\"22\"", TraditionalForm]}, {1., 
         FormBox["\"24\"", TraditionalForm]}, {0., 
         FormBox["\"25\"", TraditionalForm]}}, None}, {{{0.5, 
         FormBox["\"5\"", TraditionalForm]}, {3., 
         FormBox["\"6\"", TraditionalForm]}, {8., 
         FormBox["\"7\"", TraditionalForm]}, {13.5, 
         FormBox["\"8\"", TraditionalForm]}, {18., 
         FormBox["\"9\"", TraditionalForm]}, {21., 
         FormBox["\"10\"", TraditionalForm]}, {23., 
         FormBox["\"11\"", TraditionalForm]}, {24.5, 
         FormBox["\"12\"", TraditionalForm]}}, {{1., 
         FormBox["\"1\"", TraditionalForm]}, {5., 
         FormBox["\"5\"", TraditionalForm]}, {11., 
         FormBox["\"11\"", TraditionalForm]}, {16., 
         FormBox["\"16\"", TraditionalForm]}, {20., 
         FormBox["\"20\"", TraditionalForm]}, {22., 
         FormBox["\"22\"", TraditionalForm]}, {24., 
         FormBox["\"24\"", TraditionalForm]}, {25., 
         FormBox["\"25\"", TraditionalForm]}}}},
    FrameTicksStyle->Directive[
      Opacity[0], FontOpacity -> 1],
    GridLines->{{1, 5, 11, 16, 20, 22, 24, 25}, {24, 20, 14, 9, 5, 3, 1, 0}},
    GridLinesStyle->Directive[
      GrayLevel[0], 
      AbsoluteThickness[0.16666666666666666`]],
    ImagePadding->40,
    ImageSize->270,
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Helvetica", FontSize -> 10},
    Method->{
     "GridLinesInFront" -> True, "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultPlotStyle" -> Automatic},
    PlotRangePadding->0], ",", 
   TagBox[GridBox[{
      {"1", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.368417, 0.506779, 0.709798], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.24561133333333335`, 0.3378526666666667, 0.4731986666666667],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.368417, 0.506779, 0.709798]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.368417, 0.506779, 0.709798],
        Editable->False,
        Selectable->False]},
      {"2", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.880722, 0.611041, 0.142051], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.587148, 0.40736066666666665`, 0.09470066666666668],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.880722, 0.611041, 0.142051]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.880722, 0.611041, 0.142051],
        Editable->False,
        Selectable->False]},
      {"3", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.560181, 0.691569, 0.194885], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.37345400000000006`, 0.461046, 0.12992333333333334`],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.560181, 0.691569, 0.194885]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.560181, 0.691569, 0.194885],
        Editable->False,
        Selectable->False]},
      {"4", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.922526, 0.385626, 0.209179], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.6150173333333333, 0.25708400000000003`, 0.13945266666666667`],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.922526, 0.385626, 0.209179]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.922526, 0.385626, 0.209179],
        Editable->False,
        Selectable->False]},
      {"5", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.528488, 0.470624, 0.701351], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.3523253333333333, 0.3137493333333333, 0.46756733333333333`],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.528488`", ",", "0.470624`", ",", "0.701351`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.528488, 0.470624, 0.701351]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.528488, 0.470624, 0.701351],
        Editable->False,
        Selectable->False]},
      {"6", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0.772079, 0.431554, 0.102387], 
             RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           DefaultBaseStyle->"ColorSwatchGraphics",
           Frame->True,
           
           FrameStyle->RGBColor[
            0.5147193333333333, 0.28770266666666666`, 0.06825800000000001],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 1.35 CurrentValue["FontCapHeight"]/
              AbsoluteCurrentValue[Magnification]}],
           PlotRangePadding->None],
          StyleBox[
           RowBox[{"RGBColor", "[", 
             RowBox[{"0.772079`", ",", "0.431554`", ",", "0.102387`"}], "]"}],
            NumberMarks -> False]],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0.772079, 0.431554, 0.102387]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0.772079, 0.431554, 0.102387],
        Editable->False,
        Selectable->False]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Function[BoxForm`e$, 
     TableForm[BoxForm`e$]]], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzVWz1LA0EQDQiCIn51KQ9BLPwNrlUgjYWFlYWIQhBBsBARBStJI8Ei1nZC
/EDEpNAIWlqojYVgEQgETFJEsQhYiWgshCWZu/d27gKBMBx7czNv3868uXjz
K9OLXbFYLP77/f7983kztZux5nv3qykmEycX+SvTsk/NlT5SjxUzktisJOsF
Nftu9XTv7qFh7s+OM+Vm2Xjj2a314XO6/bDYl59dbpinBS97HSuZtaZX357J
Wf2UXi/1R7qO1E+b3bb+bWbpudHTMP2pam9h6Nnk9uMvg+mDv/tKcfX/elR8
2DiUxq2d/53GQXpfKT6ldun6NvxI4+PXf9s6na6vhUM2T6LjzOLJdvwjva/r
c1CL31B8gnouNH8GxY/UT7+4Cno+onlpx1v93JiomaPR9OXA5A2dP1H71O95
F7Te8Ht+RZVPUHWFlj9+65+g+46Nn7DFn32+2PKidY6g4s+un6PST0lxHvV6
SUs3kNbPqL4VnV9WHYLGVdD4oPxE5QXdfwXVqdD7xVYPs/Dmd/2w4bxTuw0/
WnqadB2UnobSYVB5ZO9TVPyl/OMK/0HxxtZv2XUvu06Q+smeX7DnL+j+jqVz
aukP0jij/EH1Xyh+ZvenbL7SmpdpzcVQ/Re7/mfvRzYe2Hlk6y3S8wuFZ615
UDs/XesMWrofG1co/ZnNA2x8oniDnS92n6XVf7nKb9jmF67rbfb8S8rP0v7L
1fxCqvO4nu+37NJ5vWtcsfUK9vxL630Vv3hg6XtR6eul16PeP9Tql13xOavO
icq5aVuH3X+h+FarX9PSt6X413p/gF0/256X3Tdp7WvtftC1LoGqf1D1G5v3
0Hqg63OQva+leQmb/qP1fytU3qV4Q8fZ9f8XpPVP2PghbPOFdnbp+0hsnmHZ
vwBVDXo4
     "], {{0, 0}, {25, 25}}, {0, 1}],
    AspectRatio->1,
    Frame->True,
    FrameLabel->{
      FormBox["\"No.  Edges in graph\"", TraditionalForm], 
      FormBox["\"Graph index\"", TraditionalForm], 
      FormBox["\"Graph index\"", TraditionalForm], 
      FormBox["\"\"", TraditionalForm]},
    FrameStyle->AbsoluteThickness[0.5],
    FrameTicks->{{{{24., 
         FormBox["\"1\"", TraditionalForm]}, {20., 
         FormBox["\"5\"", TraditionalForm]}, {14., 
         FormBox["\"11\"", TraditionalForm]}, {9., 
         FormBox["\"16\"", TraditionalForm]}, {5., 
         FormBox["\"20\"", TraditionalForm]}, {3., 
         FormBox["\"22\"", TraditionalForm]}, {1., 
         FormBox["\"24\"", TraditionalForm]}, {0., 
         FormBox["\"25\"", TraditionalForm]}}, None}, {{{0.5, 
         FormBox["\"5\"", TraditionalForm]}, {3., 
         FormBox["\"6\"", TraditionalForm]}, {8., 
         FormBox["\"7\"", TraditionalForm]}, {13.5, 
         FormBox["\"8\"", TraditionalForm]}, {18., 
         FormBox["\"9\"", TraditionalForm]}, {21., 
         FormBox["\"10\"", TraditionalForm]}, {23., 
         FormBox["\"11\"", TraditionalForm]}, {24.5, 
         FormBox["\"12\"", TraditionalForm]}}, {{1., 
         FormBox["\"1\"", TraditionalForm]}, {5., 
         FormBox["\"5\"", TraditionalForm]}, {11., 
         FormBox["\"11\"", TraditionalForm]}, {16., 
         FormBox["\"16\"", TraditionalForm]}, {20., 
         FormBox["\"20\"", TraditionalForm]}, {22., 
         FormBox["\"22\"", TraditionalForm]}, {24., 
         FormBox["\"24\"", TraditionalForm]}, {25., 
         FormBox["\"25\"", TraditionalForm]}}}},
    FrameTicksStyle->Directive[
      Opacity[0], FontOpacity -> 1],
    GridLines->{{1, 5, 11, 16, 20, 22, 24, 25}, {24, 20, 14, 9, 5, 3, 1, 0}},
    GridLinesStyle->Directive[
      GrayLevel[0], 
      AbsoluteThickness[0.16666666666666666`]],
    ImagePadding->40,
    ImageSize->270,
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Helvetica", FontSize -> 10},
    Method->{
     "GridLinesInFront" -> True, "AxisPadding" -> Scaled[0.02], 
      "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultPlotStyle" -> Automatic, "DomainPadding" -> Scaled[0.02], 
      "RangePadding" -> Scaled[0.05]},
    PlotRangePadding->0], ",", 
   TemplateBox[{StyleBox[
      StyleBox[
       PaneBox[
        GraphicsBox[{
          
          RasterBox[{{{0.468742, 0., 0.0158236}}, {{0.822129, 0.122225, 
           0.0039559}}, {{0.920685, 0.29146233333333327`, 
           0.022844033333333333`}}, {{0.9799753333333333, 0.4663636666666667, 
           0.04824903333333334}}, {{1., 0.646929, 0.0801709}}, {{1., 0.820127,
            0.126955}}}, {{
             Rational[-15, 2], -75}, {
             Rational[15, 2], 75}}], {Antialiasing -> False, 
           AbsoluteThickness[0.1], 
           Directive[
            Opacity[0.3], 
            GrayLevel[0]], 
           LineBox[
            NCache[{{
               Rational[15, 2], -75}, {
               Rational[-15, 2], -75}, {
               Rational[-15, 2], 75}, {
               Rational[15, 2], 75}, {
               Rational[15, 2], -75}}, {{7.5, -75}, {-7.5, -75}, {-7.5, 75}, {
              7.5, 75}, {7.5, -75}}]]}, {
           CapForm[None], {}}, 
          StyleBox[{Antialiasing -> False, 
            StyleBox[
             LineBox[{{7.5, -75.}, {7.5, 75.}}], 
             Directive[
              AbsoluteThickness[0.2], 
              Opacity[0.3], 
              GrayLevel[0]], StripOnInput -> False], 
            StyleBox[
             StyleBox[{{
                StyleBox[
                 LineBox[{{{7.5, -50.}, 
                    Offset[{4., 0}, {7.5, -50.}]}, {{7.5, -25.}, 
                    Offset[{4., 0}, {7.5, -25.}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 25.}, 
                    Offset[{4., 0}, {7.5, 25.}]}, {{7.5, 50.}, 
                    Offset[{4., 0}, {7.5, 50.}]}}], 
                 Directive[
                  GrayLevel[0], 
                  AbsoluteThickness[0.2]], StripOnInput -> False]}, 
               StyleBox[
                StyleBox[{{
                   StyleBox[{
                    InsetBox[
                    FormBox["1", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -50.}], {-1, 0.}, Automatic, {1, 
                    0}], 
                    InsetBox[
                    FormBox["2", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -25.}], {-1, 0.}, Automatic, {1, 
                    0}], 
                    InsetBox[
                    FormBox["3", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], {-1, 0.}, Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["4", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 25.}], {-1, 0.}, Automatic, {1, 
                    0}], 
                    InsetBox[
                    FormBox["5", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 50.}], {-1, 0.}, Automatic, {1, 
                    0}]}, 
                    Directive[
                    GrayLevel[0], 
                    AbsoluteThickness[0.2]], {
                    Directive[
                    Opacity[1], 
                    GrayLevel[0.3]]}, StripOnInput -> False]}, {}}, {
                  Directive[
                   Opacity[1], 
                   GrayLevel[0.3]]}, StripOnInput -> False], "GraphicsLabel", 
                StripOnInput -> False]}, "GraphicsTicks", StripOnInput -> 
              False], {
              Directive[
               GrayLevel[0], 
               AbsoluteThickness[0.2]]}, StripOnInput -> False]}, 
           "GraphicsAxes", StripOnInput -> False]}, PlotRangePadding -> 
         Scaled[0.02], PlotRange -> All, Frame -> True, 
         FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
         Opacity[0], FrameTicksStyle -> Opacity[0], 
         ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> Left, 
        AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}}, 
        ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
       False], {FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
      False]},
    "BarLegend",
    DisplayFunction->(#& ),
    InterpretationFunction:>(RowBox[{"BarLegend", "[", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"SolarColors\"", ",", 
             RowBox[{"{", 
               RowBox[{"0", ",", "6"}], "}"}]}], "}"}], ",", "5", ",", 
         RowBox[{"Method", "\[Rule]", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"TicksStyle", "\[Rule]", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}]}], 
             "}"}]}]}], "]"}]& )]}], "}"}]], "Output",
 CellChangeTimes->{3.7728038860739665`*^9, 3.77280391731284*^9, 
  3.7728041045239487`*^9, 3.7916276547944813`*^9, 3.791628705819728*^9, 
  3.79187091221166*^9, 3.791871191993464*^9},
 CellLabel->
  "Out[219]=",ExpressionUUID->"3a210698-9f29-4eac-bb01-6d1c08b322bc"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Evaluator->"otherlocal",
WindowSize->{958, 1108},
WindowMargins->{{-5, Automatic}, {1073, Automatic}},
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1144, 21, 228, "Text",ExpressionUUID->"6d21a25a-13df-4ee1-b3db-c52d9e784b69"],
Cell[CellGroupData[{
Cell[1727, 45, 233, 4, 67, "Section",ExpressionUUID->"71733473-9ec5-4fee-b78d-79ce04e711f7"],
Cell[CellGroupData[{
Cell[1985, 53, 222, 4, 62, "Subsubsection",ExpressionUUID->"55ab2756-0d76-4bec-86d6-0ee91ef5055e"],
Cell[2210, 59, 900, 20, 74, "Text",ExpressionUUID->"178fd3c3-153b-470a-b0fe-24b3cf25fbdc"],
Cell[3113, 81, 140784, 2261, 11276, "Input",ExpressionUUID->"2d067464-a022-4d79-8071-4fdcf6a0eb05",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[143934, 2347, 324, 5, 55, "Subsection",ExpressionUUID->"7c8d78ac-71ff-4ac6-a6f0-71c70ee256b2"],
Cell[CellGroupData[{
Cell[144283, 2356, 237, 4, 62, "Subsubsection",ExpressionUUID->"1c7f1b3a-04e9-47d1-9d98-699f343fc1b3"],
Cell[144523, 2362, 5908, 145, 560, "Input",ExpressionUUID->"43a681a6-74ba-4fbd-a7c5-f581334ff521"]
}, Closed]],
Cell[CellGroupData[{
Cell[150468, 2512, 211, 4, 54, "Subsubsection",ExpressionUUID->"b04c62fd-967c-4d87-b281-0dbbdcbd00c1"],
Cell[150682, 2518, 5784, 143, 587, "Input",ExpressionUUID->"e4b71112-6d99-460d-b097-1ac83b22f570"]
}, Closed]],
Cell[CellGroupData[{
Cell[156503, 2666, 211, 4, 54, "Subsubsection",ExpressionUUID->"2e2b421f-cc71-4771-843e-9a9def2530db"],
Cell[156717, 2672, 5795, 144, 567, "Input",ExpressionUUID->"ac43734c-b85a-407e-8eff-7481bccd98cb"]
}, Closed]],
Cell[CellGroupData[{
Cell[162549, 2821, 211, 4, 54, "Subsubsection",ExpressionUUID->"48965ab4-a6d9-4237-b158-be518aa2aada"],
Cell[162763, 2827, 5823, 143, 587, "Input",ExpressionUUID->"e2468250-3ee0-4097-8787-2a194d17cc0b"]
}, Closed]],
Cell[CellGroupData[{
Cell[168623, 2975, 280, 4, 54, "Subsubsection",ExpressionUUID->"a9cf0a88-0618-4152-9f80-8876ce24a3c6"],
Cell[CellGroupData[{
Cell[168928, 2983, 6596, 162, 674, "Input",ExpressionUUID->"274d9b41-f22d-4844-8486-a7c26eb60caa"],
Cell[CellGroupData[{
Cell[175549, 3149, 487, 8, 48, "Print",ExpressionUUID->"0c720882-8c46-4a2b-b8d7-2c3695204ea7"],
Cell[176039, 3159, 458, 7, 48, "Print",ExpressionUUID->"435c1e18-b858-4d12-87f3-b3b32e5ba462"],
Cell[176500, 3168, 458, 7, 48, "Print",ExpressionUUID->"637d74db-7c29-497a-9b35-50df24544053"],
Cell[176961, 3177, 444, 7, 48, "Print",ExpressionUUID->"ae652593-1a66-40e5-804a-cbdad61b7a19"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[177466, 3191, 338, 5, 54, "Subsubsection",ExpressionUUID->"c42432ab-bba7-45f2-8f9d-73c4be21f146"],
Cell[CellGroupData[{
Cell[177829, 3200, 1411, 39, 180, "Input",ExpressionUUID->"53391037-9d57-4855-9650-69e45cef23ea"],
Cell[CellGroupData[{
Cell[179265, 3243, 312, 6, 48, "Print",ExpressionUUID->"6d40be85-3dcd-47a2-9448-6f00729c89f1"],
Cell[179580, 3251, 285, 5, 48, "Print",ExpressionUUID->"6a67ea35-38da-4e2a-a6ab-d0cff3816583"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[179914, 3262, 5503, 129, 484, "Input",ExpressionUUID->"139c670b-916e-48b3-be9b-ff0012dc3b7c"],
Cell[CellGroupData[{
Cell[185442, 3395, 332, 6, 48, "Print",ExpressionUUID->"611d5377-a99c-42d2-b500-3cd2d7defdbe"],
Cell[185777, 3403, 335, 6, 48, "Print",ExpressionUUID->"0785315f-a790-4f9a-968b-0b4cc76bf5bf"],
Cell[186115, 3411, 316, 6, 48, "Print",ExpressionUUID->"330a6543-f2cc-4920-a091-fedca089bbea"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[186492, 3424, 233, 4, 62, "Subsubsection",ExpressionUUID->"13da6bd3-ef64-4cc8-a970-a1054d8e41e6"],
Cell[186728, 3430, 1661, 36, 180, "Input",ExpressionUUID->"3bf8d525-6733-4182-a42a-b30ff639a708"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[188438, 3472, 349, 6, 71, "Subsection",ExpressionUUID->"cf831fb6-486a-401d-9635-d78fc63291c0"],
Cell[CellGroupData[{
Cell[188812, 3482, 446, 7, 62, "Subsubsection",ExpressionUUID->"34330a43-6c9f-429c-9fd4-efdd702d4638"],
Cell[189261, 3491, 1573, 29, 85, "Input",ExpressionUUID->"b2651e37-3d3c-435f-9719-78b8526ecbab"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[190895, 3527, 289, 5, 85, "Chapter",ExpressionUUID->"a0a930aa-b9ec-4b5e-8d36-6eb56e7edf9d"],
Cell[191187, 3534, 49726, 1170, 4170, "Input",ExpressionUUID->"22bda154-9acb-4934-b086-f16c8f96ee23",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[240950, 4709, 467, 10, 88, "Title",ExpressionUUID->"2dad5fb9-fdca-4385-b630-529c3cc150d7"],
Cell[CellGroupData[{
Cell[241442, 4723, 247, 4, 62, "Subsubsection",ExpressionUUID->"2235ba26-cf26-44c6-8f71-2bbcf7ddbca8"],
Cell[241692, 4729, 5723, 113, 275, "Input",ExpressionUUID->"fd59f28c-5282-49e9-bafb-8236bc9e8cd4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[247452, 4847, 191, 3, 62, "Subsubsection",ExpressionUUID->"d781aa6f-1c36-4106-8c8a-ca1efb5a4d5f"],
Cell[CellGroupData[{
Cell[247668, 4854, 3731, 70, 199, "Input",ExpressionUUID->"438ab07c-3f1e-4695-ad9a-cf93a5eb67c2"],
Cell[CellGroupData[{
Cell[251424, 4928, 4711, 78, 172, "Print",ExpressionUUID->"86de566f-9beb-40a8-8c44-b9da969c838c"],
Cell[256138, 5008, 3069, 45, 48, "Print",ExpressionUUID->"684fa087-97cf-486d-b069-142b88c4f0c3"],
Cell[259210, 5055, 6767, 119, 128, "Print",ExpressionUUID->"136ebf24-f0ab-47b6-94b6-7a1720ca8e83"]
}, Open  ]],
Cell[265992, 5177, 80058, 1624, 303, "Output",ExpressionUUID->"a6248909-8bbb-462e-970a-521c1f7d2e7d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[346099, 6807, 325, 8, 105, "Section",ExpressionUUID->"ec0f9110-c08c-49cf-8168-e95fa03b58be"],
Cell[CellGroupData[{
Cell[346449, 6819, 166, 3, 62, "Subsubsection",ExpressionUUID->"36a564f3-9667-4c74-9eee-498a4fb7cadd"],
Cell[CellGroupData[{
Cell[346640, 6826, 1657, 40, 294, "Input",ExpressionUUID->"b7370530-4f03-4fdc-ad82-43f62857b7e6"],
Cell[348300, 6868, 29088, 661, 607, "Output",ExpressionUUID->"3a210698-9f29-4eac-bb01-6d1c08b322bc"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

