# species number predictions #

wd <- "/species_number/"
setwd(wd)

sp <- read.csv("sp2.csv")
sp.n <- sp[sp$old_status == "N"| sp$old_status == "N?", ]
sp.i <- sp[sp$old_status == "I"| sp$old_status == "I?", ]

co <- read.csv("american_matrix_MASTER.csv") #everything in 48 states.

# get county codes
fips <- read.csv("FIPS Codes.csv", colClasses='character') #county codes
fips$fips <- paste0("X",fips$StateFIPS, fips$CountyFIPS)
fips$c2 <- gsub(" Census Area", "", fips$CountyName)
fips$c2 <- gsub(" City and Borough", "", fips$c2)
fips$c2 <- gsub(" Borough", "", fips$c2)
fips$c2 <- gsub(" Municipio", "", fips$c2)
fips$c2 <- gsub(" County", "", fips$c2)
fips$c2 <- gsub("\\.", "", fips$c2)
fips$c2 <- gsub(" ", "_", fips$c2)
fips$sc <- paste0(fips$State, ".", fips$c2)
setwd("/species_number")
write.csv(fips, "county_codes.csv", row.names = FALSE)

fips <- read.csv("county_codes.csv")

# species number per county #

richness <- NULL
for(i in 1: nrow(co)){
  ss <- colnames(co)[which(co[i, ] == 1)]
  gg <- as.character(sp$genus[sp$sp %in% ss])
  ff <- as.character(sp$family[sp$sp %in% ss])
  # native richness
  ss.n <- ss[ss %in% sp.n$sp]
  gg.n <- as.character(sp.n$genus[sp.n$sp %in% ss.n])
  ff.n <- as.character(sp.n$family[sp.n$sp %in% ss.n])
  # non-native (introduced) richness
  ss.i <- ss[ss %in% sp.i$sp]
  gg.i <- as.character(sp.i$genus[sp.i$sp %in% ss.i])
  ff.i <- as.character(sp.i$family[sp.i$sp %in% ss.i])
  
  out <- cbind(fips = as.character(co$X[[i]]), state = as.character(fips$State[fips$fips == as.character(co$X[[i]])]), 
               county = as.character(fips$c2[fips$fips == as.character(co$X[[i]])]),
               sc = as.character(fips$sc[fips$fips == as.character(co$X[[i]])]), 
               species = length(ss), genus = length(unique(gg)), family = length(unique(ff)),
               species.n = length(ss.n), genus.n = length(unique(gg.n)), family.n = length(unique(ff.n)),
               species.i = length(ss.i), genus.i = length(unique(gg.i)), family.i = length(unique(ff.i)))
  richness <- rbind(richness, out)
  print(i)
}

write.csv(richness, "county_richness0501.csv", row.names = FALSE)