# Generated by Django 2.2.10 on 2020-04-15 07:56

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='cellTypes',
            fields=[
                ('cellTypeID', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('cellTypeName', models.CharField(blank=True, max_length=255)),
                ('cellOntologyTerm', models.CharField(blank=True, max_length=255)),
            ],
            options={
                'db_table': 'cellTypes',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='geneAnnotation',
            fields=[
                ('chr', models.CharField(blank=True, max_length=10)),
                ('start', models.IntegerField(blank=True)),
                ('end', models.IntegerField(blank=True)),
                ('geneID', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('geneSymbol', models.CharField(blank=True, max_length=255)),
                ('alternativeGeneID', models.CharField(blank=True, max_length=255)),
                ('isTF', models.CharField(blank=True, max_length=255, null=True)),
                ('strand', models.CharField(blank=True, max_length=1)),
            ],
            options={
                'db_table': 'geneAnnotation',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='genomeAnnotation',
            fields=[
                ('genomeVersion', models.CharField(blank=True, max_length=4)),
                ('annotationVersion', models.CharField(max_length=3, primary_key=True, serialize=False)),
                ('databaseName', models.CharField(blank=True, max_length=255)),
            ],
            options={
                'db_table': 'genomeAnnotation',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='REMAnnotation',
            fields=[
                ('chr', models.CharField(blank=True, max_length=10)),
                ('start', models.IntegerField(blank=True)),
                ('end', models.IntegerField(blank=True)),
                ('REMID', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('regressionCoefficient', models.FloatField(blank=True)),
                ('pValue', models.FloatField(blank=True)),
                ('normModelScore', models.FloatField(blank=True)),
                ('meanDNase1Signal', models.FloatField(blank=True)),
                ('sdDNase1Signal', models.FloatField(blank=True)),
                ('consortium', models.CharField(blank=True, max_length=1)),
                ('version', models.IntegerField(blank=True)),
                ('geneID', models.ForeignKey(db_column='geneID', on_delete=django.db.models.deletion.DO_NOTHING, to='table_manager.geneAnnotation')),
            ],
            options={
                'db_table': 'REMAnnotation',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CREMAnnotation',
            fields=[
                ('REMID', models.OneToOneField(db_column='REMID', max_length=30, on_delete=django.db.models.deletion.DO_NOTHING, primary_key=True, serialize=False, to='table_manager.REMAnnotation')),
                ('CREMID', models.CharField(max_length=255)),
                ('chr', models.CharField(blank=True, max_length=10)),
                ('start', models.IntegerField(blank=True)),
                ('end', models.IntegerField(blank=True)),
                ('REMsPerCREM', models.IntegerField(blank=True)),
                ('version', models.IntegerField(blank=True)),
            ],
            options={
                'db_table': 'CREMAnnotation',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='sampleInfo',
            fields=[
                ('sampleID', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('originalSampleID', models.CharField(blank=True, max_length=255)),
                ('origin', models.CharField(blank=True, max_length=255)),
                ('dataType', models.CharField(blank=True, max_length=255)),
                ('cellTypeID', models.ForeignKey(db_column='cellTypeID', on_delete=django.db.models.deletion.DO_NOTHING, to='table_manager.cellTypes')),
            ],
            options={
                'db_table': 'sampleInfo',
                'managed': True,
            },
        ),
        migrations.AddField(
            model_name='geneannotation',
            name='annotationVersion',
            field=models.ForeignKey(db_column='annotationVersion', on_delete=django.db.models.deletion.DO_NOTHING, to='table_manager.genomeAnnotation'),
        ),
        migrations.CreateModel(
            name='REMActivity',
            fields=[
                ('REMID', models.OneToOneField(db_column='REMID', on_delete=django.db.models.deletion.DO_NOTHING, primary_key=True, serialize=False, to='table_manager.REMAnnotation')),
                ('dnase1Log2', models.FloatField(blank=True)),
                ('standDnase1Log2', models.FloatField(blank=True)),
                ('version', models.IntegerField(blank=True)),
                ('sampleID', models.ForeignKey(db_column='sampleID', on_delete=django.db.models.deletion.DO_NOTHING, to='table_manager.sampleInfo')),
            ],
            options={
                'db_table': 'REMActivity',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='geneExpression',
            fields=[
                ('geneID', models.OneToOneField(db_column='geneID', on_delete=django.db.models.deletion.DO_NOTHING, primary_key=True, serialize=False, to='table_manager.geneAnnotation')),
                ('expressionLog2TPM', models.FloatField(blank=True)),
                ('species', models.CharField(max_length=255)),
                ('sampleID', models.ForeignKey(db_column='sampleID', on_delete=django.db.models.deletion.DO_NOTHING, to='table_manager.sampleInfo')),
            ],
            options={
                'db_table': 'geneExpression',
                'managed': True,
            },
        ),
    ]
