rm(list = ls())
########
nothoudots<-function(x){
  y<-rep(0.,length(x))
  for (i in c(1:length(x))){
    if(nchar(x[i])==11) y[i]<-as.numeric(substr(as.character(x[i]),1,2))*1000000+as.numeric(substr(as.character(x[i]),4,6))*1000+as.numeric(substr(as.character(x[i]),8,10)) 
    if(nchar(x[i])==10) y[i]<-as.numeric(substr(as.character(x[i]),1,2))*1000000+as.numeric(substr(as.character(x[i]),4,6))*1000+as.numeric(substr(as.character(x[i]),8,10)) 
    if(nchar(x[i])==9) y[i]<-as.numeric(substr(as.character(x[i]),1,1))*1000000+as.numeric(substr(as.character(x[i]),3,5))*1000+as.numeric(substr(as.character(x[i]),7,9)) 
    if(nchar(x[i])==7) y[i]<-as.numeric(substr(as.character(x[i]),1,3))*1000+as.numeric(substr(as.character(x[i]),5,7)) 
    if(nchar(x[i])==6) y[i]<-as.numeric(substr(as.character(x[i]),1,2))*1000+as.numeric(substr(as.character(x[i]),4,6)) 
    if(nchar(x[i])==5) y[i]<-as.numeric(substr(as.character(x[i]),1,1))*1000+as.numeric(substr(as.character(x[i]),3,5)) 
    if(nchar(x[i])==3) y[i]<-as.numeric(as.character(x[i])) 
    if(nchar(x[i])==2) y[i]<-as.numeric(as.character(x[i])) 
    if(nchar(x[i])==1) y[i]<-as.numeric(as.character(x[i])) 
    if(nchar(x[i])==0) y[i]->is.na
  }
  return(y)
}
#
setwd("~/Dropbox/ND_TP_baseline2018")
#
######
# Defunciones Espana por Sexo, Periodo 1975 2018, y Provincias   
# https://www.ine.es/jaxiT3/Tabla.htm?t=6545 
# Movimiento Natural de la Población: Defunciones
# Defunciones (Cifras anuales) 
# Por lugar de residencia y sexo. Total nacional y provincias
#
datini<-read.csv("6545.csv",header=TRUE,sep=";",dec=",")
summary(datini)
datini[,1]<-factor(datini[,1])
datini[,2]<-factor(datini[,2])
levels(datini$Sexo)<-c("H","M","T")
datini[,3]<-as.numeric(datini[,3])
datini[,4]<-nothoudots(as.character(datini[,4]))
dat_ND_SPP<-cbind(datini[-1],datini[1])
summary(dat_ND_SPP)
######
# Defunciones totales de Espana por Sexo, Periodo 1975 2018  
#
dat_ND_SP<-datini[datini$Provincias=="Total",-1]
summary(dat_ND_SP)
#
save(dat_ND_SP,dat_ND_SPP,file="6545.RData")
#
#######
# Defunciones Espana por Sexo, Edad, Periodo 1975 2018, y Provincias   
# https://www.ine.es/jaxiT3/Tabla.htm?t=6547 
# Movimiento Natural de la Población: Defunciones
# Defunciones (Cifras anuales) 
# Por lugar de residencia, sexo y edad. Total nacional y provincias
datini<-read.csv("6547.csv",header=TRUE,sep=";",dec=",")
#
datini[,1]<-factor(datini[,1]) 
datini[,2]<-factor(datini[,2]) 
levels(datini[,2])<-c("H","M","T")
#
#levels(datini[,3])
levels(datini[,3])[3]<-"-1"
levels(datini[,3])[101]<-"0 "
levels(datini[,3])<-substr(levels(datini[,3]),1,2)
#levels(datini[,3])
#
datini[,3]<-as.numeric(as.character(datini[,3]))
datini[datini[,3]<=-0.99,3]<-100
#
datini[,5]<-nothoudots(as.character(datini[,5]))
colnames(datini)[5]<-c("ND")
#
datini<-cbind(datini[-1],datini[1])
summary(datini)
#
dat_ND_SEPP<-datini[!datini$Provincias=="Total",]
dat_ND_SEPP$Provincias<-droplevels(dat_ND_SEPP$Provincias)
summary(dat_ND_SEPP)
#
#######
# Defunciones Espana por Sexo, Edad, Periodo 1975 2018, SUMA de Provincias   
#
datini<-dat_ND_SEPP
#
datini[,1]<-factor(datini[,1])
datini[,2]<-factor(datini[,2])
datini[,3]<-factor(datini[,3])
n1<-length(levels(datini[,1]))
n2<-length(levels(datini[,2]))
n3<-length(levels(datini[,3]))
summary(datini)
#
auxi<-as.numeric(datini[,1])
auxj<-as.numeric(datini[,2])
auxk<-as.numeric(datini[,3])
auxe<-datini$Provincias=="Extranjero"
#
for (i in c(1:n1)) { 
  for (j in c(1:n2)) {
    print(c(i,j))
    flg0<-auxi==i&auxj==j
    for (k in c(1:n3)) {
      flg<-flg0&auxk==k
      aux<-sum(datini[flg,4])
      datini[flg&auxe,4]<-aux
    }
  }
}
summary(datini)
#
datini<-datini[auxe,]
datini[,3]<-as.numeric(datini[,3])-1+1975
dat_ND_SEP<-datini[-5]
summary(dat_ND_SEP)
#
save(dat_ND_SEP,dat_ND_SEPP,file="6547.RData")
#
######
# Defunciones Espana por Provincias, Periodo Mensual 1975 2018  
# https://www.ine.es/jaxiT3/Tabla.htm?t=6561 
# Movimiento Natural de la Población: Defunciones
# Defunciones (Cifras mensuales)
# Por lugar de residencia. (Serie desde 1975). Total nacional y provincias 
#
datini<-read.csv("6561.csv",header=TRUE,sep=";",dec=",")
#
datini[,1]<-factor(datini[,1])
datini[,2]<-factor(datini[,2])
datini[,3]<-nothoudots(as.character(datini[,3]))
#
Years<-substr(datini$Periodo,1,4)
Months<-substr(datini$Periodo,6,7)
Periodo<-as.numeric(datini[,2])
#
dat_ND_MP<-cbind(Periodo,Years,Months,datini[,c(3,1)])
summary(dat_ND_MP)
#
save(dat_ND_MP,file="6561.RData")
#