# Environmental Drivers of Golden Tilefish Landings

These data and code support the results presented in (recommended citation):

Nesslage G, Lyubchich V, Nitschke P, Williams E, Grimes C, Wiedenmann J (2020)
Environmental drivers of golden tilefish (*Lopholatilus chamaeleonticeps*) landings and catch per unit effort.
In progress.

The current data and code:

Lyubchich V, Nesslage G (2020) github.com/vlyubchich/tilefish: Environmental Drivers of Golden Tilefish Landings. Zenodo. DOI 10.5281/zenodo.3732840.


## Data

The input data are located in the folder **dataraw**. 
The folder **dataderived** contains some intermediate outputs of the analysis.


## Analysis

The analysis is written in the knitr file **landings.Rnw**. For convenience,
the compiled output **landings.pdf** (containing both the R code and outputs) 
is also provided.
The analysis of catch per unit effort (CPUE) uses similar codes. 
The CPUE data are not provided due to federal confidentiality restrictions.


## Bibtex

Bibtex entry for the data and code:

```javascript
@software{lyubchich_3732840,
  author = {Lyubchich, V and Nesslage, G},
  title = {{github.com/vlyubchich/tilefish: Environmental Drivers of Golden Tilefish Landings}},
  year = 2020,
  publisher = {Zenodo},
  version = {v1.0},
  doi = {10.5281/zenodo.3732840},
  url = {https://doi.org/10.5281/zenodo.3732840}
}
```

Bibtex entry for the article:

```javascript
@article{Nesslage:etal:2020:environmental,
  author = {Nesslage, G and Lyubchich, V and Nitschke, P and Williams, E and Grimes, C and Wiedenmann, J},
  title = {Environmental drivers of golden tilefish (\emph{{Lopholatilus chamaeleonticeps}}) landings and catch per unit effort},
  journal = {},
  pages = {},
  year = {2020},
  note = {In progress}
}
```



