bootStrap_acoeff12<-function(sizes,nsim=100,plotting=TRUE)
{
sizes<-jitter(sizes)
As<-numeric(length=nsim)
A1s<-numeric(length=nsim)
A2s<-numeric(length=nsim)
tsize<-vector("list",nsim)



for (n in 1:nsim)
{
tsize[[n]]<-sample(sizes,replace=TRUE)
tmp<-a12coeff(tsize[[n]],plotting=FALSE)
A1s[n]<-tmp$A1
A2s[n]<-tmp$A2
As[n]<-tmp$A1-tmp$A2
}

tmp<-a12coeff(sizes,plotting=FALSE)
obsA1<-tmp$A1
obsA2<-tmp$A2
obsA<-obsA1-obsA2

diffA=mean(As)-obsA
diffA1=mean(A1s)-obsA1
diffA2=mean(A2s)-obsA2


As=As-diffA
A1s=A1s-diffA1
A2s=A2s-diffA2


if (plotting==TRUE)
  {
    par(mfrow=c(3,1))
    hist(As,col="grey",xlab="A")
    abline(v=obsA,col="red")
    hist(A1s,col="grey",xlab="A1")
    abline(v=obsA1,col="red")
    hist(A2s,col="grey",xlab="A2")
    abline(v=obsA2,col="red")

  }



return(list(obsA=obsA,envA=quantile(As,c(0.025,0.975)),obsA1=obsA1,envA1=quantile(A1s,c(0.025,0.975)),obsA2=obsA2,envA2=quantile(A2s,c(0.025,0.975)),raw=list(A1s,A2s,tsize)))
}
