

# Install library if not installed -------------------------------------####
if (!('rgdal' %in% installed.packages())){
  install.packages('rgdal')
}

#Load required library
library(rgdal)

#Load shape files
IronAge<-readOGR("shp/Iron_Age.shp",layer="Iron_Age") #Iron Age period
Archaic<-readOGR("shp/Archaic_new.shp",layer="Archaic_new") #Archaic period
PostArchaic<-readOGR("shp/Post_Archaic.shp",layer="Post_Archaic") #Post-Archaic period

#create dataframes for rank-size analysis
IronAge<-as.data.frame(IronAge[,1:7])
Archaic<-as.data.frame(Archaic[,1:7])
PostArchaic<-as.data.frame(PostArchaic[,1:7])

#plot histograms for site size (Fig. 6 of the paper)
pdf(file="pdf/Fig6.pdf", height=9, width=6) #define width and heigth of the figure to plot as a pdf file
layout(matrix(c(1,2,3,4,5,6,7,8,9),3,3, byrow=TRUE),height=c(3,3,3), widths=c(2,2,2)) #define the layout for the three histograms
hist(IronAge$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Iron Age (all sites)", breaks=seq(0,200,10),  col="white")
mtext("a",1, 2, adj=-0.2, font=2, cex=0.75)
hist(IronAge$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="0-50 ha", breaks=seq(0,200,5), xlim=c(0,50), col="white")
mtext("b",1, 2, adj=-0.2, font=2, cex=0.75)
hist(IronAge$SizeHa, cex.axis=0.75, xlab="Estimated Size(ha)", ylab="Site Count", main="50-200 ha", breaks=seq(0,200,10), xlim=c(50,200), ylim=c(0,4), col="white")
mtext("c",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Archaic$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Archaic (all sites)", breaks=seq(0,200,10),  col="white")
mtext("d",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Archaic$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="0-50 ha", breaks=seq(0,200,5), xlim=c(0,50), col="white")
mtext("e",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Archaic$SizeHa, cex.axis=0.75, xlab="Estimated Size(ha)", ylab="Site Count", main="50-200 ha", breaks=seq(0,200,10), xlim=c(50,200), ylim=c(0,4), col="white")
mtext("f",1, 2, adj=-0.2, font=2, cex=0.75)
hist(PostArchaic$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Post-Archaic (all sites)", breaks=seq(0,200,10),  col="white")
mtext("g",1, 2, adj=-0.2, font=2, cex=0.75)
hist(PostArchaic$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="0-50 ha", breaks=seq(0,200,5), xlim=c(0,50), col="white")
mtext("h",1, 2, adj=-0.2, font=2, cex=0.75)
hist(PostArchaic$SizeHa, cex.axis=0.75, xlab="Estimated Size(ha)", ylab="Site Count", main="50-200 ha", breaks=seq(0,200,10), xlim=c(50,200), ylim=c(0,4), col="white")
mtext("i",1, 2, adj=-0.2, font=2, cex=0.75)
dev.off()

#create zipfian law
IronAge_zipf=max(sort(IronAge$SizeHa,decreasing = TRUE))/(1:length(IronAge$SizeHa))
Archaic_zipf=max(sort(Archaic$SizeHa,decreasing = TRUE))/(1:length(Archaic$SizeHa))
PostArchaic_zipf=max(sort(PostArchaic$SizeHa,decreasing = TRUE))/(1:length(PostArchaic$SizeHa))

#PLOT ALL GRAPHS
x11(height=5,width=8) #define the width and heigth of the graph to plot
par(mar=c(2.5,3,1,3),mgp=c(1.5,0.5,0), mfrow=c(2,3))

#IRON AGE
#create a bootstrap sample 
random_data<-sample(IronAge$SizeHa,485,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(IronAge$SizeHa,485,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(IronAge$SizeHa)),y=log(sort(IronAge$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
#ymax=log(max(Volterra$SizeHa))
mtext("a",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first bootstrap sample
lines(log(x=1:length(IronAge$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(IronAge$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(IronAge$SizeHa)),y=log(sort(IronAge$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(IronAge$SizeHa)),log(sort(IronAge$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(IronAge$SizeHa)),log(IronAge_zipf),lty=2)
#text(x=2, ymax*0.98, labels="Volterra", font=2, cex=1, adj=c(0,0.7))

#ARCHAIC
#create a bootstrap sample 
random_data<-sample(Archaic$SizeHa,1112,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Archaic$SizeHa,1112,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Archaic$SizeHa)),y=log(sort(Archaic$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("b",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first bootstrap sample
lines(log(x=1:length(Archaic$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Archaic$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Archaic$SizeHa)),y=log(sort(Archaic$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Archaic$SizeHa)),log(sort(Archaic$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Archaic$SizeHa)),log(Archaic_zipf),lty=2)


#POST-ARCHAIC
#create a bootstrap sample 
random_data<-sample(PostArchaic$SizeHa,807,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(PostArchaic$SizeHa,807,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(PostArchaic$SizeHa)),y=log(sort(PostArchaic$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("c",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first bootstrap sample
lines(log(x=1:length(PostArchaic$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(PostArchaic$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(PostArchaic$SizeHa)),y=log(sort(PostArchaic$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(PostArchaic$SizeHa)),log(sort(PostArchaic$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(PostArchaic$SizeHa)),log(PostArchaic_zipf),lty=2)


############################## Scenario 2 ################################################################################

#create dataframes for rank-size analysis
IronAge2<-as.data.frame(IronAge[,1:7])
Archaic2<-as.data.frame(Archaic[,1:7])
PostArchaic2<-as.data.frame(PostArchaic[,1:7])

#subset each dataset with sites greater than 0.5 ha
IronAge2<-subset(IronAge2, IronAge2$SizeHa>0.5)
Archaic2<-subset(Archaic2, Archaic2$SizeHa>0.5)
PostArchaic2<-subset(PostArchaic2, PostArchaic2$SizeHa>0.5)

#create zipfian law
IronAge2_zipf=max(sort(IronAge2$SizeHa,decreasing = TRUE))/(1:length(IronAge2$SizeHa))
Archaic2_zipf=max(sort(Archaic2$SizeHa,decreasing = TRUE))/(1:length(Archaic2$SizeHa))
PostArchaic2_zipf=max(sort(PostArchaic2$SizeHa,decreasing = TRUE))/(1:length(PostArchaic2$SizeHa))


#IRON AGE
#create a bootstrap sample 
random_data<-sample(IronAge2$SizeHa,150,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(IronAge2$SizeHa,150,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(IronAge2$SizeHa)),y=log(sort(IronAge2$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("e",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(IronAge2$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(IronAge2$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(IronAge2$SizeHa)),y=log(sort(IronAge2$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(IronAge2$SizeHa)),log(sort(IronAge2$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(IronAge2$SizeHa)),log(IronAge2_zipf),lty=2)

#ARCHAIC
#create a bootstrap sample 
random_data<-sample(Archaic2$SizeHa,239,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Archaic2$SizeHa,239,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Archaic2$SizeHa)),y=log(sort(Archaic2$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("f",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Archaic2$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Archaic2$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Archaic2$SizeHa)),y=log(sort(Archaic2$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Archaic2$SizeHa)),log(sort(Archaic2$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Archaic2$SizeHa)),log(Archaic2_zipf),lty=2)


#POST-ARCHAIC
#create a bootstrap sample 
random_data<-sample(PostArchaic2$SizeHa,221,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(PostArchaic2$SizeHa,221,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(PostArchaic2$SizeHa)),y=log(sort(PostArchaic2$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("g",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(PostArchaic2$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(PostArchaic2$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(PostArchaic2$SizeHa)),y=log(sort(PostArchaic2$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(PostArchaic2$SizeHa)),log(sort(PostArchaic2$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(PostArchaic2$SizeHa)),log(PostArchaic2_zipf),lty=2)

dev.print(device=pdf, file="pdf/Fig8.pdf") #save the file in the folder pdf

############################# CALCULATE A-COEFFICIENTS  ###################################################

#IRON AGE
#source the codes in the subfolder "src" in order to load two functions for calculating the A-coefficient. Courtesy of Enrico Crema (Cambridge University). See: https://link.springer.com/article/10.1007/s10816-013-9185-4.   
source("src/a12coeff.R") 
source("src/bootStrap_acoeff12.R") 

#calculate the observed A-coefficient (with plot):
a12coeff(IronAge$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(IronAge$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#ARCHAIC
#calculate the observed A-coefficient (with plot):
a12coeff(Archaic$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Archaic$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#POST-ARCHAIC
#calculate the observed A-coefficient (with plot):
a12coeff(PostArchaic$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(PostArchaic$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

############## SCENARIO 2 ############################
#IRON AGE
#calculate the observed A-coefficient (with plot):
a12coeff(IronAge2$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(IronAge2$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#ARCHAIC
#calculate the observed A-coefficient (with plot):
a12coeff(Archaic2$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Archaic2$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#POST-ARCHAIC
#calculate the observed A-coefficient (with plot):
a12coeff(PostArchaic2$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(PostArchaic2$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

