
# Install library if not installed -------------------------------------####
if (!('rgdal' %in% installed.packages())){
  install.packages('rgdal')
}

#Load required library
library(rgdal)

#Load data
PostArchaic<-readOGR("shp/Post_Archaic.shp",layer="Post_Archaic") # load shape file

#load Xtent polygons
xtent_PostArchaic<-readOGR("shp/xtent_k0016.shp", layer="xtent_k0016")

#create dataframes for rank-size analysis
Volterra<-as.data.frame(PostArchaic[,1:7])
Fiesole<-as.data.frame(PostArchaic[,1:7])
Populonia<-as.data.frame(PostArchaic[,1:7])
Vetulonia<-as.data.frame(PostArchaic[,1:7])
Chiusi<-as.data.frame(PostArchaic[,1:7])
Vulci<-as.data.frame(PostArchaic[,1:7])
Orvieto<-as.data.frame(PostArchaic[,1:7])
Tarquinia<-as.data.frame(PostArchaic[,1:7])
Cerveteri<-as.data.frame(PostArchaic[,1:7])
Veii<-as.data.frame(PostArchaic[,1:7])

#Spatial query: selection of points (datesp) located within each xtent territory
query_Volterra<-over(PostArchaic,xtent_PostArchaic[xtent_PostArchaic$sitename=="Volterra",])
query_Fiesole<-over(PostArchaic,xtent_PostArchaic[xtent_PostArchaic$sitename=="Fiesole",])
query_Populonia<-over(PostArchaic,xtent_PostArchaic[xtent_PostArchaic$sitename=="Populonia",])
query_Vetulonia<-over(PostArchaic,xtent_PostArchaic[xtent_PostArchaic$sitename=="Vetulonia",])
query_Chiusi<-over(PostArchaic,xtent_PostArchaic[xtent_PostArchaic$sitename=="Chiusi",])
query_Vulci<-over(PostArchaic,xtent_PostArchaic[xtent_PostArchaic$sitename=="Vulci",])
query_Orvieto<-over(PostArchaic,xtent_PostArchaic[xtent_PostArchaic$sitename=="Orvieto",])
query_Tarquinia<-over(PostArchaic,xtent_PostArchaic[xtent_PostArchaic$sitename=="Tarquinia",])
query_Cerveteri<-over(PostArchaic,xtent_PostArchaic[xtent_PostArchaic$sitename=="Cerveteri",])
query_Veii<-over(PostArchaic,xtent_PostArchaic[xtent_PostArchaic$sitename=="Veii",])

#add spatial query column to the dataframe
Volterra["query"]<-NA
Fiesole["query"]<-NA
Populonia["query"]<-NA
Vetulonia["query"]<-NA
Chiusi["query"]<-NA
Vulci["query"]<-NA
Orvieto["query"]<-NA
Tarquinia["query"]<-NA
Cerveteri["query"]<-NA
Veii["query"]<-NA

#update the column of the dataframe
Volterra$query<-query_Volterra$sitename
Fiesole$query<-query_Fiesole$sitename
Populonia$query<-query_Populonia$sitename
Vetulonia$query<-query_Vetulonia$sitename
Chiusi$query<-query_Chiusi$sitename
Vulci$query<-query_Vulci$sitename
Orvieto$query<-query_Orvieto$sitename
Tarquinia$query<-query_Tarquinia$sitename
Cerveteri$query<-query_Cerveteri$sitename
Veii$query<-query_Veii$sitename

#subset the sites located within each xtent territory
Volterra<-subset(Volterra,Volterra$query=="Volterra")
Fiesole<-subset(Fiesole,Fiesole$query=="Fiesole")
Populonia<-subset(Populonia,Populonia$query=="Populonia")
Vetulonia<-subset(Vetulonia,Vetulonia$query=="Vetulonia")
Chiusi<-subset(Chiusi,Chiusi$query=="Chiusi")
Vulci<-subset(Vulci,Vulci$query=="Vulci")
Orvieto<-subset(Orvieto,Orvieto$query=="Orvieto")
Tarquinia<-subset(Tarquinia,Tarquinia$query=="Tarquinia")
Cerveteri<-subset(Cerveteri,Cerveteri$query=="Cerveteri")
Veii<-subset(Veii,Veii$query=="Veii")

##################################################################################################################
#RANK-SIZE analysis for each xtent territory

#create zipfian law
Volterra_zipf=max(sort(Volterra$SizeHa,decreasing = TRUE))/(1:length(Volterra$SizeHa))
Fiesole_zipf=max(sort(Fiesole$SizeHa,decreasing = TRUE))/(1:length(Fiesole$SizeHa))
Populonia_zipf=max(sort(Populonia$SizeHa,decreasing = TRUE))/(1:length(Populonia$SizeHa))
Vetulonia_zipf=max(sort(Vetulonia$SizeHa,decreasing = TRUE))/(1:length(Vetulonia$SizeHa))
Chiusi_zipf=max(sort(Chiusi$SizeHa,decreasing = TRUE))/(1:length(Chiusi$SizeHa))
Vulci_zipf=max(sort(Vulci$SizeHa,decreasing = TRUE))/(1:length(Vulci$SizeHa))
Orvieto_zipf=max(sort(Orvieto$SizeHa,decreasing = TRUE))/(1:length(Orvieto$SizeHa))
Tarquinia_zipf=max(sort(Tarquinia$SizeHa,decreasing = TRUE))/(1:length(Tarquinia$SizeHa))
Cerveteri_zipf=max(sort(Cerveteri$SizeHa,decreasing = TRUE))/(1:length(Cerveteri$SizeHa))
Veii_zipf=max(sort(Veii$SizeHa,decreasing = TRUE))/(1:length(Veii$SizeHa))

#Create Bootstrap 1000 simulations envelope for each xtent territory
#PLOT ALL GRAPHS
x11(height=10,width=8) # define the width and length of the graph to plot
par(mar=c(2.5,3,1,3),mgp=c(1.5,0.5,0), mfrow=c(4,3))

#VOLTERRA
#create a bootstrap sample 
random_data<-sample(Volterra$SizeHa,45,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Volterra$SizeHa,45,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Volterra$SizeHa)),y=log(sort(Volterra$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("a",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Volterra$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Volterra$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Volterra$SizeHa)),y=log(sort(Volterra$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Volterra$SizeHa)),log(sort(Volterra$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Volterra$SizeHa)),log(Volterra_zipf),lty=2)
#text(x=2, ymax*0.98, labels="Volterra", font=2, cex=1, adj=c(0,0.7))


#FIESOLE
#create a bootstrap sample 
random_data<-sample(Fiesole$SizeHa,41,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Fiesole$SizeHa,41,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Fiesole$SizeHa)),y=log(sort(Fiesole$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("b",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Fiesole$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Fiesole$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Fiesole$SizeHa)),y=log(sort(Fiesole$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Fiesole$SizeHa)),log(sort(Fiesole$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Fiesole$SizeHa)),log(Fiesole_zipf),lty=2)

#POPULONIA
#create a bootstrap sample 
random_data<-sample(Populonia$SizeHa,2,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Populonia$SizeHa,2,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Populonia$SizeHa)),y=log(sort(Populonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)") 
mtext("c",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Populonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Populonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Populonia$SizeHa)),y=log(sort(Populonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Populonia$SizeHa)),log(sort(Populonia$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Populonia$SizeHa)),log(Populonia_zipf),lty=2)

#VETULONIA
#create a bootstrap sample 
random_data<-sample(Vetulonia$SizeHa,28,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Vetulonia$SizeHa,28,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(Vetulonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("d",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(Vetulonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Vetulonia$SizeHa)),log(sort(Vetulonia$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Vetulonia$SizeHa)),log(Vetulonia_zipf),lty=2)

#CHIUSI
#create a bootstrap sample 
random_data<-sample(Chiusi$SizeHa,53,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Chiusi$SizeHa,53,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Chiusi$SizeHa)),y=log(sort(Chiusi$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("e",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Chiusi$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Chiusi$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Chiusi$SizeHa)),y=log(sort(Chiusi$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Chiusi$SizeHa)),log(sort(Chiusi$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Chiusi$SizeHa)),log(Chiusi_zipf),lty=2)


#VULCI
#create a bootstrap sample 
random_data<-sample(Vulci$SizeHa,104,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Vulci$SizeHa,104,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Vulci$SizeHa)),y=log(sort(Vulci$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("f",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Vulci$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Vulci$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Vulci$SizeHa)),y=log(sort(Vulci$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Vulci$SizeHa)),log(sort(Vulci$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Vulci$SizeHa)),log(Vulci_zipf),lty=2)


#ORVIETO
#create a bootstrap sample 
random_data<-sample(Orvieto$SizeHa,20,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Orvieto$SizeHa,20,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Orvieto$SizeHa)),y=log(sort(Orvieto$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("g",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Orvieto$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Orvieto$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Orvieto$SizeHa)),y=log(sort(Orvieto$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Orvieto$SizeHa)),log(sort(Orvieto$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Orvieto$SizeHa)),log(Orvieto_zipf),lty=2)

#TARQUINIA
#create a bootstrap sample 
random_data<-sample(Tarquinia$SizeHa,264,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Tarquinia$SizeHa,264,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(Tarquinia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("h",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(Tarquinia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Tarquinia$SizeHa)),log(sort(Tarquinia$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Tarquinia$SizeHa)),log(Tarquinia_zipf),lty=2)


#CERVETERI
#create a bootstrap sample 
random_data<-sample(Cerveteri$SizeHa,65,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Cerveteri$SizeHa,65,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(Cerveteri$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("i",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(Cerveteri$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Cerveteri$SizeHa)),log(sort(Cerveteri$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Cerveteri$SizeHa)),log(Cerveteri_zipf),lty=2)

#VEII
#create a bootstrap sample 
random_data<-sample(Veii$SizeHa,172,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Veii$SizeHa,172,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Veii$SizeHa)),y=log(sort(Veii$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("j",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Veii$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Veii$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Veii$SizeHa)),y=log(sort(Veii$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Veii$SizeHa)),log(sort(Veii$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Veii$SizeHa)),log(Veii_zipf),lty=2)


#save the plot as a .pdf file in the folder pdf
dev.print(device=pdf, "pdf/Fig11.pdf")


############################# CALCULATE A-COEFFICIENTS OF ALL XTENT TERRITORIES ###############################

#source the codes in the subfolder "src" in order to load two functions for calculating the A-coefficient. Courtesy of Enrico Crema (Cambridge University). See: https://link.springer.com/article/10.1007/s10816-013-9185-4.   

source("src/a12coeff.R") 
source("src/bootStrap_acoeff12.R") 

#VOLTERRA
#calculate the observed A-coefficient (with plot):
a12coeff(Volterra$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Volterra$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#FIESOLE
#calculate the observed A-coefficient (with plot):
a12coeff(Fiesole$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Fiesole$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#POPULONIA
#calculate the observed A-coefficient (with plot):
a12coeff(Populonia$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Populonia$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#VETULONIA
#calculate the observed A-coefficient (with plot):
a12coeff(Vetulonia$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Vetulonia$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#CHIUSI
#calculate the observed A-coefficient (with plot):
a12coeff(Chiusi$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Chiusi$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 


#VULCI
#calculate the observed A-coefficient (with plot):
a12coeff(Vulci$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Vulci$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#ORVIETO
#calculate the observed A-coefficient (with plot):
a12coeff(Orvieto$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Orvieto$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2

#TARQUINIA
#calculate the observed A-coefficient (with plot):
a12coeff(Tarquinia$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Tarquinia$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#CERVETERI
#calculate the observed A-coefficient (with plot):
a12coeff(Cerveteri$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Cerveteri$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2

#VEII
#calculate the observed A-coefficient (with plot):
a12coeff(Veii$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Veii$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 



