
# Install library if not installed -------------------------------------####
if (!('rgdal' %in% installed.packages())){
  install.packages('rgdal')
}

#Load required library
library(rgdal)

#Load data
Iron_Age<-readOGR("shp/Iron_Age.shp",layer="Iron_Age") # load shape file

#load Xtent polygons
xtent_IronAge<-readOGR("shp/xtent_k055.shp", layer="xtent_k055")

#create dataframes for rank-size analysis
Volterra<-as.data.frame(Iron_Age[,1:7])
Populonia<-as.data.frame(Iron_Age[,1:7])
Murlo<-as.data.frame(Iron_Age[,1:7])
Vetulonia<-as.data.frame(Iron_Age[,1:7])
Vulci<-as.data.frame(Iron_Age[,1:7])
Bisenzio<-as.data.frame(Iron_Age[,1:7])
Acquarossa<-as.data.frame(Iron_Age[,1:7])
Orvieto<-as.data.frame(Iron_Age[,1:7])
Tarquinia<-as.data.frame(Iron_Age[,1:7])
Cerveteri<-as.data.frame(Iron_Age[,1:7])
Veii<-as.data.frame(Iron_Age[,1:7])
Civita_Castellana<-as.data.frame(Iron_Age[,1:7])

#Spatial query: selection of points (datesp) located within each xtent territory
query_Volterra<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Volterra",])
query_Populonia<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Populonia",])
query_Murlo<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Murlo",])
query_Vetulonia<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Vetulonia",])
query_Vulci<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Vulci",])
query_Bisenzio<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Bisenzio",])
query_Acquarossa<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Acquarossa",])
query_Orvieto<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Orvieto",])
query_Tarquinia<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Tarquinia",])
query_Cerveteri<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Cerveteri",])
query_Veii<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Veii",])
query_Civita_Castellana<-over(Iron_Age,xtent_IronAge[xtent_IronAge$sitename=="Civita Castellana",])

#add spatial query column to the dataframe
Volterra["query"]<-NA
Populonia["query"]<-NA
Murlo["query"]<-NA
Vetulonia["query"]<-NA
Vulci["query"]<-NA
Bisenzio["query"]<-NA
Acquarossa["query"]<-NA
Orvieto["query"]<-NA
Tarquinia["query"]<-NA
Cerveteri["query"]<-NA
Veii["query"]<-NA
Civita_Castellana["query"]<-NA

#update the column of the dataframe
Volterra$query<-query_Volterra$sitename
Populonia$query<-query_Populonia$sitename
Murlo$query<-query_Murlo$sitename
Vetulonia$query<-query_Vetulonia$sitename
Vulci$query<-query_Vulci$sitename
Bisenzio$query<-query_Bisenzio$sitename
Acquarossa$query<-query_Acquarossa$sitename
Orvieto$query<-query_Orvieto$sitename
Tarquinia$query<-query_Tarquinia$sitename
Cerveteri$query<-query_Cerveteri$sitename
Veii$query<-query_Veii$sitename
Civita_Castellana$query<-query_Civita_Castellana$sitename

#subset the sites located within each xtent territory
Volterra<-subset(Volterra,Volterra$query=="Volterra")
Populonia<-subset(Populonia,Populonia$query=="Populonia")
Murlo<-subset(Murlo,Murlo$query=="Murlo")
Vetulonia<-subset(Vetulonia,Vetulonia$query=="Vetulonia")
Vulci<-subset(Vulci,Vulci$query=="Vulci")
Bisenzio<-subset(Bisenzio,Bisenzio$query=="Bisenzio")
Acquarossa<-subset(Acquarossa,Acquarossa$query=="Acquarossa")
Orvieto<-subset(Orvieto,Orvieto$query=="Orvieto")
Tarquinia<-subset(Tarquinia,Tarquinia$query=="Tarquinia")
Cerveteri<-subset(Cerveteri,Cerveteri$query=="Cerveteri")
Veii<-subset(Veii,Veii$query=="Veii")
Civita_Castellana<-subset(Civita_Castellana,Civita_Castellana$query=="Civita Castellana")

############################################################################################################
#RANK-SIZE analysis for each xtent territory

#create zipfian law
Volterra_zipf=max(sort(Volterra$SizeHa,decreasing = TRUE))/(1:length(Volterra$SizeHa))
Populonia_zipf=max(sort(Populonia$SizeHa,decreasing = TRUE))/(1:length(Populonia$SizeHa))
Murlo_zipf=max(sort(Murlo$SizeHa,decreasing = TRUE))/(1:length(Murlo$SizeHa))
Vetulonia_zipf=max(sort(Vetulonia$SizeHa,decreasing = TRUE))/(1:length(Vetulonia$SizeHa))
Vulci_zipf=max(sort(Vulci$SizeHa,decreasing = TRUE))/(1:length(Vulci$SizeHa))
Bisenzio_zipf=max(sort(Bisenzio$SizeHa,decreasing = TRUE))/(1:length(Bisenzio$SizeHa))
Acquarossa_zipf=max(sort(Acquarossa$SizeHa,decreasing = TRUE))/(1:length(Acquarossa$SizeHa))
Orvieto_zipf=max(sort(Orvieto$SizeHa,decreasing = TRUE))/(1:length(Orvieto$SizeHa))
Tarquinia_zipf=max(sort(Tarquinia$SizeHa,decreasing = TRUE))/(1:length(Tarquinia$SizeHa))
Cerveteri_zipf=max(sort(Cerveteri$SizeHa,decreasing = TRUE))/(1:length(Cerveteri$SizeHa))
Veii_zipf=max(sort(Veii$SizeHa,decreasing = TRUE))/(1:length(Veii$SizeHa))
Civita_Castellana_zipf=max(sort(Civita_Castellana$SizeHa,decreasing = TRUE))/(1:length(Civita_Castellana$SizeHa))

#Create Bootstrap 1000 simulations envelope for each xtent territory

#PLOT ALL GRAPHS
x11(height=10,width=8) #define the width and heigth of the graph to plot
par(mar=c(2.5,3,1,3),mgp=c(1.5,0.5,0), mfrow=c(4,3))

#VOLTERRA
#create a bootstrap sample 
random_data<-sample(Volterra$SizeHa,19,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Volterra$SizeHa,19,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Volterra$SizeHa)),y=log(sort(Volterra$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("a",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first bootstrap sample
lines(log(x=1:length(Volterra$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Volterra$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Volterra$SizeHa)),y=log(sort(Volterra$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Volterra$SizeHa)),log(sort(Volterra$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Volterra$SizeHa)),log(Volterra_zipf),lty=2)


#POPULONIA
#create a bootstrap sample 
random_data<-sample(Populonia$SizeHa,6,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Populonia$SizeHa,6,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Populonia$SizeHa)),y=log(sort(Populonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("b",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Populonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Populonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Populonia$SizeHa)),y=log(sort(Populonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Populonia$SizeHa)),log(sort(Populonia$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Populonia$SizeHa)),log(Populonia_zipf),lty=2)


#MURLO
#create a bootstrap sample 
random_data<-sample(Murlo$SizeHa,24,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Murlo$SizeHa,24,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Murlo$SizeHa)),y=log(sort(Murlo$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("c",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Murlo$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Murlo$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Murlo$SizeHa)),y=log(sort(Murlo$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Murlo$SizeHa)),log(sort(Murlo$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Murlo$SizeHa)),log(Murlo_zipf),lty=2)


#VETULONIA
#create a bootstrap sample 
random_data<-sample(Vetulonia$SizeHa,8,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Vetulonia$SizeHa,8,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(Vetulonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("d",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(Vetulonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Vetulonia$SizeHa)),log(sort(Vetulonia$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Vetulonia$SizeHa)),log(Vetulonia_zipf),lty=2)


#VULCI
#create a bootstrap sample 
random_data<-sample(Vulci$SizeHa,63,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Vulci$SizeHa,63,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Vulci$SizeHa)),y=log(sort(Vulci$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("e",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Vulci$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Vulci$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Vulci$SizeHa)),y=log(sort(Vulci$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Vulci$SizeHa)),log(sort(Vulci$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Vulci$SizeHa)),log(Vulci_zipf),lty=2)


#BISENZIO
#create a bootstrap sample 
random_data<-sample(Bisenzio$SizeHa,17,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Bisenzio$SizeHa,17,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Bisenzio$SizeHa)),y=log(sort(Bisenzio$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("f",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Bisenzio$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Bisenzio$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Bisenzio$SizeHa)),y=log(sort(Bisenzio$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Bisenzio$SizeHa)),log(sort(Bisenzio$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Bisenzio$SizeHa)),log(Bisenzio_zipf),lty=2)


#ACQUAROSSA
#create a bootstrap sample 
random_data<-sample(Acquarossa$SizeHa,7,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Acquarossa$SizeHa,7,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Acquarossa$SizeHa)),y=log(sort(Acquarossa$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("g",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Acquarossa$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Acquarossa$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Acquarossa$SizeHa)),y=log(sort(Acquarossa$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Acquarossa$SizeHa)),log(sort(Acquarossa$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Acquarossa$SizeHa)),log(Acquarossa_zipf),lty=2)


#ORVIETO
#create a bootstrap sample 
random_data<-sample(Orvieto$SizeHa,8,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Orvieto$SizeHa,8,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Orvieto$SizeHa)),y=log(sort(Orvieto$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("h",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Orvieto$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Orvieto$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Orvieto$SizeHa)),y=log(sort(Orvieto$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Orvieto$SizeHa)),log(sort(Orvieto$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Orvieto$SizeHa)),log(Orvieto_zipf),lty=2)

#TARQUINIA
#create a bootstrap sample 
random_data<-sample(Tarquinia$SizeHa,107,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Tarquinia$SizeHa,107,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(Tarquinia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("i",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(Tarquinia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Tarquinia$SizeHa)),log(sort(Tarquinia$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Tarquinia$SizeHa)),log(Tarquinia_zipf),lty=2)


#CERVETERI
#create a bootstrap sample 
random_data<-sample(Cerveteri$SizeHa,57,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Cerveteri$SizeHa,57,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(Cerveteri$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("j",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(Cerveteri$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Cerveteri$SizeHa)),log(sort(Cerveteri$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Cerveteri$SizeHa)),log(Cerveteri_zipf),lty=2)

#VEII
#create a bootstrap sample 
random_data<-sample(Veii$SizeHa,21,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Veii$SizeHa,21,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Veii$SizeHa)),y=log(sort(Veii$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("k",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Veii$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Veii$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Veii$SizeHa)),y=log(sort(Veii$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Veii$SizeHa)),log(sort(Veii$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Veii$SizeHa)),log(Veii_zipf),lty=2)


#CIVITA CASTELLANA
#create a bootstrap sample 
random_data<-sample(Civita_Castellana$SizeHa,7,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Civita_Castellana$SizeHa,7,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Civita_Castellana$SizeHa)),y=log(sort(Civita_Castellana$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("l",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Civita_Castellana$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Civita_Castellana$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Civita_Castellana$SizeHa)),y=log(sort(Civita_Castellana$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Civita_Castellana$SizeHa)),log(sort(Civita_Castellana$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Civita_Castellana$SizeHa)),log(Civita_Castellana_zipf),lty=2)

#save the figure as a .pdf file in the folder pdf
dev.print(device=pdf, "pdf/Fig9.pdf")


############################# CALCULATE A-COEFFICIENTS OF ALL XTENT TERRITORIES #####################################

#source the codes in the subfolder "src" in order to load two functions for calculating the A-coefficient. Courtesy of Enrico Crema (Cambridge University). See: https://link.springer.com/article/10.1007/s10816-013-9185-4.   
source("src/a12coeff.R") 
source("src/bootStrap_acoeff12.R") 

#VOLTERRA
#calculate the observed A-coefficient (with plot):
a12coeff(Volterra$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Volterra$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#POPULONIA
#calculate the observed A-coefficient (with plot):
a12coeff(Populonia$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Populonia$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#MURLO
#calculate the observed A-coefficient (with plot):
a12coeff(Murlo$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Murlo$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#VETULONIA
#calculate the observed A-coefficient (with plot):
a12coeff(Vetulonia$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Vetulonia$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#VULCI
#calculate the observed A-coefficient (with plot):
a12coeff(Vulci$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Vulci$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#BISENZIO
#calculate the observed A-coefficient (with plot):
a12coeff(Bisenzio$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Bisenzio$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#ACQUAROSSA
#calculate the observed A-coefficient (with plot):
a12coeff(Acquarossa$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Acquarossa$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 


#ORVIETO
#calculate the observed A-coefficient (with plot):
a12coeff(Orvieto$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Orvieto$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2

#TARQUINIA
#calculate the observed A-coefficient (with plot):
a12coeff(Tarquinia$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Tarquinia$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#CERVETERI
#calculate the observed A-coefficient (with plot):
a12coeff(Cerveteri$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Cerveteri$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2

#VEII
#calculate the observed A-coefficient (with plot):
a12coeff(Veii$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Veii$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#CIVITA CASTELLANA
#calculate the observed A-coefficient (with plot):
a12coeff(Civita_Castellana$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Civita_Castellana$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 



