# Install library if not installed -------------------------------------####
if (!('rgdal' %in% installed.packages())){
  install.packages('rgdal')
}

#Load required library
library(rgdal)

#Load data
Archaic<-readOGR("shp/Archaic.shp",layer="Archaic") # load shape file

#load Xtent polygons
xtent_Archaic<-readOGR("shp/xtent_k003.shp", layer="xtent_k003")

#create dataframes for rank-size analysis
Volterra<-as.data.frame(Archaic[,1:7])
Fiesole<-as.data.frame(Archaic[,1:7])
Murlo<-as.data.frame(Archaic[,1:7])
Populonia<-as.data.frame(Archaic[,1:7])
Vetulonia<-as.data.frame(Archaic[,1:7])
Chiusi<-as.data.frame(Archaic[,1:7])
Vulci<-as.data.frame(Archaic[,1:7])
Acquarossa<-as.data.frame(Archaic[,1:7])
Orvieto<-as.data.frame(Archaic[,1:7])
Tarquinia<-as.data.frame(Archaic[,1:7])
Cerveteri<-as.data.frame(Archaic[,1:7])
Veii<-as.data.frame(Archaic[,1:7])

#Spatial query: selection of points (datesp) located within each xtent territory
query_Volterra<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Volterra",])
query_Fiesole<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Fiesole",])
query_Murlo<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Murlo",])
query_Populonia<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Populonia",])
query_Vetulonia<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Vetulonia",])
query_Chiusi<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Chiusi",])
query_Vulci<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Vulci",])
query_Acquarossa<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Acquarossa",])
query_Orvieto<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Orvieto",])
query_Tarquinia<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Tarquinia",])
query_Cerveteri<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Cerveteri",])
query_Veii<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Veii",])

#add spatial query column to the dataframe
Volterra["query"]<-NA
Fiesole["query"]<-NA
Murlo["query"]<-NA
Populonia["query"]<-NA
Vetulonia["query"]<-NA
Chiusi["query"]<-NA
Vulci["query"]<-NA
Acquarossa["query"]<-NA
Orvieto["query"]<-NA
Tarquinia["query"]<-NA
Cerveteri["query"]<-NA
Veii["query"]<-NA

#update the column of the dataframe
Volterra$query<-query_Volterra$sitename
Fiesole$query<-query_Fiesole$sitename
Murlo$query<-query_Murlo$sitename
Populonia$query<-query_Populonia$sitename
Vetulonia$query<-query_Vetulonia$sitename
Chiusi$query<-query_Chiusi$sitename
Vulci$query<-query_Vulci$sitename
Acquarossa$query<-query_Acquarossa$sitename
Orvieto$query<-query_Orvieto$sitename
Tarquinia$query<-query_Tarquinia$sitename
Cerveteri$query<-query_Cerveteri$sitename
Veii$query<-query_Veii$sitename

#subset the sites located within each xtent territory
Volterra<-subset(Volterra,Volterra$query=="Volterra")
Fiesole<-subset(Fiesole,Fiesole$query=="Fiesole")
Murlo<-subset(Murlo,Murlo$query=="Murlo")
Populonia<-subset(Populonia,Populonia$query=="Populonia")
Vetulonia<-subset(Vetulonia,Vetulonia$query=="Vetulonia")
Chiusi<-subset(Chiusi,Chiusi$query=="Chiusi")
Vulci<-subset(Vulci,Vulci$query=="Vulci")
Acquarossa<-subset(Acquarossa,Acquarossa$query=="Acquarossa")
Orvieto<-subset(Orvieto,Orvieto$query=="Orvieto")
Tarquinia<-subset(Tarquinia,Tarquinia$query=="Tarquinia")
Cerveteri<-subset(Cerveteri,Cerveteri$query=="Cerveteri")
Veii<-subset(Veii,Veii$query=="Veii")

#plot histograms for each territory
pdf(file="pdf/Fig7.pdf", height=10, width=8)
layout(matrix(c(1,2,3,4,5,6,7,8,9,10,11,12),3,4, byrow=TRUE),height=c(3,3,3), widths=c(2,2,2,2)) #define the layout for the three histograms
hist(Volterra$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Volterra", breaks=seq(0,100,5),  col="white")
mtext("a",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Fiesole$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Fiesole", breaks=seq(0,30,5),  col="white")
mtext("b",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Murlo$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Murlo", breaks=seq(0,10,1),  col="white")
mtext("c",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Populonia$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Populonia", breaks=seq(0,150,5),  col="white")
mtext("d",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Vetulonia$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Vetulonia", breaks=seq(0,100,5),  col="white")
mtext("e",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Chiusi$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Chiusi", breaks=seq(0,50,5),  col="white")
mtext("f",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Vulci$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Vulci", breaks=seq(0,130,5),  col="white")
mtext("g",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Acquarossa$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Acquarossa", breaks=seq(0,30,5),  col="white")
mtext("h",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Orvieto$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Orvieto", breaks=seq(0,85,5),  col="white")
mtext("i",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Tarquinia$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Tarquinia", breaks=seq(0,150,5),  col="white")
mtext("j",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Cerveteri$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Cerveteri", breaks=seq(0,160,5),  col="white")
mtext("k",1, 2, adj=-0.2, font=2, cex=0.75)
hist(Veii$SizeHa, cex.axis=0.75, xlab="Estimated Size (ha)", ylab="Site Count", main="Veio", breaks=seq(0,185,5),  col="white")
mtext("l",1, 2, adj=-0.2, font=2, cex=0.75)
dev.off()


####################################################################################################################
#RANK-SIZE analysis for each xtent territory

#create zipfian law
Volterra_zipf=max(sort(Volterra$SizeHa,decreasing = TRUE))/(1:length(Volterra$SizeHa))
Fiesole_zipf=max(sort(Fiesole$SizeHa,decreasing = TRUE))/(1:length(Fiesole$SizeHa))
Murlo_zipf=max(sort(Murlo$SizeHa,decreasing = TRUE))/(1:length(Murlo$SizeHa))
Populonia_zipf=max(sort(Populonia$SizeHa,decreasing = TRUE))/(1:length(Populonia$SizeHa))
Vetulonia_zipf=max(sort(Vetulonia$SizeHa,decreasing = TRUE))/(1:length(Vetulonia$SizeHa))
Chiusi_zipf=max(sort(Chiusi$SizeHa,decreasing = TRUE))/(1:length(Chiusi$SizeHa))
Vulci_zipf=max(sort(Vulci$SizeHa,decreasing = TRUE))/(1:length(Vulci$SizeHa))
Acquarossa_zipf=max(sort(Acquarossa$SizeHa,decreasing = TRUE))/(1:length(Acquarossa$SizeHa))
Orvieto_zipf=max(sort(Orvieto$SizeHa,decreasing = TRUE))/(1:length(Orvieto$SizeHa))
Tarquinia_zipf=max(sort(Tarquinia$SizeHa,decreasing = TRUE))/(1:length(Tarquinia$SizeHa))
Cerveteri_zipf=max(sort(Cerveteri$SizeHa,decreasing = TRUE))/(1:length(Cerveteri$SizeHa))
Veii_zipf=max(sort(Veii$SizeHa,decreasing = TRUE))/(1:length(Veii$SizeHa))

#Create Bootstrap 1000 simulations envelope for each xtent territory

#PLOT ALL GRAPHS
x11(height=10,width=8) #define width and heigth of the graph to plot
par(mar=c(2.5,3,1,3),mgp=c(1.5,0.5,0), mfrow=c(4,3))

#VOLTERRA
#create a bootstrap sample 
random_data<-sample(Volterra$SizeHa,68,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Volterra$SizeHa,68,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Volterra$SizeHa)),y=log(sort(Volterra$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("a",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Volterra$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Volterra$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Volterra$SizeHa)),y=log(sort(Volterra$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Volterra$SizeHa)),log(sort(Volterra$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Volterra$SizeHa)),log(Volterra_zipf),lty=2)
#text(x=2, ymax*0.98, labels="Volterra", font=2, cex=1, adj=c(0,0.7))


#FIESOLE
#create a bootstrap sample 
random_data<-sample(Fiesole$SizeHa,23,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Fiesole$SizeHa,23,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Fiesole$SizeHa)),y=log(sort(Fiesole$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("b",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Fiesole$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Fiesole$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Fiesole$SizeHa)),y=log(sort(Fiesole$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Fiesole$SizeHa)),log(sort(Fiesole$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Fiesole$SizeHa)),log(Fiesole_zipf),lty=2)


#MURLO
#create a bootstrap sample 
random_data<-sample(Murlo$SizeHa,71,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Murlo$SizeHa,71,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Murlo$SizeHa)),y=log(sort(Murlo$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("c",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Murlo$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Murlo$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Murlo$SizeHa)),y=log(sort(Murlo$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Murlo$SizeHa)),log(sort(Murlo$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Murlo$SizeHa)),log(Murlo_zipf),lty=2)

#POPULONIA
#create a bootstrap sample 
random_data<-sample(Populonia$SizeHa,6,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Vetulonia$SizeHa,6,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Populonia$SizeHa)),y=log(sort(Populonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("d",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Populonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Populonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Populonia$SizeHa)),y=log(sort(Populonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Populonia$SizeHa)),log(sort(Populonia$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Populonia$SizeHa)),log(Populonia_zipf),lty=2)


#VETULONIA
#create a bootstrap sample 
random_data<-sample(Vetulonia$SizeHa,9,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Vetulonia$SizeHa,9,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(Vetulonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("e",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Vetulonia$SizeHa)),y=log(sort(Vetulonia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Vetulonia$SizeHa)),log(sort(Vetulonia$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Vetulonia$SizeHa)),log(Vetulonia_zipf),lty=2)

#CHIUSI
#create a bootstrap sample 
random_data<-sample(Chiusi$SizeHa,23,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Chiusi$SizeHa,23,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Chiusi$SizeHa)),y=log(sort(Chiusi$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("f",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Chiusi$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Chiusi$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Chiusi$SizeHa)),y=log(sort(Chiusi$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Chiusi$SizeHa)),log(sort(Chiusi$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Chiusi$SizeHa)),log(Chiusi_zipf),lty=2)


#VULCI
#create a bootstrap sample 
random_data<-sample(Vulci$SizeHa,98,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Vulci$SizeHa,98,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Vulci$SizeHa)),y=log(sort(Vulci$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("g",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Vulci$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Vulci$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Vulci$SizeHa)),y=log(sort(Vulci$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Vulci$SizeHa)),log(sort(Vulci$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Vulci$SizeHa)),log(Vulci_zipf),lty=2)


#ACQUAROSSA
#create a bootstrap sample 
random_data<-sample(Acquarossa$SizeHa,4,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Acquarossa$SizeHa,4,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Acquarossa$SizeHa)),y=log(sort(Acquarossa$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("h",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Acquarossa$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Acquarossa$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Acquarossa$SizeHa)),y=log(sort(Acquarossa$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Acquarossa$SizeHa)),log(sort(Acquarossa$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Acquarossa$SizeHa)),log(Acquarossa_zipf),lty=2)


#ORVIETO
#create a bootstrap sample 
random_data<-sample(Orvieto$SizeHa,25,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Orvieto$SizeHa,25,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Orvieto$SizeHa)),y=log(sort(Orvieto$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("i",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Orvieto$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Orvieto$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Orvieto$SizeHa)),y=log(sort(Orvieto$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Orvieto$SizeHa)),log(sort(Orvieto$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Orvieto$SizeHa)),log(Orvieto_zipf),lty=2)

#TARQUINIA
#create a bootstrap sample 
random_data<-sample(Tarquinia$SizeHa,266,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Tarquinia$SizeHa,266,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(Tarquinia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("j",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Tarquinia$SizeHa)),y=log(sort(Tarquinia$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Tarquinia$SizeHa)),log(sort(Tarquinia$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Tarquinia$SizeHa)),log(Tarquinia_zipf),lty=2)


#CERVETERI
#create a bootstrap sample 
random_data<-sample(Cerveteri$SizeHa,295,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Cerveteri$SizeHa,295,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(Cerveteri$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("k",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(Cerveteri$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Cerveteri$SizeHa)),log(sort(Cerveteri$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Cerveteri$SizeHa)),log(Cerveteri_zipf),lty=2)

#VEII
#create a bootstrap sample 
random_data<-sample(Veii$SizeHa,119,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Veii$SizeHa,119,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Veii$SizeHa)),y=log(sort(Veii$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
mtext("l",1, 1, adj=-0.05, font=2, cex=0.75)

#Plot the first sample
lines(log(x=1:length(Veii$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Veii$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Veii$SizeHa)),y=log(sort(Veii$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Veii$SizeHa)),log(sort(Veii$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Veii$SizeHa)),log(Veii_zipf),lty=2)


#dev.off()
dev.print(device=pdf, "pdf/Fig10.pdf")


############################# CALCULATE A-COEFFICIENTS OF ALL XTENT TERRITORIES ###############################


#source the codes in the subfolder "src" in order to load two functions for calculating the A-coefficient. Courtesy of Enrico Crema (Cambridge University). See: https://link.springer.com/article/10.1007/s10816-013-9185-4.   
source("src/a12coeff.R") 
source("src/bootStrap_acoeff12.R") 

#VOLTERRA
#calculate the observed A-coefficient (with plot):
a12coeff(Volterra$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Volterra$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#FIESOLE
#calculate the observed A-coefficient (with plot):
a12coeff(Fiesole$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Fiesole$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#MURLO
#calculate the observed A-coefficient (with plot):
a12coeff(Murlo$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Murlo$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#POPULONIA
#calculate the observed A-coefficient (with plot):
a12coeff(Populonia$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Populonia$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#VETULONIA
#calculate the observed A-coefficient (with plot):
a12coeff(Vetulonia$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Vetulonia$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#CHIUSI
#calculate the observed A-coefficient (with plot):
a12coeff(Chiusi$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Chiusi$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 


#VULCI
#calculate the observed A-coefficient (with plot):
a12coeff(Vulci$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Vulci$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 


#ACQUAROSSA
#calculate the observed A-coefficient (with plot):
a12coeff(Acquarossa$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Acquarossa$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 


#ORVIETO
#calculate the observed A-coefficient (with plot):
a12coeff(Orvieto$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Orvieto$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2

#TARQUINIA
#calculate the observed A-coefficient (with plot):
a12coeff(Tarquinia$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Tarquinia$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#CERVETERI
#calculate the observed A-coefficient (with plot):
a12coeff(Cerveteri$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Cerveteri$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2

#VEII
#calculate the observed A-coefficient (with plot):
a12coeff(Veii$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Veii$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 



#################################  LOAD UPDATED DATA FOR CHIUSI AND CERVETERI TERRITORIES  ######################################
#load updated data
Archaic<-readOGR("shp/Archaic_new.shp",layer="Archaic_new") # load shape file

#load Xtent polygons
xtent_Archaic<-readOGR("shp/xtent_k003.shp", layer="xtent_k003")

#create dataframes for rank-size analysis
Cerveteri<-as.data.frame(Archaic[,1:7])
Chiusi<-as.data.frame(Archaic[,1:7])

#Spatial query: selection of points (datesp) located within each xtent territory
query_Chiusi<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Chiusi",])
query_Cerveteri<-over(Archaic,xtent_Archaic[xtent_Archaic$sitename=="Cerveteri",])

#add spatial query column to the dataframe
Chiusi["query"]<-NA
Cerveteri["query"]<-NA

#update the column of the dataframe
Chiusi$query<-query_Chiusi$sitename
Cerveteri$query<-query_Cerveteri$sitename

#subset the sites located within each xtent territory
Chiusi<-subset(Chiusi,Chiusi$query=="Chiusi")
Cerveteri<-subset(Cerveteri,Cerveteri$query=="Cerveteri")

#plot histograms for each territory
dev.new()
par(mfrow=c(1,2))
hist(Chiusi$SizeHa, cex.axis=0.75, xlab="Estimated size (ha)", ylab="Site Count", main="Chiusi", breaks=seq(0,50,5),  col="white")
mtext("a",1, 2, adj=-0.2, font=2, cex=1)
hist(Cerveteri$SizeHa, cex.axis=0.75, xlab="Estimated size (ha)", ylab="Site Count", main="Cerveteri", breaks=seq(0,160,5),  col="white")
mtext("b",1, 2, adj=-0.2, font=2, cex=1)
dev.print(device = pdf, file="pdf/Fig14.pdf")

#####################################################################################################################
#RANK-SIZE analysis for each xtent territory
Chiusi_zipf=max(sort(Chiusi$SizeHa,decreasing = TRUE))/(1:length(Chiusi$SizeHa))
Cerveteri_zipf=max(sort(Cerveteri$SizeHa,decreasing = TRUE))/(1:length(Cerveteri$SizeHa))

#Create Bootstrap 1000 simulations envelope for each xtent territory
#PLOT ALL GRAPHS
dev.new()
par(mfrow=c(1,2))

#CHIUSI
#create a bootstrap sample 
random_data<-sample(Chiusi$SizeHa,31,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Chiusi$SizeHa,31,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Chiusi$SizeHa)),y=log(sort(Chiusi$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)", main="Chiusi")
mtext("a",1, 2, adj=-0.2, font=2, cex=1)

#Plot the first sample
lines(log(x=1:length(Chiusi$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Chiusi$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Chiusi$SizeHa)),y=log(sort(Chiusi$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Chiusi$SizeHa)),log(sort(Chiusi$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Chiusi$SizeHa)),log(Chiusi_zipf),lty=2)

#CERVETERI
#create a bootstrap sample 
random_data<-sample(Cerveteri$SizeHa,299,replace=TRUE)
random_data<-as.data.frame(random_data)
colnames(random_data)[1]<-"size"
random_data$sample <- 1

# now run 1000 times, WHILE COMBINE ALL INTO A SINLGE DATAFRAME WHERE EACH SAMPLE IS NUMBERED IN THE SAMPLE COLUMN
nsim<-1000
for(a in 2:nsim) {
  cat(paste(a,"; ",sep="")) 
  random<- sample(Cerveteri$SizeHa,299,replace=TRUE)
  random_n<-as.data.frame(random)
  colnames(random_n)[1]<-"size"
  random_n$sample<-a 
  random_data <- rbind(random_data, random_n)
}

#Plot the graph 
plot(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(Cerveteri$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)", main="Cerveteri")
mtext("b",1, 2, adj=-0.2, font=2, cex=1)

#Plot the first sample
lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(random_data$size[random_data$sample==1],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")

#add the other 999 samples in order to generate a grey envelope
i<-1
for (i in 2:nsim) {
  lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(random_data$size[random_data$sample==i],TRUE)),type="l",xlab="Rank",ylab="Size (ha)", col="gray")
}

#Plot the graph 
lines(log(x=1:length(Cerveteri$SizeHa)),y=log(sort(Cerveteri$SizeHa,TRUE)),type="l",xlab="Log Rank",ylab="Log Size (ha)")
points(log(1:length(Cerveteri$SizeHa)),log(sort(Cerveteri$SizeHa,TRUE)),pch=20, cex=1)
lines(log(1:length(Cerveteri$SizeHa)),log(Cerveteri_zipf),lty=2)

dev.print(device = pdf, file="pdf/Fig15.pdf")

############################# CALCULATE A-COEFFICIENTS OF CHIUSI AND CERVETERI XTENT TERRITORIES ###############################

#CHIUSI
#source the codes in the subfolder "src" in order to load two functions for calculating the A-coefficient. Courtesy of Enrico Crema (Cambridge University). See: https://link.springer.com/article/10.1007/s10816-013-9185-4.   
source("src/a12coeff.R") 
source("src/bootStrap_acoeff12.R") 

#calculate the observed A-coefficient (with plot):
a12coeff(Chiusi$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Chiusi$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 

#CERVETERI
 
#calculate the observed A-coefficient (with plot):
a12coeff(Cerveteri$SizeHa,plotting=TRUE) 

#assess the 95 confidence envelope using 1000 simulation bootstrap:
#the automatically plotted histogram shows the distrubution of the simulated A coefficients, along with the observed one (the red line)
envelope<-bootStrap_acoeff12(Cerveteri$SizeHa,nsim=1000) 

#obtain the 95% confidence envelopes
envelope$envA 
envelope$envA1 
envelope$envA2 