
# Install library if not installed -------------------------------------####
if (!('rgdal' %in% installed.packages())){
  install.packages('rgdal')
}

if (!('ads' %in% installed.packages())){
  install.packages('ads')
}

if (!('spatstat' %in% installed.packages())){
  install.packages('spatstat')
}

if (!('maptools' %in% installed.packages())){
  install.packages('maptools')
}


#load required libraries
library(rgdal)
library(ads)
library(spatstat)
library(maptools)

#load data
sites<-readOGR("shp/major_centres_utm.shp",layer="major_centres_utm") # load shape file
window<-readOGR("shp/region.shp")

#Convert the window of analysis into a an owin class object
window <- as(window,"owin")

#Create a ppp class object aggregating the spatial extent of the window analysis and the coordinates of our point data
sites.ppp<-ppp(x=sites$coords.x1,y=sites$coords.x2,window=window)

#Generate an enveolpe with 95% confidence interval and a modified K-Distribution (L)
resK<-envelope(sites.ppp,fun=Kest,nsim=1000,by=500, correction="iso", nrank=25)

#Plot the results
plot(resK, main="", xlab="distance (m)")
dev.print(device=pdf, file="pdf/Fig18.pdf")


