############################# CALCULATE B-COEFFICIENTS (Centralization Index) FOR MURLO AND CERVETERI'S TERRITORIES ###############################

if (!('jpeg' %in% installed.packages())){
  install.packages('jpeg')
}


#Load the results stored within the spreadsheet
murlo<-read.csv(file="csv/murlo_centralization.csv", header=TRUE, sep=",")
cerveteri<-read.csv(file="csv/cerveteri_centralization.csv", header=TRUE, sep=",")
tuscania<-read.csv(file="csv/tuscania_centralization.csv", header=TRUE, sep=",") 

#load required  package 
library(jpeg)
#source the codes in the subfolder "src" in order to load the function which allows you to  preserve the images pixel aspect ratio and to avoid any distortion of raster images plotted
source("src/addImg.R") 

#PLOT the estimated size proportion in each concentric ring for each period
pdf(file="pdf/Fig12.pdf", height=6, width=9)
layout(matrix(c(1,2,3,4,5,6),3,2, byrow = TRUE), height=c(0.9,0.9,1.2), widths=c(0.7,1.3))#define the layout for the plot

#plot Cerveteris's results
par(mar=c(0,4,0.5,0)) #c(bottom, left, top, right)
plot(cerveteri$size.proportion, xlab="", ylab="", xlim=c(1,10), xaxt="n", yaxt="n", col="black", type="l")
axis(2, at=seq(0,100,20), labels = seq(0,100,20), lwd=1, line=0, las=2, cex.axis=0.8, mgp=c(0,0.8,0))
mtext(2,text="Estimated size %", line=2, cex = 0.6)
abline(v=seq(1,10,1), lty="dotted", col="grey")
text(x=4, y=99, labels="a. Cerveteri", font=2, cex=1, adj=c(0,0.7))
lines(cerveteri$size.proportion.1, col="red", type="l")
lines(cerveteri$size.proportion.2, col="blue", type="l")
legend(x=5.5, y=95, legend=c("Iron Age","Archaic","Post-Archaic"), lty=c("solid","solid","solid"), lwd=c(1,1,1), col=c("black","red","blue"), bty="n", cex=1)
text(x=8, y=55,labels="B=0.94",font=1, cex=0.9)
text(x=8, y=48,labels="B=0.70",font=1, cex=0.9, col="red")
text(x=8, y=41,labels="B=0.86",font=1, cex=0.9, col="blue")
#Plot the raster image for Cerveteri
par(mar=c(0,0,0.5,0))#c(bottom, left, top, right
cerveteri<-readJPEG("jpeg/cerveteri.jpg")
plot(1:10,ty="n",xaxt="n", yaxt="n", axes=FALSE)#specify the position of the image through bottom-left and top-right coords
addImg(cerveteri, x = 5.5, y = 5.5, width = 9.5)

#plot Murlos's results
par(mar=c(0,4,0,0))#c(bottom, left, top, right
plot(murlo$size.proportion, xlab="", ylab="", xlim=c(1,10), xaxt="n", yaxt="n", col="black", type="l")
axis(2, at=seq(0,100,20), labels = seq(0,100,20), lwd=1, line=0, las=2, cex.axis=0.8, mgp=c(0,0.8,0))
mtext(2,text="Estimated size %",line=2, cex = 0.6)
abline(v=seq(1,10,1), lty="dotted", col="grey")
text(x=4, y=99, labels="b. Murlo", font=2, cex=1, adj=c(0,0.7))
lines(murlo$size.proportion.1, col="red", type="l")
legend(x=5.5, y=95, legend=c("Iron Age","Archaic"), lty=c("solid","solid"), lwd=c(1,1,1), col=c("black","red"), bty="n", cex=1)
text(x=8, y=55,labels="B=0.89",font=1, cex=0.9)
text(x=8, y=48,labels="B=0.83",font=1, cex=0.9, col="red")
#Plot the raster image for Murlo
par(mar=c(0,0,0.5,0))#c(bottom, left, top, right
murlo<-readJPEG("jpeg/murlo.jpg")
plot(1:10,ty="n",xaxt="n", yaxt="n", axes=FALSE)#specify the position of the image through bottom-left and top-right coords
addImg(murlo, x = 5.5, y = 5.5, width = 9.5)

#plot Tuscania's results
par(mar=c(3,4,0,0))#c(bottom, left, top, right
plot(tuscania$size.proportion, xlab="", ylab="", xlim=c(1,10), xaxt="n",yaxt="n",col="black", type="l")
axis(2, at=seq(0,100,20), labels = seq(0,100,20), lwd=1, line=0, las=2, cex.axis=0.8, mgp=c(0,0.8,0))
mtext(2,text="Estimated size %",line=2, cex = 0.6)
abline(v=seq(1,10,1), lty="dotted", col="grey")
text(x=4, y=99, labels="c. Tuscania", font=2, cex=1, adj=c(0,0.7))
lines(tuscania$size.proportion.1, col="red", type="l")
lines(tuscania$size.proportion.2, col="blue", type="l")
legend(x=5.5, y=95, legend=c("Iron Age","Archaic","Post-Archaic"), lty=c("solid","solid","solid"), lwd=c(1,1,1), col=c("black","red","blue"), bty="n", cex=1)
text(x=8, y=55,labels="B=0.14",font=1, cex=0.9)
text(x=8, y=48,labels="B=0.06",font=1, cex=0.9, col="red")
text(x=8, y=41,labels="B=0.24",font=1, cex=0.9, col="blue")
xticklabs <- seq(1,10,by=1)
axis(side=1, at=xticklabs, cex.axis=1, las=1)
mtext("number of rings",1, 1.8, at=5, adj=0, font=1, cex=0.6)
#Plot the raster image for Tuscania
par(mar=c(3,0,0,0))#c(bottom, left, top, right
tuscania<-readJPEG("jpeg/tuscania.jpg")
plot(1:10,ty="n",xaxt="n", yaxt="n", axes=FALSE)#specify the position of the image through bottom-left and top-right coords
addImg(tuscania, x = 5.5, y = 5.5, width = 9.5)

#save the figure as a .pdf file in the folder "pdf"
dev.off()




######################### CALCULATE DENSITY OF SITES WITHIN EACH CONCENTRICH RING SURROUNDING THE MAIN URBAN CENTRE ####################################

#Load the results stored within the spreadsheet
cerveteri<-read.csv(file="csv/cerveteri_density.csv", header=TRUE, sep=",")
murlo<-read.csv(file="csv/murlo_density.csv", header=TRUE, sep=",")
tuscania<-read.csv(file="csv/tuscania_density.csv", header=TRUE, sep=",")
veio<-read.csv(file="csv/veio_density.csv", header=TRUE, sep=",")

#normalise density value for each period
cerveteri_IronAge_norm<-(cerveteri$density-min(cerveteri$density))/(max(cerveteri$density)-min(cerveteri$density))
cerveteri_Archaic_norm<-(cerveteri$density.1-min(cerveteri$density.1))/(max(cerveteri$density.1)-min(cerveteri$density.1))
cerveteri_PostArchaic_norm<-(cerveteri$density.2-min(cerveteri$density.2))/(max(cerveteri$density.2)-min(cerveteri$density.2))

murlo_IronAge_norm<-(murlo$density-min(murlo$density))/(max(murlo$density)-min(murlo$density))
murlo_Archaic_norm<-(murlo$density.1-min(murlo$density.1))/(max(murlo$density.1)-min(murlo$density.1))
murlo_PostArchaic_norm<-rep(0,10)
  
tuscania_IronAge_norm<-(tuscania$density-min(tuscania$density))/(max(tuscania$density)-min(tuscania$density))
tuscania_Archaic_norm<-(tuscania$density.1-min(tuscania$density.1))/(max(tuscania$density.1)-min(tuscania$density.1))
tuscania_PostArchaic_norm<-(tuscania$density.2-min(tuscania$density.2))/(max(tuscania$density.2)-min(tuscania$density.2))

veio_IronAge_norm<-(veio$density-min(veio$density))/(max(veio$density)-min(veio$density))
veio_Archaic_norm<-(veio$density.1-min(veio$density.1))/(max(veio$density.1)-min(veio$density.1))
veio_PostArchaic_norm<-(veio$density.2-min(veio$density.2))/(max(veio$density.2)-min(veio$density.2))

#unnormalised density value
cerveteri_IronAge<-cerveteri$density
cerveteri_Archaic<-cerveteri$density.1
cerveteri_PostArchaic<-cerveteri$density.2

murlo_IronAge<-murlo$density
murlo_Archaic<-murlo$density.1
murlo_PostArchaic<-rep(0,10)

tuscania_IronAge<-tuscania$density
tuscania_Archaic<-tuscania$density.1
tuscania_PostArchaic<-tuscania$density.2

veio_IronAge<-veio$density
veio_Archaic<-veio$density.1
veio_PostArchaic<-veio$density.2


#Plot the normalised bar charts for each settlement
pdf(file="pdf/Fig16.pdf", height=6, width=9)
layout(matrix(c(1,2,3,4),2,2, byrow = TRUE), height=c(1,1), widths=c(1,1))#define the layout for the plot
par(mar=c(3,3,2,1))#c(bottom, left, top, right
density_cerveteri_norm<-rbind(cerveteri_IronAge_norm,cerveteri_Archaic_norm,cerveteri_PostArchaic_norm)# aggregate normalised density values for each period 
colnames(density_cerveteri_norm)<-c("1","2","3","4","5","6","7","8","9","10")#name columns of the matrix
barplot(density_cerveteri_norm, main = "Cerveteri", ylab="", xlab = "", yaxt="n", col = c("black","gray", "white"),beside=TRUE)
legend("topright",c("Iron Age","Archaic", "Post-Archaic"), fill = c("black","gray","white"))
axis(2, at=seq(0,1,0.2), labels = seq(0,1,0.2), lwd=1, line=0, las=3, cex.axis=0.8, mgp=c(0,0.5,0))
mtext(2,text="sites density sq. km", line=1.5, cex = 0.7)
mtext(1,text="n. ring", line=0, cex = 0.7)
mtext("a",1, 2, adj=0, font=2, cex=0.75)
par(mar=c(3,3,2,1))
density_murlo_norm<-rbind(murlo_IronAge_norm,murlo_Archaic_norm, murlo_PostArchaic_norm)# aggregate normalised density values for each period 
colnames(density_murlo_norm)<-c("1","2","3","4","5","6","7","8","9","10")#name columns of the matrix
barplot(density_murlo_norm, main = "Murlo", xlab = "", yaxt="n", col = c("black","gray","white"), beside=TRUE)
axis(2, at=seq(0,1,0.2), labels = seq(0,1,0.2), lwd=1, line=0, las=3, cex.axis=0.8, mgp=c(0,0.5,0))
mtext(2,text="sites density sq. km", line=1.5, cex = 0.7)
mtext(1,text="n. ring", line=0, cex = 0.7)
mtext("b",1, 2, adj=0, font=2, cex=0.75)
par(mar=c(3,3,1,1))
density_tuscania_norm<-rbind(tuscania_IronAge_norm,tuscania_Archaic_norm,tuscania_PostArchaic_norm)# aggregate normalised density values for each period 
colnames(density_tuscania_norm)<-c("1","2","3","4","5","6","7","8","9","10")#name columns of the matrix
barplot(density_tuscania_norm, main = "Tuscania", xlab = "", yaxt="n",col = c("black","gray","white"), beside=TRUE)
axis(2, at=seq(0,1,0.2), labels = seq(0,1,0.2), lwd=1, line=0, las=3, cex.axis=0.8, mgp=c(0,0.5,0))
mtext(2,text="sites density sq. km", line=1.5, cex = 0.7)
mtext(1,text="n. ring", line=0, cex = 0.7)
mtext("c",1, 2, adj=0, font=2, cex=0.75)
par(mar=c(3,3,1,1))
density_veio_norm<-rbind(veio_IronAge_norm,veio_Archaic_norm,veio_PostArchaic_norm)# aggregate normalised density values for each period 
colnames(density_veio_norm)<-c("1","2","3","4","5","6","7","8","9","10")#name columns of the matrix
barplot(density_veio_norm, main = "Veio", xlab = "", yaxt="n", col = c("black","gray", "white"), beside=TRUE)
axis(2, at=seq(0,1,0.2), labels = seq(0,1,0.2), lwd=1, line=0, las=3, cex.axis=0.8, mgp=c(0,0.5,0))
mtext(2,text="sites density sq. km", line=1.5, cex = 0.7)
mtext(1,text="n. ring", line=0, cex = 0.7)
mtext("d",1, 2, adj=0, font=2, cex=0.75)
dev.off()

#Plot the unnormalised bar charts for each settlement
pdf(file="pdf/Fig17.pdf", height=6, width=9)
layout(matrix(c(1,2,3,4),2,2, byrow = TRUE), height=c(1,1), widths=c(1,1))#define the layout for the plot
par(mar=c(3,3,2,1))#c(bottom, left, top, right
density_cerveteri<-rbind(cerveteri_IronAge,cerveteri_Archaic,cerveteri_PostArchaic)# aggregate normalised density values for each period 
colnames(density_cerveteri)<-c("1","2","3","4","5","6","7","8","9","10")#name columns of the matrix
barplot(density_cerveteri, main = "Cerveteri", ylab="", xlab = "", yaxt="n", col = c("black","gray", "white"),beside=TRUE)
legend("topright",c("Iron Age","Archaic", "Post-Archaic"), fill = c("black","gray","white"))
axis(2, at=seq(0,2,0.2), labels = seq(0,2,0.2), lwd=1, line=0, las=3, cex.axis=0.8, mgp=c(0,0.5,0))
mtext(2,text="sites density sq. km", line=1.5, cex = 0.7)
mtext(1,text="n. ring", line=0, cex = 0.7)
mtext("a",1, 2, adj=0, font=2, cex=0.75)
par(mar=c(3,3,2,1))
density_murlo<-rbind(murlo_IronAge,murlo_Archaic,murlo_PostArchaic)# aggregate normalised density values for each period 
colnames(density_murlo)<-c("1","2","3","4","5","6","7","8","9","10")#name columns of the matrix
barplot(density_murlo, main = "Murlo", xlab = "", yaxt="n", col = c("black","gray","white"), beside=TRUE)
axis(2, at=seq(0,2,0.2), labels = seq(0,2,0.2), lwd=1, line=0, las=3, cex.axis=0.8, mgp=c(0,0.5,0))
mtext(2,text="sites density sq. km", line=1.5, cex = 0.7)
mtext(1,text="n. ring", line=0, cex = 0.7)
mtext("b",1, 2, adj=0, font=2, cex=0.75)
par(mar=c(3,3,1,1))
density_tuscania<-rbind(tuscania_IronAge,tuscania_Archaic,tuscania_PostArchaic)# aggregate normalised density values for each period 
colnames(density_tuscania)<-c("1","2","3","4","5","6","7","8","9","10")#name columns of the matrix
barplot(density_tuscania, main = "Tuscania", xlab = "", yaxt="n",col = c("black","gray", "white"), beside=TRUE)
axis(2, at=seq(0,4.5,0.5), labels = seq(0,4.5,0.5), lwd=1, line=0, las=3, cex.axis=0.8, mgp=c(0,0.5,0))
mtext(2,text="sites density sq. km", line=1.5, cex = 0.7)
mtext(1,text="n. ring", line=0, cex = 0.7)
mtext("c",1, 2, adj=0, font=2, cex=0.75)
par(mar=c(3,3,1,1))
density_veio<-rbind(veio_IronAge,veio_Archaic,veio_PostArchaic)# aggregate normalised density values for each period 
colnames(density_veio)<-c("1","2","3","4","5","6","7","8","9","10")#name columns of the matrix
barplot(density_veio, main = "Veio", xlab = "", yaxt="n", col = c("black","gray", "white"), beside=TRUE)
axis(2, at=seq(0,1.4,0.2), labels = seq(0,1.4,0.2), lwd=1, line=0, las=3, cex.axis=0.8, mgp=c(0,0.5,0))
mtext(2,text="sites density sq. km", line=1.5, cex = 0.7)
mtext(1,text="n. ring", line=0, cex = 0.7)
mtext("d",1, 2, adj=0, font=2, cex=0.75)
dev.off()

