---
title: "Patterns of Etruscan urbanism (dataset) README"
authors: Alessio Palmisano, Simon Stoddart, David Redhouse, Graeme Barker, Tom Rasmussen, Troy Samuels, and Nicola Terrenato
dataset_version: 1.0
---

#Patterns of Etruscan urbanism (dataset)
The present digital archive is the outcome of the paper: Stoddart, S., Palmisano, A.,Redhouse, D.I., Barker, G., di Paola, G., Rasmussen, T., Samuels, T., Terrenato, N., and Witcher, R., 2020. Patterns of Etruscan urbanism. Frontiers in Digital Humanities.  

The dataset included here provides a collection of 1355 sites dating from the ninth to the fifth century BC, uncovered by systematic field survey carried out in central Italy (Tuscany and Lazio). In addition, the digital archive related to this paper provides reproducible analyses in the form of six scripts written in R statistical computing language. The present repository contains also a R Markdwon tutorial to drive step by step any practitioner interested in running some analytical tools to assess regional centralisation and settlement hierarchies: site-size histograms, rank-size graphs, A-coefficient, and B-coefficient. 

NB:the present digital archive does not include the datasets provided by G. di Paola and R. Witcher for the paper published in the journal Frontiers in Digital Humanities. They will be published separately in forthcoming publications. Therefore, the following figures reproduced by using the R scripts and data here provided will slightly differ from the ones published in the original paper: Fig. 6; Fig. 7d-e; Fig. 8; Fig. 9b,d; Fig. 10d-e; Fig. 11c.  


###### CONTENTS ######

* Rmarkdown document as a tutorial explaining the core analitical tools for measuring regional centralisation (Tutorial.Rmd). 
* .html output of the Rmakdown tutorial (Tutorial.html)

#R_scripts
* Script for plotting site size histograms and rank-size graphs for all sites in each period (Iron Age,Archaic,Post-Archaic) and for reproducing Figures 6 and 8 (ranksize_allperiods.R).
* Script for plotting rank-size graphs, for calculating the A-coefficient for each modelled XTENT territory during the Iron Age, and for reproducing Figure 9 (ranksize_IronAge.R)
* Script for plotting site size histograms and rank-size graphs, for calculating the A-coefficient for each modelled XTENT territory during the Archaic Period, and for reproducing Figures 7,10,14 and 15 (ranksize_Archaic.R)
* Script for plotting rank-size graphs, for calculating the A-coefficient for each modelled XTENT territory during the Post-Archaic Period, and for reproducing Figure 11 (ranksize_PostArchaic.R)
* Script for plotting the density of rural settlement (by number and area) as one moves away from the main urban centre, for calculating the B-coefficient, and for reproducing Figures 12,16 and 17 (centralisation.R). 
* Script for running a Ripley's K function to assess if the archaeological sites appears to be dispersed, clustered, or randomly distributed throughout the study area and for reproducing Figure 18 (point_pattern.R).

#Folder "shp"
* A .txt file providing the field description for the attributes of the ESRI shape files (sites_key.txt).
* A .txt file providing a list of references of published settlements data stored in the ESRI point shapefiles (References.txt).
* ESRI point shapefile of archaeological sites located in central Italy in the Iron Age (Iron_Age.shp)
* ESRI point shapefile of archaeological sites located in central Italy in the Archaic period (Archaic.shp)
* Updated ESRI point shapefile of archaeological sites located in central Italy in the Archaic period (Archaic_new.shp)
* ESRI point shapefile of archaeological sites located in central Italy in the Post-Archaic period (Post_Archaic.shp)
* ESRI polygons shapefiles of the modelled XTENT territories (xtent_k055.shp, xtent_k003.shp, xtent_k0016.shp). 
* ESRI point shapefile of the main urban centres (major_centres_utm.shp)
* ESRI polygon shapefile of the study area (region.shp)
* ESRI polygon shapefile of the archaeological surveys carried out in the region (surveys.shp)

#Folder "src"
* Source codes of the functions for calculating the observed A-coefficient (a12coeff.R) and to run a bootstrap statistical technique to test the statistical significance of the A-coefficient values (bootStrap_acoeff12.R).
* Source code of the function to load the function which allows you to  preserve the images pixel aspect ratio and to avoid any distortion of raster images plotted (addImg.R).

#Folder "csv"
* csv files storing the proprtions of the total estimated size within each concentring ring radiating from the main urban centre (cerveteri_centralization.csv, murlo_centralization.csv, tuscania_centralization.csv).
* csv file storing the site density within each concentring ring radiating from the main urban centre (cerveteri_density.csv, murlo_density.csv, tuscania_density.csv, veio_density.csv).

#Folder "jpeg"
* jpg files showing ten concentring rings radiating from the main urban centre (cerveteri.jpg, murlo.jpg, tuscania.jpg)

###### Licences
Dataset: CC-BY (http://creativecommons.org/licenses/by/4.0/)

Code: MIT (http://opensource.org/licenses/MIT year: 2020, copyright holder: Alessio Palmisano, Simon Stoddart, David Redhouse, Graeme Barker, Tom Rasmussen, Troy Samuels, and Nicola Terrenato)

##### Dependencies
R version 3.6.1 (2019-07-05)

