function [plot_handle] = inspect_MTM_template(mtm_params)
% [plot_handle] = inspect_MTM_template(mtm_params)
% Plot VEP_template contained in MTM param datastructure given in input (mtm_params).

%% ---- set pars and initialize ----

% unpack useful params
VEP_template=mtm_params.VEP_template;
VEP_template_std=mtm_params.VEP_template_std;
template_center_depths=mtm_params.template_center_depths;
S_freq=mtm_params.S_freq;
n_template_center_depths=numel(template_center_depths);
n_samples_to_use=size(VEP_template,2);

% get colors
C = parula;
C_template=flipud(C(round(linspace(1,64,n_template_center_depths)),:));

%% ---- plot VEP template ----

plot_step=5*mean(std(VEP_template,[],2));
handles_bis=cell(size(template_center_depths));
plot_handle=figure('units','normalized','outerposition',[0 0 1 1]);
baselevels=zeros(n_template_center_depths,1);
time_samples=(1:n_samples_to_use)*(1/S_freq)*1000;
for template_bin_idx=1:n_template_center_depths

    baselevel=plot_step*(template_bin_idx-1);
    plt=plot(time_samples,VEP_template(template_bin_idx,:)-baselevel,'LineWidth',6,'Color',C_template(template_bin_idx,:)); hold on;
    handles_bis{template_bin_idx}=plt;
    upper_lim_curve=VEP_template(template_bin_idx,:)+VEP_template_std(template_bin_idx,:)-baselevel;
    lower_lim_curve=fliplr(VEP_template(template_bin_idx,:)-VEP_template_std(template_bin_idx,:))-baselevel;
     patch = fill([time_samples,fliplr(time_samples)], [upper_lim_curve,lower_lim_curve], C_template(template_bin_idx,:));
     set(patch, 'edgecolor', 'none');
     set(patch, 'FaceAlpha', 0.35);
    baselevels(template_bin_idx)=median(VEP_template(template_bin_idx,:))-baselevel;
    
end
xlim([0,450]);
yticks(flipud(baselevels));
labelslist=sprintfc('%.f',fliplr(template_center_depths));
yticklabels(labelslist);
title('Average VEP depth template');
xlabel('time from stimulus onset (ms)')
ylabel('cortical depth (\mum)')
set(gca,'fontsize',13)

end

