function [ VEP_template_mu, VEP_template_std ] = get_VEP_template_for_MTM( Y, X, mtm_params )
% [ VEP_template_mu, VEP_template_std ] = get_VEP_template_for_MTM( Y, X, mtm_params )
% Function to obtain VEP template from an input VEP matrix (X) and depth labels for each channel (Y).

%% ---- set pars and initialize ----

% unpack useful params
template_center_depths=mtm_params.template_center_depths;

% get input sizes
n_template_center_depths=length(template_center_depths);
n_traces=size(Y,1);

% initialize matrices
Y_template_center_id=zeros(n_traces,1);
VEP_template_mu=zeros(n_template_center_depths,size(X,2));
VEP_template_std=zeros(n_template_center_depths,size(X,2));
n_VEPs_per_template=zeros(n_template_center_depths,1);

%% ---- build VEP template ----

% get template assignment labels
for trace_counter=1:n_traces
    % assign each trace to the closes depth bin
    [~,Y_template_center_id(trace_counter)]=min(abs(template_center_depths-Y(trace_counter)));
end

% get mu and std of VEPs assigned to each depth bin
for template_bin_idx=1:n_template_center_depths
    % get number of VEPs in current bin
    n_VEPs_per_template(template_bin_idx)=sum(Y_template_center_id==template_bin_idx);
    if n_VEPs_per_template(template_bin_idx)~=0
        % compute average (mu)
        VEP_template_mu(template_bin_idx,:)=mean(X(Y_template_center_id==template_bin_idx,:));
        % compute standard deviation (std)
        VEP_template_std(template_bin_idx,:)=std(X(Y_template_center_id==template_bin_idx,:));
    end
end

end

