function [ Y_layer_test_pred ] = get_MTM_predicted_layers( Y_test_pred, mtm_params )
% [ Y_layer_test_pred ] = get_MTM_predicted_layers( Y_test_pred, mtm_params )
% Function to predict layer identity (Y_layer_test_pred) combining predicted depths (Y_test_pred) and histological layer boundary information (layer_bins).

%% ---- set pars and initialize ----

% unpack useful params
layer_bins=mtm_params.layer_bins;
n_ch=mtm_params.n_ch;

% set layer numeric lables
layer_labels=[1,2,4,5,6];

% initialize output variable
Y_layer_test_pred=zeros(1,n_ch);


%% ---- classify channel laminar identity ----

% loop over channels
for ch_idx=1:n_ch
    % get one hot encoding for current channel
    one_hot_label=histc(Y_test_pred(ch_idx),layer_bins);
    one_hot_label=logical(one_hot_label(1:end-1));
    current_label=layer_labels(one_hot_label);
    % assign corresponding numeric label
    Y_layer_test_pred(ch_idx)=current_label;
end

% output it as column vector
Y_layer_test_pred=Y_layer_test_pred';

end
