function [ Y_test_pred,min_match_distance,match_distance_matrix ] = get_MTM_predicted_depth( X_test, mtm_params )
% [ Y_test_pred,min_match_distance,match_distance_matrix ] = get_MTM_predicted_depth( X_test, mtm_params )
% Function to get depth predictions (Y_test_pred) for VEP test data (X_test) from mtm_params structure containing the VEP template.

%% ---- set pars and initialize ---- 

% unpack useful params
VEP_template=mtm_params.VEP_template;
template_center_depths=mtm_params.template_center_depths;
min_effective_spacing=mtm_params.min_effective_spacing;
max_effective_spacing=mtm_params.max_effective_spacing;
min_tip_depth=mtm_params.min_tip_depth;
max_tip_depth=mtm_params.max_tip_depth;
n_effective_spacings=mtm_params.n_effective_spacings;
n_tip_depths=mtm_params.n_tip_depths;
n_ch=mtm_params.n_ch;

% compute ranges of search grid (effective spacings and tip depths to try)
n_best_matches_to_average=round(mtm_params.fraction_best_matches_to_average*mtm_params.n_effective_spacings*mtm_params.n_tip_depths);
effective_spacings=linspace(min_effective_spacing,max_effective_spacing,n_effective_spacings);
tip_depths=linspace(min_tip_depth,max_tip_depth,n_tip_depths);

% initialize match distance matrix
match_distance_matrix=zeros(n_tip_depths,n_effective_spacings);

%% ---- compute Euclidean distance matrix ---- 

% loop over tip depths
for td_idx=1:n_tip_depths
    % loop over effective spacings
    for es_idx=1:n_effective_spacings
        
        % get current channel depths (for current combination of tip depth and effective spacing)
        current_ch_depths=tip_depths(td_idx)-effective_spacings(es_idx)*(0:n_ch-1);
        
        % search closest VEP template centers
        closer_template_idx=zeros(1,n_ch);
        % loop over channels
        for ch_idx=1:n_ch
            % choose closest template depth bin
            [~,selected_depth_index]=min(abs(current_ch_depths(ch_idx)-template_center_depths));
            % store it
            closer_template_idx(ch_idx)=selected_depth_index;
        end
        % obtain expected VEP profile(grabbing reference VEP waveshapes from the template)
        expected_VEP_profile=VEP_template(closer_template_idx,:);
        % fetch observed VEP profile
        observed_VEP_profile=X_test;
        % compute Euclidean distances between observed and predicted wavershapes (averaging over channels)
                Ed=mean(sqrt(sum((expected_VEP_profile - observed_VEP_profile).^2,2)));
        % store Euclidean distances in match_distance_matrix
        match_distance_matrix(td_idx,es_idx)=Ed;
        
    end
end

%% ---- predict depth by wheighted averaging ---- 

% find minimal matching distance conditions
[min_match_distance,unrolled_idx]=sort(match_distance_matrix(:),'ascend');
[min_match_idx_td,min_match_idx_es]=ind2sub(size(match_distance_matrix),unrolled_idx);

% get channel depths prediction
temp_pred=zeros(n_ch,n_best_matches_to_average);
for best_matches_idx=1:n_best_matches_to_average
    
    temp_pred(:,best_matches_idx) =(tip_depths(min_match_idx_td(best_matches_idx))...
        -effective_spacings(min_match_idx_es(best_matches_idx))*(0:n_ch-1));
    
end
weights = ( (1./(min_match_distance(1:n_best_matches_to_average)))./(sum(1./(min_match_distance(1:n_best_matches_to_average)))) )';
Y_test_pred=sum(repmat(weights,n_ch,1).*temp_pred,2);

end

