clear all
close all
clc

% set how to obtain the VEP template
which_template='load_reference_template'; % 'produce_template_from_VEPs'; 

%% ---- set parameters of the MTM algorithm ---- 

% set number of channels along a shank
mtm_params.n_ch=32;

% set value range of the search grid (tip angle <-> effective site spacing)
mtm_params.min_effective_spacing=15;                                        % as a rule of thumb: max expected angle + 15 headroom
mtm_params.max_effective_spacing=25;                                        % as a rule of thumb: perfectly vertical

% set value range of the search grid (tip depths)
mtm_params.min_tip_depth=400;                                               % as a rule of thumb: max expected depth in datset - 200 um headroom
mtm_params.max_tip_depth=1600;                                              % as a rule of thumb: max expected depth in datset + 200 um headroom

% set quantile of matches to use for weighted averaging
mtm_params.fraction_best_matches_to_average=1;                             

% set dimentions of the search grid
mtm_params.n_effective_spacings=25; 
mtm_params.n_tip_depths=25;

% set template bin centers
mtm_params.template_center_depths=(25:150:1275);                            % as a rule of thumb: choosen depending on amount of data and span of channel depth in the VEP dataset

%% ---- set layers bins ---- 

% load layer borders (inferred from histology) to define depth bins
load('layers_borders_from_histology.mat')

% store layer border information in params structure
mtm_params.layer_bins=V1_layer_bins;

%% ---- get VEP template ---- 

switch which_template
    
    % if you want to produce a vew template from VEP_dataset.mat
    case 'produce_template_from_VEPs'
        
        % load VEP dataset
        load('VEP_dataset.mat');
     
        % produce template from VEPs
        [ VEP_template_mu, VEP_template_std ] =...
            get_VEP_template_for_MTM( Y, X, mtm_params );
        
    % if you want to use reference template from the paper
    case 'load_reference_template'
        
        % load reference VEP template
        load('VEP_template.mat')
        
end

% store template in mtm params structure
mtm_params.VEP_template=VEP_template_mu;
mtm_params.VEP_template_std=VEP_template_std;
mtm_params.S_freq=S_freq;

%% ---- use VEP template for layer prediction on example data ---- 

% load example test session data
load('example_session_data.mat')

% get depth prediction for test session
[ Y_test_pred,min_match_distance,match_distance_matrix ] = get_MTM_predicted_depth( X_test, mtm_params );
% assess depth prediction performance
depth_prediction_rmse=sqrt(mean((Y_test_pred-Y_test).^2));

% infer predicted layers from predicted depths
[ Y_layer_test_pred ] = get_MTM_predicted_layers( Y_test_pred, mtm_params );
% assess layer classification performance
layer_prediction_accuracy=sum(Y_layer_test_pred==Y_layer_test)/numel(Y_test);

%% ---- inspect results ---- 

% plot MTM template for inspection
inspect_MTM_template(mtm_params);
% plot prediction results
inspect_MTM_prediction_results( Y_test_pred, Y_layer_test_pred, Y_test, Y_layer_test, X_test, mtm_params)
