%-------------------------------------------------------------------------------------------------------
% PURPOSE: "Backtesting Marginal Expected Shortfall and Related Systemic Risk Measures"
%           Banulescu, Leymarie, Hurlin and Scaillet (2016)
%-------------------------------------------------------------------------------------------------------
% Compute the adjusted alpha coverage allowing to retreive well specified MES and SRISK
%-------------------------------------------------------------------------------------------------------
% J. Leymarie, September 25, 2017.
% LEO, University of Orleans
%-------------------------------------------------------------------------------------------------------

function obj=adjusted_alpha(alpha_tilde,Y1_out,Y2_out,var2_out,Sigma_out,alpha)

N=length(Y1_out);                                                         % OOS sample size

H_tilde=zeros(N,1);                                                       % Ht(alpha) series (with estimation risk)

VaR2_tilde=sqrt(var2_out)*norminv(alpha_tilde);                           % Value-at-Risk of level alpha for Y2 (in-sample)

for i=1:N                                                                 % Loop on out-of-sample periods
            
if Y2_out(i)<=VaR2_tilde(i)                                               % Indicator function on Y2

H_tilde(i)=1-mvncdf([Y1_out(i) VaR2_tilde(i)],zeros(1,2),Sigma_out(:,:,i))/alpha_tilde;  % Cumulative violation

end                                                                       % End of if condition
            
end                                                                       % End of loop on i

obj=(mean(H_tilde)-alpha/2)^2;                                            % Objective function to be minimized

end