%-------------------------------------------------------------------------------------------------------------
% Purpose: Estimate the variance of the sample mean when there is serial dependence using HAC Estimator
%          (Newey and West, Econometrica 1987)
%-------------------------------------------------------------------------------------------------------------
% Function S_NW = HAC(Ht,mu,sig2)
% Inputs 
%          - Ht   : (Nx1) vector of Cumulative Joint Violation process
%          - mu   : Ht expectation under H0
%          - sig2 : Ht variance under H0
% Outputs
%          - S_NW : Estimated variance of sqrt(N)*mean(H)
% ---------------------------------------------------------------------
% J. Leymarie - Oct 11, 2016.
% LEO, University of Orleans
% ---------------------------------------------------------------------

function S_NW = hac(Ht,mu,sig2)

N=length(Ht);               % Ht sample size

q=round(0.5*N^(1/3));       % Truncated parameter (depending on N)

Gamma_L=NaN(q,1);           % Initialization of Gamma function

for v=1:q                   % Loop on v
    
    Gamma_L(v)=(1-v/(q+1))*2*mean((Ht(1:N-v)-mu).*(Ht(v+1:N)-mu));
    
end 

S_NW=sig2+sum(Gamma_L);     % Variance of sqrt(N)*(mean(H)-alpha/2)
                             
end



