
my $utr_length = 120;  #size of 3'UTR to retrieve
my $gap_filter = 5;   #number of gaps allowed in MA
my $header = -1;
my $agoHumanPrt = 0;
my $name, $agoH, $agoHgaps, $agoSp, $agoSpGaps;

while($line=<>){

    chomp $line;

    if($line =~ m/>[^\s]+ (.*)$/){
        $name = $1;
        $header=1;
    } else {
        if($header==1){ #AGO human
            ($agoH,$agoHgaps) = analyze_seq($line,$utr_length);
            $header = 2;
        } else {
            ($agoSp,$agoSpGaps) = analyze_seq($line,$utr_length);
            $header=0;
        }
    }

    if ( $header==0 & ($agoHgaps+$agoSpGaps) <= $gap_filter ){
        #print "$name\t$agoH\t$agoHgaps\t$agoSp\t$agoSpGaps\n"; 
        
        #print to FASTA
        if($agoHumanPrt == 0) { print ">hg19\n$agoH\n"; $agoHumanPrt = 1;}
        print ">$name\n$agoSp\n";
    }
}

sub analyze_seq{

    my $initial_str = shift;
    my $des_length = shift;
    my $final_str = "";
    my $gap_counter = 0;

    for(my $i = 0; $i < length($initial_str); $i++){

        my $base = substr($initial_str,$i,1);

        if(length($final_str) < $des_length){
            #if($base eq "-" | $base eq "N"){
            if($base eq "-"){
                $gap_counter++;
            } else {
                if($base eq "N") { $gap_counter++; }
                $final_str = $final_str . uc($base);
            }
        }

    }

    return ($final_str,$gap_counter);
}
