# AGO1x prevents dsRNA-induced interferon signaling to promote proliferation of breast cancer cells
This project includes analyses and figure generation performed for the paper [AGO1x prevents dsRNA-induced interferon signaling to promote proliferation of breast cancer cells](https://www.to.do).

## Data 
Necessary datasets (for example, gene expression matrix, auxiliary files, etc.) can be found in the folder "data/".

## Requirements
The provided code has been tested with:
- R 3.3.3 [macOS 10.15.2 : x86_64-apple-darwin13.4.0 (64-bit)]
- DESeq2_1.12.4
- gplots_3.0.1
- biomaRt_2.28.0
- VennDiagram_1.6.17

## Project structure
In this project you will find the following files/folders:
- **mda.mb.231.analysis.R** : An R script to perform the analyses and generate figures for MDA-MB-231 data
- **hela.analysis.R** : An R script to perform the analyses and generate figures for HeLa data
- **other.analysis.R** : An R script to perform the analyses and generate figures for readthrough conservation, as well as analysis of AGO1 and AGO1x binding partners
- **data/** : contains all required input files to perform the analyses
	- **3utr.conservation/** : Genome alignments for AGO1 3'UTR across species; genome-wide translation readthrough (RT) conservation analysis (e.g. length of RT region and average conservation) as well as gene ontology analysis for genes with high RT region conservation
	- **ago1x.localization/** : statistics for AGO1x localization in cells
	- **auxiliary/** : auxiliary input files for the analysis script (e.g. human mRNAs features)
	- **dsrnaseq.mdb231-cas9-triplicates/** : gene count tables (and other analysis) for dsRNA expression profiling in MDA-MB-231 (mapping to txome and repetitive elements)
	- **ms.crispr.cell.lines/** : analysis of mass spectometry data comparing the different CRISPR cell lines (Control and mutants) in MDA-MB-231
	- **ms.ip.ago1x.vs.ago1.ip/** : analysis of mass spectometry data comparing the binding partners of AGO1x and IgG, as well as AGO1x and AGO1 in nuclear extracts from MDA-MB-231
	- **ms.ip.over.exp.ago1x.vs.ago1/** : analysis of mass spectometry data comparing the binding partners of AGO1x and AGO1 overexpressed from a lentivirus in MDA-MB-231
	- **rnaseq.hela-cas9-triplicates/** : gene count tables (and other analysis) for mRNA expression profiling in HeLa. It also includes the output from GSEA and ISMARA analyses
	- **rnaseq.mdb231-cas9-triplicates/** : gene count tables (and other analysis) for mRNA expression profiling in MDA-MB-231 (mapping to txome and repetitive elements). It also includes the output from GSEA and ISMARA analyses
- **figures/** : contains all the figures generated by the R script
- **README.md** : this file
- **results/** :  contains all the tables generated by the R script
- **scripts/** : contains scripts used to generate some of the input files required for the analyses
- **tables/** : contains multiple tables with distincts analyses presented in the paper

## Running analysis
$ Rscript hela.analysis.R
$ Rscript mda.mb.231.analysis.R
$ Rscript other.analysis.R

## Output
The analyses output will be saved to the following folders:
- **results/** : contains several tables (e.g. differential expression)
- **figures/** : contains several figures

## RAW data
FASTQ files for all high thoughput datasets generated in this study are available at: https://www.ncbi.nlm.nih.gov/bioproject/PRJNA447929

## Citation
Please cite the following paper: [AGO1x prevents dsRNA-induced interferon signaling to promote proliferation of breast cancer cells](https://www.to.do).

## Contact
All correspondence about the analyses provided can be addressed to [Joao C Guimaraes](mailto:joaoguima@gmail.com)