package is.hail.expr.ir

object RewriteBottomUp {
  def apply(ir: BaseIR, rule: BaseIR => Option[BaseIR]): BaseIR = {
    def rewrite(ast: BaseIR): BaseIR = {
      val newChildren = ast.children.map(rewrite)

      // only recons if necessary
      val rewritten =
        if ((ast.children, newChildren).zipped.forall(_ eq _))
          ast
        else
          ast.copy(newChildren)

      rule(rewritten) match {
        case Some(newAST) =>
          if (newAST != rewritten)
            rewrite(newAST)
          else newAST
        case None =>
          rewritten
      }
    }

    rewrite(ir)
  }
}
