% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testthat_addins.R
\name{insertExpectationsAddin}
\alias{insertExpectationsAddin}
\title{Creates testthat tests for selected code}
\usage{
insertExpectationsAddin(selection = NULL, insert = TRUE, indentation = 0)
}
\arguments{
\item{selection}{String of code. (Character)

E.g. \code{"stop('This gives an expect_error test')"}.

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{insert}{Whether to insert the expectations via
\code{\link[rstudioapi:insertText]{rstudioapi::insertText()}}
or return them. (Logical)

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{indentation}{Indentation of the selection. (Numeric)

\strong{N.B.} Mainly intended for testing the addin programmatically.}
}
\value{
Inserts \code{\link[testthat:expect_equal]{testthat::expect_*}}
unit tests for the selected code.

Returns \code{NULL} invisibly.
}
\description{
Inserts relevant \code{expect_*} tests based
on the evaluation of the selected code.

Example: If the selected code is the name of a data frame object,
it will create an \code{\link[testthat:expect_equal]{expect_equal}}
test for each column,
along with a test of the column names.

Currently supports side effects (error, warnings, messages),
data frames, and vectors.

List columns in data frames (like nested tibbles) are currently skipped.

See \code{Details} for how to set a key command.
}
\details{
\subsection{How}{
Parses and evaluates the selected code string
within the parent environment.
Depending on the output, it creates a set of unit tests
(like \code{expect_equal(data[["column"]], c(1,2,3))}),
and inserts them instead of the selection.
}
\subsection{How to set up a key command in RStudio}{

After installing the package.
Go to:

\code{Tools >> Addins >> Browse Addins >> Keyboard Shortcuts}.

Find \code{"Insert Expectations"} and press its field under \code{Shortcut}.

Press desired key command, e.g. \code{Alt+E}.

Press \code{Apply}.

Press \code{Execute}.
}
}
\seealso{
Other expectation generators: 
\code{\link{gxs_function}()},
\code{\link{gxs_selection}()}

Other addins: 
\code{\link{assertCollectionAddin}()},
\code{\link{dputSelectedAddin}()},
\code{\link{wrapStringAddin}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{addins}
\concept{expectation generators}
