import dolfin as df
import numpy as np

mesh = df.Mesh("cookie.xml")
U = np.loadtxt("U.txt", ndmin=2)
assert U.ndim == 2

V = df.FunctionSpace(mesh, "CG", 1)

if U.shape[1] != V.dim():
    U = U.T
assert U.shape[1] == V.dim()

output = df.File("out.pvd")
state = df.Function(V)
for u in U:
    state.vector()[:] = u
    output << state
