from scipy.io import mmread
import matplotlib.pyplot as plt

Ai = [mmread(f"A{i}.mtx") for i in range(5)]
E = mmread("E.mtx")

fig, ax = plt.subplots(2, 3, figsize=(15, 10))
ax[0, 0].spy(E, marker=",")
ax[0, 0].set_title("$E$")
ax[1, 0].spy(Ai[0], marker=",")
ax[1, 0].set_title("$A_0$")
for i, A in enumerate(Ai[1:]):
    pos = (i % 2, i // 2 + 1)
    ax[pos].spy(A, marker=",")
    ax[pos].set_title(f"$A_{i + 1}$")
fig.savefig("spy.png", dpi=150, bbox_inches="tight")
