%% Introduction

% The hysterisis loops of the collected data are ploted.

% Input: specimen name and the type of hysteresis plot (Global or Panel zone response)
% Output: hysteresis response together with maximum and minimum force and
% rotation values.

clear; clc; close all;

%% Input Parameters

plot_type = 'Global_Response'; % Either 'Global_Response' or 'Panel_Zone_Response'
specimen = 'UT05_Shin_F_SDR.csv'; % Input the specimen to be ploted

%% Load files

directory = cd;
local_directory = strcat(cd,'\',plot_type);
cd(local_directory);
data_array = xlsread(specimen);

%% Plots

if strcmp(plot_type, 'Global_Response')  
    figure('position',[550 100 350 300],'color','white');
    hold on; grid on; box on;
    set(gcf,'units','pixels')
    set(gcf,'Position', [1500, 500, 350, 330]) 
    set(gca,'units','pixels')
    set(gca,'Position', [80, 75, 200, 200])

    plot(data_array(:,1),data_array(:,2),'LineStyle','-','color','black','LineWidth', 1.2);
    xlabel('\itSDR\rm [rad]');
    ylabel('Actuator force, \itF\rm [kN]');
    set(gca,'FontSize',12);set(gca,'FontName','Times New Roman');
    set(gca,'GridLineStyle','--')
    set(gca,'color','white');
    [max_F max_F_id] = max(data_array(:,2));
    [min_F min_F_id] = min(data_array(:,2));
    [max_sdr max_sdr_id] = max(data_array(:,1));
    [min_sdr min_sdr_id] = min(data_array(:,1));
    scatter(data_array(max_F_id,1),data_array(max_F_id,2),40,'o', 'MarkerEdgeColor','k',...
                          'MarkerFaceColor','red',...
                          'LineWidth',0.4, 'HandleVisibility', 'Off');
    scatter(data_array(min_F_id,1),data_array(min_F_id,2),40,'o', 'MarkerEdgeColor','k',...
                          'MarkerFaceColor','red',...
                          'LineWidth',0.4, 'HandleVisibility', 'Off');
    scatter(data_array(max_sdr_id,1),data_array(max_sdr_id,2),40,'o', 'MarkerEdgeColor','k',...
                          'MarkerFaceColor','green',...
                          'LineWidth',0.15, 'HandleVisibility', 'Off');
    scatter(data_array(min_sdr_id,1),data_array(min_sdr_id,2),40,'o', 'MarkerEdgeColor','k',...
                          'MarkerFaceColor','green',...
                          'LineWidth',0.4, 'HandleVisibility', 'Off');
                      
    htext = text(data_array(max_F_id,1),data_array(max_F_id,2),['(' num2str(data_array(max_F_id,1),2) ',' num2str(data_array(max_F_id,2),4) ')']);
    set(htext,'FontSize', 11,'FontName','Times New Roman', 'FontWeight', 'normal')               
    htext = text(data_array(min_F_id,1),data_array(min_F_id,2),['(' num2str(data_array(min_F_id,1),2) ',' num2str(data_array(min_F_id,2),4) ')']);
    set(htext,'FontSize', 11,'FontName','Times New Roman', 'FontWeight', 'normal')      
    htext = text(data_array(max_sdr_id,1),data_array(max_sdr_id,2),['(' num2str(data_array(max_F_id,1),2) ',' num2str(data_array(max_F_id,2),4) ')']);
    set(htext,'FontSize', 11,'FontName','Times New Roman', 'FontWeight', 'normal')               
    htext = text(data_array(min_sdr_id,1),data_array(min_sdr_id,2),['(' num2str(data_array(min_F_id,1),2) ',' num2str(data_array(min_F_id,2),4) ')']);
    set(htext,'FontSize', 11,'FontName','Times New Roman', 'FontWeight', 'normal')
    
else
    figure('position',[550 100 350 300],'color','white');
    hold on; grid on; box on;
    plot(data_array(:,1),data_array(:,2),'LineStyle','-','color','black','LineWidth', 1.2);
    xlabel('Panel zone shear distortion, \gamma [rad]');
    ylabel('Panel zone shear force, \itV_{pz}\rm [kN]');
    set(gca,'FontSize',12);set(gca,'FontName','Times New Roman');
    set(gca,'GridLineStyle','--')
    set(gca,'color','white');
    [max_F max_F_id] = max(data_array(:,2));
    [min_F min_F_id] = min(data_array(:,2));
    [max_sdr max_sdr_id] = max(data_array(:,1));
    [min_sdr min_sdr_id] = min(data_array(:,1));
    scatter(data_array(max_F_id,1),data_array(max_F_id,2),40,'o', 'MarkerEdgeColor','k',...
                          'MarkerFaceColor','red',...
                          'LineWidth',0.4, 'HandleVisibility', 'Off');
    scatter(data_array(min_F_id,1),data_array(min_F_id,2),40,'o', 'MarkerEdgeColor','k',...
                          'MarkerFaceColor','red',...
                          'LineWidth',0.4, 'HandleVisibility', 'Off');
    scatter(data_array(max_sdr_id,1),data_array(max_sdr_id,2),40,'o', 'MarkerEdgeColor','k',...
                          'MarkerFaceColor','green',...
                          'LineWidth',0.15, 'HandleVisibility', 'Off');
    scatter(data_array(min_sdr_id,1),data_array(min_sdr_id,2),40,'o', 'MarkerEdgeColor','k',...
                          'MarkerFaceColor','green',...
                          'LineWidth',0.4, 'HandleVisibility', 'Off');
                      
    htext = text(data_array(max_F_id,1),data_array(max_F_id,2),['(' num2str(data_array(max_F_id,1),2) ',' num2str(data_array(max_F_id,2),4) ')']);
    set(htext,'FontSize', 11,'FontName','Times New Roman', 'FontWeight', 'normal')               
    htext = text(data_array(min_F_id,1),data_array(min_F_id,2),['(' num2str(data_array(min_F_id,1),2) ',' num2str(data_array(min_F_id,2),4) ')']);
    set(htext,'FontSize', 11,'FontName','Times New Roman', 'FontWeight', 'normal')      
    htext = text(data_array(max_sdr_id,1),data_array(max_sdr_id,2),['(' num2str(data_array(max_F_id,1),2) ',' num2str(data_array(max_F_id,2),4) ')']);
    set(htext,'FontSize', 11,'FontName','Times New Roman', 'FontWeight', 'normal')               
    htext = text(data_array(min_sdr_id,1),data_array(min_sdr_id,2),['(' num2str(data_array(min_F_id,1),2) ',' num2str(data_array(min_F_id,2),4) ')']);
    set(htext,'FontSize', 11,'FontName','Times New Roman', 'FontWeight', 'normal')
end
