# -*- coding: utf-8 -*- 

import re
import os
from os import chdir, getcwd, listdir, path
from os import walk
import comtypes.client 
import xlsx2csv
import logging
from PIL import Image
import fileinput
import zipfile

##########################
#### PFADE DEFINIEREN ####
##########################

#### FIX in Python definiert: ####

#path = r'D:\Brigit_Dateien\Dokumente\OPEN-RESEARCH-DATA\Convert'
#acmecadconvert = r"C:\Software\AcmeCADConverter\AcmeCADConverter.exe"
#pdf24path = r"C:\Software\pdf24-DocTool.exe.lnk"
#profile = r"user/pdfa"
#iconv = r"C:\Software\iconv\bin\iconv.exe"
#doi = "10.5281/zenodo.3685479"

#### Definiert durch Eingabe in Kommandozeile: ####
path = input("Massnameordner angeben: ")
acmecadconvert = input("AcmeCADConverter.exe hierherziehen: ")
pdf24path = input("pdf24-DocTool.exe hierherziehen. ACHTUNG: DARF KEINE LEERZEICHEN BEINHALTEN!! ")
profile = r"user/" + input("Name des Profiles für PDF-As eingeben: ")
iconv = input("Hier iconv.exe herziehen: ")
doi = input("Hier die DOI eingeben: ")

## Logging:
log = input("Hier leeres Textfile als Logfile angeben: ")
logging.basicConfig(filename=log, level=logging.INFO, format='%(asctime)s %(message)s', datefmt='%d/%m/%Y %H:%M:%S')


############################################################################
#### ERSETZEN VON ALLEN LEERZEICHEN (braucht es für PDF24) UND UMLAUTEN ####
############################################################################


#### Alle Dateien:
def dateien_ersetzen(eingabe, ausgabe):
    for dirpath, dirnames, filenames in os.walk(path):
        for f in filenames:
            if eingabe in f:
                newfilename = f.replace(eingabe, ausgabe)
                in_file = os.path.abspath(dirpath + "\\" + f)
                new_file = os.path.abspath(dirpath + "\\" + newfilename)
                print("Umbenennung", newfilename)
                logging.info("Umbenennung Datei: " + f + "->" + newfilename)
                os.rename(in_file, new_file)

leerzeichen = dateien_ersetzen(" ", "_")
AE = dateien_ersetzen(u'Ä', "Ae")
ae = dateien_ersetzen(u'ä', "ae")
Oe = dateien_ersetzen(u'Ö', "Oe")
oe = dateien_ersetzen(u'ö', "oe")
Ue = dateien_ersetzen(u'Ü', "Ue")
ue = dateien_ersetzen(u'ü', "ue")
ss = dateien_ersetzen(u'ß', "ss")


#### Alle Ordner:
def ordner_ersetzen(eingabe, ausgabe):
    for dirpath, dirnames, filenames in os.walk(path, topdown = False):
        for d in dirnames:
            if eingabe in d:
                newdirname = d.replace(eingabe, ausgabe)
                in_folder = os.path.join(dirpath, d)
                new_folder = os.path.join(dirpath, newdirname)
                print("Umbenennung " + newdirname)
                logging.info("Umbenennung Ordner " + d + " -> " + newdirname)
                os.rename(in_folder, new_folder)

leerzeichen = ordner_ersetzen(" ", "_")
AE = ordner_ersetzen(u'Ä', "Ae")
ae = ordner_ersetzen(u'ä', "ae")
Oe = ordner_ersetzen(u'Ö', "Oe")
oe = ordner_ersetzen(u'ö', "oe")
Ue = ordner_ersetzen(u'Ü', "Ue")
ue = ordner_ersetzen(u'ü', "ue")
ss = ordner_ersetzen(u'ß', "ss")
bindestrich = ordner_ersetzen("-", "_")


#######################################
#### ENTPACKEN VON .EXE-CONTAINERN ####
#######################################

for dirpath, dirnames, filenames in os.walk(path):
    for f in filenames:
        if f.lower().endswith('.exe'):
            filePath = os.path.abspath(dirpath + "\\" + f)
            new_container_name = f.replace("exe", "zip")
            name_folder = new_container_name.replace(".zip", "")
            os.rename(dirpath + "\\" + f, dirpath + "\\" + new_container_name)
            logging.info("exe-container " + f + " zu zip-container " + new_container_name + " konvertiert")
            print("Umbenennung " + new_container_name)
            

#######################################
#### ENTPACKEN VON .ZIP-CONTAINERN ####
#######################################

for dirpath, dirnames, filenames in os.walk(path):
    for f in filenames:
        if f.lower().endswith('.zip'):
            filePath = os.path.abspath(dirpath + "\\" + f)
            name_folder = f.replace(".zip", "")
            new_folder = os.path.abspath(dirpath + "\\" + name_folder)
            os.mkdir(new_folder)
            zip_file = zipfile.ZipFile(filePath)
            zip_file.extractall(new_folder)
            zip_file.close()
            logging.info("zip " + f + " wurde entzippt nach " + new_folder)
            os.remove(filePath)  #### ACHTUNG: Löscht zip-container!
            logging.info("zip-file gelöscht " + f)
            print("Entzippen " + filePath)
            

###################################################
#### ABSPEICHERN ALLER DXFs ALS SVGs UND PDFs: ####
###################################################
            
for dirpath, dirnames, filenames in os.walk(path):
    print(dirpath)
    for f in filenames:
        ## dxf zu svg
        if f.lower().endswith("dxf"):
            in_file = os.path.abspath(dirpath + "\\" + f)
            cmd = acmecadconvert + " /r /ls /f 101 /a -2 " + in_file
            os.system(cmd)
            logging.info("dxf zu svg " + f + "->" + f.replace(".dxf", r".svg"))
            print("dxf zu svg" + f)
        ## dxf zu pdf
        if f.lower().endswith("dxf"):
            in_file = os.path.abspath(dirpath + "\\" + f)
            cmd = acmecadconvert + " /r /ls /f 104 /a -2 /layer /pdf tshe " + in_file
            os.system(cmd)
            logging.info("dxf zu pdf " + f + "->" + f.replace(".dwg", r".pdf"))
            print("dxf zu pdf " + f) 

########################################################
#### ABSPEICHERN ALLER DWGs ALS DXFs, SVGs UND PDF: ####
########################################################
            
for dirpath, dirnames, filenames in os.walk(path):
    print(dirpath)
    for f in filenames:
        ## dwg zu dxf:
        if f.lower().endswith("dwg"):
            new_name = f.replace(".dwg", r".dxf")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + new_name)
            cmd = acmecadconvert + " /r /x14 " + in_file + " " + new_file
            os.system(cmd)
            logging.info("dwg zu dxf " + f + "->" + new_name)
            print("dwg zu dxf " + f)
        ## dwg zu svg:
        if f.lower().endswith("dwg"):
            in_file = os.path.abspath(dirpath + "\\" + f)
            cmd = acmecadconvert + " /r /ls /f 101 /a -2 " + in_file
            os.system(cmd)
            logging.info("dwg zu svg " + f + "->" + f.replace(".dwg", r".svg"))
            print("dwg zu svg " + f)
        ## dwg zu pdf:
        if f.lower().endswith("dwg"):
            in_file = os.path.abspath(dirpath + "\\" + f)
            cmd = acmecadconvert + " /r /ls /f 104 /a -2 /layer /pdf tshe " + in_file
            os.system(cmd)
            logging.info("dwg zu pdf " + f + "->" + f.replace(".dwg", r".pdf"))
            print("dwg zu pdf " + f)

######################################################################################
#### ERSETZEN ALLER PDFs ZU PDF-A, Achtung: Alle originalen PDFs werden gelöscht! ####
######################################################################################      

for dirpath, dirnames, filenames in os.walk(path):
        print (dirpath)
        for f in filenames:
            if f.lower().endswith("pdf"):
                new_name = f.replace(".pdf", r"_pdfa.pdf")
                in_file = os.path.abspath(dirpath + "\\" + f)
                new_file = os.path.abspath(dirpath + "\\" + new_name)
                cmd = pdf24path + " -convertToPDF " + "-outputFile " + new_file + " -profile " + profile + " " + in_file
                os.system(cmd)
                logging.info("pdf zu pdf-a " + f + "->" + new_name)
                os.remove(in_file) ## Falls die originalen PDFs NICHT gelöscht werden sollen: Zeile inaktiv schalten durch "#"
                logging.info("pdf gelöscht " + f)
                print("pdf zu pdf-a " + f)

##########################################################################################
#### NEU ABSPEICHERN ALLER WORD-FILES ALS PDF-A, Achtung: braucht installiertes Word! ####
##########################################################################################
   
try:
    word = comtypes.client.CreateObject('Word.Application')
    for dirpath, dirnames, filenames in os.walk(path):
        print (dirpath)
        for f in filenames:
            if f.lower().endswith(".docx"):
                new_name = f.replace(".docx", r".pdf")
                in_file = os.path.abspath(dirpath + "\\" + f)
                new_file = os.path.abspath(dirpath + "\\" + new_name)
                doc = word.Documents.Open(in_file)
                doc.ExportAsFixedFormat(
                    OutputFileName=new_file,
                    ExportFormat=17, #17 = PDF output, 18=XPS output
                    OpenAfterExport=False,
                    OptimizeFor=0,  #0=Print (higher res), 1=Screen (lower res)
                    CreateBookmarks=1, #0=No bookmarks, 1=Heading bookmarks only, 2=bookmarks match word bookmarks
                    DocStructureTags=True,
                    UseISO19005_1 = True #Wenn True dann PDF-A
                    );
                doc.Close()
                logging.info("docx zu pdf-a " + f + " " + new_name)
                os.remove(in_file)
                logging.info("docx gelöscht " + f)
                print("docx zu pdf-a " + f)
            if f.lower().endswith(".doc"):
                new_name = f.replace(".doc", r".pdf")
                in_file = os.path.abspath(dirpath + "\\" + f)
                new_file = os.path.abspath(dirpath + "\\" + new_name)
                doc = word.Documents.Open(in_file)
                doc.ExportAsFixedFormat(
                    OutputFileName=new_file,
                    ExportFormat=17, #17 = PDF output, 18=XPS output
                    OpenAfterExport=False,
                    OptimizeFor=0,  #0=Print (higher res), 1=Screen (lower res)
                    CreateBookmarks=1, #0=No bookmarks, 1=Heading bookmarks only, 2=bookmarks match word bookmarks
                    DocStructureTags=True,
                    UseISO19005_1 = True #Wenn True dann PDF-A
                    );
                doc.Close()
                logging.info("doc zu pdf-a " + f + "->" + new_name)
                os.remove(in_file)
                logging.info("doc gelöscht " + f)
                print("doc zu pdf-a " + f)
finally:
    word.Quit()


#########################################
#### ABSPEICHERN DER EXCELs ALS CSVs ####
#########################################
    
for dirpath, dirnames, filenames in os.walk(path):
    print (dirpath)
    for f in filenames:
        if f.lower().endswith(".xlsx"):
            new_name = f.replace(".xlsx", r".csv")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + new_name)
            cmd = "xlsx2csv.py -d tab -a " + in_file + " " + new_file
            os.system(cmd)
            logging.info("xlsx zu csv " + f + "->" + new_name)
            print("xlsx zu csv " + f)
for dirpath, dirnames, files in os.walk(path):  
    for name in files:  
        filename = os.path.join(dirpath,name)   
        if os.stat(filename).st_size == 0:  
            print("csv gelöscht da leer " + name)  
            os.remove(filename)
            logging.info("leeres csv gelöscht " + filename)

#######################
#### TXT ALS UTF-8 ####
#######################

for dirpath, dirnames, files in os.walk(path):
    for f in files:
        if f.endswith("TXT"):
            new_name = f.replace(".TXT", r"_utf8.txt")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + new_name)
            cmd = iconv + " -f cp1252 -t utf-8 " + in_file + " > " + new_file
            os.system(cmd)
            os.remove(in_file) ##ACHTUNG: Alle Ausgangsfiles werden gelöscht!
            logging.info("txt in utf-8 konvertiert " + f)
            print("TXT zu UTF-8 " + f)
        if f.endswith("txt"):
            new_name = f.replace(".txt", r"_utf8.txt")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + new_name)
            cmd = iconv + " -f cp1252 -t utf-8 " + in_file + " > " + new_file
            os.system(cmd)
            os.remove(in_file) ##ACHTUNG: Alle Ausgangsfiles werden gelöscht!
            logging.info("txt in utf-8 konvertiert " + f)
            print("txt zu UTF-8 " + f)

###################################
#### PNGs zu TIFs konvertieren ####
###################################

for dirpath, dirnames, filenames in os.walk(path):
    print(dirpath)
    for f in filenames:
        if f.lower().endswith("png"):
            new_name = f.replace(".png", r".tif")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + new_name)
            img = Image.open(in_file)
            img.save(new_file)
            logging.info("png zu tif konvertiert " + f + "->" + new_name)
            print("png zu tif " + f)


##########################################
#### ORDNER- UND DATEILISTE ERSTELLEN ####
##########################################

os.chdir(path)

metadata = open(path + "\\metadaten.txt", "w")
metadata.write("pfadname" + "\t" + "doi_nr" + "\t" + "parent" + "\n")
lineno = -2
parents = {}

for subdir, dirs, files in os.walk('.'):
    lineno +=1
    rel_dir = os.path.relpath(subdir)
    parents[rel_dir] = doi + "_" + str(lineno)
    ind_pos = rel_dir.rfind("\\")
    parent_pfad = rel_dir[0:ind_pos]
    tmp_lst_fold = [parent_pfad]
    if tmp_lst_fold[0] in parents:
        metadata.write(rel_dir + "\t" + doi + "_" + str(lineno) + "\t" + (parents[tmp_lst_fold[0]]) + "\n")
    if tmp_lst_fold[0] not in parents:
        metadata.write(rel_dir + "\t" + doi + "_" + str(lineno) + "\n")
            
    for file in files:
        lineno +=1
        rel_file = os.path.join(rel_dir, file)
        tmp_lst = [rel_dir]
        if tmp_lst[0] in parents:
            metadata.write(rel_file + "\t" + doi + "_" + str(lineno) + "\t" + (parents[tmp_lst[0]]) + "\n")
        if tmp_lst[0] not in parents:
            metadata.write(rel_file + "\t" + doi + "_" + str(lineno) + "\n")
            
metadata.close()

for line in fileinput.FileInput(path + "\\metadaten.txt", "w"):
    line = line.replace("\\", "/")
    if len(line) > 1 or line != '\n':
        print(line, end='')
    