# -*- coding: utf-8 -*-
#
# fast-plotter documentation build configuration file, created by
# sphinx-quickstart on Thu Jul 13 09:48:02 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
import inspect
import fast_plotter


# Get the project root dir, which is the parent dir of this
cwd = os.getcwd()
project_root = os.path.dirname(cwd)
# Insert the project root dir as the first element in the PYTHONPATH.
# This lets us ensure that the source package is imported, and that its
# version is used.
sys.path.insert(0, project_root)


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinxcontrib.apidoc',
    'sphinxcontrib.programoutput',
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.coverage',
    'sphinx.ext.mathjax',
    'sphinx.ext.linkcode',
    'sphinx.ext.napoleon',
    # 'sphinx.ext.githubpages',
    'm2r',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = ['.rst', '.md']
#source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'fast-plotter'
copyright = u'2019, Ben Krikler'
author = u'Ben Krikler'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
# version = u'0.7'
# The full version, including alpha/beta/rc tags.
release = u'0.9.0'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# List of modules to be mocked up. This is useful when some external
# dependencies are not met at build time and break the building process.
autodoc_mock_imports = [
]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#

html_theme = 'sphinx_rtd_theme'

# Increase width of main content by overriding corresponding parameter in rtd theme's css
#   Solution from http://blog.deimos.fr/2014/10/02/sphinxdoc-and-readthedocs-theme-tricks-2/
#            and  http://stackoverflow.com/questions/23211695/modifying-content-width-of-the-sphinx-theme-read-the-docs
import sphinx_rtd_theme
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

#html_theme = 'alabaster'
#
# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
#html_theme_options = {
#    'page_width': '1200px',
#    'show_related': 'true',
#    'fixed_sidebar': 'true',
#    'font_family': 'Georgia'
#}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'fast-plotter-doc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'fast-plotter.tex', u'fast-plotter Documentation',
     [author], 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'fast-plotter', u'fast-plotter Documentation',
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'fast-plotter', u'fast-plotter Documentation',
     author, 'fast-plotter', 'One line description of project.',
     'Miscellaneous'),
]


# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'python': ('https://docs.python.org/3', None),
                       'matplotlib': ('http://matplotlib.sourceforge.net', None),
                        }


# Configure the sphinxcontrib.apidoc extension
apidoc_module_dir = '../fast_plotter'
apidoc_toc_file = False
apidoc_module_first = True
apidoc_separate_modules = True
pidoc_extra_args = ["-e"]


# linkcode control, inspired by numpy's approach:
#   - https://github.com/numpy/numpy/blob/master/doc/source/conf.py#L286
def linkcode_resolve(domain, info):
    if domain != 'py':
        return None

    modname = info['module']
    fullname = info['fullname']

    submod = sys.modules.get(modname)
    if submod is None:
        return None

    obj = submod
    for part in fullname.split('.'):
        try:
            obj = getattr(obj, part)
        except Exception:
            return None

    # strip decorators, which would resolve to the source of the decorator
    # possibly an upstream bug in getsourcefile
    try:
        unwrap = inspect.unwrap
    except AttributeError:
        pass
    else:
        obj = unwrap(obj)

    try:
        fn = inspect.getsourcefile(obj)
    except Exception:
        fn = None
    if not fn:
        return None

    try:
        source, lineno = inspect.getsourcelines(obj)
    except Exception:
        lineno = None

    if lineno:
        linespec = "#L%d-%d" % (lineno, lineno + len(source) - 1)
    else:
        linespec = ""

    fn = os.path.relpath(fn, start=os.path.dirname(fast_plotter.__file__))
    version = fast_plotter.__version__
    if 'dev' in version:
        version = "master"
    else:
        version = "v" + version
    url_root = "https://gitlab.cern.ch/fast-hep/public/fast-plotter/blob/"
    return url_root + "%s/fast_plotter/%s%s" % (version, fn, linespec)


# Control the napoleon extension for nicer docstrings
# napoleon_include_init_with_doc = True



# -- Modify sphinx app -------------------------------------------
#from docutils.parsers.rst import Directive, directives
#class AutodocWithoutDocstring(Directive):
#
#    from sphinx.ext.autodoc import cut_lines
#    first_line = cut_lines(1)
#    print(options)
#    if "first-line" in options:
#        del options["first-line"]
#        first_line(app, what, name, obj, options, lines)

def setup(app):
    # Override default css to get a larger width for local build
    #app.add_javascript("custom.js")
    app.add_stylesheet('custom.css')
    # app.connect('autodoc-without-docstring', AutodocWithoutDocstring)

