% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDMhelper_man.R
\docType{package}
\name{EDMhelper}
\alias{EDMhelper}
\alias{EDMhelper-package}
\title{EDMhelper: A helper package for rEDM.}
\source{
Ye, H., Sugihara, G., et al. (2015). Equation-free ecosystem forecasting. PNAS 112:E1569-E1576.

Ye, H., et al. (2019). rEDM: Applications of Empirical Dynamic Modeling from Time Series. R package version 0.7.2.
}
\description{
This package contains wrapper functions for the rEDM package. These functions automate various
EDM routines, including CCM and extraction of s-mapping coefficients.
}
\examples{

#load data
require(rEDM)
data("paramecium_didinium")
data<-paramecium_didinium
dnames<-colnames(data)[-1]

#get segments (all observations are in one single segment)
sgm<-segment_data(rep(1, nrow(data)))

#make standardized data
df<-normalize_data(data[,dnames])$xnorm

#run simplex on all columns
maxE_test<-round(sqrt(min(sgm[,2]-sgm[,1]))) #maximum E to test is sqrt(time series length)

simplex_out <- lapply(dnames, function(dnames){
  simplex(df[,c(dnames)], E=2:maxE_test, lib=sgm, pred=sgm, tau=1, silent = TRUE)
})
names(simplex_out)<-dnames

plot_simplex(simplex_out)

#find best E for all time series
best_E<-find_max_E(simplex_out, buffer=1, predtype = "rho")
names(best_E)<-dnames

#run CCM
ccm_out<-ccm_easy(df=df, best_E=best_E, lib_segments=sgm, pred_segments=sgm)

#summarize results
summaryout<-ccm_summary(ccm_output = ccm_out, predtype = "rho")

#run significance tests
sigout<-significance_test(ccm_output = ccm_out, predtype = "rho")

#plot result
ccm_easy_plot(summaryout)

#run time-delay CCM
#smaller number of samples to reduce runtime
num_samples<-20
ccm_del_out<-ccm_delay_easy(df=df, best_E = best_E, lib_segments=sgm,
  pred_segments=sgm, tp = -5:5, num_samples=num_samples)

#summarize results
summaryout_del<-ccm_summary(ccm_output = ccm_del_out, predtype = "rho")

#run significance tests
sigout_del<-significance_test(ccm_output = ccm_del_out, predtype = "rho")

sigout_tp<-find_tp(sigout_del, cutoff = 0.05)

#plot result
ccm_easy_plot(summaryout_del)

#plot prediction skill at the maximum library size as a function of tp
ccm_delay_plot(summaryout_del)

#run s-mapping
smap_out <- lapply(dnames, function(dnames){
  s_map(df[,c(dnames)], E=best_E[dnames], lib=sgm, pred=sgm, tau=1, silent = TRUE)
})
names(smap_out)<-dnames

#find best theta for all time series
best_theta<-find_max_theta(smap_out, buffer=1, predtype = "rho")
names(best_theta)<-dnames

plot_smap(smap_out)


#calculate s-map coefficients
smap_coef_out<-get_smap_coef(df=df, lib_segments = sgm,
  sigout = sigout_tp, best_E = best_E, best_theta = best_theta)


#plot coefficients
smap_coef_plot(index_sp=1, smap_coef_out=smap_coef_out,
  covar=df[,"paramecium"], ycol="all", xlab="paramecium")
smap_coef_plot(index_sp=1, smap_coef_out=smap_coef_out,
  covar="time", ycol="all", xlab="time")

smap_coef_plot(index_sp=2, smap_coef_out=smap_coef_out,
  covar=df[,"didinium"], ycol="all", xlab="didinium")
smap_coef_plot(index_sp=2, smap_coef_out=smap_coef_out,
  covar="time", ycol="all", xlab="time")


#stability analysis
smap_coef_out_FULL<-get_smap_coef(df=df, lib_segments = sgm,
  sigout = sigout, best_E = best_E, best_theta = best_theta, selfref = TRUE)

  stability_out = stability_analysis(smap_coef_out_FULL)
  stability_out$plot_indices
}
