#  PyMODA, a Python implementation of MODA (Multiscale Oscillatory Dynamics Analysis).
#  Copyright (C) 2019  Lancaster University
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program. If not, see <https://www.gnu.org/licenses/>.


class BaseUI:
    """
    A base UI element which defines the function 'setup_ui', which is used
    to setup UI elements and perform tasks such as inflating the layout from
    a .ui file.

    `setup_ui` is called in the constructor.
    """

    def __init__(self):
        self.setup_ui()

    def setup_ui(self) -> None:
        """
        A function which should be overridden and used to setup
        UI components.
        """
        pass
