title: Examples
---

<style>
  .categories {
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
  }

  .category {
    flex: 1;
    min-width: 225px;
  }

  .categories br {
    display: none;
  }

  .category ul {
    margin-top: 0;
  }

  .gallery img {
    width: 16%;
    display: inline-block;
    padding: 2px;
  }

  .gallery br {
    display: none;
  }
</style>

This will allow you to see the some live code running in your browser. Just pick a class on the left menu or in the category grouping below. The [Simple Cone](SimpleCone.html) is a good example to start with if you are new to VTK.

<div class="gallery">
[![PDBReader Example][PDBReader]](./PDBReader.html)
[![ElevationReader Example][ElevationReader]](./ElevationReader.html)
[![VolumeContour Example][VolumeContour]](./VolumeContour.html)
[![MultiSliceImageMapper Example][MultiSliceImageMapper]](./MultiSliceImageMapper.html)
[![PiecewiseGaussianWidget Example][PiecewiseGaussianWidget]](./PiecewiseGaussianWidget.html)
[![ZipHttpReader Example][ZipHttpReader]](./ZipHttpReader.html)
</div>

<div class="categories">

<div class="category">
__Sources__

<ul>
<li>[ArrowSource](ArrowSource.html)</li>
<li>[ConcentricCylinderSource](ConcentricCylinderSource.html)</li>
<li>[Cone](Cone.html)</li>
<li>[ConeSource](ConeSource.html)</li>
<li>[CubeSource](CubeSource.html)</li>
<li>[CylinderSource](CylinderSource.html)</li>
<li>[LineSource](LineSource.html)</li>
<li>[PlaneSource](PlaneSource.html)</li>
<li>[PointSource](PointSource.html)</li>
<li>[SLICSource](SLICSource.html)</li>
<li>[SphereSource](SphereSource.html)</li>
</ul>

</div>
<div class="category">
__Data processing__

<ul>
<li>[Calculator](Calculator.html)</li>
<li>[Cutter](Cutter.html)</li>
<li>[ImageCropFilter](ImageCropFilter.html)</li>
<li>[ImageMarchingCubes](ImageMarchingCubes.html)</li>
<li>[ImageMarchingSquares](ImageMarchingSquares.html)</li>
<li>[ImageStreamline](ImageStreamline.html)</li>
<li>[ImplicitBoolean](ImplicitBoolean.html)</li>
<li>[OutlineFilter](OutlineFilter.html)</li>
<li>[ScalarToRGBA](ScalarToRGBA.html)</li>
<li>[TubeFilter](TubeFilter.html)</li>
<li>[VolumeContour](VolumeContour.html)</li>
<li>[WarpScalar](WarpScalar.html)</li>
</ul>

</div>
<div class="category">
__Rendering__

<ul>
<li>[Glyph3DMapper](Glyph3DMapper.html)</li>
<li>[ImageMapper](ImageMapper.html)</li>
<li>[MultiSliceImageMapper](MultiSliceImageMapper.html)</li>
<li>[SphereMapper](SphereMapper.html)</li>
<li>[StickMapper](StickMapper.html)</li>
<li>[VolumeMapper](VolumeMapper.html)</li>
</ul>

</div>
<div class="category">
__User interaction__

<ul>
<li>[PointPicker](PointPicker.html)</li>
<li>[CellPicker](CellPicker.html)</li>
<li>[DeviceOrientationToCamera](DeviceOrientationToCamera.html)</li>
<li>[InteractorStyleManipulator](InteractorStyleManipulator.html)</li>
<li>[MouseRangeManipulator](MouseRangeManipulator.html)</li>
<li>[VR](VR.html)</li>
<li>[KeyboardCameraManipulator](KeyboardCameraManipulator.html)</li>
<li>[MouseCameraTrackballFirstPersonManipulator](MouseCameraTrackballFirstPersonManipulator.html)</li>
</ul>

</div>
<div class="category">
__Interactive widgets__

<ul>
<li>[HandleWidget](HandleWidget.html)</li>
<li>[ImageCroppingRegionsWidget](ImageCroppingRegionsWidget.html)</li>
<li>[LabelWidget](LabelWidget.html)</li>
<li>[LineWidget](LineWidget.html)</li>
<li>[OrientationMarkerWidget](OrientationMarkerWidget.html)</li>
<li>[PiecewiseGaussianWidget](PiecewiseGaussianWidget.html)</li>
</ul>

</div>
<div class="category">
__Data readers__

<ul>
<li>[ZipHttpReader](ZipHttpReader.html)</li>
<li>[HttpDataSetReader](HttpDataSetReader.html)</li>
<li>[HttpSceneLoader](HttpSceneLoader.html)</li>
<li>[STLReader](STLReader.html)</li>
<li>[PolyDataReader](PolyDataReader.html)</li>
<li>[ElevationReader](ElevationReader.html)</li>
<li>[JSONNucleoReader](JSONNucleoReader.html)</li>
<li>[OBJReader](OBJReader.html)</li>
<li>[PDBReader](PDBReader.html)</li>
</ul>

</div>
<div class="category">
__Advanced usage__

<ul>
<li>[DepthTest](DepthTest.html)</li>
<li>[SpheresAndLabels](SpheresAndLabels.html)</li>
<li>[Texture](Texture.html)</li>
<li>[RenderWindowWithControlBar](RenderWindowWithControlBar.html)</li>
<li>[ActorSerialization](ActorSerialization.html)</li>
<li>[PipelineExecution](PipelineExecution.html)</li>
<li>[PolyDataSerialization](PolyDataSerialization.html)</li>
</ul>

</div>

<div class="category">
__Sample applications__

<ul>
<li>[GeometryViewer](GeometryViewer.html)</li>
<li>[OBJViewer](OBJViewer.html)</li>
<li>[SceneExplorer](SceneExplorer.html)</li>
<li>[SkyboxViewer](SkyboxViewer.html)</li>
<li>[TubesViewer](TubesViewer.html)</li>
<li>[VolumeViewer](VolumeViewer.html)</li>
</ul>

</div>

<div class="category">
</div>
</div>

[ElevationReader]: ../docs/gallery/ElevationReader.jpg
[MultiSliceImageMapper]: ../docs/gallery/MultiSliceImageMapper.jpg
[PDBReader]: ../docs/gallery/PDBReader.jpg
[PiecewiseGaussianWidget]: ../docs/gallery/PiecewiseGaussianWidget.jpg
[VolumeContour]: ../docs/gallery/VolumeContour.jpg
[ZipHttpReader]: ../docs/gallery/ZipHttpReader.jpg
