---
title: Tom Elliott
institution: The Institute for the Study of the Ancient World
job-title: Associate Director for Digital Programs and Senior Research Scholar
image: '/images/staff/elliot.jpeg'
layout: team
orcid: 0000-0002-4114-6677
website: https://paregorios.org/about/
---
Tom Elliott graduated from Duke University in 1989 with B.S. in Computer Science and a second major in Classical Studies. Following service as a Communications and Computer Systems Officer in the United States Air Force, he worked as a software developer and program manager for AEgis Research Corporation (now AEgis Technologies) in Huntsville, Alabama on a number of visual and engineering simulation projects. He received his Ph.D. in Ancient History from the University of North Carolina, Chapel Hill in 2004, for research focused on the intersection of Roman documentary, administrative and geographic studies. His doctoral dissertation was entitled _Epigraphic Evidence for Boundary Disputes in the Early Roman Empire_ (see also [github:demarc](https://github.com/paregorios/demarc)).

Tom has spent nearly two decades advancing the practice of digital humanities in ancient studies. In the late 1990s, he wrote database software that was used to prepare the alphabetical gazetteer and _Map-by-Map Directory_ that accompanies the _Barrington Atlas of the Greek and Roman World_ (Princeton, 2000). During that period he also started the [EpiDoc Community](http://epidoc.sf.net), which creates standards-based tools and guidelines for the digital encoding of epigraphic and papyrological texts like those published in the _[Inscriptions of Aphrodisias 2007](http://insaph.kcl.ac.uk/iaph2007/)_ and _[Papyri.info](http://papyri.info/)_. In August 2000, he was appointed as Founding Director of the [Ancient World Mapping Center](http://awmc.unc.edu) at the University of North Carolina in Chapel Hill. In February 2006, Tom stepped down from this position to assume full-time leadership of [the _Pleiades_ gazetteer of ancient places](https://pleiades.stoa.org). In 2008, he brought this role with him to the [Institute for the Study of the Ancient World](http://isaw.nyu.edu) at New York University, where he is also responsible for developing and overseeing a spectrum of innovative digital projects and services.
