% Groups the individual models (IMs) in different cell arrays, as explained below. 
% 
% The main purpose of this function is to rearrange how the IMs are stored so that we can cleverly use 
% the "param_distribution" function to a) plot the values of the model parameters and their empirical 
% distributions (Figure 4 in the article) for all the tests and environments, and b) compute the 
% statistics of the distributions (Table 1 in the article).
% 
% INPUTS: 
% Let us denote an "experiment" a group of tests involving K nodes (the number of nodes can be different
% in different experiments). The inputs of this function are three TxK cell arrays containing the IMs
% corresponding to one experiment each. 
%   - me1: TxK cell array containing the K IMs from each of the T tests carried out in one experiment. 
%       me1{t_i}{n_i} is the IM corresponding to the n_i'th node in the t_i'th test. 
%   - me2: idem (a different experiment).
%   - me3: idem (a different experiment).
%   - labels: cell with 3 labels, each containing a color associated to the 3 experiments.
%   - colors: cell with 3 cells, each containing a color associated to the 3 experiments.
%   
% OUTPUTS
% - me1_at: models from experiment 1 put all together in the same cell array (of dimension 1x(TxK)), as 
%       if they had been obtained in one single test containing TxK nodes.
% - me2_at: idem for me2
% - me3_at: idem for me3.
% - m_at_av: groups the tests of me1, me2 and me3 into one single experiment. That is: if me1, me2 and me3 
%       contain T1, T2 and T3 tests, respectively, m_at_av is of size 1x(T1+T2+T3).
% - labels_a: labels associated to each cell in m_at_av, as expected by the function "param_distribution"
% - colors_a: colors associated to each cell in m_at_av, as expected by the function "param_distribution"
function [me1_at,me2_at,me3_at,m_at_av,labels_a,colors_a]=join_tests(me1,me2,me3,labels,colors)  
  j=1;k=1;nr_id=21;
  me1_at={};me2_at={};me3_at={};m_at_av={};labels_a={};colors_a={};
  for t_i=1:3
    for n_i=1:nr_id
      if isempty(me1{t_i}{n_i}) || (n_i==nr_id) continue endif
      me1_at{j++}=me1{t_i}{n_i}; %all together
    endfor
    m_at_av{k}=me1{t_i}; %all together
    if nargin>3; labels_a(k)=sprintf(""); endif
    if nargin>4; colors_a{k}=colors{1}{1}; endif
    k++;
  endfor
  if nargin>3; labels_a(1)=labels{1}{1}; endif
  j=1;
  for t_i=1:3
    for n_i=1:nr_id
      if isempty(me2{t_i}{n_i}) || (n_i==nr_id) continue endif
      me2_at{j++}=me2{t_i}{n_i};
    endfor
    m_at_av{k}=me2{t_i}; %all together
    if nargin>3; labels_a(k)=sprintf(""); endif
    if nargin>4; colors_a{k}=colors{1}{2}; endif
    k++;
  endfor
  if nargin>3; labels_a(4)=labels{1}{2}; endif
  j=1;
  for t_i=1:3
    for n_i=1:nr_id
      if isempty(me3{t_i}{n_i}) || (n_i==nr_id) continue endif
      me3_at{j++}=me3{t_i}{n_i};
    endfor
    m_at_av{k}=me3{t_i}; %all together
    if nargin>3; labels_a(k)=sprintf(""); endif
    if nargin>4; colors_a{k}=colors{1}{3}; endif
    k++;
  endfor
  if nargin>3; labels_a(7)=labels{1}{3}; endif
endfunction
