function D=distmat(pos1,pos2 = pos1)
% Calculates the matrix of distances
%
% INPUTS:
% 	- pos1: MxD matrix with the M D-dimensional positions
%	- pos2: NxD matrix with the N D-dimensional positions
%
% RETURNS
%	- D: MxN matrix whose (m,n) component is the distance between the m-th row of pos1
%		and the n-th row of pos2. That is, D(m,n)=||pos1(m,:)-pos2(n,:)||
%
% If only one input is provided, the matrix D will contain the distances among points of pos1,
% that is:  D(m,n)=||pos1(m,:)-pos1(n,:)||
%

if nargin < 1 || nargin > 2
  error("distmat: expected 1 or two vectors as arguments.");
endif

[M1,D1,N]=size(pos1);
[M2,D2,N]=size(pos2);
if D1!=D2
  error("distmat: inputs must have the same second dimension.");
endif

D=permute(sqrt(sum((pos1-permute(pos2,[3 2 1])).^2,2)),[1 3 2]);