function model=extract_rssi_model(d,rssi,model_type)
% Extract RSSI-distance model
%
% SYNTAX: model=extract_rssi_models(d,rssi,model_type)
%	  
% INPUTS
%	d: distance
%	rssi: rssi measurements corresponding to the distance d
%	model_type: cell array with information about the type of model to extract and the required
%	parameters. The possible types are
%		- PLN: polynomial in log-distance with normally distributed error. Requires the degree of the polynomial
%		- ...
% RETURNS
%	model: structure with the model parameters for that node. The specific fields depend on the model type.
%
% EXAMPLES:
%	model=extract_rssi_models(d,rssi,{'PLN',1})
%	extracts a polynomial model of degree 1 with normally distributed error
%

if (nargin != 3)
	error ("Wrong number of arguments");
endif

%Get rid of NaN rssi measurements
idx=find(isnan(rssi));
rssi(idx)=[];
d(idx)=[];

if(strcmp(model_type{1},'PLN')==1)
  %The degree of the polynomial is in the second element of the model_type cell
  p_deg=model_type{2};
  if numel(model_type)==3
    d0=model_type{3};
    model=extract_pln_model(d,rssi,p_deg,d0);
  else
    model=extract_pln_model(d,rssi,p_deg);
  endif
else
  error("Model type not supported");
endif    


