function [h u]=get_heading(b_pos)
% Calculates the heading of the robot and returns a unitary vector for each robot position
% indicating the heading.
% 
% SYNTAX: [h u]=get_heading(b_pos)
% 
% INPUTS: 
%       b_pos: the trajectory of the robot
%       
% OUTPUTS:
%       h: the heading angle (in radians)
%       u: a unitary vector in the direction of the heading
% 

Ay=diff(b_pos(:,2));
Ax=diff(b_pos(:,1));
u=[Ax Ay];
u=u./distmat(u,[0 0]); %modulo of the vectors
%h=acos(u*[1;0]); %Use the scalar product to calculate the angle wrt. the x axis
h=atan2(Ay,Ax);
%The last element is missing, due to the diff operation. We copy the previous to the last.
h(end+1)=h(end);
u(end+1,:)=u(end,:);