function plot_rssi_model(model,fig_number,hold_figure)
%Usage function plot_rssi_model(model,fig_number)  
h=figure(fig_number);

if nargin<=2
    hold_figure=false;
endif
if hold_figure
  hold on;
else
  clf;
endif

n_bars=20;

dots_size=5;
linewidth_thick=1;
linewidth_thin=0.25*linewidth_thick;
linewidth=2;

num_rows=1; %of the subplots
num_cols=2;

%Colors in RGB scale between 0 and 1
green_1=[64,161,64]/260; 
blue_dark=[0 77 153]/255; 

color_dots=[0 0 1]; %Color of the dots representing the measurements
color_mean=[1 0 0]; %Color of the mean curve
color_ebars=green_1; %Color of the error bars (std.dev)

color_hbars=green_1; %Color of the bars of the histogram
color_pdf=[1 0 0];
color_pdf_components=[255 0 0]/255;



if (strcmp(model.type,'PLN')==1)
  %Plot the original data and the model
  subplot(num_rows,num_cols,1);
  rssi=calculate_prediction(model,model.theta,model.d);
  res=rssi-model.rssi;
  semilogx(model.d,model.rssi,'.','Color',color_dots,'markersize',dots_size, ...
	    model.d,rssi,'linewidth',linewidth_thick,'Color',color_mean);
  hold on;grid on;
  %Plot the error bars
  semilogx(model.d,rssi-model.std,'linewidth',linewidth_thick,'Color',color_ebars, ...
  	    model.d,rssi+model.std,'linewidth',linewidth_thick,'Color',color_ebars);
  %Plot a histogram of the residuals and a scaled distribution to compare it with the residuals
  subplot(num_rows,num_cols,2);
  [x,k]=plot_res_hist(res,n_bars,color_hbars);
  %pdf=1./((sqrt(2*pi)*model.res_sdev)) * exp(-0.5*(x-model.res_mean).^2/model.res_sdev^2);
  pdf=normpdf(x,mean(res),model.std);
  plot(x,k*pdf,"r",'linewidth',linewidth);
  grid on;
else
  error("Model type not supported");
endif


%Titles of figures
subplot(num_rows,num_cols,1);
ylabel('RSS(dBm)');
xlabel('Distance(m)');  
title("RSS vs. distance");
subplot(num_rows,num_cols,2);
xlabel('Residuals');  
title("Histogram of residuals");

%Plot a histogram of the residuals
function [x,k]=plot_res_hist(res,n_bars,color_bars)
  if nargin==2
    color_bars=[0 0 1];
  endif
  x=min(res):0.1:max(res);
  [nn,xx]=hist(res,n_bars);%nn=frequency counts, xx= bar locations
  h = bar(xx,nn); 
  set (h, "facecolor", color_bars);
  k=sum(nn)*range(res)/n_bars;%Constant that a pdf has to be multiplied for to scale it to the residuals
  hold on;
