function [pos]= robot_pos_at_time(nts,robot_s)
%
% SYNTAX: [pos]= robtot_pos_at_time(nts,robot_s)
%
% Arguments
%	nts: column vector with network timestamps at which the position of the robot wants to be estimated
%	robot_s: stricture containing the following fields
%		robot_s.nts: robot timestamps transformed into network timestamps
%		robot_s.pos_x: x coordinate of the robot position
%       robot_s.pos_y: y coordinate of the robot position
%
%
% Returns
%	pos: position of the robot (x, y) calculated using interpolation.
%

nts=reshape(nts,[],1);% Make sure that nts is a column vector
pos=[interp1(robot_s.nts,robot_s.pos_x,nts) interp1(robot_s.nts,robot_s.pos_y,nts)];

