function [d,rssi,traj,nts,ierr]=get_data_from_MICRO_node(node_s,robot_pos_s,filter_options)
% Get the data from the node. Optionally prefilter the data
%
% Example:
%	[d,rssi,traj,nts,ierr]=get_data_from_node(node_s{1},robot_pos_s,{'RMWA',0.5});
%

if (nargin != 2) && (nargin != 3)
	error ("Wrong number of arguments");
endif

if (nargin == 2)
  filter_options = 'NO_FILTER';
endif

nr_id=robot_pos_s.nr_id;

ierr=1;
if iscell(filter_options)
  if numel(filter_options)==1
    foption1=filter_options{1};
    foption2={};
  elseif numel(filter_options)==2
    foption1=filter_options{1};
    foption2=filter_options{2};
  else
    foption1=filter_options{1};
    foption2=filter_options{2};
    %warning("get_data_from_node: some filter_options ignored");
  endif
else
  foption1=filter_options;
  foption2={};
endif


if(strcmp(foption1,'NO_FILTER')==1)
  %Measurements from the node of the robot
  mr_i=find(node_s.tx_id==nr_id); %indexes of the measurements
  if isempty(mr_i) 
    error('Node with no measurements'); 
  endif
  rssi=node_s.rssi(mr_i);
  nts=node_s.nts(mr_i);
  pos=robot_pos_at_time(nts,robot_pos_s);%Position of the robot for each measurement
  traj=[pos(:,1) pos(:,2)];
  d= sqrt( (pos(:,1)-node_s.pos_x()).^2 + (pos(:,2)-node_s.pos_y).^2 );%Distances to the robot

elseif(iscell(foption1) && (length(foption1) == 2) && strcmp(foption1{1},'RSS_THRESHOLD'))
  rss_threshold=foption1{2};
  %Measurements from the node of the robot
  mr_i=find((node_s.tx_id==nr_id) & (node_s.rssi>rss_threshold)); %indexes of the measurements
  if isempty(mr_i) 
    error('Node with no measurements'); 
  endif
  rssi=node_s.rssi(mr_i);
  nts=node_s.nts(mr_i);
  pos=robot_pos_at_time(nts,robot_pos_s);%Position of the robot for each measurement
  traj=[pos(:,1) pos(:,2)];
  d= sqrt( (pos(:,1)-node_s.pos_x()).^2 + (pos(:,2)-node_s.pos_y).^2 );%Distances to the robot_pos_at_time

elseif strcmp(foption1,'RMWA') || strcmp(foption1,'DPTRAJ') || strcmp(foption1,'Antenna')
  %Do the filtering
  [d,rssi,traj,nts,ierr]=filter_rssi(node_s,robot_pos_s,filter_options);
else
  error('get_data_from_node: wrong filter_options');
endif

if !isempty(foption2) && !strcmp(foption1,'RMWA')
  if iscell(foption2) && (length(foption2) == 2) && strcmp(foption2{1},'RANDOM')
    %pick a random number of measurements.
    precentage=foption2{2};
    idx=randi(length(rssi),precentage*length(rssi),1);
    d=d(idx);
    rssi=(idx);
    traj=(idx);
    nts=(idx);
    ierr=(idx);
  elseif strcmp(foption1,'DPTRAJ') || strcmp(foption1,'Antenna')
    %Do nothing
  else
    error('get_data_from_MICRO_node: wrong filter_options{2}');
  endif
endif
