% Load all the data used in the studies. The data is already averaged as explained in Section 2, 
% so it is not necessary to average it again.

% We have data collected in three different buildings of the Otaniemi campus (Aalto University), namely:
% - otahalli20120126_av.dat: collected in a basketball court of the sports center (Otahalli).
% - tuas20120125_av.dat: collected in the lobby of the TUAS building (semi-open space).
% - tuas20120203_av.dat: collected in an office in the third floor of the TUAS building (a typical modern office).
if !exist("oh_av") 
  load("../data/otahalli20120126_av.dat");
endif
if !exist("tul_av")
  load("../data/tuas20120125_av.dat");
endif
if !exist("tu3_av")
  load("../data/tuas20120203_av.dat");
endif

%Trick to add the rx_id field that was not added when loading the data.
for t_i=1:3
  for n_i=1:numel(oh_av{t_i}.nodes_s)
    if isempty(oh_av{t_i}.nodes_s{n_i}) continue; endif
    oh_av{t_i}.nodes_s{n_i}.rx_id=n_i;
  endfor
endfor
for t_i=1:3
  for n_i=1:numel(tu3_av{t_i}.nodes_s)
    if isempty(tu3_av{t_i}.nodes_s{n_i}) continue; endif
    tu3_av{t_i}.nodes_s{n_i}.rx_id=n_i;
  endfor
endfor
for t_i=1:3
  for n_i=1:numel(tul_av{t_i}.nodes_s)
    if isempty(tul_av{t_i}.nodes_s{n_i}) continue; endif
    tul_av{t_i}.nodes_s{n_i}.rx_id=n_i;
  endfor
endfor

%% ATTENTION!!
% Node 5 had a problem with the antenna connector. We eliminate it.
for t_i=1:3
  oh_av{t_i}.nodes_s{5}={};
endfor
for t_i=1:3
  tu3_av{t_i}.nodes_s{5}={};
endfor
for t_i=1:3
  tul_av{t_i}.nodes_s{5}={};
endfor

% Now you have the following structures, each containing the data in relation to the experiments carried out in the different 
% buildings:
% * oh_av: Otahalli building
% * tul_av: the lobby of TUAS 
% * tu3_av: the third floor of TUAS
%
% Taking as an example the data collected in Otahalli (oh_av), the information contained in the structures is:
%   * oh_av{t_i}: contains the information collected during to the 't_i'th test/robot trajectory.
%   * oh_av{t_i}.nodes_s: cell array with structures containing the information collected by the nodes (see below) in the given test.
%   * oh_av{t_i}.robot_s: structure containing the information related to the robot (see below) in the given test.
% 
% octave:5> fieldnames(oh_av{t_i}.nodes_s{n_i}) %Information related to the node with ID equal to n_i collected during the 't_i'th test/robot trajectory
% ans =                                                                                                                                                                                        
% {                                                                                                                                                                                            
%   [1,1] = nts     % Network timestamp (calculated by the WSN)                                                                                                                                                                         
%   [2,1] = rssi    % RSS of the incoming packet                                                                                                                                                                        
%   [3,1] = tx_id   % ID of the transmitting node                                                                                                                                                                           
%   [4,1] = pos_x   % Ground truth position of the node (coordinate X)                                                                                                                                                                          
%   [5,1] = pos_y   % Ground truth position of the node (coordinate Y)                                                                                                                                                                           
%   [6,1] = pos     % (pos_x, pos_y)                                                                                                                                                                          
%   [7,1] = rx_id   % ID of the receiving node (equal to n_i)
% }
% fieldnames(oh_av{t_i}.robot_s) %Information related to the robot during the 't_i'th test/trajectory
% ans =
% {
%   [1,1] = rts_sec     % Seconds of the real (Linux) timestamp. 
%   [2,1] = rts_usec    % Microseconds of the real (Linux) timestamp. 
%   [3,1] = pos_x       % X coordinate of the trajectory
%   [4,1] = pos_y       % Y coordinate of the trajectory
%   [5,1] = nts         % Network timestamp corresponding to the real Linux timestamp
%   [6,1] = pos         % (pos_x, pos_y) 
%   [7,1] = nr_id       % ID of the node mounted on top of the robot
% }
