%Load all the (already filtered) data if not loaded already
if !exist("oh_av") || !exist("tul_av") || !exist("tu3_av")
  load_averaged_data;
endif

%d0=5;
d0=1;

% Identify the individual and reference models
printf("Otahalli\n");
for t_i=1:3
  moh_av_p1ln{t_i}=extract_rssi_models(oh_av{t_i}.nodes_s,oh_av{t_i}.robot_s,'NO_FILTER',{'PLN',1,d0});
endfor
printf("TUAS 3rd floor\n");
for t_i=1:3
  mtu3_av_p1ln{t_i}=extract_rssi_models(tu3_av{t_i}.nodes_s,tu3_av{t_i}.robot_s,'NO_FILTER',{'PLN',1,d0});
endfor
printf("TUAS lobby\n");
for t_i=1:3
  mtul_av_p1ln{t_i}=extract_rssi_models(tul_av{t_i}.nodes_s,tul_av{t_i}.robot_s,'NO_FILTER',{'PLN',1,d0});
endfor

% The information contained in the arrays:
% moh_av_p1ln{t_i}{n_i}: model associated to the data collected by the node with ID n_i during the 't_i'th robot trajectory/test in Otahalli.

% NOTE: the reference models (identified with the data collected by all nodes during an experiment) are placed in the structure
% moh_av_p1ln{t_i}{nr_id}, where nr_id is the index of the node mounted in the robot (nr_id=21). Therefore, the model in moh_av_p1ln{t_i}{nr_id}
% is NOT identified with the RSS measurements collected by the node on top of the robot: that info is not used in this publication.
% In particular note that 
% ---
% octave:34> length(oh_av{t_i}.nodes_s)
% ans =  20
% octave:35> length(moh_av_p1ln{t_i})
% ans =  21
% ---
% so there are 20 nodes and 21 models: 20 IMs and one RM for each trajectory (the last one).
%
% The decision to put the RM in the last cell after the IMs is completely arbitrary and done for convenience of the coding.


% Compare the log-likelihood of all the measurements when using IMs and a RM in each test.
% This shows that the log-likelihood is larger when usig IMs wrt. using a RM (as claimed in 
% the Discussion section)
function [lr_im,lr_rm]=calculate_lr(models)
    nr_id=21;
    lr_im=0;lr_rm=0;
    for n_i=1:nr_id
        if isempty(models{n_i}) continue endif
        
        m=models{n_i}; %loglikelihood of the measuremets
        if n_i == nr_id
            lr_rm+=m.lr;
        else
            lr_im+=m.lr;
        endif
    endfor
endfunction

printf("Loglikelihood of all measurements (from all nodes) for each experiment/robot trajectory when using IMs and RM \n");
printf("Otahalli\n");
for t_i=1:3
    [lr_im,lr_rm]=calculate_lr(moh_av_p1ln{t_i});
    printf("t_i=%d: l_im=:%f; lr_rm=%f;\n",t_i,lr_im,lr_rm);
endfor
printf("TUAS lobby\n");
for t_i=1:3
    [lr_im,lr_rm]=calculate_lr(mtul_av_p1ln{t_i});
    printf("t_i=%d: l_im=:%f; lr_rm=%f;\n",t_i,lr_im,lr_rm);
endfor
printf("TUAS 3rd floor\n");
for t_i=1:3
    [lr_im,lr_rm]=calculate_lr(mtu3_av_p1ln{t_i});
    printf("t_i=%d: l_im=:%f; lr_rm=%f;\n",t_i,lr_im,lr_rm);
endfor


%{
octave:7> extract_averaged_models
Otahalli
Log-likelihood of residuals for IMs:-42987.5
Log-likelihood of residuals for IMs:-36003.3
Log-likelihood of residuals for IMs:-30160.2
TUAS 3rd floor
Log-likelihood of residuals for IMs:-20015.5
Log-likelihood of residuals for IMs:-21806.6
Log-likelihood of residuals for IMs:-21128.1
TUAS lobby
Log-likelihood of residuals for IMs:-14960.6
Log-likelihood of residuals for IMs:-17685.8
Log-likelihood of residuals for IMs:-9160.21
Loglikelihood of all measurements (from all nodes) for each experiment/robot trajectory when using IMs and RM 
Otahalli
t_i=1: l_im=:-42987.489213; lr_rm=-45405.926056;
t_i=2: l_im=:-36003.316399; lr_rm=-38063.139110;
t_i=3: l_im=:-30160.183210; lr_rm=-32019.245262;
TUAS lobby
t_i=1: l_im=:-14960.573928; lr_rm=-15929.760839;
t_i=2: l_im=:-17685.793220; lr_rm=-19058.959662;
t_i=3: l_im=:-9160.206170; lr_rm=-9782.674627;
TUAS 3rd floor
t_i=1: l_im=:-20015.549434; lr_rm=-20865.594422;
t_i=2: l_im=:-21806.581814; lr_rm=-22612.501472;
t_i=3: l_im=:-21128.104412; lr_rm=-21942.393489;
%}
