printf("\n\n\n");
printf("**************************************\n");
printf("*    Correlation among Parameters    *\n");
printf("**************************************\n");
clear all;
run("../preliminaries/load_averaged_data");
nr_id=21;
load_colors;
colors={{color_bfield,color_lobby,color_office}};
save_plots=false;
markersize=2;


%Compute the correlation as a function of d0. 
%During this computation, the empirical distributions of the model parameters will be shown for the different
%values of d0. This is simply because it clearly shows how the distribution of z0 changes with d0, whereas
%those of n and s do not. These figures will not be shown in the publication.
fig_number=22;
dref=1:1:20;
d0_i=1;
clear params pcorr;
for d0=dref
  d0
  %Extract the models
  moh_av_at_do={};mtu3_av_p1ln_do={};mtul_av_p1ln_do={};
  %Otahalli (basketball court)
  to_i=1;
  for t_i=1:3
    moh_av_at_do{to_i++}=extract_rssi_models(oh_av{t_i}.nodes_s,oh_av{t_i}.robot_s,'NO_FILTER',{'PLN',1,d0});
  endfor
  %TUAS 3rd floor (office)
  ttu3_i=1;
  for t_i=1:3
    mtu3_av_p1ln_do{ttu3_i++}=extract_rssi_models(tu3_av{t_i}.nodes_s,tu3_av{t_i}.robot_s,'NO_FILTER',{'PLN',1,d0});
  endfor
  %TUAS lobby (semi-open space)
  ttul_i=1;
  for t_i=1:3
    mtul_av_p1ln_do{ttul_i++}=extract_rssi_models(tul_av{t_i}.nodes_s,tul_av{t_i}.robot_s,'NO_FILTER',{'PLN',1,d0});
  endfor

  %Put all the models from all the nodes in the same cell array, as if we had one single test per environment.
  me1=moh_av_at_do;
  me2=mtu3_av_p1ln_do;
  me3=mtul_av_p1ln_do;
  [me1_at,me2_at,me3_at]=join_tests(me1,me2,me3);
  
  %Calculate the statistics
  options=struct('PlotEmpiricalDensities',true,'PlotGlobalEmpiricalDensity',false,'PlotDots',false,'PlotRefModel',false,'Colors',colors);
  [PA,st_av]=param_distribution({me1_at,me2_at,me3_at},nr_id,fig_number,options);
  drawnow;

  %Get the parameters
  params.oh(:,:,d0_i) =st_av{1}.params;
  params.tu3(:,:,d0_i)=st_av{2}.params;
  params.tul(:,:,d0_i)=st_av{3}.params;
  
  pcorr.oh(:,:,d0_i) =corr(st_av{1}.params');
  pcorr.tu3(:,:,d0_i)=corr(st_av{2}.params');
  pcorr.tul(:,:,d0_i)=corr(st_av{3}.params');
  
  d0_i++;
endfor
%Variables with the correlation values, for easier handling.
pcorr.d0=dref;
cnp_oh=permute(pcorr.oh,[3,1,2])(:,1,2);
cns_oh=permute(pcorr.oh,[3,1,2])(:,1,3);
cps_oh=permute(pcorr.oh,[3,1,2])(:,2,3);

cnp_tul=permute(pcorr.tul,[3,1,2])(:,1,2);
cns_tul=permute(pcorr.tul,[3,1,2])(:,1,3);
cps_tul=permute(pcorr.tul,[3,1,2])(:,2,3);

cnp_tu3=permute(pcorr.tu3,[3,1,2])(:,1,2);
cns_tu3=permute(pcorr.tu3,[3,1,2])(:,1,3);
cps_tu3=permute(pcorr.tu3,[3,1,2])(:,2,3);

%
% Plot the correlation among the different parameters vs. the reference distance d0.
% These figures are not included in the article.
%
%Correlation between n and z0
figure(22); %reuse the figure.
clf;
subplot(1,3,1);
plot(pcorr.d0,cnp_oh,'r',"markersize", markersize,'Color',color_bfield);
hold on;
plot(pcorr.d0,cnp_tul,'g',"markersize", markersize,'Color',color_lobby);
plot(pcorr.d0,cnp_tu3,'b',"markersize", markersize,'Color',color_office);
xlabel("$d_0$");
title("Corr($n$,$z_0$)");
legend("bfield","lobby","office");
grid on;
%Correlation between n and s
subplot(1,3,2);
plot(pcorr.d0,cns_oh,'r',"markersize", markersize,'Color',color_bfield);
hold on;
plot(pcorr.d0,cns_tul,'g',"markersize", markersize,'Color',color_lobby);
plot(pcorr.d0,cns_tu3,'b',"markersize", markersize,'Color',color_office);
xlabel("$d_0$");
title("Corr($n$,$s$)");
legend("bfield","lobby","office");
grid on;
%Correlation between z0 and s
subplot(1,3,3);
plot(pcorr.d0,cps_oh,'r',"markersize", markersize,'Color',color_bfield);
hold on;
plot(pcorr.d0,cps_tu3,'g',"markersize", markersize,'Color',color_office);
plot(pcorr.d0,cps_tul,'b',"markersize", markersize,'Color',color_office);
xlabel("$d_0$");
title("Corr($P$,$s$)");
legend("bfield","lobby","office");
grid on;

%Cloud-plot of z_0 vs. n for d0=1 (Figure 8a in the article)
figure(23);clf;
d0_i=1; %the contents of dref coincide with the index
plot(params.oh(1,:,d0_i), params.oh(2,:,d0_i), 'o',"markersize", markersize,'Color',color_bfield,...
     params.tul(1,:,d0_i),params.tul(2,:,d0_i),'+',"markersize", markersize,'Color',color_lobby,...
     params.tu3(1,:,d0_i),params.tu3(2,:,d0_i),'*',"markersize", markersize,'Color',color_office);
xlabel("$n$");ylabel('$z_0$')
legend("bfield","lobby","office");
grid on;
if save_plots
    save_plot_as_tikz(sprintf("correlation_n_P0_d0_%d.tex",d0_i));
endif

%Cloud-plot of z_0 vs. n for d0=5, so you can see how different it is wrt. d=1 (not included in the article)
figure(24);clf;
d0_i=5; %the contents of dref coincide with the index
plot(params.oh(1,:,d0_i), params.oh(2,:,d0_i), 'o',"markersize", markersize,'Color',color_bfield,...
     params.tul(1,:,d0_i),params.tul(2,:,d0_i),'+',"markersize", markersize,'Color',color_lobby,...
     params.tu3(1,:,d0_i),params.tu3(2,:,d0_i),'*',"markersize", markersize,'Color',color_office);
xlabel("$n$");ylabel('$z_0$')
legend("bfield","lobby","office");
grid on;
if save_plots
    save_plot_as_tikz(sprintf("correlation_n_P0_d0_%d.tex",d0_i));
endif     

% Correlation between n and z_0 vs. the reference distance d0 (Figure 8b in the article)
figure(25);clf;
markersize=5;
LineWidth=1.5;
plot(pcorr.d0,cnp_oh, 'r','markersize', markersize,'Color',color_bfield,'linestyle','--','LineWidth',LineWidth,...
     pcorr.d0,cnp_tul,'g','markersize', markersize,'Color',color_lobby, 'linestyle',':', 'LineWidth',LineWidth,...
     pcorr.d0,cnp_tu3,'b','markersize', markersize,'Color',color_office,'linestyle','-.','LineWidth',LineWidth);
xlabel("$d_0$");
ylabel("$\Corr(n,z_0)$");
legend("bfield","lobby","office");
grid on;
if save_plots
    save_plot_as_tikz("correlation_n_P0_vs_d0.tex");
endif 

% Correlation between n and z_0 in the different environments for d0=1 and d0=5 (Table 2 in the article)
printf("Correlation between n and z_0 \n");
printf("--------------------------------------\n")
printf("     \tOH\tTUL\tTU3\n");
printf("--------------------------------------\n")
printf("d0=1;\t%.2f\t%.2f\t%.2f\n",cnp_oh(1),cnp_tul(1),cnp_tu3(1));
printf("d0=5;\t%.2f\t%.2f\t%.2f\n",cnp_oh(5),cnp_tul(5),cnp_tu3(5));
printf("--------------------------------------\n")
   
%{
Correlation between n and z_0 
--------------------------------------
        OH      TUL     TU3
--------------------------------------
d0=1;   0.86    0.90    0.89
d0=5;   0.63    0.56    0.31
--------------------------------------
%}
