printf("\n\n\n");
printf("***********************************************************\n");
printf("*    Parameter's Variability: IMs' Empirical Densities    *\n");
printf("***********************************************************\n");

% Creates Figure 4 of the article and calculates the values of Table 1

nr_id=21; %The ID of the node on top of the robot
save_plots=false;

%Colors in RGB scale between 0 and 1
load_colors; %loads color_bfield, color_lobby and color_office

%Cleverly join the tests so that we can use the "param_distribution" to compute the statistics and create the plots below
me1=moh_av_p1ln;
me2=mtul_av_p1ln;
me3=mtu3_av_p1ln;
labels={{'bcourt','lobby','office'}};
colors={{color_bfield,color_lobby,color_office}};
titles={{'$n$','$z_\sub{0}$','$\sigma$'}};
xlables={{'$n$','$z_\sub{0}$','$\sigma$'}};
[me1_at,me2_at,me3_at,m_at_av,labels_a,colors_a]=join_tests(me1,me2,me3,labels,colors);
%Now we have:
% - me1_at: contains all the IMs corresponding to all the nodes and tests carried out in the bcourt (1 test with 57 nodes)
% - me2_at: contains all the IMs corresponding to all the nodes and tests carried out in the lobby (1 test with 55 nodes)
% - me3_at: contains all the IMs corresponding to all the nodes and tests carried out in the office (1 test with 54 nodes)
% - m_at_av: contains all the tests (9 in total), each with its own set of IMs, as if they had been done in the same environment.
% - labels_a: contain the labels corresponding to the 9 tests of m_at_av. Will be used as legends in the plot below, and thus 
%       only the first for each group is not empty.
% - colors_a: contain the colors corresponding to the 9 tests of m_at_av.


% The following plot contains the IMs from all tests aggregated per environment. It is not shown in the publication.
fig_number=5; 
options={};
options=struct('PlotEmpiricalDensities',true,'PlotDots',true,'PlotRefModel',true,'Labels',labels,'XLabels',xlables,'Colors',colors,'UseKde',true);
[PA,st_av]=param_distribution({me1_at;me2_at;me3_at},nr_id,fig_number,options); 

% The following plot corresponds to Figure 4 in the publication.
fig_number=6;
options=struct('PlotEmpiricalDensities',true,'PlotDots',true,'PlotRefModel',true,'Labels',{labels_a},'XLabels',xlables,'Colors',{colors_a},'UseKde',true,...
'KSep',0.4,'DotSize',5,'Linewidth',1,'NumMeshPoints',2^7);
[PA_,st_av_]=param_distribution(m_at_av,nr_id,fig_number,options);
if save_plots
  save_plot_as_tikz('env_cmp_av_at_p1ln.tex');
endif



% Now we compute the values shown in Table 1 of the article. In order to do so, compute the statistics for each test/robot trajectory.
% I will use the function param_distribution, so we will also see the plot associated to each robot trajectory, each in its respective plot.
%The previous figure (fig_number=6) shows all the data presented in the following three figures.
xlables={{'$n$','$z_\sub{0}$','$\sigma$'}};
options=struct('PlotEmpiricalDensities',true,'PlotDots',true,'PlotRefModel',true,'Labels',labels,'XLabels',xlables,'Colors',colors,'KSep',0.4,'DotSize',5,'Linewidth',1,'UseKde',true,'parseStrings',false);
for t_i=1:3
  fig_number=6+t_i;
  [PA_,st_av_]=param_distribution({moh_av_p1ln{t_i},mtul_av_p1ln{t_i},mtu3_av_p1ln{t_i}},nr_id,fig_number,options);
  
  printf("Mean and standard deviations of the curves for trajectory %i\n",t_i);
  printf("        \tOH\tTUL\tTU3\n");
  printf("--------------------------------------\n")
  printf("n-mean  \t%.2f\t%.2f\t%.2f\n",st_av_{1}.mean(1),st_av_{2}.mean(1),st_av_{3}.mean(1));
  printf("n-std   \t%.2f\t%.2f\t%.2f\n",st_av_{1}.std_dev(1),st_av_{2}.std_dev(1),st_av_{3}.std_dev(1));
  printf("n-std/n-mean   \t%.2f\t%.2f\t%.2f\n",st_av_{1}.std_dev(1)/st_av_{1}.mean(1),
                                         st_av_{2}.std_dev(1)/st_av_{2}.mean(1),
                                         st_av_{3}.std_dev(1)/st_av_{3}.mean(1));
  
  printf("n-cm    \t%.2f\t%.2f\t%.2f\n",moh_av_p1ln{t_i}{nr_id}.p(1),mtul_av_p1ln{t_i}{nr_id}.p(1),mtu3_av_p1ln{t_i}{nr_id}.p(1));

  printf("P0-mean \t%.2f\t%.2f\t%.2f\n",st_av_{1}.mean(2),st_av_{2}.mean(2),st_av_{3}.mean(2));
  printf("P0-std  \t%.2f\t%.2f\t%.2f\n",st_av_{1}.std_dev(2),st_av_{2}.std_dev(2),st_av_{3}.std_dev(2));
  printf("P0-cm   \t%.2f\t%.2f\t%.2f\n",moh_av_p1ln{t_i}{nr_id}.p(2),mtul_av_p1ln{t_i}{nr_id}.p(2),mtu3_av_p1ln{t_i}{nr_id}.p(2));

  printf("s-mean  \t%.2f\t%.2f\t%.2f\n",st_av_{1}.mean(3),st_av_{2}.mean(3),st_av_{3}.mean(3));
  printf("s-std   \t%.2f\t%.2f\t%.2f\n",st_av_{1}.std_dev(3),st_av_{2}.std_dev(3),st_av_{3}.std_dev(3));
  printf("s-cm    \t%.2f\t%.2f\t%.2f\n",moh_av_p1ln{t_i}{nr_id}.std,mtul_av_p1ln{t_i}{nr_id}.std,mtu3_av_p1ln{t_i}{nr_id}.std);
  
  printf("s-cm/n-cm    \t%.2f\t%.2f\t%.2f\n",moh_av_p1ln{t_i}{nr_id}.std/moh_av_p1ln{t_i}{nr_id}.p(1),
                                       mtul_av_p1ln{t_i}{nr_id}.std/mtul_av_p1ln{t_i}{nr_id}.p(1),
                                       mtu3_av_p1ln{t_i}{nr_id}.std/mtu3_av_p1ln{t_i}{nr_id}.p(1));
  
  printf("--------------------------------------\n")

endfor


%The results
%{
Mean and standard deviations of the curves for trajectory 1                                                                                                                  
                OH      TUL     TU3                                                                                                                                          
--------------------------------------                                                                                                                                       
n-mean          1.71    1.70    2.87                                                                                                                                         
n-std           0.14    0.25    0.48                                                                                                                                         
n-std/n-mean    0.08    0.15    0.17                                                                                                                                         
n-cm            1.68    1.74    2.85                                                                                                                                         
P0-mean         -42.23  -43.78  -38.62                                                                                                                                       
P0-std          2.20    2.87    4.65                                                                                                                                         
P0-cm           -42.51  -43.43  -39.11                                                                                                                                       
s-mean          2.65    2.98    4.76                                                                                                                                         
s-std           0.28    0.47    0.71                                                                                                                                         
s-cm            3.00    3.40    5.34                                                                                                                                         
s-cm/n-cm       1.79    1.95    1.88                                                                                                                                         
--------------------------------------
Mean and standard deviations of the curves for trajectory 2
                OH      TUL     TU3
--------------------------------------
n-mean          1.74    1.89    2.89
n-std           0.17    0.17    0.40
n-std/n-mean    0.10    0.09    0.14
n-cm            1.73    1.91    2.92
P0-mean         -41.93  -41.67  -38.58
P0-std          2.50    2.78    3.75
P0-cm           -41.99  -41.39  -38.61
s-mean          2.67    2.88    4.82
s-std           0.25    0.55    0.79
s-cm            3.03    3.39    5.31
s-cm/n-cm       1.76    1.77    1.82
--------------------------------------
Mean and standard deviations of the curves for trajectory 3
                OH      TUL     TU3
--------------------------------------
n-mean          1.72    1.39    2.84
n-std           0.17    0.20    0.41
n-std/n-mean    0.10    0.14    0.15
n-cm            1.71    1.43    2.86
P0-mean         -42.00  -46.61  -38.89
P0-std          2.70    2.27    3.80
P0-cm           -42.09  -46.06  -38.98
s-mean          2.66    2.46    4.86
s-std           0.23    0.26    0.83
s-cm            3.05    2.85    5.38
s-cm/n-cm       1.79    1.99    1.88
--------------------------------------
%}
