printf("\n\n\n");
printf("************************************************\n");
printf("*         Impact of the Antenna Directivity    *\n");
printf("************************************************\n");

%Load all the data that might be needed for the studies
clear all;
run("../preliminaries/load_averaged_data");
run("../preliminaries/extract_averaged_models");
nr_id=21;
d0=1;
load_colors;
save_plots=false;

function g=dir_antenna_pattern(t,gmax,gmin,k)
  t=mod(t,2*pi);
  idx=find(t<pi);
  idx2=find(t>=pi);
  g(idx)=exp(-k*t(idx).^2);
  g(idx2)=exp(-k*(2*pi-t(idx2)).^2);
  g=gmin+(gmax-gmin)*g;
  g=reshape(g,size(t));
endfunction

%First a plot with the different patterns showing how our virtual antenna works (Figure 5 in the article)
gmax=0; %Maximum gain
gmin=-30; %Minimum gain
antenna_pattern=@(t) dir_antenna_pattern(t,gmax,gmin,1);
t=linspace(0,2*pi,200);
figure(10);clf
mmpolar(t,dir_antenna_pattern(t,gmax,gmin,0.01),'r','Style','compass');hold on;
mmpolar(t,dir_antenna_pattern(t,gmax,gmin,0.1), 'r','Style','compass');
mmpolar(t,dir_antenna_pattern(t,gmax,gmin,1),   'r','Style','compass');
mmpolar(t,dir_antenna_pattern(t,gmax,gmin,10),  'r','Style','compass');
text (0.7,-0.15, '$\kappa=10$')
text (0.5,-0.39, '$\kappa=1$')
text (0.05,-0.75,'$\kappa=10^{-1}$')
text (-0.46,-0.8,'$\kappa=10^{-2}$') 
if save_plots
    save_plot_as_tikz('antennize_polar_plot.tex');
endif
figure(11);clf
plot(t,dir_antenna_pattern(t,gmax,gmin,0.01),'r');hold on;
plot(t,dir_antenna_pattern(t,gmax,gmin,0.1),'r');
plot(t,dir_antenna_pattern(t,gmax,gmin,1),'r');
plot(t,dir_antenna_pattern(t,gmax,gmin,10),'r');
set (gca, 'xtick', [0.0 pi 2*pi]);
set (gca, 'xticklabel', {'0' '$\pi$' '$2\pi$'});
axis ([0 2*pi -30 0]);
xlabel('Angle [rad]')
ylabel('Gain[dB]')
text (0.5,-25,'$\kappa=10$')
text (1,-19,'$\kappa=1$')
text (2.1,-10,'$\kappa=10^{-1}$')
text (3,-4,'$\kappa=10^{-2}$')
grid on
if save_plots
    save_plot_as_tikz('antennize_gain_angle_plot.tex');
endif

%Now a plot showing an example of the mean and standard deviation of the model parameters wrt. the antenna directivity 
%(Figure 7 in the article). 
t_i=2; % arbitrarily pick the second test/robot trajectory. Note that in my thesis I used t_i=1 and d0=5 for figures 3.5 and 3.6, in case you wander why they are different.
fig_num=[]; %Do not plot, for faster execution.
clear moh_ant_p1ln mtu3_ant_p1ln mtul_ant_p1ln st_av_oh st_av_tul st_av_tu3 ant
kappa=logspace(-3,5,100);
for k_i=1:numel(kappa)
  k=kappa(k_i)
  antenna_pattern=@(t) dir_antenna_pattern(t,gmax,gmin,k);
  filter_options={'Antenna',antenna_pattern}; 
  moh_ant_p1ln{t_i}= extract_rssi_models( oh_av{t_i}.nodes_s, oh_av{t_i}.robot_s,filter_options,{'PLN',1,d0});
  mtu3_ant_p1ln{t_i}=extract_rssi_models(tu3_av{t_i}.nodes_s,tu3_av{t_i}.robot_s,filter_options,{'PLN',1,d0});
  mtul_ant_p1ln{t_i}=extract_rssi_models(tul_av{t_i}.nodes_s,tul_av{t_i}.robot_s,filter_options,{'PLN',1,d0});
  
  %Calculate the statistical distribution of the parameter values, without (*_av_p1ln) and with (*_ant_p1ln) 
  %the effect of the antenna
  [~,st_av_oh{k_i}]= param_distribution({moh_av_p1ln{t_i}, moh_ant_p1ln{t_i}}, nr_id,fig_num);
  [~,st_av_tul{k_i}]=param_distribution({mtul_av_p1ln{t_i},mtul_ant_p1ln{t_i}},nr_id,fig_num);
  [~,st_av_tu3{k_i}]=param_distribution({mtu3_av_p1ln{t_i},mtu3_ant_p1ln{t_i}},nr_id,fig_num);
 
  %Store the statistics associated to using the antenna 
  ant.mean.n.oh(k_i)   =st_av_oh{k_i}{2}.mean(1);
  ant.mean.n.tul(k_i)  =st_av_tul{k_i}{2}.mean(1);
  ant.mean.n.tu3(k_i)  =st_av_tu3{k_i}{2}.mean(1);
  ant.mean.p0.oh(k_i)  =st_av_oh{k_i}{2}.mean(2);
  ant.mean.p0.tul(k_i) =st_av_tul{k_i}{2}.mean(2);
  ant.mean.p0.tu3(k_i) =st_av_tu3{k_i}{2}.mean(2);
  ant.mean.std.oh(k_i) =st_av_oh{k_i}{2}.mean(3);
  ant.mean.std.tul(k_i)=st_av_tul{k_i}{2}.mean(3);
  ant.mean.std.tu3(k_i)=st_av_tu3{k_i}{2}.mean(3);
  
  ant.std.n.oh(k_i)   =st_av_oh{k_i}{2}.std_dev(1);
  ant.std.n.tul(k_i)  =st_av_tul{k_i}{2}.std_dev(1);
  ant.std.n.tu3(k_i)  =st_av_tu3{k_i}{2}.std_dev(1);
  ant.std.p0.oh(k_i)  =st_av_oh{k_i}{2}.std_dev(2);
  ant.std.p0.tul(k_i) =st_av_tul{k_i}{2}.std_dev(2);
  ant.std.p0.tu3(k_i) =st_av_tu3{k_i}{2}.std_dev(2);
  ant.std.std.oh(k_i) =st_av_oh{k_i}{2}.std_dev(3);
  ant.std.std.tul(k_i)=st_av_tul{k_i}{2}.std_dev(3);
  ant.std.std.tu3(k_i)=st_av_tu3{k_i}{2}.std_dev(3);
endfor
clear k_i,k;
ant.kappa=kappa;
%save('-binary','ant.dat','ant');

% st_av_oh{k_i}{t_i} contains the parameters and their statistics associated to the 
% directionality parameter 'kappa(k_i)' corresponding to the test 't_i', where 
% t_i=1 refers to the original data, and t_i=2 to the "antennized" data. 

%The mean n (Figure 7a in the article)
n_mean0.oh =st_av_oh{1}{1}.mean(1);  %Values without the effect of the antenna 
n_mean0.tul=st_av_tul{1}{1}.mean(1); 
n_mean0.tu3=st_av_tu3{1}{1}.mean(1); 
figure(12);clf
semilogx(kappa, ant.mean.n.oh/n_mean0.oh,  '-','Color',color_bfield,...
         kappa, ant.mean.n.tul/n_mean0.tul,'-','Color',color_lobby,...
         kappa, ant.mean.n.tu3/n_mean0.tu3,'-','Color',color_office);
xlabel('$\kappa$')
ylabel('$\mathrm{mean}(n)/\mathrm{mean}(n_{\smsub{0}})$')
legend('bfield','lobby','office','location','SouthEast')
grid on
if save_plots
    save_plot_as_tikz('antennize_mean_n_plot.tex');
endif
            
%The standard deviation of n (Figure 7b in the article)
n_std0.oh=st_av_oh{1}{1}.std_dev(1); 
n_std0.tul=st_av_tul{1}{1}.std_dev(1); 
n_std0.tu3=st_av_tu3{1}{1}.std_dev(1); 
figure(13);clf
semilogx(kappa, ant.std.n.oh/n_std0.oh,  '-','Color',color_bfield,...
         kappa, ant.std.n.tul/n_std0.tul,'-','Color',color_lobby,...
         kappa, ant.std.n.tu3/n_std0.tu3,'-','Color',color_office);
xlabel('$\kappa$')
ylabel('$\mathrm{std}(n)/\mathrm{std}(n_{\smsub{0}})$')
legend('bfield','lobby','office','location','NorthEast')
grid on
if save_plots
    save_plot_as_tikz('antennize_std_n_plot.tex');
endif
            
%The mean z0 (Figure 7c in the article)
p0_mean0.oh=st_av_oh{1}{1}.mean(2); 
p0_mean0.tul=st_av_tul{1}{1}.mean(2); 
p0_mean0.tu3=st_av_tu3{1}{1}.mean(2); 
figure(14);clf
semilogx(kappa, ant.mean.p0.oh/p0_mean0.oh,  '-','Color',color_bfield,...
         kappa, ant.mean.p0.tul/p0_mean0.tul,'-','Color',color_lobby,...
         kappa, ant.mean.p0.tu3/p0_mean0.tu3,'-','Color',color_office);
xlabel('$\kappa$')
ylabel('$\mathrm{mean}(z_{\smsub{r}})/\mathrm{mean}(z_{\smsub{r0}})$')
legend('bfield','lobby','office','location','SouthEast')
grid on
if save_plots
    save_plot_as_tikz('antennize_mean_p0_plot.tex');
endif

%The standard deviation of z0  (Figure 7d in the article)         
p0_std0.oh=st_av_oh{1}{1}.std_dev(2); 
p0_std0.tul=st_av_tul{1}{1}.std_dev(2); 
p0_std0.tu3=st_av_tu3{1}{1}.std_dev(2); 
figure(15);clf
semilogx(kappa, ant.std.p0.oh/p0_std0.oh,'-','Color',color_bfield,...
         kappa, ant.std.p0.tul/p0_std0.tul,'-','Color',color_lobby,...
         kappa, ant.std.p0.tu3/p0_std0.tu3,'-','Color',color_office);
xlabel('$\kappa$')
ylabel('$\mathrm{std}(z_{\smsub{r}})/\mathrm{std}(z_{\smsub{r0}})$')
legend('bfield','lobby','office','location','NorthEast')
grid on
if save_plots
    save_plot_as_tikz('antennize_std_p0_plot.tex');
endif

%The mean sigma (Figure 7e in the article)         
std_mean0.oh=st_av_oh{1}{1}.mean(3); 
std_mean0.tul=st_av_tul{1}{1}.mean(3); 
std_mean0.tu3=st_av_tu3{1}{1}.mean(3); 
figure(16);clf
semilogx(kappa, ant.mean.std.oh/std_mean0.oh,  '-','Color',color_bfield,...
         kappa, ant.mean.std.tul/std_mean0.tul,'-','Color',color_lobby,...
         kappa, ant.mean.std.tu3/std_mean0.tu3,'-','Color',color_office);
xlabel('$\kappa$')
ylabel('$\mathrm{mean}(\sigma)/\mathrm{mean}(\sigma_{\smsub{0}})$')
legend('bfield','lobby','office','location','NorthEast')
grid on
if save_plots
    save_plot_as_tikz('antennize_mean_std_plot.tex');
endif

%The standard deviation of sigma (Figure 7f in the article)                    
std_std0.oh=st_av_oh{1}{1}.std_dev(3); 
std_std0.tul=st_av_tul{1}{1}.std_dev(3); 
std_std0.tu3=st_av_tu3{1}{1}.std_dev(3); 
figure(17);clf
semilogx(kappa, ant.std.std.oh/std_std0.oh,  '-','Color',color_bfield,...
         kappa, ant.std.std.tul/std_std0.tul,'-','Color',color_lobby,...
         kappa, ant.std.std.tu3/std_std0.tu3,'-','Color',color_office);
xlabel('$\kappa$')
ylabel('$\mathrm{std}(\sigma)/\mathrm{std}(\sigma_{\smsub{0}})$')
legend('bfield','lobby','office','location','NorthEast')
grid on
if save_plots
    save_plot_as_tikz('antennize_std_std_plot.tex');
endif                                
          
%Now the plot showing how much the distributions can change
t_i=1; % arbitrarily pick the first test/robot trajectory. If you choose the third one, you will see even larger variations in n. 
antenna_pattern=@(t) dir_antenna_pattern(t,gmax,gmin,1);
filter_options={'Antenna',antenna_pattern}; 
moh_ant_p1ln{t_i}= extract_rssi_models( oh_av{t_i}.nodes_s, oh_av{t_i}.robot_s,filter_options,{'PLN',1,d0});
mtu3_ant_p1ln{t_i}=extract_rssi_models(tu3_av{t_i}.nodes_s,tu3_av{t_i}.robot_s,filter_options,{'PLN',1,d0});
mtul_ant_p1ln{t_i}=extract_rssi_models(tul_av{t_i}.nodes_s,tul_av{t_i}.robot_s,filter_options,{'PLN',1,d0});

color_orig=color_bfield;
color_ant=color_lobby;
colors={{color_orig,color_ant}};
labels={{'Orig.','Ant.'}};
xlables={{'$n$',sprintf("$z_\\sub{0}$",d0),'$\sigma$'}};
options=struct('PlotEmpiricalDensities',true,'PlotDots',true,'PlotRefModel',true,'Labels',labels,'XLabels',xlables,...
               'Colors',colors,'KSep',0.4,'DotSize',5,'Linewidth',1,'NumMeshPoints',2^7,'UseKde',true);
fig_num=18; % Changes in the basketball court (Figure 6b in the publication)
[PA_oh,st_av_oh]=param_distribution({moh_av_p1ln{t_i},moh_ant_p1ln{t_i}},nr_id,fig_num,options);
if save_plots
    save_plot_as_tikz('antennize_oh_plot.tex');
endif
fig_num=19; % Changes in the lobby (Not in the publication)
[PA_tul,st_av_tul]=param_distribution({mtul_av_p1ln{t_i},mtul_ant_p1ln{t_i}},nr_id,fig_num,options);
if save_plots
    save_plot_as_tikz('antennize_tul_plot.tex');
endif
fig_num=20; % Changes in the office (Not in the publication)
[PA_tu3,st_av_tu3]=param_distribution({mtu3_av_p1ln{t_i},mtu3_ant_p1ln{t_i}},nr_id,fig_num,options);
if save_plots
    save_plot_as_tikz('antennize_tu3_plot.tex'); 
endif

%The maximum relative variation of the path-loss exponent in IMs due to the addition of the antenna in the basketball court.
mrvn=max(abs((PA_oh(2,:,1)-PA_oh(1,:,1))./PA_oh(1,:,1)));
printf("Max. relative variation of 'n' due to the antenna addition: %.2f;\n",mrvn);
clear mrvn;

%The relative change in the path-loss exponent of the reference models when switching from the basketball court to the office. 
n_rm_bc=[1.68 1.73 1.71];  
n_rm_office=[2.85 2.92 2.86];
mrvn=(n_rm_office-n_rm_bc)./n_rm_bc;
printf("Relative change in 'n' (ref model) when switching from Bcourt to Office. Traj 1:%.2f; Traj 2: %.2f; Traj 3: %.2f;\n",mrvn);

%Now the plot showing an example of how does the RSS-distance scatter plot changes.
antenna_pattern=@(t) dir_antenna_pattern(t,gmax,gmin,0.1);
filter_options={'Antenna',antenna_pattern}; 
t_i=2;
moh_ant_p1ln=extract_rssi_models(oh_av{t_i}.nodes_s,oh_av{t_i}.robot_s,filter_options,{'PLN',1,d0});
%Check which IM has the largest impact in the path loss exponent
comp=[];
for n_i=1:numel(moh_av_p1ln{t_i})-1
  if isempty(moh_av_p1ln{t_i}{n_i}), continue; endif
  comp=[comp; ...
        n_i ...
        (moh_ant_p1ln{n_i}.theta-moh_av_p1ln{t_i}{n_i}.theta)./moh_av_p1ln{t_i}{n_i}.theta];
endfor
idx=find(abs(comp(:,2))==max(abs(comp(:,2))));
relative_changes=comp(idx,2:end);
printf("Relative changes in the model parameters. n: %.2f; z0: %.2f; s: %.2f\n",relative_changes);
n_i=comp(idx,1);
% Plot the RSS-log(d) scatter plots showing the effect of the antenna. This corresponds to Figure 6a in the article.
figure(21);clf;
semilogx(moh_av_p1ln{t_i}{n_i}.d, moh_av_p1ln{t_i}{n_i}.rssi,'b.','MarkerSize',2,moh_av_p1ln{t_i}{n_i}.d, moh_av_p1ln{t_i}{n_i}.yf,'r','Linewidth',1);
hold on;
semilogx(moh_ant_p1ln{n_i}.d,moh_ant_p1ln{n_i}.rssi,'g.','MarkerSize',2,moh_ant_p1ln{n_i}.d,moh_ant_p1ln{n_i}.yf,'k','Linewidth',1)
legend("orig.","orig.",'ant.','ant.')
grid on;
xlabel('Distance [m]');
ylabel('RSS [dBm]');
if save_plots
    save_plot_as_tikz('antennize_scatter_plot.tex'); 
endif


