Characterization of the Log-normal Model for Received Signal Strength Measurements in Real Wireless Sensor Networks: Data and Scripts
------------------------------------------

This repository contains the data and scripts necessary to reproduce the results of the publication "Characterization of the Log-normal Model for Received Signal Strength Measurements in Real Wireless Sensor Networks" [1].

Prerequisites
-------------
The code has been prepared to be executed in Octave [2], and has been tested using version 5.1.0, although others might work as well. The code uses functions of the *statistics* package from octave-forge [3], and thus has to be installed.

Directory Structure
-------------------
Besides this README, the root directory contains the following scripts (.m files):

* setup.m: script that sets the octave path so that it can find all the relevant functions. If you start octave from the root directory of this repository, octave will automatically execute it, so you will not need to do it yourself.
* main.m: loads the data and executes all the scripts that do all the necessary computations in a sequential order.

The root directory contains the following directories:

* data: contais the data used.
* tools: contains a *mini-toolbox* with scripts necessary to do common computations in relation to localization using RSS measurements. These scripts are stripped down versions taken from the original toolbox (see Notes).
* preliminaries: scripts to load the data, identify the models and to plot some figures of the RSS vs. the log-distance.
* env_cmp: scripts dedicated to study the variability of the model parameters.
* antennize: scripts related to the study of the effect of the antenna directionality.
* par_corr: scripts to calculate and plot the correlation among the model parameters.

Credits
----------------
The following scripts included in this repository have been created by other authors, namely:

* tools/utils/mmpolar: created by Duane Hanselman [5].
* tools/utils/kde: created by Zdravko Botev [6].
* tools/utils/gkdeb: created by Yi Cao [7].

Notes
------
* The figures in the publication were created first with the code provided, then converted to tikz using matlab2tikz v0.4.2 [4], and then manually and extensibly tweaked. For the sake of simplicity, then, the resulting tikz files are not present in this repository, neither the commands needed to convert the figures into tikz plots using matlab2tikz.

* The scripts in the tools directory are part of a larger toolbox (not openly available at the time of this deposition). For the sake of simplicity, they have been stripped down, keeping mostly only parts that are necessary for the calculations related to the article at hand. These scripts then are not optimized for the purposes of the publication at hand.


References
----------
* [1]- Vallet García, José M., Characterization of the Log-normal Model for Received Signal Strength Measurements in Real Wireless Sensor Networks. J. Sens. Actuator Netw. 2019, Special Issue "Localization in Wireless Sensor Networks".
* [2]- Octave - https://www.gnu.org/software/octave/
* [3]- Statistics package - https://octave.sourceforge.io/statistics/index.html
* [4]- matlab2tikz - https://github.com/matlab2tikz/matlab2tikz
* [5]- Duane Hanselman (2012). Comprehensive Polar Plots (https://www.mathworks.com/matlabcentral/fileexchange/38855-comprehensive-polar-plots), MATLAB Central File Exchange. Retrieved February 1, 2012.
* [6]- Zdravko Botev (2012). Kernel Density Estimator (https://www.mathworks.com/matlabcentral/fileexchange/14034), MATLAB Central File Exchange. Retrieved May, 2012.
* [7]- Yi Cao (2012). Probability Density Function (PDF) Estimator (https://www.mathworks.com/matlabcentral/fileexchange/19121), MATLAB Central File Exchange. Retrieved May, 2012.

