close all
clear all
clc
set(0,'DefaultLegendAutoUpdate','off')
load('f.mat')
load('fEpsX.mat')

j=[1 2 3 4];

f={f_1 f_2 f_3 f_4};

J_Wa=[0.283 0.283];
J_75=0.62490765323756;
J_90=0.647252709454988;
Gss_Wa=[0.289 0.289];
GI_Wa=[0.073 0.073];
GII_Wa=[0.217 0.217];

% Opdaterede values
GI_45=0.0749949379755304;
GII_45=0.226476585590192;
Gss_45=GI_45+GII_45
J_45=0.290746036065814;
Psi45GlassFRP1=66.8170982669114;
%
GI_60=0.375654485438415;
GII_60=0.172754250656044;
Gss_60=GI_60+GII_60
J_60=0.518031029370894;
Psi60GlassFRP1=42.688920633835;
%
GI_75=0.639005977258598;
GII_75=0.0447346577308536;
Gss_75=GI_75+GII_75
J_75=0.638960676060924;
Psi75GlassFRP1=19.889104440001;
%
GI45CarbonFRP1=0.00688844332856289;
GII45CarbonFRP1=0.234111946717807;
Gss45CarbonFRP1=GI45CarbonFRP1+GII45CarbonFRP1;
J45CarbonFRP1=0.236597468278669;
Psi45CarbonFRP1=84.7629300166265;
%
GI60CarbonFRP1=0.26586959671699;
GII60CarbonFRP1=0.181736622678055;
Gss60CarbonFRP1=GI60CarbonFRP1+GII60CarbonFRP1;
J60CarbonFRP1=0.421336288420267;
Psi60CarbonFRP1=58.8772779406503;
%
GI75CarbonFRP1=0.550261541499525;
GII75CarbonFRP1=0.0447525427058537;
Gss75CarbonFRP1=GI75CarbonFRP1+GII75CarbonFRP1;
J75CarbonFRP1=0.541774570628912;
Psi75CarbonFRP1=29.8912963621323;
%
GI60CarbonFRP2=0.189364082422751;
GII60CarbonFRP2=0.203135324243291;
Gss60CarbonFRP2=GI60CarbonFRP2+GII60CarbonFRP2;
J60CarbonFRP2=0.377874879949903;
Psi60CarbonFRP2=69.6459461281049;
%
GI45CarbonFRP2=0.000219262456001454;
GII45CarbonFRP2=0.257210460929043;
Gss45CarbonFRP2=GI45CarbonFRP2+GII45CarbonFRP2;
J45CarbonFRP2=0.256918161487865;
Psi45CarbonFRP2=88.789260701636;
%
GI75CarbonFRP2=0.463275392886766;
GII75CarbonFRP2=0.0567357514623096;
Gss75CarbonFRP2=GI75CarbonFRP2+GII75CarbonFRP2;
J75CarbonFRP2=0.475900482384404;
Psi75CarbonFRP2=42.6658480012797;
% End updateret

% Gss45GlassFRP1=0.295
% Psi45GlassFRP1=67.1
% Gss45CarbonFRP1=0.223
% Psi45CarbonFRP1=85.1
% Gss60CarbonFRP1=0.424
% Psi60CarbonFRP1=53.7
% Gss45CarbonFRP2=0.225
% Psi45CarbonFRP2=89.2


figure(1)
plot([0 0],[0 0],'--b','LineWidth',1.5)
hold on
plot([0 0],[0 0],'-.b','LineWidth',1.5)
plot([0 0],[0 0],'-b','LineWidth',1.5)
plot([0 0],[0 0],':b','LineWidth',1.5)

%plot(45,J_Wa(1),'ob','MarkerSize',8)
%plot(45,GI_Wa(1),'xb','MarkerSize',8)
%plot(45,GII_Wa(1),'+b','MarkerSize',8)
%plot(45,Gss_Wa(1),'*b','MarkerSize',8)
plot(45,J_45,'ob','MarkerSize',8)
plot(45,GI_45,'xb','MarkerSize',8)
plot(45,GII_45,'+b','MarkerSize',8)
plot(45,Gss_45,'*b','MarkerSize',8)
plot(60,J_60,'ob','MarkerSize',8)
plot(60,GI_60,'xb','MarkerSize',8)
plot(60,GII_60,'+b','MarkerSize',8)
plot(60,Gss_60,'*b','MarkerSize',8)
plot(75,J_75,'ob','MarkerSize',8)
plot(75,GI_75,'xb','MarkerSize',8)
plot(75,GII_75,'+b','MarkerSize',8)
plot(75,Gss_75,'*b','MarkerSize',8)
legend({'$\hat{G}_{I}$','$\hat{G}_{II}$','$\hat{G}_{ss}$','$\delta^{min}_n<0$','$\bar{J}$','$\bar{G}_{I}$','$\bar{G}_{II}$','$\bar{G}_{ss}$'},'location','northwest','Interpreter','latex','FontSize',14)

figure(4)
plot([0 0],[0 0],'--b','LineWidth',1.5)
hold on
plot([0 0],[0 0],'-g','LineWidth',1.5)
plot([0 0],[0 0],'--k','LineWidth',1.5)
plot([0 0],[0 0],'-r','LineWidth',1.5)
plot([0 0],[0 0],':k','LineWidth',1.5)

figure(71)
plot([0 0],[0 0],'--b','LineWidth',1.5)
hold on
plot([0 0],[0 0],'-g','LineWidth',1.5)
plot([0 0],[0 0],'--k','LineWidth',1.5)
plot([0 0],[0 0],'-r','LineWidth',1.5)
plot([0 0],[0 0],':k','LineWidth',1.5)
axis([0 90 0.5 0.7]) 
legend({'GlassFRP1','GlassFRP2','CarbonFRP1','CarbonFRP2','$\delta^{min}_n<0$'},'location','southwest','Interpreter','latex','FontSize',12)
grid on
ylabel('$\bar{\delta}/\delta_{max}$','interpreter','latex', 'FontSize', 14)
xlabel('$\theta~[^{\circ}]$','interpreter','latex', 'FontSize', 14)
text(25,0.6,'$\delta_{n}$','interpreter','latex', 'FontSize', 20)
text(45,0.6,'$\delta_{n}$','interpreter','latex', 'FontSize', 20)
text(20,0.65,'$\delta_t$','interpreter','latex', 'FontSize', 20)


figure(4)
yyaxis left
plot(60,J_60,'ob','MarkerSize',8)
yyaxis right
plot(60,Psi60GlassFRP1,'sb','MarkerSize',8)
legend({'GlassFRP1','GlassFRP2','CarbonFRP1','CarbonFRP2','$\delta^{min}_n<0$','$\bar{J}$','$\bar{\psi}$'},'location','west','Interpreter','latex','FontSize',12)
yyaxis left
plot(45,J_45,'ob','MarkerSize',8)
plot(75,J_75,'ob','MarkerSize',8)
%plot(45,Gss45GlassFRP1,'*b','MarkerSize',8)
%plot(45,Gss45CarbonFRP1,'*k','MarkerSize',8)
%plot(60,Gss60CarbonFRP1,'*k','MarkerSize',8)
%plot(45,Gss45CarbonFRP2,'*r','MarkerSize',8)
plot(75,J75CarbonFRP2,'or','MarkerSize',8)
plot(60,J60CarbonFRP2,'or','MarkerSize',8)
plot(45,J45CarbonFRP2,'or','MarkerSize',8)
plot(75,J75CarbonFRP1,'ok','MarkerSize',8)
plot(60,J60CarbonFRP1,'ok','MarkerSize',8)
plot(45,J45CarbonFRP1,'ok','MarkerSize',8)
yyaxis right
%plot(45,Psi45GlassFRP1,'sb','MarkerSize',8)
%plot(45,Psi45CarbonFRP1,'sk','MarkerSize',8)
%plot(60,Psi60CarbonFRP1,'sk','MarkerSize',8)
%plot(45,Psi45CarbonFRP2,'sr','MarkerSize',8)
plot(75,Psi75CarbonFRP1,'sk','MarkerSize',8)
plot(60,Psi60CarbonFRP1,'sk','MarkerSize',8)
plot(45,Psi45CarbonFRP1,'sk','MarkerSize',8)
plot(75,Psi75CarbonFRP2,'sr','MarkerSize',8)
plot(60,Psi60CarbonFRP2,'sr','MarkerSize',8)
plot(45,Psi45CarbonFRP2,'sr','MarkerSize',8)
plot(45,Psi45GlassFRP1,'sb','MarkerSize',8)
plot(75,Psi75GlassFRP1,'sb','MarkerSize',8)


figure(2)
plot([0 0],[0 0],'--b','LineWidth',1.5)
hold on
plot([0 0],[0 0],'-g','LineWidth',1.5)
plot([0 0],[0 0],'--k','LineWidth',1.5)
plot([0 0],[0 0],'-r','LineWidth',1.5)
plot([0 0],[0 0],':k','LineWidth',1.5)
plot(45,GI_45,'ob','MarkerSize',8)
plot(45,GII_45,'sb','MarkerSize',8)
plot(75,GI_75,'ob','MarkerSize',8)
plot(75,GII_75,'sb','MarkerSize',8)
plot(60,GI_60,'ob','MarkerSize',8)
plot(60,GII_60,'sb','MarkerSize',8)
plot(60,GI60CarbonFRP1,'ok','MarkerSize',8)
plot(60,GII60CarbonFRP1,'sk','MarkerSize',8)
plot(45,GI45CarbonFRP1,'ok','MarkerSize',8)
plot(45,GII45CarbonFRP1,'sk','MarkerSize',8)
plot(75,GI75CarbonFRP1,'ok','MarkerSize',8)
plot(75,GII75CarbonFRP1,'sk','MarkerSize',8)
plot(60,GI60CarbonFRP2,'or','MarkerSize',8)
plot(60,GII60CarbonFRP2,'sr','MarkerSize',8)
plot(45,GI45CarbonFRP2,'or','MarkerSize',8)
plot(45,GII45CarbonFRP2,'sr','MarkerSize',8)
plot(75,GI75CarbonFRP2,'or','MarkerSize',8)
plot(75,GII75CarbonFRP2,'sr','MarkerSize',8)
legend({'GlassFRP1','GlassFRP2','CarbonFRP1','CarbonFRP2','$\delta^{min}_n<0$','$\bar{G}_{I}$','$\bar{G}_{II}$'},'location','northwest','AutoUpdate','off','Interpreter','latex','FontSize',12)


%%



for k=1:size(f,2)
    DNfactor{k}=zeros(1,size((TT{j(k)}),2))
    DTfactor{k}=zeros(1,size((TT{j(k)}),2))
    GI=zeros(1,size((TT{j(k)}),2));
    GII=zeros(1,size((TT{j(k)}),2));
    GI_norm=zeros(1,size((TT{j(k)}),2));
    GII_norm=zeros(1,size((TT{j(k)}),2));
    GI=zeros(1,size((TT{j(k)}),2));
    GII=zeros(1,size((TT{j(k)}),2));
    for n=1:size((TT{j(k)}),2)
        a=find(TT{j(k)}==45);
        if j(k)==1
            if n<a(1)
                name0=['D',num2str(TT{j(k)}(n)),'_W180_Hh2_L140_G004_001_T_5'];
            else
                name0=['D',num2str(TT{j(k)}(n)),'_W40_Hh2_L140_G004_001_T'];
            end
        end
        if j(k)==2
            if n<a(1)
                name0=['EG_D',num2str(TT{j(k)}(n)),'_W180_Hh2_L140_G004_001_T_5'];
            else
                name0=['EG_D',num2str(TT{j(k)}(n)),'_W40_Hh2_L140_G004_001_T'];
            end
        end
        if j(k)==3
            if n<a(1)
                name0=['AS4_D',num2str(TT{j(k)}(n)),'_W220_Hh2_L180_G004_001_T_5'];
            else
                name0=['AS4_D',num2str(TT{j(k)}(n)),'_W40_Hh2_L140_G004_001_T'];
            end
        end
        if j(k)==4
            if n<a(1)
                name0=['UM_D',num2str(TT{j(k)}(n)),'_W220_Hh2_L180_G004_001_T_5'];
            else
                name0=['UM_D',num2str(TT{j(k)}(n)),'_W40_Hh2_L140_G004_001_T'];
            end
        end
        name1=[name0,'disp1_dx.rpt'];
        name2=[name0,'disp1_sx.rpt'];
        name3=[name0,'disp3_dx.rpt'];
        name4=[name0,'disp3_sx.rpt'];
        name5=[name0,'s22.rpt'];
        name6=[name0,'s12.rpt'];
        name7=[name0,'s11.rpt'];
        name8=[name0,'e22.rpt'];
        name9=[name0,'e12.rpt'];
        name10=[name0,'e11.rpt'];
        
        
        [X,delta1_dx] = importfile1(name1,2);
        [X,delta1_sx] = importfile1(name2,2);
        [X,delta3_dx] = importfile1(name3,2);
        [X,delta3_sx] = importfile1(name4,2);
        [Y,S22] = importfile1(name5,2);
        [Y,S12] = importfile1(name6,2);
        [Y,S11] = importfile1(name7,2);
        [Y,e22] = importfile1(name8,2);
        [Y,e12] = importfile1(name9,2);
        [Y,e11] = importfile1(name10,2);
        
        S12=-S12; %in abaqus model 3 axis is turned
        e12=-e12;%in abaqus model 3 axis is turned
        
 
        
        
        
        
        theta=TT{j(k)}(n)
        
        sigma_local=s_local{j(k),n}
        factor=f{k}(n)
        
       
            
        
        length=((delta1_dx-delta1_sx).^2+(delta3_dx-delta3_sx).^2).^(1/2);
        
        alpha=atand((delta3_dx-delta3_sx)./(delta1_dx-delta1_sx));
        betha=theta-alpha;
       
        
        delta_n=[sind(betha).* length];
        delta_t=[cosd(betha).* length];
        DNneg{k}(n)=min(delta_n(2:size(delta_n,1)));    
        DNpos{k}(n)=min(delta_n(2:size(delta_n,1))); 
        
        delta_n(delta_n<0)=0;
        
        deltanmean=mean(delta_n);
        deltanmax=max(delta_n);
        deltatmean=mean(delta_t);
        deltatmax=max(delta_t);

        DNfactor{k}(n)=deltanmean/deltanmax;
        DTfactor{k}(n)=deltatmean/deltatmax;
        
         if TT{j(k)}(n)==45
             if j(k)==1
                 figure(61)
                 plot(0.5*delta_n/EpsX_1(n),(X-1)/2,'b.','MarkerFaceColor','b')
                 DELTAn1_45ave=trapz(X,0.5*delta_n/EpsX_1(n))
                 hold on
                 plot(0.5*delta_t/EpsX_1(n),(X-1)/2,'bx')
                 DELTAt1_45ave=trapz(X,0.5*delta_t/EpsX_1(n))
             elseif j(k)==3
                 figure(61)
                 hold on
                 plot(0.5*delta_n/EpsX_3(n),(X-1)/2,'k.','MarkerFaceColor','k')
                 DELTAn3_45ave=trapz(X,0.5*delta_n/EpsX_3(n))
                 plot(0.5*delta_t/EpsX_3(n),(X-1)/2,'kx')
                 DELTAt3_45ave=trapz(X,0.5*delta_t/EpsX_3(n))
             end  
             figure(61)
             hold on
             legend({'GlassFRP1: $\delta_n$','GlassFRP1: $\delta_t$','CarbonFRP1: $\delta_n$','CarbonFRP1: $\delta_t$'},'location','southeast','interpreter','latex', 'FontSize', 14)
             xlabel('$\delta/(2h\varepsilon_{xx})$','interpreter','latex', 'FontSize', 14)
             ylabel('$z/(2h)$','interpreter','latex', 'FontSize', 14)
             %ylim([-0.5,0])
             yticks(-0.5:0.1:0)
             xlim([0,2.25])
         end

         
        
        h=1;
        
        %calculation of Crack Growth Rate, mode I
        
        lambda=sigma_local(3)/sigma_local(2);
if sigma_local(2)<0
    
    GI(n)=0;        
else
    GI(n)=(1/(2*h))*trapz(X,delta_n)*sigma_local(2); % [kJ/m2]
end
if GI(n)<0
    GI(n)=0
end
                GII(n)=(1/(2*h))*trapz(X,delta_t)*sigma_local(3); % [kJ/m2]
        
        GI_norm(n)=GI(n)/factor;
        GII_norm(n)=GII(n)/factor;
        
        % S11p(n)=S11(a);
        % S12p(n)=S12(a);
        % S22p(n)=S22(a);
        
        Gss(n)=GI(n)+GII(n);
        Gss_norm(n)=GI_norm(n)+GII_norm(n);
    end
    
% END ON N-LOOP
%     for n=2:size((TT{j(k)}),2)
%         if DNneg{k}(n-1)<1e-10 & DNneg{k}(n)>1e-10
%             DNneg{k}(n)=-1;
%             break
%         end
%     end
    for n=2:size((TT{j(k)}),2)
        if DNpos{k}(n-1)<0 & DNpos{k}(n)>0
            DNpos{k}(n-1)=1;
            break
        end
    end
    
    GI_norm_c{k}=GI_norm;
    GII_norm_c{k}=GII_norm;
    if k==1
        figure(1)
        plot(TT{1}(DNneg{k}<0),GI_norm_c{1}(DNneg{k}<0),'b:','LineWidth',1.5)
        plot(TT{1}(DNpos{k}>0),GI_norm_c{1}(DNpos{k}>0),'b--','LineWidth',1.5)
        hold on
        plot(TT{1}(DNneg{k}<0),GII_norm_c{1}(DNneg{k}<0),'b:','LineWidth',1.5)
        plot(TT{1}(DNpos{k}>0),GII_norm_c{1}(DNpos{k}>0),'-.b','LineWidth',1.5)
        plot(TT{1}(DNneg{k}<0),GI_norm_c{1}(DNneg{k}<0)+GII_norm_c{1}(DNneg{k}<0),'b:','LineWidth',1.5)
        plot(TT{1}(DNpos{k}>0),GI_norm_c{1}(DNpos{k}>0)+GII_norm_c{1}(DNpos{k}>0),'b-','LineWidth',1.5)
		csvwrite('GlassFRP1.output.csv',{TT{1}',GI_norm_c{1}',GII_norm_c{1}'},0,0)
%        writematrix({TT{1}',GI_norm_c{1}',GII_norm_c{1}'},'GlassFRP1.output.csv','Delimiter',';')
        grid on
        xlabel('$\theta ~ [^{\circ}]$','interpreter','latex', 'FontSize', 14)
        ylabel('$G/({\epsilon_{xx} \sigma_{xx} 2h})$','interpreter','latex', 'FontSize', 14)
        text(65,0.15,'$\hat{G}_{II}$','interpreter','latex', 'FontSize', 16)
        text(65,0.42,'$\hat{G}_{I}$','interpreter','latex', 'FontSize', 16)
        text(65,0.65,'$\hat{G}_{ss}$','interpreter','latex', 'FontSize', 16)
%        h=legend('$G_{I}','G_{II}','G_{ss}','location','northwest')
    end
    figure(2)
    if k==1
        %         plot(TT{j(k)},GI_norm_c{k},'o--','Color',[1,0,0.5])
        plot(TT{j(k)}(DNneg{k}<1e-10),GI_norm_c{k}(DNneg{k}<1e-10),'b:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>1e-10),GI_norm_c{k}(DNpos{k}>1e-10),'b--','LineWidth',1.5)
 		csvwrite('GlassFRP1GInorm.output.csv',{TT{j(k)}',GI_norm_c{k}'},0,0)
   elseif k==2
        plot(TT{j(k)}(DNneg{k}<1e-10),GI_norm_c{k}(DNneg{k}<1e-10),'g:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>1e-10),GI_norm_c{k}(DNpos{k}>1e-10),'g-','LineWidth',1.5)
 		csvwrite('GlassFRP2GInorm.output.csv',{TT{j(k)}',GI_norm_c{k}'},0,0)
    elseif k==3
        plot(TT{j(k)}(DNneg{k}<1e-10),GI_norm_c{k}(DNneg{k}<1e-10),'k:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>1e-10),GI_norm_c{k}(DNpos{k}>1e-10),'k--','LineWidth',1.5)
 		csvwrite('CarbonFRP1GInorm.output.csv',{TT{j(k)}',GI_norm_c{k}'},0,0)
    else
        plot(TT{j(k)}(DNneg{k}<1e-10),GI_norm_c{k}(DNneg{k}<1e-10),'r:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>1e-10),GI_norm_c{k}(DNpos{k}>1e-10),'r-','LineWidth',1.5)
%        legend([p1,p2,p3,p4],{'GlassFRP1','GlassFRP2','CarbonFRP1','CarbonFRP2'},'location','northwest','AutoUpdate','off','FontSize',12)
  		csvwrite('CarbonFRP2GInorm.output.csv',{TT{j(k)}',GI_norm_c{k}'},0,0)
   end
    hold on
    grid on
%    xlabel('$\theta$','interpreter','latex', 'FontSize', 14)
%    ylabel('$\frac{G_{I}}{\epsilon_{xx} \sigma_{xx} h}$','interpreter','latex', 'FontSize', 18)
    text(75,0.1,'$\hat{G}_{II}$','interpreter','latex', 'FontSize', 16)
    text(75,0.38,'$\hat{G}_{I}$','interpreter','latex', 'FontSize', 16)
    
    figure(2)
    if k==1
        plot(TT{j(k)}(DNneg{k}<0),GII_norm_c{k}(DNneg{k}<0),'b:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),GII_norm_c{k}(DNpos{k}>0),'b--','LineWidth',1.5)
 		csvwrite('GlassFRP1GIInorm.output.csv',{TT{j(k)}',GII_norm_c{k}'},0,0)
    elseif k==2
        plot(TT{j(k)}(DNneg{k}<0),GII_norm_c{k}(DNneg{k}<0),'g:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),GII_norm_c{k}(DNpos{k}>0),'g-','LineWidth',1.5)
 		csvwrite('GlassFRP2GIInorm.output.csv',{TT{j(k)}',GII_norm_c{k}'},0,0)
    elseif k==3
        plot(TT{j(k)}(DNneg{k}<0),GII_norm_c{k}(DNneg{k}<0),'k:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),GII_norm_c{k}(DNpos{k}>0),'k--','LineWidth',1.5)
 		csvwrite('CarbonFRP1GIInorm.output.csv',{TT{j(k)}',GII_norm_c{k}'},0,0)
    else
        plot(TT{j(k)}(DNneg{k}<0),GII_norm_c{k}(DNneg{k}<0),'r:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),GII_norm_c{k}(DNpos{k}>0),'r-','LineWidth',1.5)
  		csvwrite('CarbonFRP2GIInorm.output.csv',{TT{j(k)}',GII_norm_c{k}'},0,0)
    end
    axis([0 90 0 0.7])
    hold on
    grid on
    xlabel('$\theta ~ [^{\circ}]$','interpreter','latex', 'FontSize', 14)
    ylabel('$G/(\epsilon_{xx} \sigma_{xx} 2h)$','interpreter','latex', 'FontSize', 14)
    %legend('location','northwest')
    
    figure(4)
    yyaxis left
    %     plot(TT{j(k)},GI_norm_c{k}+GII_norm_c{k},'o-')
    if k==1
        plot(TT{j(k)}(DNneg{k}<0),GI_norm_c{k}(DNneg{k}<0)+GII_norm_c{k}(DNneg{k}<0),'b:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),GI_norm_c{k}(DNpos{k}>0)+GII_norm_c{k}(DNpos{k}>0),'b--','LineWidth',1.5)
    elseif k==2
        plot(TT{j(k)}(DNneg{k}<0),GI_norm_c{k}(DNneg{k}<0)+GII_norm_c{k}(DNneg{k}<0),'g:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),GI_norm_c{k}(DNpos{k}>0)+GII_norm_c{k}(DNpos{k}>0),'g-','LineWidth',1.5)
    elseif k==3
        plot(TT{j(k)}(DNneg{k}<0),GI_norm_c{k}(DNneg{k}<0)+GII_norm_c{k}(DNneg{k}<0),'k:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),GI_norm_c{k}(DNpos{k}>0)+GII_norm_c{k}(DNpos{k}>0),'k--','LineWidth',1.5)
    else
        plot(TT{j(k)}(DNneg{k}<0),GI_norm_c{k}(DNneg{k}<0)+GII_norm_c{k}(DNneg{k}<0),'r:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),GI_norm_c{k}(DNpos{k}>0)+GII_norm_c{k}(DNpos{k}>0),'r-','LineWidth',1.5)
    end
    hold on
    grid on
    xlabel('$\theta$','interpreter','latex', 'FontSize', 14)
    ylabel('$G_{ss}/(\epsilon_{xx} \sigma_{xx} 2h)$','interpreter','latex', 'FontSize', 14)
    text(25,0.15,'$\hat{G}_{ss}$','interpreter','latex', 'FontSize', 16)
    text(70,0.14,'$\hat{\psi}$','interpreter','latex', 'FontSize', 20)


%    legend('GlassFRP1','GlassFRP2','CarbonFRP1','CarbonFRP2','location','west')
    ax = gca;
    ax.YAxis(1).Color = 'k';
    ax.YAxis(2).Color = 'k';
        
   
    
    % LARS: Mode mixity parameter
    figure(4)
    yyaxis right
    %     plot(TT{j(k)},GI_norm_c{k}+GII_norm_c{k},'o-')
    if k==1
        plot(TT{j(k)}(DNneg{k}<0),atand(sqrt(((8.62/30.6)^(-0.5))*GII_norm_c{k}(DNneg{k}<0)./GI_norm_c{k}(DNneg{k}<0))),'b:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),atand(sqrt(((8.62/30.6)^(-0.5))*GII_norm_c{k}(DNpos{k}>0)./GI_norm_c{k}(DNpos{k}>0))),'b--','LineWidth',1.5)
    elseif k==2
        plot(TT{j(k)}(DNneg{k}<0),atand(sqrt(((10.3/41.2)^(-0.5))*GII_norm_c{k}(DNneg{k}<0)./GI_norm_c{k}(DNneg{k}<0))),'g:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),atand(sqrt(((10.3/41.2)^(-0.5))*GII_norm_c{k}(DNpos{k}>0)./GI_norm_c{k}(DNpos{k}>0))),'g-','LineWidth',1.5)
    elseif k==3
        plot(TT{j(k)}(DNneg{k}<0),atand(sqrt(((7.56/126)^(-0.5))*GII_norm_c{k}(DNneg{k}<0)./GI_norm_c{k}(DNneg{k}<0))),'k:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),atand(sqrt(((7.56/126)^(-0.5))*GII_norm_c{k}(DNpos{k}>0)./GI_norm_c{k}(DNpos{k}>0))),'k--','LineWidth',1.5)
    else
        plot(TT{j(k)}(DNneg{k}<0),atand(sqrt(((5.49/266)^(-0.5))*GII_norm_c{k}(DNneg{k}<0)./GI_norm_c{k}(DNneg{k}<0))),'r:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),atand(sqrt(((5.49/266)^(-0.5))*GII_norm_c{k}(DNpos{k}>0)./GI_norm_c{k}(DNpos{k}>0))),'r-','LineWidth',1.5)
    end
    axis([0 90 0 90]) 
    hold on
%    grid on
    xlabel('$\theta ~ [^{\circ}]$','interpreter','latex', 'FontSize', 14)
    ylabel('$\hat{\psi} ~ [^{\circ}]$','interpreter','latex', 'FontSize', 14)
    %legend('GlassFRP1','GlassFRP2','CarbonFRP1','CarbonFRP2','location','west')

    % LARS: DeltaFactor
    figure(71)
    if k==1
        plot(TT{j(k)}(DNneg{k}<0),DNfactor{k}(DNneg{k}<0),'b:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),DNfactor{k}(DNpos{k}>0),'b--','LineWidth',1.5)
    elseif k==2
        plot(TT{j(k)}(DNneg{k}<0),DNfactor{k}(DNneg{k}<0),'g:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),DNfactor{k}(DNpos{k}>0),'g--','LineWidth',1.5)
    elseif k==3 
        plot(TT{j(k)}(DNneg{k}<0),DNfactor{k}(DNneg{k}<0),'k:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),DNfactor{k}(DNpos{k}>0),'k--','LineWidth',1.5)
    elseif k==4
        plot(TT{j(k)}(DNneg{k}<0),DNfactor{k}(DNneg{k}<0),'r:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),DNfactor{k}(DNpos{k}>0),'r--','LineWidth',1.5)
    end

    if k==1
        plot(TT{j(k)}(DNneg{k}<0),DTfactor{k}(DNneg{k}<0),'b:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),DTfactor{k}(DNpos{k}>0),'b--','LineWidth',1.5)
    elseif k==2
        plot(TT{j(k)}(DNneg{k}<0),DTfactor{k}(DNneg{k}<0),'g:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),DTfactor{k}(DNpos{k}>0),'g-','LineWidth',1.5)
    elseif k==3
        plot(TT{j(k)}(DNneg{k}<0),DTfactor{k}(DNneg{k}<0),'k:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),DTfactor{k}(DNpos{k}>0),'k--','LineWidth',1.5)
    elseif k==4
        plot(TT{j(k)}(DNneg{k}<0),DTfactor{k}(DNneg{k}<0),'r:','LineWidth',1.5)
        plot(TT{j(k)}(DNpos{k}>0),DTfactor{k}(DNpos{k}>0),'r-','LineWidth',1.5)
    end
    
end
%%




%,'MarkerSize',12

((GI_norm_c{1}(end)+GII_norm_c{1}(end))-(GI_norm_c{2}(end)+GII_norm_c{2}(end)))/(GI_norm_c{1}(end)+GII_norm_c{1}(end))*100

% Output to figures
print('-f1','FIG16-FigGssDegGlass','-dpng')
print('-f1','FIG16-FigGssDegGlass','-depsc')
print('-f2','FIG17-FigGI-GII-Deg','-dpng')
print('-f2','FIG17-FigGI-GII-Deg','-depsc')
%print('-f3','FigGIIDeg','-dpng')
%print('-f3','FigGIIDeg','-depsc')
print('-f4','FIG18-FigGssAllDeg','-dpng')
print('-f4','FIG18-FigGssAllDeg','-depsc')
print('-f61','FIG7-FigDeltaCrack','-dpng')
print('-f61','FIG7-FigDeltaCrack','-depsc')
print('-f71','FIG19-FigDeltaFactor','-dpng')
print('-f71','FIG19-FigDeltaFactor','-depsc')
%print('-f9','FigPsiDeg','-dpng')
%print('-f9','FigPsiDeg','-depsc')


% ((GI_norm_c{3}(2)+GII_norm_c{3}(2))-(GI_norm_c{3}(1)+GII_norm_c{3}(1)))/((GI_norm_c{3}(2)+GII_norm_c{3}(2)))*100
% GI_norm_c{3}+GII_norm_c{3}
%%
% GI            =   0.0103
% GII           =   0.5450
% sigma_local   =   156.1832
%                   11.6361
%                   54.3646
% Gssres        =   0.5554
% Gssres_norm   =   0.2343